/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class IceListener
implements Wrapper {
    private InputStream sis;
    private OutputStream sos;
    private Properties heads;
    public Socket source;
    private PicoServer pico;
    private long dataout = 0L;
    private long prevdata = 0L;
    public boolean active = false;

    public IceListener() throws Exception {
        Logger.ok();
        Logger.log("Listening source on " + Config.bind + ":" + Config.listen + " ...", false);
        ServerSocket serverSocket = Config.bind.equals("*") ? new ServerSocket(Config.listen) : new ServerSocket(Config.listen, 5, InetAddress.getByName(Config.bind));
        Logger.ok();
        Logger.log("");
        block8: while (true) {
            try {
                while (true) {
                    String string;
                    if (!this.active) {
                        Logger.log("Waiting source ...", false);
                    }
                    this.source = serverSocket.accept();
                    this.source.setSoTimeout(20000);
                    this.sis = this.source.getInputStream();
                    this.sos = this.source.getOutputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.sis));
                    if (!this.active) {
                        Logger.log(" connected: " + this.source.getInetAddress().getCanonicalHostName() + " [" + this.source.getRemoteSocketAddress().toString() + "]");
                    }
                    if ((string = bufferedReader.readLine()).toLowerCase().startsWith("get")) {
                        new IceStats(string, this.source, bufferedReader);
                        continue;
                    }
                    if (string.toLowerCase().startsWith("source")) {
                        int n;
                        String string2;
                        String string3;
                        this.heads = new Properties();
                        this.getShout(bufferedReader);
                        Logger.log("Checking password ...", false);
                        String string4 = this.heads.getProperty("authorization", "");
                        Config.pass = string3 = this.getPass(string4);
                        this.pico = new PicoServer();
                        String string5 = this.pico.getData("auth");
                        if (!string5.startsWith("200")) {
                            Logger.log("bad password or data: " + string3);
                            this.sos.write("HTTP/1.0 401 Authentication Required\nWWW-Authenticate: Basic realm=\"Icecast2 Server\"\n\nKO\n".getBytes());
                            try {
                                this.source.close();
                                continue block8;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                        this.sos.write("HTTP/1.0 200 OK\n\n".getBytes());
                        Logger.ok();
                        if (Config.useproxy) {
                            string2 = Config.proxy;
                            n = Config.proxyport;
                        } else {
                            string2 = Config.host;
                            n = Config.port;
                        }
                        Logger.log("Connecting to PicoStreamer server...", false);
                        Socket socket = new Socket(string2, n);
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write(this.pico.getHeaders("source").getBytes());
                        Logger.ok();
                        Logger.log("");
                        this.active = true;
                        this.dataout = 0L;
                        this.prevdata = 0L;
                        new Connector(this.sis, outputStream, this);
                        continue;
                    }
                    Logger.log("Unknown request.\n");
                    try {
                        this.source.close();
                        continue block8;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                Logger.log("\nSource connection closed:" + PicoServer.err(exception) + "\n");
                try {
                    this.source.close();
                }
                catch (Exception exception2) {
                }
                continue;
            }
            break;
        }
    }

    private String getPass(String string) {
        int n = string.indexOf(" ");
        String string2 = Base64.decode(string.substring(n));
        string2 = string2.substring(string2.indexOf(":") + 1);
        return string2;
    }

    private void getShout(BufferedReader bufferedReader) throws Exception {
        boolean bl = true;
        while (bl) {
            String string = bufferedReader.readLine();
            if (string.startsWith("SOURCE")) {
                string = bufferedReader.readLine();
                continue;
            }
            if (string.equals("")) {
                bl = false;
                continue;
            }
            int n = string.indexOf(":");
            String string2 = string.substring(n + 1).trim();
            String string3 = string.substring(0, n).trim();
            this.heads.setProperty(string3.toLowerCase(), string2);
        }
        Config.info = this.heads.getProperty("ice-name", "unknown");
        Config.bits = this.heads.getProperty("ice-bitrate", "N/A");
        Config.ctype = this.heads.getProperty("content-type", "audio/mpeg");
    }

    public void alt() {
        Logger.log("\nSource connection closed:" + Config.err + "\n");
        this.active = false;
        Logger.log("Waiting source ...", false);
    }

    public void data(int n) {
        this.dataout += (long)n;
        if (this.dataout / 1024L != this.prevdata) {
            Logger.line(this.dataout / 1024L + " kbytes sent");
        }
        this.prevdata = this.dataout / 1024L;
    }
}

