#	               WARNING!!!                   #
#        Change this value to the real          #
#          PicoStreamer install dir             #
# default is http://www.domain.com/picostreamer #
#     so the default value is "/picostreamer"   #

          $c_appdir = "/picostreamer"; 
        
          ############################

#################################################################
#	PicoStreamer 2.0                                        	#
#	Config library 1.0                                          #
#	Vinz486 (c) 2004	                                		#
#################################################################
$libcfg = 1;

# This values wil be override by config.txt file

# Size of read/write buffer in bytes.
# This is the max value and the real value may be lower.
$c_buffer_size=8192;

# Time after a listener should be considered idle in seconds.
# A listener is idle when don't read bytes for this time.
$c_idle_timeout=30;

# Time after the source should be considered online, in seconds.
$c_online_time=15;

# Check for idle listeners every this time, in seconds.
$c_idle_check_interval=15;

# Check for new listeners every this time, in seconds.
$c_clients_search_interval=5;

# The source will refresh it's presence every this time, in seconds.
$c_source_ping_interval=10;

# Print to log the buffer average size every this time, in seconds.
$c_buffer_avg=10;

# The reader will refresh it's presence every this time, in seconds.
$c_reader_ping_interval=25;

# Search for peak listeners value every this time, in seconds.
$c_log_peak=10;

# Search for new relay every this time, in seconds.
$c_relay_scan_interval=30;

# Ping the Yellow Pages every this time, in seconds.
$c_ping_yp_interval=20;

# file separator
$c_fs = &c_fsep();

# application root
$c_approot = $ENV{'DOCUMENT_ROOT'} . $c_appdir;

# users dir
$c_users = $c_approot . $c_fs . "users";

# load external config file usersdir/config.txt
&cfg_load();

# user desc file offsets
$D_PASS 		= "password";
$D_MAXUSERS		= "maxusers";
$D_BITRATE		= "bitrate";
$D_CTYPE		= "ctype";
$D_INFO			= "info";
$D_DESC			= "desc";
$D_GENRE		= "genre";
$D_INTRO		= "intro";
$D_BANNER		= "banner";
$D_RHOST		= "rhost";
$D_RUSER		= "ruser";
$D_ARELAY		= "arelay";


# Exit codes and error strings
$OK	 					= "200";
$c_errcode{$OK} 		= "OK";
$NOAUTH		 			= "401";
$c_errcode{$NOAUTH}		= "AuthRequired";
$NOUSER		 			= "404";
$c_errcode{$NOUSER}		= "UserNotFound";
$ERROR		 			= "500";
$c_errcode{$ERROR}		= "ServerError";
$NO_PORT	 			= "501";
$c_errcode{$NO_PORT}	= "NoPortAvailable";
$MAXUSERS	 			= "503";
$c_errcode{$MAXUSERS}	= "MaxUsersReached";
$OFF					= "800";
$c_errcode{$OFF}		= "UserOffline";
$BADRELAY				= "804";
$c_errcode{$BADRELAY}	= "BadRelayData";
$BANNED					= "900";
$c_errcode{$BADRELAY}	= "BannedNet";

$RPCERR					= "600";
$c_errcode{$RPCERR}		= "RPCError";
$RPCBAD					= "601";
$c_errcode{$RPCBAD}		= "RPCBadData";
$RPCWRI					= "602";
$c_errcode{$RPCWRI}		= "RPCWriteError";
$RPCREA					= "603";
$c_errcode{$RPCREA}		= "RPCReadError";
$RPCCHM					= "604";
$c_errcode{$RPCCHM}		= "RPCChmodError";

$UNK		 			= "509";
$c_errcode{$UNK}		= "UnknownCommand";

# playlists ext -> content type
$ptype{'ram'} = "audio/vnd.rn-realaudio";
$ptype{'pls'} = "audio/x-scpls";
$ptype{'m3u'} = "audio/mpegurl";
$ptype{'asx'} = "video/x-ms-asf";

# content type -> file ext
$pext{'audio/mpeg'} = "mp3";
$pext{'video/nsv'} 	= "nsv";


# return this file ver
sub cfg_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

sub cfg_load {
			
	open(CFG,$c_users.$c_fs."config.txt")  or return;
	my @clines = <CFG>;
	close(CFG);
	
	my $line;
	foreach $line (@clines) {
		
		chomp($line);
		$line = &trim($line);
		
		if($line eq "") {
			next;
		}
		
		if($line =~m/^\#/) {
			next;
		}
		
		($ck,$cv) = split(/ /,$line);
		
		$ck = &trim($ck);
		$cv = &trim($cv);
		
		$toev = '$c_'.$ck.'="'.$cv.'";';
		
		eval($toev);
		#print $ck."=".$cv."<br>";
		
	}
	
}

sub trim {
	
	my $str = $_[0];
	$str =~s/^\s+//;
	$str =~s/\s+$//;
	return $str;
}

$c_yp_host = "d3d3LnZpbno0ODYuY29t";
#$c_yp_host = "d3LnZpbno0YuY29t";
$c_yp_api = "L3BzeXAvdG91Y2gucGhw";

# file separator
sub c_fsep {

	if($^O ne "MSWin32") {
		return "/";
	} else {
		return "\\";
	}
}

1;