#################################################################
#	PicoStreamer 2.0                                        	#
#	RPC library 1.0                                             #
#	Vinz486 (c) 2004	                                		#
#################################################################
$librpc = 1;


# return this file ver
sub rpc_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# Check auth user
sub _user_auth {
	
	if(&_admin_auth() == 1) {
		
		return 1;
	}
	
	if(&ps_loaduser() == 0) {
		
		return 0;
	}
	
	if($f_pass ne &ps_get_pass()) {
		
		return 0;
	}

	return 1;
}

# Check auth admin
sub _admin_auth {
	
	if(($f{'user'} eq "admin") && ($c_admin_pass eq $f{'pass'})) {
		
		return 1;
	
	} else {
		
		return 0;
	}
	
}

# RPC Test Function
sub rpc_test {
	
	$ret{'msg'} = "ciao mondo";
	
	$ret{'err'} = $OK;
	
	return %ret;
}

# Create user
sub rpc_newuser {
	
	
	if(&_admin_auth() == 0) {
		
		$ret{'err'} = $NOAUTH;
		
		return %ret;
	}
	
	if($f{'d_username'} eq "") {
		
		$ret{'err'} = $RPCBAD;
		$ret{'str'} = "No new username defined";
		
		return %ret;
	}
	
	if($f{'d_password'} eq "") {
		
		$ret{'err'} = $RPCBAD;
		$ret{'str'} = "No new password defined";
		
		return %ret;
	}
	
	if(!-d $c_users."/".$f{'d_username'}) {
		
		if(!mkdir($c_users."/".$f{'d_username'},0777)) {
		
			$ret{'err'} = $RPCWRI;
			$ret{'str'} = "On mkdir username: ".$!;
			
			return %ret;
		}
	}
	
	if(chmod(0777,$c_users."/".$f{'d_username'}) != 1) {
				
		$ret{'err'} = $RPCCHM;
		$ret{'str'} = "On chmod username: ".$!;

		&_rollback();
		
		return %ret;
		
	}
	
	if(!-d $c_users."/".$f{'d_username'}."/ports") {
	
		if(!mkdir($c_users."/".$f{'d_username'}."/ports",0777)) {
						
			$ret{'err'} = $RPCWRI;
			$ret{'str'} = "On mkdir ports: ".$!;

			&_rollback();
			
			return %ret;
		}
	}   
	
	if(chmod(0777,$c_users."/".$f{'d_username'}."/ports") != 1) {
				
		$ret{'err'} = $RPCCHM;
		$ret{'str'} = "On chmod ports:".$!;

		&_rollback();
		
		return %ret;		
	}
	
	if(!open(DESC,">".$c_users."/".$f{'d_username'}."/desc.txt")) {
				
		$ret{'err'} = $RPCWRI;
		$ret{'str'} = "On write desc.txt: ".$!;

		&_rollback();
			
		return %ret;
	}
	
	print DESC "password=".$f{'d_password'}."\n";
	print DESC "maxusers=".$f{'d_maxusers'}."\n";
	print DESC "bitrate=".$f{'d_bitrate'}."\n";
	print DESC "ctype=".$f{'d_ctype'}."\n";
	print DESC "desc=".$f{'d_desc'}."\n";
	print DESC "info=".$f{'d_info'}."\n";
	print DESC "genre=".$f{'d_genre'}."\n";
	print DESC "intro=0\nbanner0\nrhost=norelay\nrusernorelay\n";
	print DESC "arelay=".$f{'d_arelay'}."\n";
	
	close(DESC);
	
	if(chmod(0666,$c_users."/".$f{'d_username'}."/desc.txt") != 1) {
				
		$ret{'err'} = $RPCCHM;
		$ret{'str'} = "On chmod desc.txt: ".$!;

		&_rollback();
	
		return %ret;
	}
	
	if(!open(PEAK,">".$c_users."/".$f{'d_username'}."/peak.txt")) {
		
		
		$ret{'err'} = $RPCWRI;
		$ret{'str'} = "On write peak.txt: ".$!;

		&_rollback();
			
		return %ret;
	}
	
	print PEAK "0\n".time()."\n";
	close(PEAK);
	
	if(chmod(0666,$c_users."/".$f{'d_username'}."/peak.txt") != 1) {
				
		$ret{'err'} = $RPCCHM;
		$ret{'str'} = "On chmod peak.txt: ".$!;
		
		&_rollback();
			
		return %ret;
	}
	
	$ret{'err'} = $OK;
	return %ret;
}

#############
# Util subs #
#############

# Save desc data
# d_username
# d_password
# d_maxusers
# d_bitrate
# d_ctype
# d_info
# d_desc
# d_genre
# d_intro
# d_banner
# d_rhost
# d_ruser
# d_arelay
sub _savedesc {
	
	my $hr = $_[0];
	my %dat = %$hr;
	
	if($dat{'d_username'} eq "") {
		
		$ret{'err'} = $RPCBAD;
		return %ret;
	}
	
	my %prev = &_loaddesc($dat{'d_username'});
	
	if($pev{'err'} ne $OK) {
		
		return %prev;
	}
	
	my %toput;
	my $it;
	
	foreach $it (keys %prev) {
		
		if(defined($dat{$it})) {
			
			$toput{$it} = $dat{$it};
		
		} else {
			
			$toput{$it} = $prev{$it};
		}
	}
	
	if(!open(DESC,">".$c_users."/".$dat{'d_username'})) {
		
		$ret{'err'} = $RCPWRI;
		return %ret;
	}

	print DESC $toput{'d_username'}."\n"; 
	print DESC $toput{'d_password'}."\n"; 
	print DESC $toput{'d_maxusers'}."\n"; 
	print DESC $toput{'d_bitrate'}."\n"; 
	print DESC $toput{'d_ctype'}."\n"; 
	print DESC $toput{'d_info'}."\n"; 
	print DESC $toput{'d_desc'}."\n"; 
	print DESC $toput{'d_genre'}."\n"; 
	print DESC $toput{'d_intro'}."\n"; 
	print DESC $toput{'d_banner'}."\n"; 
	print DESC $toput{'d_rhost'}."\n"; 
	print DESC $toput{'d_ruser'}."\n"; 
	print DESC $toput{'d_arelay'}."\n"; 
	
	close(DESC);
	
	$ret{'err'} = $OK;
	return $ret;
}   
    
# Load desc data
# of [0] user
sub _loaddesc {
	
	my %ret;
	
	my $_user = shift;
	
	if(!open(DESC,$c_users."/".$_user."/desc.txt")) {
		
		$ret{'err'} = $RPCREA;
		return %ret;
	}
	
	#$ret{'d_username'} = $_user;
	#$ret{'d_password'} = <DESC>;
	#chomp($ret{'d_password'}); 
	#$ret{'d_maxusers'} = <DESC>;
	#chomp($ret{'d_maxusers'}); 
	#$ret{'d_bitrate'} = <DESC>;
	#
	#$ret{'d_ctype'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_info'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_desc'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_genre'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_intro'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_banner'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_rhost'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_ruser'} = <DESC>; 
	#chomp($ret{' 
	#$ret{'d_arelay'} = <DESC>; 
	
	close(DESC);
	
	$ret{'err'} = $OK;
	
	
}   
    
# Delete fault user creation
sub _rollback {
    
	unlink($c_users."/".$f{'d_username'}."/peak.txt");
	unlink($c_users."/".$f{'d_username'}."/desc.txt");
	rmdir($c_users."/".$f{'d_username'}."/ports");
	rmdir($c_users."/".$f{'d_username'});

}

1;