#################################################################
#	PicoStreamer 2.0                                        	#
#	Utility library 1.0                                         #
#	Vinz486 (c) 2004	                                		#
#################################################################
$libutl = 1;

#use URI::Escape;

use HTML::Entities;

# return this file ver
sub utl_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# trim [0]
sub ut_trim {
	
	my $string = $_[0];
	
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	
	return $string;
	
}

# return the hostname
# without the :80
sub ut_this_host {

	my $hnew;
	
	if($_[0] eq "noport") {
	
		($hnew) = split(":", $ENV{'HTTP_HOST'});
	
	} else {
	
		$hnew = $ENV{'HTTP_HOST'};
	
	}
	
	return $hnew;
}


# encode url strings [0]
sub ut_url_encode {
	
	return $_[0];
	#uri_escape($_[0]);
}

# encode html special chars [0]
sub ut_html_encode {
	
	return encode_entities($_[0]);
}

# intstall a SIG handler
# [0] name, [1] subname
sub ut_install_sig {
	
	&logger($T,"ut_install_sig",$_[0], $_[1]);
	
	if(($_[0] eq "") || ($_[1] eq "")) {
		
		return "";
	}
	
	$SIG{$_[0]} = $_[1];
}

# uninstall a SIG handler
# [0] name
sub ut_remove_sig {

	&logger($T,"ut_remove_sig",$_[0]);
	
	if($_[0] eq "") {
		
		return "";
	}
	
	$SIG{$_[0]} = 'DEFAULT';

}

# asynchronous timer set
# [0] key, [1] interval
my %_times;
my %_delay;
my %_subs;
sub ut_timer_set {
	
	my $del = &ut_digits($_[1]);
	
	if($_[0] eq "") {
		
		return;
	}
	
	# get
	if($_[1] eq "") {
		
		my $tnow = time();
		
		if(($tnow - $_times{$_[0]}) > $_delay{$_[0]}) {
			
			$_times{$_[0]} = $tnow;
			
			return 1;
		
		} else {
			
			return 0;
		}
		
	# set
	} else {
		
		if($_[2] eq "") {
			
			return;
		}
		
		&logger($T,"ut_timer_set",$_[0],$_[1]);
		
		$_times{$_[0]} = time();
		$_delay{$_[0]} = $_[1];
		$_subs{$_[0]} = $_[2];
	}
	 

}

# remove all timers
sub ut_timer_clear {
	
	&logger($T,"ut_timer_clear");
	
	undef %_times;
	undef %_delay;
	undef %_subs;
	
}

# execute timers
# return number of execs
sub ut_timer_exe {
	
	&logger($T,"ut_timer_exe");
		
	my $csub = 0;
	my $tk;
	
	foreach $tk (keys %_times) {
		
		if(&ut_timer_set($tk) == 1) {
			
			
			if($_subs{$tk} ne "") {
				
				&logger($T,"ut_timer_exe",$tk,$_subs{$tk});
			
				$csub++;
				
				$_subs{$tk}->();
			}
		}
	}
	
	return $csub;
}

# return the numeric part of a string
# 0 on no numeric digits
sub ut_digits {
	
	&logger($T,"ut_digits");
	
	my $str = $_[0];
	
	$str =~m/(\d+)/;
	
	if($1 eq "") {
	
		return 0;
	
	} else {
	
		return $1;
	}
}

# kill a process
# [0] pid, ([1] sig num)
# return 1 on successful
sub ut_kill {
	
	my $knum = 3;
	
	if($_[1] ne "") {
		
		$knum = $_[1];
	}
	
	&logger($T,"ut_kill",$_[0],$knum);
	
	if($_[0] ne "") {
	
		return kill($knum,$_[0]);
		
	}
}

# get current month and year
# in MMYY format
sub ut_get_MY {
  	
  	&logger($T,"ut_get_MY");
  	
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	
	$year = $year + 1900;
	$mon++;
	
	return sprintf("%02d%02d",substr($year,2),$mon);
}

# strip html code from strings
sub ut_strip_html {
	
	&logger($T,"ut_strip_html");
	
	my $str = $_[0];
	
	$str =~s/\</\]/g;
	$str =~s/\>/\[/g;

	return $str;
}

# strip \n and \r from strings
sub ut_strip_carriage {
	
	&logger($T,"ut_strip_carriage");
	
	my $str = $_[0];
	
	$str =~s/\n//g;
	$str =~s/\r//g;

	return $str;
}

# ls or dir
# [0] path
# return @files
sub ut_list {
	
	&logger($T,"ut_list",$_[0]);
	
	undef @_ls;
	my @_ls;
	
	if($^O ne "MSWin32") {
		
		@_ls = qx(ls $_[0] 2>/dev/null);
	
	} else {
	
		@_ls = qx(dir /b $_[0]);
	
	}
	
	undef @_clg;
	my $_clg;
	
	my $_lin;
	
	foreach $_lin (@_ls) {
		
		chomp($_lin);
		push(@_clg, $_lin);
	
	}
	 
	return @_clg;
}

# get the modified time of a file
# [0] filename
sub ut_get_ftime {
	
	&logger($T,"ut_get_ftime",$_[0]);
	
	if($_[0] eq "") { return; }
	
	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($_[0]);
	
	return $mtime;
}

# get the size of a file
# [0] filename
sub ut_get_fsize {
	
	&logger($T,"ut_get_fsize",$_[0]);
	
	if($_[0] eq "") { return; }
	
	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($_[0]);
	
	return $size;
}

# delete a file
# [0] filename
sub ut_rem_file {
	
	&logger($T,"ut_rem_file",$_[0]);
	
	return unlink($_[0]);
}

# update time/create a file
# [0] filename
sub ut_touch {
	
	&logger($T,"ut_touch");
	
	if($_[0] eq "") { return; }
	
	if($^O ne "MSWin32") {
		
		qx(touch $_[0]);
	
	} else {
	
		open(TTT, ">" . $_[0]);
		close(TTT);
	}
}

# lock access
# [0] filehandle
sub ut_lokf {
	
	&logger($T,"ut_lokf",$_[0]);
	
	if($^O ne "MSWin32") {
		flock($_[0],2);
	}
}

# unlock access
# [0] filehandle
sub ut_unlokf {
	
	&logger($T,"ut_unlokf",$_[0]);
	
	if($^O ne "MSWin32") {
		flock($_[0],8);
	}
}

1;