#!/usr/bin/perl
###########################
##  AutoRank v4.0.x      ##
##########################################################
##  admin.cgi - control administration of AutoRank      ##
##########################################################

BEGIN
{
    chdir('..');
}

print "Content-type: text/html\n\n";

eval
{
    require 'ar.pl';
    $HEADER = 1;
    main();
};

err("$@", 'admin.cgi') if( $@ );
exit;

#####################################################################
##  Removing the link back to JMB Software is a license violation. ##
##  Altering or removing any of the code that is responsible, in   ##
##  any way, for generating that link is strictly forbidden.       ##
##  Anyone violating the above policy will have their license      ##
##  terminated on the spot.  Do not remove that link - ever.       ##
#####################################################################

sub main
{
    derr(1005) if( !$RMTUSR );
    derr(1006) if( !-e "$DDIR/vars.dat" );  
    diskspace();

    if( $REQMTH eq 'GET' )
    {
        displayMain();
    }
    else
    {
        parsepost();
        derr(1008) if( !$FRM{run} );
        &{$FRM{run}};
    }
}



sub displayMain
{
    $TPL{MESSAGE}   = shift;
    $TPL{VERSION}   = $VERSION;
    $TPL{MEMBERS}   = scalar(@{dread("$DDIR/members", '\.dat')});
    $TPL{RR_FROM}   = freadline("$DDIR/times/rerank.frm");
    $TPL{RS_FROM}   = freadline("$DDIR/times/reset.frm" );
    $TPL{LAST_RR}   = timetostr( getAge("$DDIR/times/rerank") );
    $TPL{LAST_RS}   = timetostr( getAge("$DDIR/times/reset" ) );
    $TPL{MAIN_PAGE} = "$HTML_URL/autorank.html";

    fparse('_admin_main.htmlt');
}



sub displayHTML
{
    require "$DDIR/html/$FRM{hpages}";

    stripHTML(\$HEAD);
    stripHTML(\$TEMP);
    stripHTML(\$FILL);
    stripHTML(\$FOOT);

    $TPL{HEAD}    = $HEAD;
    $TPL{TEMP}    = $TEMP;
    $TPL{FILL}    = $FILL;
    $TPL{FOOT}    = $FOOT;
    $TPL{PAGE}    = $FRM{hpages};

    fparse('_admin_html.htmlt');
}



sub displayAll
{
    $FILTER = 0;
    sortMembers();

    $FRM{page} = 0 if( $FRM{page} < 0 );

    $TPL{MESSAGE} = shift;
    $TPL{GROUP}   = $FRM{scat};
    $TPL{SHOW}    = $FRM{show};
    $TPL{SORT}    = $FRM{sort};
    $TPL{TOTAL}   = scalar(@SORTED);
    $TPL{START}   = getStart($TPL{TOTAL}, $FRM{show});
    $TPL{END}     = getEnd($TPL{TOTAL}, $FRM{show}, $TPL{START});
    $TPL{NEXT}    = $TPL{TOTAL} > $TPL{END} ? qq|<option value="displayAll">Display Next Page</option>| : '';
    $TPL{PAGE}    = $FRM{page} + 1;
    $TPL{JUMP}    = getJump($TPL{TOTAL}, $FRM{show});

    fparse('_admin_allt.htmlt');
    printAll() if( $TPL{TOTAL} );
    fparse('_admin_allb.htmlt');
}



sub displayMember
{
    my $id = (split(/,/, $FRM{id}))[0];
    derr(1000, "No Member Selected") if( !$id );
    derr(1018) if( !-e "$DDIR/members/$id.dat" );

    $TPL{FROM}  = $FRM{from};
    $TPL{PAGE}  = $FRM{page};
    $TPL{SORT}  = $FRM{sort};
    $TPL{GROUP} = $FRM{scat};
    $TPL{SHOW}  = $FRM{show};
    $TPL{KEY}   = $FRM{key};

    memberTemplate($id);
    fparse('_admin_member.htmlt');
}



sub displayEditMember
{
    my $id = (split(/,/, $FRM{id}))[0];
    derr(1000, "No Member Selected") if( !$id );
    derr(1018) if( !-e "$DDIR/members/$id.dat" );

    $TPL{FROM}  = $FRM{from};
    $TPL{SORT}  = $FRM{sort};
    $TPL{GROUP} = $FRM{scat}; 
    $TPL{KEY}   = $FRM{key};
    $TPL{SHOW}  = $FRM{show};
    $TPL{PAGE}  = $FRM{page};

    memberTemplate($id);

    fparse('_admin_editmem.htmlt');
}



sub displayTemplate
{
    $line = freadalls("$TDIR/$FRM{template}");
    stripHTML($line);

    $TPL{HTML}     = $$line;
    $TPL{TEMPLATE} = $FRM{template};

    fparse('_admin_template.htmlt');
}



sub displayLang
{
    require "$DDIR/errors.dat";

    %TPL = %error;

    for( @{freadall("$DDIR/lang.dat")} )
    {
        $_ =~ /\$([^\s]+)/;
        $TPL{$1} = ${$1};
    }

    for( keys %TPL )
    {
        stripHTML(\$TPL{$_});
    }

    fparse('_admin_lang.htmlt');
}



sub displayChangePass
{
    fparse('_admin_chpass.htmlt');
}


#####################################################################


sub resetList
{
    doReset();
    fwrite("$DDIR/times/reset.frm", 'Manual');
    fwrite("$DDIR/times/reset", time);
    displayMain("List Has Been Reset");
}



sub rerankList
{
    doRerank(1);
    fwrite("$DDIR/times/rerank.frm", 'Manual');
    fwrite("$DDIR/times/rerank", time);
    displayMain("List Has Been Reranked");
}



sub restoreDefault
{
    my $def = freadalls("$DDIR/def.html");

    fwrite("$DDIR/html/autorank.html", $$def);

    displayMain("Default Template Has Been Restored");
}



sub saveLangSettings
{
    delete $FRM{run};

    fwrite("$DDIR/errors.dat");
    fwrite("$DDIR/lang.dat");

    for( sort keys %FRM )
    {
        $FRM{$_} =~ s/"/\\"/g;

        if( index($_, 'L_') == 0 )
        {
            fappend("$DDIR/lang.dat", "\$$_ = \"$FRM{$_}\";\n");
        }
        else
        {
            fappend("$DDIR/errors.dat", "\$error{$_} = \"$FRM{$_}\";\n");
        }
    }

    fappend("$DDIR/errors.dat", "\n1;\n");
    fappend("$DDIR/lang.dat", "\n1;\n");

    displayMain("Language settings have been updated");
}



sub updatePassword
{
    derr(1000, 'Username') if( !$FRM{newuser} );
    derr(1000, 'Password') if( !$FRM{newpass} );

    fwrite('./admin/.htpasswd', "$FRM{newuser}:" . crypt($FRM{newpass}, getsalt())) if( $RMTUSR );
    fwrite("$DDIR/admin.epf", crypt($FRM{newpass}, getsalt()));
    $TPL{APWD} = $FRM{newpass};

    displayMain('Administrative username/password has been updated');
}



sub updateHTML
{
    $FRM{head} =~ s/\r|\n$//g;
    $FRM{foot} =~ s/\r|\n$//g;
    $FRM{temp} =~ s/\r|\n$//g;
    $FRM{fill} =~ s/\r|\n$//g;

    fwrite("$DDIR/html/autorank.html", qq|\$HEAD = <<'HEAD';\n$FRM{head}\nHEAD\n\n\$FOOT = <<'FOOT';\n$FRM{foot}\nFOOT\n\n\$TEMP = <<'TEMP';\n$FRM{temp}\nTEMP\n\n1;\n|);

    displayMain("HTML successfully updated");
}



sub updateTemplate
{
    $FRM{html} =~ s/\r//gi;
    $FRM{html} =~ s/\r|\n$//g;

    fwrite("$TDIR/$FRM{template}", $FRM{html});
    displayMain("The $FRM{template} template has been updated");
}



sub updateAccount
{
    my $id = $FRM{id};
    my $cd = fsplit("$DDIR/members/$id.cnt");
    my $md = fsplit("$DDIR/members/$id.dat");

    for( keys %FRM )
    {
        stripHTML(\$FRM{$_}, 1);
    }

    $$md[0]  = $FRM{mail};
    $$md[1]  = $FRM{surl};
    $$md[2]  = $FRM{burl};
    $$md[3]  = $FRM{bht};
    $$md[4]  = $FRM{bwd};
    $$md[5]  = $FRM{rurl};
    $$md[6]  = $FRM{titl};
    $$md[7]  = $FRM{desc};
    $$md[8]  = $FRM{cat};
    $$md[9]  = $FRM{icon};
    $$md[12] = $FRM{rat};
    $$md[18] = $FRM{pass};  
    $$md[20] = $FRM{susp};
    $$md[21] = $FRM{lock};
    $$md[22] = $FRM{inac};  
    $$md[23] = $FRM{fld1};
    $$md[24] = $FRM{fld2};
    $$md[25] = $FRM{fld3};

    $$cd[0]  = $FRM{rhin};
    $$cd[1]  = $FRM{hout};
    $$cd[2]  = $FRM{rtin};
    $$cd[3]  = $FRM{tout};
    $$cd[5]  = $FRM{rat};
    $$cd[6]  = $FRM{cat};
    $$cd[7]  = $FRM{susp};

    fjoin("$DDIR/members/$id.cnt", @{$cd});
    fjoin("$DDIR/members/$id.dat", @{$md});

    $FRM{page}--;

    &{$FRM{from}}("Account '$id' Has Been Updated");
}



sub deleteMember
{
    derr(1000, 'No Member Selected') if( !$FRM{id} );

    for( split(/,/, $FRM{id}) )
    {
        fremove("$DDIR/members/$_.dat");
        fremove("$DDIR/members/$_.cnt");
        fremove("$DDIR/members/$_.sts");
    }

    $FRM{page}--;

    &{$FRM{from}}("Account(s) $FRM{id} Have Been Deleted");
}



sub printAll
{
    my $i;
    for( $i = $TPL{START} - 1; $i <= $TPL{END} - 1; $i++ )
    {
        memberTemplate(getUsername($SORTED[$i]));
        $TPL{SORT_VALUE} = (split(/\|/, $MEM{$SORTED[$i]}))[0];
        $TPL{SORT_VALUE} = $TPL{SIGNUP_DATE} if( $FRM{sort} eq 'signupDate' );
        $TPL{BANNER_URL} = !$TPL{BANNER_URL} ? 'None' : qq|<a href="javascript:openBanner('$TPL{BANNER_URL}');" class="reg">Click Here</a>|;
        fparse('_admin_allm.htmlt');
    }
}



sub execute
{
    derr(1008) if( !$FRM{function} );
    &{$FRM{function}};
}



sub quickJump
{
    $FRM{page}--;
    displayAll();
}



sub stripHTML
{
    my($html, $amp) = @_;

    $$html =~ s/&/&amp;/gi if( !$amp );
    $$html =~ s/>/&gt;/gi;
    $$html =~ s/</&lt;/gi;
    $$html =~ s/\"/&quot;/gi;
}



sub getYesNo
{
    return (shift) ? qq|<option value="0">No</option>\n<option value="1" selected>Yes</option>| : 
                     qq|<option value="0" selected>No</option>\n<option value="1">Yes</option>|;
}



sub getStart
{
    my($total, $show) = @_;

    return 0 if( !$total );

    my $start = $FRM{page} * $show + 1;

    while( $start > $total )
    {
        $FRM{page}--;
        $start = $FRM{page} * $show + 1
    }

    $start = 0 if( $start < 0 );

    return $start;
}



sub getEnd 
{
    my($total, $show, $start) = @_;

    return 0 if( !$total );

    my $end = $start + $show - 1;
    $end = $total if( $end > $total );
    return $end;
}



sub getJump
{
    my($total, $show) = @_;

    if( !$total || $show == 9999999 || $total <= $show )
    {
        $TPL{STATUS} = ' disabled';
        return qq|<option value="--">--</option>|;
    }

    my $html;
    my $num = $total % $show == 0 ? 0 : 1;
    for( 1..($total/$show + $num) )
    {
        $html .= qq|<option value="$_">\#| . ($show*($_-1)+1) . qq|</option>|;
    }

    return $html;
}



sub memberTemplate
{
    my $id  = shift;
    my $cd  = fsplit("$DDIR/members/$id.cnt");
    my $md  = fsplit("$DDIR/members/$id.dat");
    my $age = time - $$md[11];

    $TPL{USERNAME}      = $id;
    $TPL{PASSWORD}      = $$md[18];
    $TPL{EMAIL}         = $$md[0];
    $TPL{SITE_URL}      = $$md[1];
    $TPL{BANNER_URL}    = $$md[2];
    $TPL{HEIGHT}        = $$md[3];
    $TPL{WIDTH}         = $$md[4];
    $TPL{TITLE}         = $$md[6];
    $TPL{DESCRIPTION}   = $$md[7];
    $TPL{CATEGORY}      = $$md[8];
    $TPL{CAT_OPTIONS}   = getCatOptions($$md[8]);
    $TPL{SIGNUP_DATE}   = fdate($DATE_FORMAT, $$md[10] + ($TIME_ZONE * 3600)) . ' ' . ftime($TIME_FORMAT, $$md[10] + ($TIME_ZONE * 3600));
    $TPL{HITS_IN}       = $$cd[0];
    $TPL{HITS_OUT}      = $$cd[1];
    $TPL{TOTAL_IN}      = $$cd[2];
    $TPL{TOTAL_OUT}     = $$cd[3];
    $TPL{TRACK_URL}     = "$IN_URL?id=$id";
}