#!/usr/bin/perl
###########################
##  AutoRank v4.0.x      ##
#####################################################################
##  accounts.cgi - handle maintenance of accounts by webmasters    ##
#####################################################################

print "Content-type: text/html\n\n";

eval
{
    require 'ar.pl';
    $HEADER = 1;
    main();
};

err("$@", 'accounts.cgi') if( $@ );
exit;

#####################################################################
##  Removing the link back to JMB Software is a license violation. ##
##  Altering or removing any of the code that is responsible, in   ##
##  any way, for generating that link is strictly forbidden.       ##
##  Anyone violating the above policy will have their license      ##
##  terminated on the spot.  Do not remove that link - ever.       ##
#####################################################################

sub main
{
    if( $REQMTH eq 'GET' )
    {
        displayMain();
    }
    elsif( $REQMTH eq 'POST' )
    {
        parsepost(1);
        addAccount();
    } 

}



sub displayMain
{
    $TPL{CAT_OPTIONS} = getCatOptions();  
    fparse('_account_add.htmlt');
}


#####################################################################

sub addAccount
{
    my $time = time;

    checkInput(1);  

    $TPL{USERNAME}    = $FRM{user};
    $TPL{PASSWORD}    = $FRM{pass};
    $TPL{RECIP_URL}   = $FRM{rurl};
    $TPL{BANNER_URL}  = $FRM{burl};
    $TPL{HEIGHT}      = $FRM{bht};
    $TPL{WIDTH}       = $FRM{bwd};
    $TPL{SITE_URL}    = $FRM{surl};
    $TPL{TITLE}       = $FRM{title};
    $TPL{DESCRIPTION} = $FRM{desc};
    $TPL{CATEGORY}    = $FRM{cat};
    $TPL{EMAIL}       = $FRM{email};
    $TPL{ADMIN_EMAIL} = $ADMIN_EMAIL;
    $TPL{FIELD_1}     = $FRM{fld1};
    $TPL{FIELD_2}     = $FRM{fld2};
    $TPL{FIELD_3}     = $FRM{fld3};
    $TPL{TRACK_URL}   = $IN_URL  . "?id=$FRM{user}";
    $TPL{LOGIN_URL}   = $CGI_URL . "/accounts.cgi?login";

    fwrite ("$DDIR/members/$FRM{user}.dat", "$FRM{email}|$FRM{surl}|$FRM{burl}|$FRM{bht}|$FRM{bwd}|$FRM{rurl}|$FRM{title}|$FRM{desc}|$FRM{cat}||$time|$time|1.000|NA|NA|NA|NA|NA|$FRM{pass}|-|0|0|-|$FRM{fld1}|$FRM{fld2}|$FRM{fld3}");
    fwrite ("$DDIR/members/$FRM{user}.cnt", "0|0|0|0|-|1.000|$FRM{cat}|0|$time|0");
    fcreate("$DDIR/members/$FRM{user}.sts");

    mail($SENDMAIL, freadalls("$TDIR/_email_added.etmpl"), \%TPL) if( $USE_MEM_EMAIL );

    fparse('_account_added.htmlt');
}



sub checkInput
{
    derr(1012) if( -e "$DDIR/members/$FRM{user}.dat" );

    derr(1009                 ) if( $FRM{email} !~ /^[\w\d][\w\d\,\.\-]*\@([\w\d\-]+\.)+([a-zA-Z]+)$/ );
    derr(1010, $L_SITE_URL    ) if( $FRM{surl} !~ /^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+/ );
    derr(1010, $L_BANNER_URL  ) if( $FRM{burl} && $FRM{burl} !~ /^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+/ );
    derr(1011, $L_SITE_TITLE  ) if( length( $FRM{title} ) > int( $TITLE_LEN ) );
    derr(1011, $L_SITE_DESC   ) if( length( $FRM{desc}  ) > int( $DESC_LEN  ) );
    derr(1015, $L_USERNAME    ) if( length( $FRM{user} ) < 4 );
    derr(1011, $L_USERNAME    ) if( length( $FRM{user} ) > 8 );
    derr(1014                 ) if( $FRM{user} !~ m/^[a-zA-Z0-9]+$/gi );
    derr(1015, $L_PASSWORD    ) if( length( $FRM{pass} ) < 4 );
    derr(1000, $L_SITE_TITLE  ) if( !$FRM{title} );
    derr(1000, $L_SITE_DESC   ) if( !$FRM{desc}  );


    ## Make sure valid category was choosen
    if( $CATEGORIES )
    {
        $found = 0;
        for( split(/,/, $CATEGORIES) )
        {
            if( $FRM{cat} eq $_ )
            {
                $found = 1;
                last;
            }
        }
        derr(1023) if( !$found );  ## Invalid category selected
    }


    ## If banner URL is supplied, check height and widths
    if( $FRM{burl} )
    {
        if( $FRM{bht} > $BANNER_HEIGHT )
        {
            derr(1026, "$BANNER_WIDTH x $BANNER_HEIGHT");
        }

        if( $FRM{bwd} > $BANNER_WIDTH )
        {
            derr(1026, "$BANNER_WIDTH x $BANNER_HEIGHT");
        }
    }


    for( keys %FRM )
    {
        $FRM{$_} =~ s/\|//g;
        $FRM{$_} =~ s/\r//g;
        $FRM{$_} =~ s/\n//g;
    }
}
