#!/usr/bin/perl
###########################
##  AutoRank v4.0.x      ##
#####################################################################
##  ar.pl - AutoRank shared functions                              ##
#####################################################################

use lib '.';
use cgiworks;

$VERSION = '4.0.0';

require "$DDIR/vars.dat" if( -e "$DDIR/vars.dat" );
require "$DDIR/lang.dat";

1;

#####################################################################
##  Removing the link back to JMB Software is a license violation. ##
##  Altering or removing any of the code that is responsible, in   ##
##  any way, for generating that link is strictly forbidden.       ##
##  Anyone violating the above policy will have their license      ##
##  terminated on the spot.  Do not remove that link - ever.       ##
#####################################################################

sub doRerank
{
    my $now   = time;
    my $reset = freadline("$DDIR/times/reset");

    $FILTER = 1;
    sortMembers();  
    my $ranked = scalar(@SORTED);

    $TPL{MEMBERS}     = $TOTAL;
    $TPL{LAST_RERANK} = fdate($DATE_FORMAT, $now   + (3600 * $TIME_ZONE)          ) . ' ' . ftime($TIME_FORMAT, $now   + (3600 * $TIME_ZONE)          );
    $TPL{NEXT_RERANK} = fdate($DATE_FORMAT, $now   + (3600 * $TIME_ZONE) + $RERANK) . ' ' . ftime($TIME_FORMAT, $now   + (3600 * $TIME_ZONE) + $RERANK);
    $TPL{LAST_RESET}  = fdate($DATE_FORMAT, $reset + (3600 * $TIME_ZONE)          ) . ' ' . ftime($TIME_FORMAT, $reset + (3600 * $TIME_ZONE)          );
    $TPL{NEXT_RESET}  = fdate($DATE_FORMAT, $reset + (3600 * $TIME_ZONE) + $RESET ) . ' ' . ftime($TIME_FORMAT, $reset + (3600 * $TIME_ZONE) + $RESET );
    $TPL{CGI_URL}     = $CGI_URL;


    ## Build ranking page
    require "$DDIR/html/autorank.html";

    $TPL{ROW_COLOR} = $COLOR_1;

    open(HTML, ">$HTML_DIR/autorank.html") || err("$!", "$HTML_DIR/autorank.html");
    vparse($HEAD, \*HTML);

    for( $i = 0; $i < $SITES_TO_LIST; $i++ )
    {
        $TPL{OVERALL_RANK} = $i+1;

        last if( $TPL{OVERALL_RANK} > $ranked );

        ## Parse the template
        if( defined($SORTED[$index]) )
        {          
            rankingTemplate(getUsername($SORTED[$i]));

            vparse($TEMP, \*HTML);
        }

        $TPL{ROW_COLOR} = $TPL{ROW_COLOR} eq $COLOR_1 ? $COLOR_2 : $COLOR_1;
    }

    $som  = freadalls("$DDIR/dbs/bdata");
    $$som    =~ tr/qwertyuiopasdfghjklzxcvbnm($&%#@*!/a-z <>\n:\/"=/;
    ${$O_REC_LONG} .= $$som;
    
    vparse($FOOT, \*HTML);

    close(HTML);

    mode(0666, "$HTML_DIR/autorank.html");
}



sub doReset
{
    for( @{dread("$DDIR/members", '\.cnt$')} )
    {
        my $cd = fsplit("$DDIR/members/$_");
        $$cd[0] = 0;
        $$cd[1] = 0;
        fjoin("$DDIR/members/$_", @{$cd});
    }
}



sub rankingTemplate
{
    my $user  = shift;
    my $md    = fsplit("$DDIR/members/$user.dat");
    my @cd    = split(/\|/, $MEM{"$user.cnt"});

    $TPL{USERNAME}      = $user;
    $TPL{SORT_VALUE}    = $cd[0];  
    $TPL{SITE_URL}      = $$md[1];
    $TPL{OUT_URL}       = "$OUT_URL?id=$user&url=" . urlencode($$md[1]);
    $TPL{TITLE}         = $$md[6];
    $TPL{DESCRIPTION}   = $$md[7];
    $TPL{CATEGORY}      = $$md[8];
    $TPL{HITS_IN}       = $cd[1];
    $TPL{HITS_OUT}      = $cd[2];
    $TPL{TOTAL_IN}      = $cd[3];
    $TPL{TOTAL_OUT}     = $cd[4];
    $TPL{BANNER_HTML}   = '';

    if( $TPL{OVERALL_RANK} <= $NUM_BANNERS )
    {
        if( $$md[2] )
        {
            $TPL{BANNER_HTML} = qq|<img src="$$md[2]"| . heightWidth( $$md[3], $$md[4] ) . qq| border="0" alt="$ALT_VALUE"><br>|;
        }
    }
}



sub getAge
{
    my $file = shift;
    return time - freadline($file);
}



sub getCatOptions
{
    my $cat = shift;
    my $html;

    for( split(',', $CATEGORIES) )
    {
        $html .= $cat eq $_ ? qq|<option value="$_" selected>$_</option>\n| : qq|<option value="$_">$_</option>\n|;
    }

    return $html;
}



sub getUsername
{
    my $string = shift;
    return substr($string, 0, rindex($string, '.'));
}



sub heightWidth
{
    my( $ht, $wd ) = @_;
    return if( !$ht || !$wd );
    return qq| height="$ht" width="$wd"|;
}



sub sortMembers
{
    $TOTAL = 0;

    for( @{dread("$DDIR/members", '\.cnt$')} )
    {
        $TOTAL++;
        my $cd  = fsplit("$DDIR/members/$_");
        my $val = $$cd[0];
        next if( $FILTER && $val < $MIN_HITS );
        $MEM{$_} = $val . '|' . join('|', @{$cd});
    }

    @SORTED = sort { $MEM{$b} <=> $MEM{$a} } keys %MEM;
}