<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.0 Build 9                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2004 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);
define('CURR_FILE','statschart.php');
error_reporting(E_ERROR | E_WARNING | E_PARSE);

function filled_arc(&$im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $int_line_color, $int_fill_color='') {

	ImageArc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $int_line_color);
	$x = $CenterX + (cos(deg2rad($Start)) * ($DiameterX / 2));
	$y = $CenterY + (sin(deg2rad($Start)) * ($DiameterY / 2));
	imageline($im, $x, $y, $CenterX, $CenterY, $int_line_color);
	$x = $CenterX + (cos(deg2rad($End)) * ($DiameterX / 2));
	$y = $CenterY + (sin(deg2rad($End)) * ($DiameterY / 2));
	imageline($im, $x, $y, $CenterX, $CenterY, $int_line_color);
	if ($int_fill_color != '')
	{
		if (($End - $Start) > 0.5)
		{
			$x = $CenterX + (cos(deg2rad(($Start + $End) / 2)) * ($DiameterX / 4)); 
			$y = $CenterY + (sin(deg2rad(($Start + $End) / 2)) * ($DiameterY / 4)); 
			ImageFillToBorder($im, $x, $y, $int_line_color, $int_fill_color);
		}
	}
}

function chart_pie($title, $data, $width, $height, $CenterX, $CenterY, $DiameterX, $DiameterY, $MinDisplayPct, $DisplayColors, $BackGroundColor, $TextColor, $LineColor, $Legend=true, $FontNumber=5, $SortData=true,$text_copyright='') {

	if ($Legend)
	{
		$DiameterX = $DiameterY;
		$CenterX = $width - $CenterY;
	}
	if ($im = @ImageCreate($width, $height))
	{
		$int_background_color = ImageColorAllocate($im, hexdec(substr($BackGroundColor, 0, 2)), hexdec(substr($BackGroundColor, 2, 2)), hexdec(substr($BackGroundColor, 4, 2)));
		$int_text_color = ImageColorAllocate($im, hexdec(substr($TextColor, 0, 2)), hexdec(substr($TextColor, 2, 2)), hexdec(substr($TextColor, 4, 2)));
		$int_line_color = ImageColorAllocate($im, hexdec(substr($LineColor, 0, 2)), hexdec(substr($LineColor, 2, 2)), hexdec(substr($LineColor, 4, 2)));
		
		imagestring($im, $FontNumber, $width-( (strlen($text_copyright)*imagefontwidth($FontNumber)) + 10), $height - round(imagefontheight($FontNumber)+5), $text_copyright, $int_text_color);
		
		$fillcolorsarray = explode(';', $DisplayColors);
		$k = sizeof($fillcolorsarray);
		for ($i=0; $i<$k; $i++)
		{
			$int_fill_color[]= ImageColorAllocate($im, hexdec(substr($fillcolorsarray[$i], 0, 2)), hexdec(substr($fillcolorsarray[$i], 2, 2)), hexdec(substr($fillcolorsarray[$i], 4, 2)));
			$int_label_color[]= ImageColorAllocate($im, hexdec(substr($fillcolorsarray[$i], 0, 2)) * 0.8, hexdec(substr($fillcolorsarray[$i], 2, 2)) * 0.8, hexdec(substr($fillcolorsarray[$i], 4, 2)) * 0.8);
		}
		$TotalArrayValues = array_sum($data);
		if ($SortData)
		{
			arsort($data);
		}
		$Start = 0;
		$valuecounter = 0;
		$ValuesSoFar = 0;
		foreach ($data as $key => $value)
		{
			if($added_title++ <1 )
			{
				$FontNumber = $FontNumber+3;
				imagestring($im, $FontNumber+2, round( ($width/2) - (imagefontwidth($FontNumber)*strlen($title))/2  ), round((imagefontheight($FontNumber) * .5) + ($valuecounter * 1.5 * imagefontheight($FontNumber))), $title , $int_text_color);
				$valuecounter++;
				$FontNumber = $FontNumber-3;
			}
			$int_y = round((imagefontheight($FontNumber) * .5) + ($valuecounter * 1.5 * imagefontheight($FontNumber)));
			$ValuesSoFar += $value;
			if (!$SortData || (($value / $TotalArrayValues) > $MinDisplayPct))
			{
				$End = ceil(($ValuesSoFar / $TotalArrayValues) * 360);
				filled_arc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $int_line_color, $int_fill_color[$valuecounter % count($int_fill_color)]);
				if ($Legend)
				{
					imagefilledrectangle($im, 4, $int_y+1, 14, $int_y+11, $int_text_color);
					imagefilledrectangle($im, 5, $int_y+2, 13, $int_y+10, $int_fill_color[$valuecounter % count($int_fill_color)]);
					imagestring($im, $FontNumber, 20, round((imagefontheight($FontNumber) * .5) + ($valuecounter * 1.5 * imagefontheight($FontNumber))), $key.' ('.number_format(($value / $TotalArrayValues) * 100, 1).'%)', $int_text_color);
				}
				$Start = $End;
			} else {
				$End = 360;
				if ((($TotalArrayValues - $ValuesSoFar) / $TotalArrayValues) > 0.0025)
				{
					filled_arc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $int_line_color, $int_line_color);
				}
				if ($Legend)
				{
					imagefilledrectangle($im, 4, $int_y+1, 14, $int_y+11, $int_text_color);
					imagefilledrectangle($im, 5, $int_y+2, 13, $int_y+10, $int_line_color);
					imagestring($im, $FontNumber, 20, round((imagefontheight($FontNumber)*.5) + ($valuecounter*1.5*imagefontheight($FontNumber))), 'Outros ('.number_format((($TotalArrayValues - $ValuesSoFar) / $TotalArrayValues) * 100,2).'%)', $int_text_color);
				}
				break;
			}
			$valuecounter++;
		}
		if (@function_exists('ImagePng'))
		{
			@header("Content-type: image/png"); //if GD support JPEG
			ImagePng($im);
		} else {
			@header("Content-type: image/jpeg"); //if GD support JPEG
			ImageJPEG($im);
		}
		ImageDestroy($im);
		return true;
	} else {
		echo 'Cannot Initialize new GD image stream';
		return false;
	}
}
/* #################################### image ################################### */
if(!empty($HTTP_GET_VARS)) {
	while(list($xxxname, $value) = each($HTTP_GET_VARS)) {
		$$xxxname = $value;
    }
}
if(!empty($HTTP_POST_VARS)){
	while(list($xxxname, $value) = each($HTTP_POST_VARS)) {
		$$xxxname = $value;
	}
}

$title = urldecode(stripslashes($title));
$data = urldecode(stripslashes($data));
$width	= empty($w)? 450 : $w;
$height	= empty($h)? 320 : $h;
$font_size = empty($tfz)? 2 : $tfz;
$text_copyright = 'vCard PRO (c)' .date('Y');
// '<img src="statschart.php?data='. urlencode(serialize($data)) .'">';
/* #################################### image ################################### */
if (empty($type))
{
	$width	= 450;
	$height	= 250;
	$background = 'ffffff';
	$barcolor = '00ff00';
	$textcolor = '000000';
	$im = imagecreate($width,$height);
	$int_background = ImageColorAllocate($im, hexdec(substr($background, 0, 2)), hexdec(substr($background, 2, 2)), hexdec(substr($background, 4, 2)));
	$int_textcolor = ImageColorAllocate($im, hexdec(substr($textcolor, 0, 2)), hexdec(substr($textcolor, 2, 2)), hexdec(substr($textcolor, 4, 2)));
	$int_barcolor = ImageColorAllocate($im, hexdec(substr($barcolor, 0, 2)), hexdec(substr($barcolor, 2, 2)), hexdec(substr($barcolor, 4, 2)));
	imagestring($im, $font_size, ($width-imagefontwidth($font_size)*strlen($title))/2, 0, $title, $int_textcolor);
	imagefilledrectangle($im, 25, 20, $width-10, $height-10, $int_background);
	$valeurs = explode(';',$data);
	$width_barre = (int)(($width-22)/(1.5*sizeof($valeurs)+0.5));
	$k = sizeof($valeurs);
	for ($i=0; $i<$k; $i++)
	{
		if ($valeurs[$i] > $max)
		{
			$max = $valeurs[$i];
		}
	}
	
	for ($i=0; $i<sizeof($valeurs); $i++)
	{
		$x = 25+(int)($width_barre*(0.5+$i*1.5));
		$height_barre = (int)(($valeurs[$i]*($height-40))/$max);
		imagefilledrectangle($im, $x, $height-15-$height_barre, $x+$width_barre, $height-15, $int_barcolor);
		if ($valeurs[$i] == $max)
		{
			imagestring($im, 2, 4, ($height-15-$height_barre)-(imagefontheight(2)/2), $valeurs[$i], $int_textcolor);
			imageline($im, 20, $height-15-$height_barre, $width-2, $height-15-$height_barre, $int_background);
		}
		if (($i % 2)==0)
		{
			imagestring($im, 1, $x, $height-9, $i, $int_textcolor);
		}
	}
	imagestring($im, 2, 3, 0, 'hits', $int_textcolor);
	imagestring($im, -10, 320, 191, 'Hour', $int_textcolor);
	if (@function_exists('ImagePng'))
	{
		@header("Content-type: image/png");		//if your php support JPEG
		ImagePng($im);
	} else {
		@header("Content-type: image/jpeg");	//if your php support JPEG
		ImageJPEG($im);
	}
	ImageDestroy($im);
	exit;
}
if ($type=='pie')
{
	if (empty($data))
	{
		if (!isset($demomode)){
			srand(time());
			for ($i = 1; $i < 15; $i++)	{ $data['demo '.$i] = rand(0, 1000);}
		} else {
			$data = array('NO DATA'=>1);
		}
	}else{
		$data = unserialize($data);
	}
	$CenterX = round($width / 2);
	$CenterY = round($height / 2);
	$DiameterX = round($width * 0.75);
	$DiameterY = round($height * 0.75);
	$DiameterX = round($width * 0.75);
	$DiameterY = round($height * 0.75);
	$MinDisplayPct = 0.01;
	$DisplayColors = '000066;00ff00;ff0000;0000ff;ffff00;ff00ff;00ffff;ff8400;ceceff;808000;990099;eac8b7;597e7b;8a1e37;00CCFF;FFCCFF;003366;FF00FF;666666;000000';
	$BackGroundColor = 'ffffff';
	$TextColor = '000000';
	$LineColor = '000000';
	$Legend = true;
	$FontNumber = $font_size;
	$SortData = true;
	if (($width > 800) || ($height > 640) || ($width <= 0) || ($height <= 0))
	{
		die('Image size limited to 819 x 819 for safety reasons');
	}
	chart_pie($title, $data, $width, $height, $CenterX, $CenterY, $DiameterX, $DiameterY, $MinDisplayPct, $DisplayColors, $BackGroundColor, $TextColor, $LineColor, $Legend, $FontNumber, $SortData, $text_copyright);
}

?>