<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.0 Build 9                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2004 Belchior Foundry                   //
//***************************************************************************//
// ##############################  DATE FUNC  ############################## //
function get_day_after($date) {
	list ($year, $month, $day) = split ('[/.-]', $date);
	$sec_pass = mktime() - mktime(0,0,0, $month, $day, $year);
	$day_pass = floor( $sec_pass / 86400); // % div modulo
	return $day_pass;
}
function get_date_agebybirthday($month,$day,$year) {
	$iTimeStamp = (mktime() - 86400) - mktime(0, 0, 0, $month, $day, $year);
	$idays = $iTimeStamp / 86400;
	$ageyears = floor($idays / 365.25);
	return $ageyears;
}
function make_date_form2db($date,$limit="-") {
	if (ereg("([0-9]{2,4})$limit([0-9]{1,2})$limit([0-9]{1,2})", $date, $regs))
	{
		if (strlen($regs['1']) <4) $regs['1'] = '20'.$regs['1'];
		if (strlen($regs['2']) <2) $regs['2'] = '0'.$regs['2'];
		if (strlen($regs['3']) <2) $regs['3'] = '0'.$regs['3'];
		$value = $regs['1'].'-'.$regs['2'].'-'.$regs['3'];
		return $value;
	} else {
		return false;
	}
}
function make_date_db2form($date,$delimiter='-') {
	$d = array();
	$d['day'] = substr($date,6,2);
	$d['month'] = substr($date,4,2);
	$d['year'] = substr($date,0,4);
	return $d['day'].$delimiter.$d['month'].$delimiter.$d['year'];
}
function get_date_readable($date) {
	global $cfg;
	if (eregi("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $date, $regs))
	{
		$regs['1'] = (strlen($regs['1'])>=4)? $regs['1'] : '20'.$regs['1'];
		$regs['2'] = (strlen($regs['2'])>=2)? $regs['2'] : '0'.$regs['2'];
		$regs['3'] = (strlen($regs['3'])>=2)? $regs['3'] : '0'.$regs['3'];
		$month = get_monthname($regs['2'],1);
		$day = $regs['3'];
		$year = $regs['1'];
		if ($cfg['site_dateformat'] == 1){
			$date = $day.'-'.$month.'-'.$year;
		} else {
			$date = $month.'-'.$day.'-'.$year;
		}
	}
	if ($year !='0000')
	{
		return $date;
	}
}
function get_monthname($month,$section='') {
	global $msg;
	
	$month = $month + 1;
	$month = $month - 1;
	if ($section == 1)
	{
		return $msg['month_names'][$month];
	} else {
		return $msg['a_month_names'][$month];
	}
}

// ##############################  FILE & DIR FUNC  ############################## //
function my_realpath($path) {
	return (!@function_exists('realpath') || !@realpath(VCARD_ROOT_PATH.'include/functions.inc.php')) ? $path : @realpath($path);
}
function fix_url_dir($url) {
	if(!empty($url))
	{
		return (substr($url,-1)=='/')? $url : $url . '/';
	}else{
		return './';
	}
}
function get_file_extension($file) {
	$file = strtolower($file);
	$extension = split("[/\\.]", $file);
	$n = sizeof($extension)-1;
	$extension = $extension[$n];
	return $extension;
}
function is_invalid_file_extension($file,$types=array()) {
	$ext = get_file_extension($file);
	if (in_array($ext, $types))
	{
		return false;
	} else {
		return true;
	}
}
function get_video_url($file) {
	global $cfg;
	return eregi('http://',$file)? $file : $cfg['site_image_url'] . $file;
}
function get_audio_url($file) {
	global $cfg;
	return eregi('http://',$file)? $file : $cfg['site_music_url'] . $file;
}
function get_video_dir($file) {
	global $cfg;
	return $cfg['site_image_path'] . $file;
}
function get_audio_dir($file) {
	global $cfg;
	return $cfg['site_music_path'] . $file;
}

// ##############################  STRING FUNC  ############################## //
function my_htmlspecialchars($data) {
   $data = ereg_replace('"','&quot;', $data);
   $data = ereg_replace("'","&#039;", $data);
   return $data;
}
function make_remove_extrachars($str,$nchar=500){
	$str = substr($str, 0, $nchar);
	return $str;
}
function get_widthpercent($column) {
	$width = (100/$column);
	list($first, $second) = split ('[/.-]', $width);
	$valor = $first.'%';
	return $valor;
}
function make_idmessage() {
	
	$pool = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$pool .= 'abcdefghijklmnopqrstuvwxyz';
	$pool .= '0123456789';
	mt_srand ((double) microtime() * 1000000);
	$unique_id = '';
	for ($i=0; $i<12; $i++)
	{
		$unique_id .= substr($pool, (mt_rand()%(strlen($pool))), 1);
	}
	$unique_id = date("ymdHis").$unique_id;
	return $unique_id;
}
function get_readable_password() {
	$word_arr_one = array(
						'mirc','old','rose','pink','blue','cyan','gold', 'lime','silk','slim','sant','lock',
						'walk','warm','zoom','high','jack','posh','face','hand','next','site','they','tune',
						'dose','cool','club','club','cube','baby','body','auto','acid','home');
	$word_arr_two = array(
						'aunt','gold','love','girl','time','door','disc','book','news','star','wica','morp',
						'ball','bond','trek','joke','tall','tank','drum','hill','duck','rock','blur','luar',
						'hand','cook','black','look','mate','main','pack','page','palm','talk');
	$arr_one_len = sizeof($word_arr_one);
	$arr_two_len = sizeof($word_arr_two);
	mt_srand ((double)microtime()*1000000);
	for($i=0; $i<5; $i++)
	{
		$pos_one = mt_rand(0,($arr_one_len-1));
		if($pos_one%2 == 0 )
		{
			$pwd_one = $word_arr_one[$pos_one].$pwd_one;
		}else{
			$pwd_one.= $word_arr_one[$pos_one];
		}
	}
	for($i=0; $i<5; $i++)
	{
		$pos_two = mt_rand(0,($arr_two_len-1));
		if($pos_two%2 == 0 )
		{
			$pwd_two.= $word_arr_two[$pos_two];
		}else{
			$pwd_two = $word_arr_two[$pos_two].$pwd_two;
		}
	}
	$str = substr($pwd_one,0,4) . mt_rand(10,99) . substr($pwd_two,0,4); 
	return $str; 
}

// ##############################  ARRAYS  ############################## //
function view_array($array) {
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key1 => $elem1)
	{
		echo '<tr>';
		echo '<td>'.$key1.'&nbsp;</td>';
		if (is_array($elem1)){
			ext_array($elem1);
		} else {
			echo '<td>'.htmlspecialchars($elem1).'&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
}
function ext_array($array) {
	echo '<td>';
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key => $elem)
	{
		echo '<tr>';
		echo '<td>'.$key.'&nbsp;</td>';
		if (is_array($elem))
		{
			ext_array($elem);
		} else {
			echo '<td>'.htmlspecialchars($elem).'&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
	echo '</td>';
}
function my_array_sort($array, $key) {
	$k = sizeof($array);
	for ($i=0; $i<$k; $i++)
	{
		$sort_values[$i] = $array[$i][$key];
	}
	if (is_array($sort_values))
	{
		asort($sort_values);
		reset($sort_values);
		foreach($sort_values as $arr_key=>$arr_val)
		{
			$sorted_arr[] = $array[$arr_key];
		}
	}
	return $sorted_arr;
}

// ##############################  HTTP HEADER  ############################## //
function my_setcookie($name,$value="",$permanent=1) {
	$cookiepath = '/';
	$cookiedomain = '';
	$SERVER_PORT = '';
	$expire = ($permanent)? time() + 60*60*24*365 : 0;
	if ($SERVER_PORT == '443')
	{
		$secure = 1; // we're using SSL
	} else {
		$secure = 0;
	}
	if ($cookiedomain)
	{
		@setcookie($name,addslashes($value), $expire, $cookiepath, $cookiedomain, $secure);
	} else {
		@setcookie($name,addslashes($value), $expire, $cookiepath, '', $secure);
	}
}
function my_redirect_die($url){
	global $msg;
	//$url .= ( ( strpos($url, '?') != false ) ? '&' : '?' ) . 'tstamp='.time();
	if (defined('HEADER_INC'))
	{
		echo '<script type="text/javascript">window.location="'.$url.'";</script>';
		echo '<p><a href="'. $url .'">'.$msg['a_continue'].'</a></p>';
	} else {
		@header("Location: ". $url);
	}
	exit;
}
function make_redirectpage($url) {
	global $cfg;
	//$url .= ( ( strpos($url, '?') != false ) ? '&' : '?' ) . 'tstamp='.time();
	if(!@header("Location: ". $url))
	{
		echo '<html><head>';
		echo '<meta content="text/html; charset=iso-8859-1" http-equiv="Content-Type" />';
		echo '<meta http-equiv="Refresh" content="0; URL='.$url.'" />';
		echo '<title>'.$cfg['site_name'].'</tile>';
		echo '<body>';
		echo '<script type="text/javascript">window.location="'.$url.'";</script>';
		echo '</body>';
		echo '</html>';
		exit;
	}
}

// ##############################  HTML CODES  ############################## //
function html_body($file_url='',$base_url='',$extra='') {
	global $cfg;
	$base_url = !empty($base_url)? $base_url : $cfg['site_image_url'];
	$file_url = eregi('http://',$file_url)? $file_url : $base_url.$file_url;
	$show = "\n<body ".( !empty($file_url)? "background='".$file_url."'":'' ) ." $extra>\n";
	return $show;
}
function make_html_hiddenfield($name,$value) {
	
	echo '<input type="hidden" name="'.$name.'" value="'.$value.'" />';
}
function get_html_hiddenfield($name,$value='',$htmlise=1) {
	
	if (is_array($name))
	{
		foreach ($name as $key => $value) 
		{
			if ($key != 'action' && $key!='preview' && $key!='sendnow')
			{
				if ($htmlise)
				{
					$value = addslashes(htmlspecialchars(stripslashes($value),ENT_QUOTES));
				}
				$hidden .= '<input name="'.$key.'" type="hidden" value="'.$value.'" />'."\n";
			}
		}
		return $hidden;
	} else {
		if ($htmlise)
		{
			$value = addslashes(htmlspecialchars(stripslashes($value),ENT_QUOTES));
		}
		return '<input type="hidden" name="'.$name.'" value="'.$value.'" />'."\n";
	}
}
function get_html_formselector_advdate($range,$format,$name,$value='') {
	global $msg,$sys_tmp_vars;
	
	$show = '<select name="'.$name.'" size="1">'."\n";
	$show .= '<option value="'.$sys_tmp_vars['Y-m-d'].'">'. $msg['date_to_send_now'] .'</option>';
	$i = 0;
	$d = $sys_tmp_vars['d'] + 1;
	$m = $sys_tmp_vars['m'];
	$y = $sys_tmp_vars['Y'];
	
	for ($d; $i<=$range; $d++)
	{
		if ($d == 32)
		{
			$m = $m + 1;
			if ($m > 12)
			{
				$m = 1;
				$y = $y + 1;
			}
			$d = 1;
		}
		if (checkdate($m,$d,$y))
		{
			$show .= '<option value="'.$y.'-'.$m.'-'.$d.'" '.( ($value==$y.'-'.$m.'-'.$d)? 'selected="selected"': '' ).">";
			if ($format == 1)
			{
				$show .= $d.' - '.get_monthname($m,1).' - '.$y.'</option>';
			} else {
				$show .= get_monthname($m,1).' - '. $d .' - '. $y .'</option>';
			}
			$i++;
		}
	}
	$show .= '</select>';
	return $show;
}
// ##############################  END-USER ECARD DATA  ############################## //
function save_data_cardcopy($recip_arr,$sender_name,$sender_email,$data) {
	global $DB_site,$msg,$sys_user_session;
	
	$message_id = make_idmessage();
	sendmail_copy($recip_arr,$sender_email,$sender_name,$data,$message_id);
	$data['card_sent'] = 1;
	spam_inserdata();
	$data['card_notify'] = 0;
	$recip_email = $msg['recip_email'];
	$recip_name	= $msg['recip_name'];
	$sql = "INSERT INTO ". TBL_USR_ECARD ." (
		card_date,sender_name,sender_email,sender_ip,recip_name,recip_email,card_file,card_id,card_stamp,card_message,card_sig,card_heading,card_sound,card_poem,card_effect,card_background,card_color,card_template,card_fontface,card_fontcolor,card_fontsize,message_id,card_notify,card_tosend,card_sent)
		VALUES (NOW(),'".addslashes($sender_name)."','".addslashes($sender_email)."','".addslashes($sys_user_session['ip'])."','".addslashes($sender_name)."','".addslashes($sender_email)."','".addslashes($data['card_file'])."','".addslashes($data['card_id'])."','".addslashes($data['card_stamp'])."','".addslashes($data['card_message'])."','".addslashes($data['card_sig'])."','".addslashes($data['card_heading'])."','".addslashes($data['card_sound'])."','".addslashes($data['card_poem'])."','".addslashes($data['card_effect'])."','".addslashes($data['card_background'])."','".addslashes($data['card_color'])."','".addslashes($data['card_template'])."','".addslashes($data['card_fontface'])."','".addslashes($data['card_fontcolor'])."','".addslashes($data['card_fontsize'])."','".addslashes($message_id)."','".addslashes($data['card_notify'])."','".addslashes($data['card_tosend'])."','".addslashes($data['card_sent'])."') ";
	$DB_site->query($sql);
	if (!empty($data['card_id']))
	{
		save_data_stats($data['card_id'],$data['card_template']);
	}
}
function save_data_card($recip_email,$recip_name,$sender_name,$sender_email,$data) {
	global $DB_site,$sys_user_session,$sys_tmp_vars;
	global $cfg;
	global $receive_newsletter;
	
	$message_id = make_idmessage();
	$data['card_sent'] = 0;
	$data['card_tosend'] = make_date_form2db($data['card_tosend']);
	if ($data['card_tosend'] <= $sys_tmp_vars['Y-m-d'])
	{
		if(sendmail_pickup($recip_email,$recip_name,$sender_email,$sender_name,$message_id,$sys_user_session['ip']))
		{
			$data['card_sent'] = 1;
		}else{
			$data['card_sent'] = 0;
		}
	}
	spam_inserdata();
	$sql = "INSERT INTO ". TBL_USR_ECARD ." (card_date,sender_name,sender_email,sender_ip,recip_name,recip_email,card_file,card_id,card_stamp,card_message,card_sig,card_heading,card_sound,card_poem,card_effect,card_background,card_color,card_template,card_fontface,card_fontcolor,card_fontsize,message_id,card_notify,card_tosend,card_sent)
		VALUES (NOW(),'".addslashes($sender_name)."','".addslashes($sender_email)."','".addslashes($sys_user_session['ip'])."','".addslashes($recip_name)."','".addslashes($recip_email)."','".addslashes($data['card_file'])."','".addslashes($data['card_id'])."','".addslashes($data['card_stamp'])."','".addslashes($data['card_message'])."','".addslashes($data['card_sig'])."','".addslashes($data['card_heading'])."','".addslashes($data['card_sound'])."','".addslashes($data['card_poem'])."','".addslashes($data['card_effect'])."','".addslashes($data['card_background'])."','".addslashes($data['card_color'])."','".addslashes($data['card_template'])."','".addslashes($data['card_fontface'])."','".addslashes($data['card_fontcolor'])."','".addslashes($data['card_fontsize'])."','".addslashes($message_id)."','".addslashes($data['card_notify'])."','".addslashes($data['card_tosend'])."','".addslashes($data['card_sent'])."') ";
	$DB_site->query($sql);
	
	if ($receive_newsletter == 1)
	{
		save_data_email($sender_email,$sender_name);
	}
	if (!empty($data['card_id']))
	{
		save_data_stats($data['card_id'],$data['card_template']);
	}
	return $message_id;
}
// ##############################  LOGGING  ############################## //
function save_data_stats($card_id,$card_template) {
	global $DB_site,$sys_tmp_vars;
	
	$logdate = date('Y-m-d H:i:s',$sys_tmp_vars['timestamp']);
	$sql = "INSERT INTO ". TBL_STATS_ECARD ." ( date, card_id,card_template) VALUES ('$logdate','".addslashes($card_id)."','".addslashes($card_template)."') ";
	$DB_site->query($sql);
}
function external_filelog($url) {
	global $DB_site;
	if (eregi('http://',$url))
	{
		$sql = " INSERT INTO ". TBL_STATS_EXTFILE ." (extfile_id,extfile_file,extfile_date) VALUES (NULL, '".addslashes($url)."', CURDATE())";
		$DB_site->query($sql); 
	}
}
function save_data_email($email,$name='') {
	global $DB_site;
	$email = strtolower($email);
	$sql = "INSERT INTO ". TBL_LOG_EMAIL ." ( date, name, email) VALUES (NOW(),'".addslashes($name)."','".addslashes($email)."') ";
	$result = $DB_site->query($sql);
}
function save_data_search($str='') {
	global $DB_site,$sys_tmp_vars;
	$str = eregi_replace("%'",'',$str);
	$str = eregi_replace("'%",'',$str);
	$str = eregi_replace('%','',$str);
	$str = trim(addslashes($str));
	if (!empty($str))
	{
		$logdate = date("Y-m-d H:i:s",$sys_tmp_vars['timestamp']);
		$sql = "INSERT INTO ". TBL_LOG_SEARCH ." ( search_date, search_word) VALUES ('$logdate','".addslashes($str)."') ";
		$DB_site->query($sql);
	}
}
// ##############################  SPAM FUNC ############################## //
function spam_inserdata() {
	global $DB_site,$sys_user_session;
	
	$sql = "INSERT INTO ". TBL_SPAM ." VALUES (NULL,'".$sys_user_session['ip']."','".time()."') ";
	$DB_site->query($sql);
}
function is_spam_bulk($curr_bulk=0) {
	global $DB_site,$cfg,$sys_user_session;
	
	$sql = "SELECT * FROM ". TBL_SPAM ." WHERE ip='". $sys_user_session['ip'] ."' AND date > ".( time()-3600 )." ";
	$data_arr = $DB_site->query($sql);
	$num_rows = $DB_site->num_rows($data_arr);
	$DB_site->free_result($data_arr);
	if (($num_rows+$curr_bulk) >= $cfg['antispam_allow_entries'])
	{
		return true;
	}
}
// ##############################  ERROR HANDLING ############################## /
function usr_message_die($msg_case,$msg_text,$case='') {
	global $page_header,$page_footer,$page_header_include,$page_phpinclude,$htmlbody,$cfg,$msg,$sys_tmp_vars;
	global $drop_down_list,$list_cat_text,$list_calendar,$list_topcards_in_site,$msg_top_cards;
	global $list_text_all_cats,$box_pickup,$box_search;
	global $HTTP_POST_VARS,$DB_site;
	
	if(!defined('HEADER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_header.inc.php');
	}
	if(is_array($HTTP_POST_VARS))
	{
		foreach ($HTTP_POST_VARS as $name => $value) 
		{
			if ($varname != 'action' && $varname!='preview' && $varname!='sendnow')
			{
				$hidden_fields .= '<input name="'. $name .'" type="hidden" value="'. $value .'" />'."\n";
			}
		}
	}
	if (!empty($action))
	{
		$hidden_fields .= "<input name='action' type='hidden' value='$action' />\n";
	}
	switch($msg_case)
	{
		case GENERAL_MESSAGE:
			$error_title = $msg['mdie_information'];
			break;
		case CRITICAL_MESSAGE:
			$error_title = $msg['mdie_critical_information'];
			break;
		case GENERAL_ERROR:
			$error_title = $msg['mdie_general_error'];
			$error_text = empty($msg_text)? $msg['mdie_an_error_occured'] : $msg_text;
			break;
		case CRITICAL_ERROR:
			$error_title = $msg['mdie_critical_error'];
			$error_text = empty($msg_text)? $msg['mdie_critical_error'] : $msg_text;
			break;
	}
	switch($case)
	{
		case 'edit':
			$form_button = '<form action="'.CREATE_PAGE.'" method="post">'. $hidden_fields . "<input name='action' type='hidden' value='edit' /><input type='submit' value=' ". $msg['back']." ' width='200' /></form>";
			break;
		case 'back':
			$form_button = "<form><input type='submit' value=' ". $msg['back']." ' width='200' onClick='javascript:history.go(-1)' /></form>";
			break;
		default:
			$form_button = "<p align='center'><a href='".INDEX_PAGE."'><b>". $msg['home'] ."</b></a></p>";
			break;
	}
	$page_header_include .= '<script src="./script.js" type="text/javascript"></script>';
	$htmlbody = html_body($cfg['site_body_bgimage']);
	eval("make_output(\"".get_template('page_error')."\");");
	if(!defined('FOOTER_INC'))
	{
		include(VCARD_ROOT_PATH.'include/user_footer.inc.php');
	}
	exit;
}

// ##############################  CATS ARRAYS  ############################## //
function make_full_cat_tree() {
	global $DB_site,$totalcards_in_site,$sys_tmp_vars,$cat_tree_arr;
	$cat_tree_arr = array();
	$totalcards_in_site = 0;
	$sql = "SELECT * FROM ". TBL_CARDS_CAT ." ORDER BY cat_order";
	$data_arr = $DB_site->query($sql);
	$i = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$cat_tree_arr[] = array(
				'cat_id' => $row['cat_id'],
				'cat_subid' => $row['cat_subid'],
				'cat_order' => $row['cat_order'],
				'cat_name' => stripslashes($row['cat_name']),
				'cat_img' => $row['cat_img'],
				'cat_link' => $row['cat_link'],
				'cat_header' => stripslashes($row['cat_header']),
				'cat_footer' => stripslashes($row['cat_footer']),
				'cat_sort' => $row['cat_sort'],
				'cat_ncards' => $row['cat_ncards'],
				'cat_active' => $row['cat_active']
		);
		$totalcards_in_site += $row['cat_active']==1 ? $row['cat_ncards'] : 0;
		$i++;
	}
	$sys_tmp_vars['k'] = $i;
	unset($row);
	$DB_site->free_result($data_arr);
}

function get_catinfo($cid) {
	global $cat_tree_arr,$sys_tmp_vars;
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id']==$cid)
		{
			return array(
				'cat_id' => $cat_tree_arr[$i]['cat_id'],
				'cat_subid'=> $cat_tree_arr[$i]['cat_subid'],
				'cat_order'=> $cat_tree_arr[$i]['cat_order'],
				'cat_name'=> $cat_tree_arr[$i]['cat_name'],
				'cat_img'=> $cat_tree_arr[$i]['cat_img'],
				'cat_link'=> $cat_tree_arr[$i]['cat_link'],
				'cat_header' => $cat_tree_arr[$i]['cat_header'],
				'cat_footer' => $cat_tree_arr[$i]['cat_footer'],
				'cat_sort'=> $cat_tree_arr[$i]['cat_sort'],
				'cat_ncards'=> $cat_tree_arr[$i]['cat_ncards'],
				'cat_active'=> $cat_tree_arr[$i]['cat_active']);
		}
	}
}
function get_total_ncards($cid=0) {
	global $cat_tree_arr,$sys_tmp_vars;
	
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id']==$cid)
		{
			return $cat_tree_arr[$i]['cat_ncards'];
		}
	}
}
function get_total_ncards_catandsubcat($cid=0) {
	global $cat_tree_arr,$sys_tmp_vars;
	
	$total = get_total_ncards($cid);
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid']==$cid && $cat_tree_arr[$i]['cat_active']==1)
		{
			$total += get_total_ncards_catandsubcat($cat_tree_arr[$i]['cat_id']);
		}
	}
	return $total;
}
function make_recount_ncards_to_cat(){
	global $DB_site;
	
	$sql = "SELECT * FROM ". TBL_CARDS_CAT ." ";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$sql = "SELECT count(card_id) AS count FROM ". TBL_CARDS_DATA ." WHERE cat_id='".$row['cat_id']."' AND card_active='1' ";
		$count_info = $DB_site->query_first($sql);
		$sql = "UPDATE ". TBL_CARDS_CAT ." SET cat_ncards='". $count_info['count'] . "' WHERE cat_id='".$row['cat_id']."' ";
		$DB_site->query($sql);
	}
	$DB_site->free_result($data_arr);
}
function get_html_dropdown_cat2() {
	global $DB_site,$cat_tree_arr,$sys_tmp_vars;
	global $cfg,$sys_tmp_vars;
	
	$html = "\n<form><select OnChange=\"if (options[selectedIndex].value) location.href=(options[selectedIndex].value)\">\n<option value=''>". $msg['go_to'] ."</option>\n<option value='".INDEX_PAGE."'>". $msg['home'] ."</option>\n";
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if (empty($cat_tree_arr[$i]['cat_subid']) && $cat_tree_arr[$i]['cat_active']==1)
		{
			$html .= '<option value="'.GBROWSE_PAGE.'?cat_id='. $cat_tree_arr[$i]['cat_id'] .'"> ' .$cat_tree_arr[$i]['cat_name'] .'</option>'."\n";
			for ($j=0; $j < $k ;$j++)
			{
				if ($cat_tree_arr[$j]['cat_subid']==$array[$i]['cat_id'] && $cat_tree_arr[$j]['cat_active']==1)
				{
					$html .= '<option value="'.GBROWSE_PAGE.'?cat_id='. $cat_tree_arr[$j]['cat_id'] . '">&nbsp;&nbsp; &raquo; '. $cat_tree_arr[$j]['cat_name'] .'</option>'."\n";
				}
			}
		}
	}
	$html .='</select></form>';
	return $html;
}
function get_html_dropdown_cat() {
	global $DB_site,$msg;
	global $cfg,$sys_tmp_vars;
	
	$drop_down_list = "\n<form><select OnChange=\"if (options[selectedIndex].value) location.href=(options[selectedIndex].value)\">\n<option value=''>". $msg['go_to'] ."</option>\n<option value='".INDEX_PAGE."'>". $msg['home'] ."</option>\n";
	$drop_down_list .= get_html_dropdown_opt_cat();
	$drop_down_list .='</select></form>';
	return $drop_down_list;
}
function get_html_dropdown_opt_cat($cat_parent=0,$selected=0,$_menu_level=0){
	global $cat_tree_arr,$sys_tmp_vars;
	
	$space = str_repeat('&nbsp;&nbsp;',$_menu_level*3);
	$_menu_level++;
	$_html = '';
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid']==$cat_parent && $cat_tree_arr[$i]['cat_active']==1)
		{
			$_html .= '<option value="'. GBROWSE_PAGE .'?cat_id='. $cat_tree_arr[$i]['cat_id'] . '">'. $space. $cat_tree_arr[$i]['cat_name'] .'</option>'."\n";
			$_html .= get_html_dropdown_opt_cat($cat_tree_arr[$i]['cat_id'],$selected,$_menu_level);
		}
	}
	$_menu_level--;
	return $_html;
}
function make_html_cat_nav_links($cid){
	global $cat_tree_arr,$sys_tmp_vars;
	
	for ($i=0; $i<=$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id']==$cid)
		{
			$_html = ' / <a href="'. GBROWSE_PAGE .'?cat_id='.$cat_tree_arr[$i]['cat_id'].'">'.$cat_tree_arr[$i]['cat_name'].'</a>' . $_html;
			if ($cat_tree_arr[$i]['cat_subid'] != '0')
			{
				$_html = make_html_cat_nav_links($cat_tree_arr[$i]['cat_subid']) . $_html;
			}
			break;
		}
	}
	return $_html;
}
// ##############################  CATS  ############################## //
function get_parents_cat_ids($cat_id=0) {
	global $cat_tree_arr,$sys_tmp_vars;
	static $_arr = '';
	if ($cat_id==0)
	{
		return $_arr;
	}
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_id']==$cat_id)
		{
			$_arr[]= $cat_tree_arr[$i]['cat_id'];
			get_parents_cat_ids($cat_tree_arr[$i]['cat_subid']);
			break;
		}
	}
	return $_arr;
}
function get_categories_table() {
	global $DB_site,$totalcards_in_site,$cat_tree_arr;
	global $cfg,$sys_tmp_vars,$msg;
	global $list_table_cats,$list_table_main_cats,$sys_tmp_vars;

	$number = $totalcards_in_site;
	$tbl_cat ='<table cellspacing="0" cellpadding="0" width="100%" border="0"><tr>'; 
	$tbl_upcat = '<table cellspacing="0" cellpadding="0" width="100%" border="0"><tr>'; 
	$total_cards_incatsubcat = 0;
	$td = 0;
	$tdd = 0;
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		$catinfo['cat_id'] = $cat_tree_arr[$i]['cat_id'];
		$catinfo['cat_img'] = $cat_tree_arr[$i]['cat_img'];
		$catinfo['cat_name'] = htmlspecialchars(stripslashes($cat_tree_arr[$i]['cat_name']),ENT_QUOTES);
		$catinfo['totalcards'] = get_total_ncards_catandsubcat($cat_tree_arr[$i]['cat_id']);
		$cat_name = $catinfo['cat_name'];
		$cat_img_url = get_video_url($cat_tree_arr[$i]['cat_img']);
		// $cat_html_image = get_html_image($cat_img_url,$cfg['gallery_thm_width'],$cfg['gallery_thm_height']);
		// main cats
		if ((empty($cat_tree_arr[$i]['cat_subid']) || $cat_tree_arr[$i]['cat_subid']==0 ) && $cat_tree_arr[$i]['cat_active']==1)
		{
			$tbl_upcat .= '<td align="center" valign="top" width="' . get_widthpercent($cfg['gallery_table_cols']) . '">';
			if ($cat_tree_arr[$i]['cat_link'] ==1)
			{
				eval("\$tbl_upcat .= \"".get_template('link_cat_text')."\";");
			} else {
				eval("\$tbl_upcat .= \"".get_template('link_cat_image')."\";");
			}
			$tbl_upcat .= '</td>';
			$td++;
			if ($td == $cfg['gallery_table_cols'])
			{
				$tbl_upcat.='</tr><tr>';
				$td = 0;
			}
		}
		if ( $cat_tree_arr[$i]['cat_active']==1)
		{
			$tbl_cat .= '<td align="center" valign="top" width="' . get_widthpercent($cfg['gallery_table_cols']) .'">';
			// all cats
			if ($cat_tree_arr[$i]['cat_link'] ==1)
			{
				eval("\$tbl_cat .= \"".get_template('link_cat_text')."\";");
			} else {
				eval("\$tbl_cat .= \"".get_template('link_cat_image')."\";");
			}
			$tbl_cat .= '</td>';
			$tdd++;
			if ($tdd == $cfg['gallery_table_cols'])
			{
				$tbl_cat .='</tr><tr>';
				$tdd = 0;
			}
		}
	}
	$tbl_upcat .='</tr></table>';
	$tbl_cat .='</tr></table>';
	$list_table_main_cats = $tbl_upcat;
	$list_table_cats = $tbl_cat;
	return true;
}
function get_box_sub_cats($cid) {
	global $cat_tree_arr,$subcategory_table,$sys_tmp_vars;
	global $msg;
	
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid']==$cid)
		{
			$total += ($cat_tree_arr[$i]['cat_active']==1)? $cat_tree_arr[$i]['cat_ncards'] : 0;
		}
	}
	if ($total > 0)
	{
		$box_content = get_subcat_table($cid);
		$box_title	= $msg['sub_categories'];
		eval("\$box_sub_cats = \"".get_template('box_sub_cats')."\";");
	}else{
		$box_sub_cats = '';
	}
	return $box_sub_cats;
}

function get_text_link_to_cat($cid=0,$_menu_level=0){
	global $cfg,$cat_tree_arr,$sys_tmp_vars;
	
	$_html = '';
	$space = str_repeat('&nbsp;-',$_menu_level*3);
	if($_menu_level>3)
	{
		return $_html;
	}
	$_menu_level++;
	reset($cat_tree_arr);
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid']==$cid && $cat_tree_arr[$i]['cat_active']==1)
		{
			$cat_name = stripslashes($cat_tree_arr[$i]['cat_name']);
			$cat_id = $cat_tree_arr[$i]['cat_id'];
			
			if(get_has_sub_cat($cat_tree_arr[$i]['cat_id'])) // with subcats
			{
				$list_cat_text_subs = get_text_link_to_cat($cat_tree_arr[$i]['cat_id'],$_menu_level);
				eval("\$_html .= \"".get_template('list_cats_text_with_sub')."\";");
				unset($list_cat_text_subs);
			}else{ // without subcats
				eval("\$_html .= \"".get_template('list_cats_text_without_sub')."\";");
			}
		}
	}
	$_menu_level--;
	
	if($_menu_level==0) // final output
	{
		$list_cat_text_rows = $_html;
		eval("\$html = \"".get_template('list_cats_text')."\";");
		return $html;
	}
	return $_html;
}
function get_has_sub_cat($cid=0) {
	global $cfg,$cat_tree_arr,$sys_tmp_vars;
	
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		if ($cat_tree_arr[$i]['cat_subid']==$cid && $cat_tree_arr[$i]['cat_active']==1)
		{
			return true;
		}
	}
	return false;
}
function get_subcat_table($cid='') {
	global $DB_site,$cat_tree_arr;
	global $cfg,$msg,$sys_tmp_vars;
	
	$html = '<table cellspacing="0" cellPadding="0" width="100%" border="0"><tr>';
	$td = 0;
	for ($i=0; $i<$sys_tmp_vars['k']; $i++)
	{
		$list_cat_image_main = '';
		$list_cat_image_sub = '';
		$catinfo['cat_name'] = htmlspecialchars(stripslashes($cat_tree_arr[$i]['cat_name']),ENT_QUOTES);
		$catinfo['cat_id'] = $cat_tree_arr[$i]['cat_id'];
		$catinfo['cat_img'] = $cat_tree_arr[$i]['cat_img'];
		//$catinfo['totalcards'] = $cat_tree_arr[$i]['cat_ncards'];
		$cat_img_url = get_video_url($cat_tree_arr[$i]['cat_img']);
		$catinfo['totalcards'] = get_total_ncards_catandsubcat($cat_tree_arr[$i]['cat_id']);
		// $cat_html_image = get_html_image($cat_img_url,$cfg['gallery_thm_width'],$cfg['gallery_thm_height']);
		if (!empty($cid))
		{
				if ($cat_tree_arr[$i]['cat_subid']==$cid && $cat_tree_arr[$i]['cat_active']==1)
				{
					$html .= '<td align="center" valign="top" width="' . get_widthpercent($cfg['gallery_table_cols']) . '">'; 
					if ($cat_tree_arr[$i]['cat_link'] ==1)
					{
						eval("\$html .= \"".get_template('link_cat_text')."\";");
					} else {
						eval("\$html .= \"".get_template('link_cat_image')."\";");
					}
					$html .= '</td>';
					$td++;
				}
		} else {
				if ($cat_tree_arr[$i]['cat_active']==1)
				{
					$html .= '<td align="center" valign="top">';
					if ($cat_tree_arr[$i]['cat_link'] ==1)
					{
						eval("\$html .= \"".get_template('link_cat_text')."\";");
					} else {
						eval("\$html .= \"".get_template('link_cat_image')."\";");
					}
					$html .= '</td>';
					$td++;
				}
		}
		
		if ($td == $cfg['gallery_table_cols'])
		{
			$html .= '</tr><tr>';
			$td = 0;
		}
	}
	$html.='</tr></table>';
	return $html;
}
// ##############################  CARDS  ############################## //
function getcardoftheday() {
	global $DB_site,$sys_tmp_vars;
	
	$today = $sys_tmp_vars['Y-m-d'];
	$html ='';
	return $html;
}

function get_html_day_topcard()
{
	global $DB_site;
	global $cfg,$sys_tmp_vars;
	
	$today = $sys_tmp_vars['Y-m-d'].' 00:00:00';
	$sql = "SELECT COUNT(s.card_id) AS score, cd.card_id, cd.card_thmfile, cd.card_caption,cd.card_date, cd.card_rating
FROM ". TBL_STATS_ECARD ." AS s
	LEFT JOIN ". TBL_CARDS_DATA ." AS cd ON (cd.card_id=s.card_id)
	LEFT JOIN ". TBL_CARDS_CAT ." AS ct ON (cd.cat_id = ct.cat_id)
WHERE s.date>='$today' AND ct.cat_active='1' AND cd.card_active='1'
GROUP BY s.card_id
ORDER BY score DESC
LIMIT ". $cfg['gallery_toplist_value'];
	$data_arr = $DB_site->query($sql);
	$list_top_card_itens = '';
	$i = 0;
	$c = 0;
	$columns = 1;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_id = $row['card_id'];
		$card_imgthm = $row['card_thmfile'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = star_rating($row['card_rating']);
		$card_new = gethml_newbutton($row['card_date']);
		if (!empty($card_imgthm))
		{
			$card_caption = stripslashes($row['card_caption']);
			$card_img_url = get_video_url($row['card_thmfile']);
			$card_thm_image = "<img src='$card_img_url' ". ( !empty($cfg['gallery_thm_width'])?"width='". $cfg['gallery_thm_width'] ."' height='". $cfg['gallery_thm_height'] ."' ":'' ) ." hspace='2' vspace='2' alt='' />";
			eval("\$list_top_card_itens .= \"".get_template('list_top_card_item')."\";");
			$i++;
			$c++;
			if ($c==$columns){
				$list_top_card_itens .= '';
				$c = 0;
			}
		}
		if ($i == $cfg['gallery_toplist_value'])
		{
			break;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$output = \"".get_template('list_top_card')."\";");
	return $output;
}

function get_html_week_topcard() {
	global $DB_site;
	global $cfg,$sys_tmp_vars;
	
	$begin = date("Y-m-d H:i:s", mktime(0,0,0,$sys_tmp_vars['m'],$sys_tmp_vars['d']-date("w",mktime(0,0,0,$sys_tmp_vars['m'],$sys_tmp_vars['d'],$sys_tmp_vars['Y'])),$sys_tmp_vars['Y'])); 
	$end = date("Y-m-d H:i:s", mktime(0,0,0,$sys_tmp_vars['m'],$sys_tmp_vars['d']+6-date("w",mktime(0,0,0,$sys_tmp_vars['m'],$sys_tmp_vars['d'],$sys_tmp_vars['Y'])),$sys_tmp_vars['Y'])); 
	$list_top_card_itens = '';
	$i = 0;
	$c = 0;
	$columns = 1;
	$sql = "SELECT COUNT(cd.card_id) AS score, cd.card_id, cd.card_thmfile, cd.card_caption, cd.card_date, cd.card_rating 
FROM ". TBL_STATS_ECARD ." AS s
	LEFT JOIN ". TBL_CARDS_DATA ." AS cd ON s.card_id=cd.card_id
	LEFT JOIN ". TBL_CARDS_CAT ." AS ct ON ct.cat_id=cd.cat_id
WHERE s.date>='$begin' AND s.date<='$end' AND ct.cat_active='1' AND cd.card_active='1'
GROUP BY s.card_id
ORDER BY score DESC";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_id = $row['card_id'];
		$card_imgthm = $row['card_thmfile'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = star_rating($row['card_rating']);
		$card_new = gethml_newbutton($row['card_date']);
		if (!empty($card_imgthm))
		{
			$card_caption = stripslashes($row['card_caption']);
			$card_img_url = get_video_url($row['card_thmfile']);
			$card_thm_image = "<img src='$card_img_url' ". ( !empty($cfg['gallery_thm_width'])? "width='". $cfg['gallery_thm_width'] ."' height='". $cfg['gallery_thm_height'] ."' ":'' ) ." hspace='2' vspace='2' alt='' />";
			eval("\$list_top_card_itens .= \"".get_template('list_top_card_item')."\";");
			$i++;
			$c++;
			if ($c==$columns){
				$list_top_card_itens .= '';
				$c = 0;
			}
		}
		if ($i == $cfg['gallery_toplist_value'])
		{
			break;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$output = \"".get_template('list_top_card')."\";");
	return $output;;
}

function get_html_toplist($cid='') {
	global $DB_site;
	global $cfg,$sys_tmp_vars;
	
	$i = 0;
	$columns = 0;
	$list_top_card_itens = '';
	$sql_where = (empty($cid))? '': " AND cd.cat_id='$cid' ";
	$sql = "SELECT cd.card_id,cd.card_thmfile,cd.card_date,cd.card_caption,cd.hits,cd.card_rating
FROM ". TBL_CARDS_DATA ." AS cd, ". TBL_CARDS_CAT ." AS ct
WHERE cd.card_active='1' AND cd.cat_id=ct.cat_id AND ct.cat_active='1' AND cd.hits!='0' $sql_where
ORDER BY cd.hits DESC
LIMIT ". $cfg['gallery_toplist_value'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_id = $row['card_id'];
		$card_imgthm = $row['card_thmfile'];
		$card_date = get_date_readable($row['card_date']);
		$card_caption = stripslashes($row['card_caption']);
		$card_img_url = get_video_url($row['card_thmfile']);
		$card_thm_image = "<img src='$card_img_url' ".( !empty($cfg['gallery_thm_width'])? " width='". $cfg['gallery_thm_width'] ."' height='". $cfg['gallery_thm_height'] ."' ": '' ) ." hspace='2' vspace='2' alt='' />";
		$card_rating = star_rating($row['card_rating']);
		$card_new = gethml_newbutton($row['card_date']);
		eval("\$list_top_card_itens .= \"".get_template('list_top_card_item')."\";");
		if ($i==$columns)
		{
			$list_top_card_itens .= '';
			$i = 0;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$output = \"".get_template('list_top_card')."\";");
	return $output;
}
function get_random_cards($cid) {
	global $DB_site;
	global $cfg,$sys_tmp_vars,$msg;
	
	$html = '<table><tr>';
	$i= 0;
	$sql = " SELECT * FROM ". TBL_CARDS_DATA ." WHERE cat_id='$cid' AND card_active='1' ORDER BY RAND() LIMIT ". $cfg['gallery_table_cols'] ." ";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$html .= '<td align="center" valign="top">';
		
		$card_thmfile = $row['card_thmfile'];
		$card_caption = stripslashes($row['card_caption']);
		$card_id = $row['card_id'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = star_rating($row['card_rating']);
		$icon_new = gethml_newbutton($row['card_date']);
		$url_thumb_image = get_video_url($row['card_thmfile']);
		// $html_thumb_image = get_html_image($url_thumb_image,$cfg['gallery_thm_width'],$cfg['gallery_thm_height']);
		eval("\$html .= \"".get_template('link_card')."\";");
		$html .= '</td>';
		$i++;
		if ($i == $cfg['gallery_table_cols'])
		{
			$html .= '</tr><tr>';
			$i = 0;
		}
	}
	while (($i > 0) && ($i != $cfg['gallery_table_cols']))
	{
		$html.='<td>&nbsp;</td>';
		$i++; 
	} 
	$html .= '</tr></table>';
	$DB_site->free_result($data_arr);
	return $html;
}

function get_box_random_card($cid) {
	global $DB_site,$cfg,$msg;
	
	$num_rows = get_total_ncards($cid);
	if ($num_rows > $cfg['gallery_thm_per_page'] && $cfg['gallery_random'] == 1)
	{
		$box_content = get_random_cards($cid);
		$box_title = $msg['random_cards'];
		eval("\$output = \"".get_template('box_random_card')."\";");
	}
	return $output;
}
// ##############################  NEW CARDS  ############################## //

function get_html_newcard() {
	global $DB_site;
	global $cfg,$sys_tmp_vars;
	
	$i = 0;
	$columns = 1;
	$list_new_card_itens = '';
	$sql = "SELECT * FROM ". TBL_CARDS_DATA ." c LEFT JOIN ". TBL_CARDS_CAT ." cat ON c.cat_id=cat.cat_id  WHERE cat.cat_active='1' AND c.card_active='1'  ORDER BY c.card_id DESC LIMIT ". $cfg['gallery_newlist_value'];
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$card_thmfile = $row['card_thmfile'];
		$card_caption = stripslashes($row['card_caption']);
		$card_id = $row['card_id'];
		$card_date = get_date_readable($row['card_date']);
		$card_rating = star_rating($row['card_rating']);
		$card_new = gethml_newbutton($row['card_date']);
		$card_thmfile = get_video_url($row['card_thmfile']);
		$card_thm_image = "<img src='$card_thmfile' ". ( !empty($cfg['gallery_thm_width'])? "width='". $cfg['gallery_thm_width'] ."' height='". $cfg['gallery_thm_height'] ."' ": "" ) ." hspace='2' vspace='2' />";
		eval("\$list_new_card_itens .= \"".get_template('list_new_card_item')."\";");
		$i++;
		if ($i++==$columns)
		{
			$list_new_card_itens .= '';
			$i = 0;
		}
	}
	$DB_site->free_result($data_arr);
	eval("\$card_list = \"".get_template('list_new_card')."\";");
	return $card_list;
}
// ##############################  EVENTS  ############################## //
function get_html_event() {
	global $DB_site;
	global $cfg,$sys_tmp_vars;
	
	$range_days = 60;
	$max_num_events = 100;
	
	$now_month = $sys_tmp_vars['m'];
	$now_day = $sys_tmp_vars['d'];
	$now_year = $sys_tmp_vars['Y'];
	$stopdate = date('Y-m-d',$sys_tmp_vars['timestamp'] +($range_days*24*60*60));
	$now_x = date('md',$sys_tmp_vars['timestamp']); //$now_month.$now_day;
	
	$list_calendar	= '';
	$list_calendar_rows = '';
	$cfg['gallery_event_allow'] = 1;
	$event_array = array();
	if ($cfg['gallery_event_allow'] == 1)
	{
		$sql = "SELECT * FROM ". TBL_EVENTS ." WHERE event_active='1' ORDER BY event_month,event_day ASC ";
		$data_arr = $DB_site->query($sql);
		while ($row=$DB_site->fetch_array($data_arr))
		{
			$x = $row['event_month'].$row['event_dayend'];
			$temp_year = ($x<=3112 && $x>=$now_x)? $now_year : $now_year+1;
			$event_array[] = array(
				'event_id' => $row['event_id'],
				'event_day' => $row['event_day'],
				'event_dayend' => $row['event_dayend'],
				'event_month' => $row['event_month'],
				'event_name' => stripslashes($row['event_name']),
				'event_active' => $row['event_active'],
				'stop_date' => $temp_year.'-'.$row['event_month'].'-'.$row['event_dayend']
			);
		}
		unset($row);
		$DB_site->free_result($data_arr);
		$event_array = my_array_sort($event_array,'stop_date');
		
		$lm ='';
		$displayed = 0;
		$k = sizeof($event_array);
		$j = 0;
		for ($i=0; $i<$k; $i++)
		{
			if ($j>=$max_num_events)
			{
				break;
			}
			if ($event_array[$i]['stop_date'] >= $stopdate)
			{
				break;
			}
			if (!empty($event_array[$i]))
			{
				extract($event_array[$i]);
			}
			if ($event_array[$i]['event_month']!=$lm && $displayed==1)
			{
				$displayed = 0;
			}
			if ($event_array[$i]['event_month']!=$lm && $displayed==0)
			{
				$event_month = get_monthname($event_month,1);
				eval("\$list_calendar_rows .= \"".get_template('list_calendar_month')."\";");
				$displayed = 1;
				$lm = $event_array[$i]['event_month'];
			}
			$event_date = $event_day . ( ($event_dayend!=$event_day)? "-$event_dayend" : '');
			eval("\$list_calendar_rows .= \"".get_template('list_calendar_day')."\";");
			$j++;
		}
		eval("\$_html = \"".get_template('list_calendar')."\";");
	}
	return $_html;
}


// ##############################  CARDS COMPONENTES  ############################## //
function get_html_card_link($row=array()) {
	
	$card_thmfile = $row['card_thmfile'];
	$card_caption = stripslashes($row['card_caption']);
	$card_id = $row['card_id'];
	$card_date = get_date_readable($row['card_date']);
	$card_rating = star_rating($row['card_rating']);
	$icon_new = gethml_newbutton($row['card_date']);
	$url_thumb_image = get_video_url($row['card_thmfile']);
	// $html_thumb_image = get_html_image($url_thumb_image,$cfg['gallery_thm_width'],$cfg['gallery_thm_height']);
	eval("\$_html = \"".get_template('link_card')."\";");
	return $_html;
}
function gethml_newbutton($date) {
	global $cfg;
	
	$days = get_day_after($date);
	if ($cfg['site_new_days'] > $days)
	{
		return '<img src="img/icon_new.gif" alt="new" />';
	}
}
function star_rating($value=0) {
	global $cfg;
	
	$html = '';
	$stars = split("[/\\.]", $value);
	$starsf = $stars['0'];
	if ($cfg['user_rating_allow']==1)
	{
		for ($i = 1; $i<=$value; $i++)
		{
			$html .= '<img src="img/star.gif" alt="" />';
		}
		if (!empty($stars['1']))
		{
			$html .= '<img src="img/starh.gif" alt="" />';
		}
	}
	return $html;
}

// ##############################  CACHE & TEMPLATES  ############################## //
function get_replaced_vars($text) {
	global $DB_site;
	$sql = "SELECT findword,replaceword FROM ". TBL_REPLACE ." ";
	$vars = $DB_site->query($sql);
	/* static $vars;
	if (connection_status()) { exit; }
	if (!isset($vars)){ $vars = $DB_site->query("SELECT findword,replaceword FROM ". TBL_REPLACE ." ");
	} else { $DB_site->data_seek(0,$vars); } */
	while ($var = $DB_site->fetch_array($vars))
	{
		if (!empty($var['findword']))
		{
			$var['replaceword'] = stripslashes($var['replaceword']);
			$text = str_replace($var['findword'],$var['replaceword'],$text);
		}
	}
	$DB_site->free_result($vars);
	return $text;
}

function make_output($vartext) {
	
	echo get_replaced_vars($vartext);
	flush();
}
function cache_templates($list) {
	global $templatecache,$DB_site,$cache_hd;
	
	$sql_in = str_replace(',', "','", $list);
	$sql = " SELECT template,title FROM ". TBL_TEMPLATES_DATA ." WHERE title IN ('". $sql_in ."') ";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$templatecache[$row['title']] = stripslashes($row['template']);
	}
	unset($row);
	$DB_site->free_result($data_arr);
}
function get_template($templatename,$escape=1,$comment=0) {
	global $templatecache,$DB_site;
	
	$template = $templatecache[$templatename];
	if ($escape == 1)
	{
		$template = addslashes($template);
		$template = str_replace("\\'","'",$template);
	}
	if ($comment==1 && $templatename!='page_phpinclude')
	{
		return "<!-- TEMPLATE: $templatename -->\n$template\n<!-- /TEMPLATE: $templatename -->\n";
	}
	return $template;
}
$seed = '0';
function cache_vcard_pieces($list) {
	global $cache_tree_arr,$DB_site;
	$cache_tree_arr = array();
	$sql_in = str_replace(',', "','", $list);
	$sql = " SELECT * FROM ". TBL_CACHE ." WHERE title IN ('". $sql_in ."') AND date>'". time() ."' ";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$cache_tree_arr[$row['title']] = stripslashes($row['content']);
	}
	unset($row);
	$DB_site->free_result($data_arr);
}
function make_cachereflash() {
	global $DB_site;
	
	$sql = "DELETE FROM ". TBL_CACHE ." ";
	$DB_site->query($sql);
}

function get_vc_cached_item($item) {
	global $DB_site,$cfg,$cache_tree_arr,$cat_tree_arr,$list_table_cats,$list_table_main_cats;
	
	if(empty($cat_tree_arr))
	{
		make_full_cat_tree();
	}
	$str = $cache_tree_arr[$item];
	if (!empty($str))
	{
		return $str;
	} else {
		$item = addslashes($item);
		$next = time() + (60 * $cfg['vcachereflesh']);
		switch ($item)
		{
			case 'cache_date':
				$str = $next;
				break;
			case 'cache_dropdown':
				$str = get_html_dropdown_cat();
				break;
			case 'cache_newcard':
				$str = get_html_newcard();
				break;
			case 'cache_today_topcard' :
				$str = get_html_day_topcard();
				break;
			case 'cache_week_topcard' :
				$str = get_html_week_topcard();
				break;
			case 'cache_calendar':
				$str = get_html_event();
				break;
			case 'cache_categories_text':
				$str = get_html_table_cattex();
				break;
			case 'cache_categories_table_upcat':
				$list_table_main_cats = '';
				$list_table_cats = '';
				get_categories_table();
				$str = $list_table_main_cats;
				break;
			case 'cache_categories_table_cat':
				$list_table_main_cats = '';
				$list_table_cats = '';
				get_categories_table();
				$str = $list_table_cats;
				break;
			case 'cache_list_text_all_cats':
				$str = get_text_link_to_cat();
				break;
		}
		$sql = "REPLACE INTO ". TBL_CACHE ." (title,content,date) VALUES ('$item', '".addslashes($str)."', '". $next ."')";
		$DB_site->query($sql);
		return $str;
	}
}

function get_vc_cached_cattoplist($cid='') {
	global $cfg,$DB_site,$cache_tree_arr;
	
	$cid = addslashes($cid);
	$title = 'topcat_id_'.$cid;
	if (!empty($cache_tree_arr[$title]))
	{
		return $cache_tree_arr[$title];
	} else {
		$now = time();
		$next = (60 * $cfg['vcachereflesh']) + $now;
		$sql = "SELECT * FROM ". TBL_CACHE ." WHERE title='". $title ."' ";
		$row = $DB_site->query_first($sql);
		if ($row)
		{
			if ($now <= $row['date'])
			{
				$content = stripslashes($row['content']);
			} else {
					$content = get_html_toplist($cid);
					$sql = "REPLACE INTO ". TBL_CACHE ." (title,content,date) VALUES ('". $title ."','".addslashes($content)."','$next') ";
					if (!empty($content))
					{
						$DB_site->query($sql);
					} else {
						$content = get_html_toplist($cid);
						$DB_site->query($sql);
					}
			}
		} else {
			$content = get_html_toplist($cid);
			$sql = "REPLACE INTO ". TBL_CACHE ." (title,content,date) VALUES ('". $title ."','".addslashes($content)."','$next') ";
			if (!empty($content))
			{
				$DB_site->query($sql);
			} else {
				$content = get_html_toplist($cid);
				$DB_site->query($sql);
			}
		}
		return $content;
	}
}

// ##############################  MISC  ############################## //
function checkonlytemplate($image,$template) {
	
	if (!empty($image) && !empty($template))
	{
		return false;
	} elseif (empty($image) && !empty($template)) {
		return true;
	} else {
		return false;
	}
}
function increment_hits($case,$id,$hits=0) {
	global $DB_site;
	
	$id = addslashes($id);
	$id = (int) $id;
	if (!empty($id))
	{
		$increment = !empty($hits)? $hits : 1;
		switch ($case){
			case 'card':
				$sql = "UPDATE ". TBL_CARDS_DATA ." SET hits = hits + $increment WHERE card_id='$id' "; 
				break;
			case 'cat':
				$sql = "UPDATE ". TBL_CARDS_CAT ." SET hits = hits + $increment WHERE cat_id='$id' "; 
				break;
			case 'pattern':
				$sql = "UPDATE ". TBL_BACKGROUNDS ." SET hits = hits + $increment WHERE pattern_id='$id' "; 
				break;
			case 'poem':
				$sql = "UPDATE ". TBL_POEMS ." SET hits = hits + $increment WHERE poem_id='$id' "; 
				break;
			case 'sound':
				$sql = "UPDATE ". TBL_SOUNDS ." SET hits = hits + $increment WHERE sound_id='$id' "; 
				break;
			case 'stamp':
				$sql = "UPDATE ". TBL_STAMPS ." SET hits = hits + $increment WHERE stamp_id='$id' "; 
				break;
		}
		$do = $DB_site->query($sql);
	}
	return true;
}

function get_item_id($case,$str) {
	global $DB_site;
	
	if (!empty($str))
	{
		switch ($case){
			case 'pattern':
				$sql = "SELECT pattern_id FROM ". TBL_BACKGROUNDS ." WHERE pattern_file='$str' "; 
				break;
			case 'sound':
				$sql = "SELECT sound_id FROM ". TBL_SOUNDS ." WHERE sound_file='$str' "; 
				break;
			case 'stamp':
				$sql = "SELECT stamp_id FROM ". TBL_STAMPS ." WHERE stamp_file='$str' "; 
				break;
		}
		$do = $DB_site->query_first($sql);
		return $do[0];
	}
	return true;
}


?>