<?php
	class Priority
	{
		var $pid = false;		// this is for the commit
		var $name;
		var $severity = 1;		//they always go in at the bottom
		
		// new in 3.4.9
		var $unknown = false;	// boolean for unknown state
		
		function Priority($pid = false)
		{
			/*
				We want to hold a non database stored Unknown state for a ticket whose priority has been deleted. This means
				that our old model of default the parameter to false becomes incorrect as 0 could be passed.  We want to
				intercept this 0 and create a mock object for display purposes. However, since we are not storing the 0 in the
				database with a reference, the Unknown state will never appear in a dropdown forcing a value set.
				
				This is critical to understand, the !== false is the only way to distinguish between
					$p = new Priority(0)
					and 
					$p = new Priority()
					
				The former refers to displaying an Unknown for the Priority, the later is a new priority being created
			*/
			if ($pid !== false) {
				if (intval($pid) === 0)	{	// we have to be absolutely sure this is 0
					$this->unknown = true;
					$this->createMockObject();
				}
				else {
					$this->pid = intval($pid);
					$this->fetch();
				}
			}
		}
		
		function createMockObject()
		{
			$this->pid = 0;
			$this->name = 'Unknown';
			$this->severity = 0;
		}
		
		function fetch()
		{
			$q = "select * from " . DB_PREFIX . "priorities where pid = $this->pid LIMIT 1";
			$s = mysql_query($q) or die(mysql_error());
			$r = mysql_fetch_assoc($s);
			
			$this->pid = $r['pid'];
			$this->name = $r['priority'];
			$this->severity = $r['severity'];
		}
		
		function get($name, $callback = null)
		{
			if (is_null($callback))
				return $this->$name;
			else
				return $callback($this->$name);	
		}
		
		function set($name, $value, $app = null)
		{
			if (is_null($app)) {
				$this->$name = $value;
			}
			else {
				$this->$name = $app($value);	
			}	
		}
		
		function commit()
		{
			if (!$this->unknown) {
				if ($this->pid) {		
					//update
					$cmd  = "update " . DB_PREFIX . "priorities set ";
					$cmd .= "priority = '$this->name', ";
					$cmd .= "severity = $this->severity ";
					$cmd .= "where pid = $this->pid";
	                
	                mysql_query($cmd) or die(mysql_error());
				}
				else {
					//insert
					mysql_query("update " . DB_PREFIX . "priorities set severity = severity + 1");
					$cmd = "insert into " . DB_PREFIX . "priorities(priority, severity) values('$this->name', $this->severity)";
	                
	                mysql_query($cmd) or die(mysql_error());
	                $this->pid = mysql_insert_id();
				}
			}
		}
		
		function delete($skipCheck = false)
		{
			if (!$skipCheck)
			{
				$q = "select count(priority) as _count_ from " . DB_PREFIX . "data where priority = " . $this->pid;
				$s = mysql_query($q) or die(mysql_error());
				if (intval(mysql_result($s, 0, '_count_'))) return false;
			}
			
			// set all tickets to unknown priority with that priority
			$cmd = "update " . DB_PREFIX . "data set priority = 0 where priority = " . $this->pid;
			mysql_query($cmd) or die(mysql_error());
			
			// delete the priority
			$cmd = "delete from " . DB_PREFIX . "priorities where pid = " . $this->pid;
			mysql_query($cmd) or die(mysql_error());
			
			return true;
		}
		
		function IncreaseServerity()
		{	
			//get our new severity and id
			$q = "select severity, pid from " . DB_PREFIX . "priorities where severity >= $this->severity order by severity LIMIT 2";
			$s = mysql_query($q) or die(mysql_error());
			
			if (mysql_num_rows($s) >= 2) {
				//note how the results will be returned
				//current pid on top, and our target on the secoind row (offset 1)
				$p = new Priority(mysql_result($s, 1, 'pid'));
				$temp = $this->severity;
				$this->severity = $p->get('severity', 'intval');
				$p->set('severity', $temp, 'intval');
				$p->commit();
				$this->commit();
			}
			//if this check fails then there is only one priority in the databse
			//so changing severity would be pointless
		}
		
		function DecreaseSeverity()
		{
			//get our new severity and id
			$q = "select severity, pid from " . DB_PREFIX . "priorities where severity <= $this->severity order by severity desc LIMIT 2";
			$s = mysql_query($q) or die(mysql_error());
			
			if (mysql_num_rows($s) >= 2) {
				//note how the results will be returned
				//current pid on top, and our target on the secoind row (offset 1)
				$p = new Priority(mysql_result($s, 1, 'pid'));
				$temp = $this->severity;
				$this->severity = $p->get('severity', 'intval');
				$p->set('severity', $temp, 'intval');
				$p->commit();
				$this->commit();
			}
			//if this check fails then there is only one priority in the databse
			//so changing severity would be pointless
		}
	}
?>