<?php
	/*
		Report Class
		Holds all the information about a Report
		Serializable to permit report saving
		
		it is very important for performance reasons that we try to allow the backend database to do the vast
		majority of processing and filtering, as this will increase the performance and simplify the frontend code
	*/

	define('FILTER_BY_PRIORITY', 1);
	
	class Report
	{
		var $rid = 0;		// id of the saved report
		var $name = 'Unamed Report';		// name of the report (used for saving)
		var $start = 0;	// start of the range
		var $end = 0;		// end of the range
		var $information = array();		// array of flags indicating what information to show
		var $techs = array();	// array of tech ids to include in the reporting
		var $filter = 0;	// filter the data by what (this is a grouping)
		
		var $htmlBuffer = '';		// string we are gonna write using JS document.write
		
		function Report()
		{ /* nothing to do */ }
		
		/*	Set Functions - Internal Data Modifications Done Through this function Set	*/
		function setName($value)
		{
			$this->name = mysql_real_escape_string($value);
			return;	
		}
		
		function setStartRange($value)
		{
			$this->start = strtotime($value);
			return;
		}
		
		function setEndRange($value)
		{
			$this->end = strtotime($value);
			return;	
		}
		
		function setInformation($value)
		{
			if (!is_array($value)) return;
			$this->information = $value;
			return;	
		}
		
		function setTechs($value)
		{
			if (!is_array($value)) return;
			$this->techs = $value;
			return;	
		}
		
		// pass this a string to set the enumerator as needed
		function setFilter($value)
		{
			if (!is_string($value)) return;
			switch ($value)
			{
				case "priority":
					$this->filter = 1;
					return;
				default:
					return;	
			}
		}
		
		function get($name)
		{
			return $this->$name;	
		}
		
		function validate()
		{
			/*
				Use this for internal verifications of information, this way we can create reports and then have a second level
				of verification if they decide to save it, making sure everything is in order
			*/
			
			// make sure the report has a name
			if ($this->name) return false;
			
			// make sure some information is being shown
			if (!is_array($this->information) || !count($this->information)) return false;
			
			// make sure at least one tech is being shown
			if (!is_array($this->techs) || !count($this->techs)) return false;
			
			return true;
		}
		
		function generate()
		{
			// create the header section
			$this->htmlBuffer .= "<html>\n";
			$this->htmlBuffer .= "<head>\n";
			$this->htmlBuffer .= "<title>$this->name</title>\n";
			$this->htmlBuffer .= "<link type=\"text/css\" media=\"print\" href=\"styles/print.css\" rel=\"stylesheet\" />\n";
			$this->htmlBuffer .= "</head>\n";
			
			// create the body section
			$this->htmlBuffer .= "<body>\n";
			$this->htmlBuffer .= "<h2 align=\"center\">$this->name</h2>\n";
			$this->htmlBuffer .= "<h4>Helpdesk Reloaded - Productivity Report</h2>\n";		// report type is dynamic
						// change this later
			$this->htmlBuffer .= "<hr/>\n";
			
			// information sections
			$this->htmlBuffer .= "<h5>Displaying Following Information</h5>\n";
			$this->htmlBuffer .= "<ul>\n";
			
			$humanReadArray = array(
				'assignedHours' => 'Assigned Hours by Tech',
				'completedHours' => 'Completed Hours by Tech',
				'overallaHours' => 'Overall Assigned Hours for All Techs',
				'overallcHours' => 'Overall Completed Hours for All Techs'
			);
			
			foreach ($this->information as $key=>$value)
			{
				$this->htmlBuffer .= "<li>{$humanReadArray[$key]}</li>\n";
			}
			$this->htmlBuffer .= "</ul>\n";
			
			$this->htmlBuffer .= "<hr/>\n";
			if ($this->filter == FILTER_BY_PRIORITY) {
				$this->generateTechGroupPriority();
			}
			else {
				$this->generateNormal();	
			}
			
			$this->htmlBuffer .= "<div align=\"center\">\n";
			$this->htmlBuffer .= "<form name=\"command\">\n";
			$this->htmlBuffer .= "<input type=\"button\" name=\"cmdPrint\" onClick=\"window.print();\" value=\"Print Report\" class=\"button\">\n";
			$this->htmlBuffer .= "<input name=\"cmdClose\" type=\"button\" onClick=\"self.close();\" value=\"Close Report\">\n";
			$this->htmlBuffer .= "</form>\n";
			$this->htmlBuffer .= "</div>\n";
			
			$this->htmlBuffer .= "</body>\n";
			$this->htmlBuffer .= "</html>";
			
		}
		
		/****************************************************************************
			Custom Report Generation Functions
			
			These functions are so named because based on the parameters and information passed we will call a particular function.
			That function will contain within it the code to create the HTML. Once completed it will concatenate the output onto
			the htmlBuffer member and then return
		*****************************************************************************/
		function generateTechGroupPriority()
		{
			// obtain the id of the status that means closed (this will be the one with the biggest position)
			$q = "select id from " . DB_PREFIX . "status order by position desc LIMIT 1";
			$closed_status = isset($this->information['completedHours']) ? mysql_result(mysql_query($q), 0, 'id') : -1;
			
			// here we are going to foreach through each of the selected techs
			// obviously if no tech is selected this section will be skipped by virtue of the way it is written
			$totalAssignedTime = 0;
			$totalCompleteTime = 0;
			$techTotalAssignedTime = 0;
			$techTotalCompletedTime = 0;
				
			foreach ($this->techs as $k=>$v)
			{
				$techTotalAssignedTime = 0;		// reset the values
				$techTotalCompletedTime = 0;
				
				$loop_user = new User($k);
				$this->htmlBuffer .= "<ul>\n";
				$this->htmlBuffer .= "<h3>" . $loop_user->get('LastName', 'stripslashes') . ", " . $loop_user->get('FirstName', 'stripslashes') . "</h3>\n";
				$this->htmlBuffer .= "<li>Type: " . $loop_user->getStringLevel() . "</li>\n";
				$this->htmlBuffer .= "<li>Email Address: " . $loop_user->get('email_addr') . "</li>\n";
				$this->htmlBuffer .= "</ul>\n";
				
				$this->htmlBuffer .= "<div style=\"padding-left:40px\">\n";
				$this->htmlBuffer .= "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">";
				
				if ($this->start == 0 && $this->end == 0) {
					$rangeClaus = '';
				}
				else $rangeClaus = "and t.mainDate between $this->start and $this->end";	
				
				
				$q = "select t.id, t.priority from " . DB_PREFIX . "data t, " . DB_PREFIX . "priorities p where (t.staff = " . $loop_user->get('id') . " and t.priority = p.pid and t.expectCompleteDate <> 0 $rangeClaus) ";
				$q .= "group by p.pid";
				$rs = mysql_query($q) or die(mysql_error());
				
				while ($row = mysql_fetch_assoc($rs))
				{
					// row start condition
					if (!isset($cpriority) || $cpriority != $row['priority']) {
						$p = new Priority($row['priority']);
						$this->htmlBuffer .= "<tr><th align=\"left\" colspan=\"2\">" . $p->get('name', 'stripslashes') . " Tickets</th></tr>\n";
					}
					
					// output the report information here - the headers and footers will output as needed
					$t = new Ticket($row['id']);
					
					// we return an array containing both completed and assigned totals
					// depending on selection we will take what we need
					$totalsArray = $this->calculate($t);
					$this->htmlBuffer .= "<tr><td colspan=\"2\">Ticket #" . $t->get('id') . " :: " . $totalsArray['days'] . " Days, " . $totalsArray['hours'] . " Hours and " . $totalsArray['mins'] . " Minutes</td></tr>\n";
					
					$techTotalAssignedTime += ((24*3600*$totalsArray['days']) + (3600*$totalsArray['hours']) + (60*$totalsArray['mins']));
					$stat = $t->get('status');
					if ($stat->get('id') == $closed_status) {	// this will act as a filter
						$techTotalCompletedTime += ((24*3600*$totalsArray['days']) + (3600*$totalsArray['hours']) + (60*$totalsArray['mins']));
					}
					
					if (!isset($cpriority) || $cpriority != $row['priority']) {
						$cpriority = $row['priority'];
					}
				}
				
				// assigned hours block
				$this->htmlBuffer .= "<tr>";
				$this->htmlBuffer .= "<td></td>";
				if (isset($this->information['assignedHours'])) {
					$this->htmlBuffer .= "<th align=\"left\">Assigned Hours: " . $this->format($techTotalAssignedTime) . "</th>";
				}
				else {
					$this->htmlBuffer .= "<td></td>";
				}
				$this->htmlBuffer .= "</tr>\n";
				
				// completed hours block
				$this->htmlBuffer .= "<tr>";
				$this->htmlBuffer .= "<td></td>";
				if (isset($this->information['completedHours'])) {
					$this->htmlBuffer .= "<th align=\"left\">Completed Hours: " . $this->format($techTotalCompletedTime) . "</th>";
				}
				else {
					$this->htmlBuffer .= "<td></td>";
				}
				$this->htmlBuffer .= "</tr>\n";
				
				// now we check and display the desired information for this tech
				$this->htmlBuffer .= "</table>\n";
				$this->htmlBuffer .= "</div>\n";
			}
			
			$totalAssignedTime += $techTotalAssignedTime;
			$totalCompleteTime += $techTotalCompletedTime;
			
			// assigned hours block
			$this->htmlBuffer .= "<hr/>\n";
			$this->htmlBuffer .= "<h4 style=\"display:inline\">";
			if (isset($this->information['overallaHours'])) {
				$this->htmlBuffer .= "Overall Assigned Hours: " . $this->format($totalAssignedTime) . "<br/>\n";
			}
			
			// overall hours block
			if (isset($this->information['overallcHours'])) {
				$this->htmlBuffer .= "Overall Completed Hours: " . $this->format($totalCompleteTime) . "<br/>\n";
			}
			$this->htmlBuffer .= "</h4>\n";
		}
		
		function generateNormal()
		{
			// obtain the id of the status that means closed (this will be the one with the biggest position)
			$q = "select id from " . DB_PREFIX . "status order by position desc LIMIT 1";
			$closed_status = isset($this->information['completedHours']) ? mysql_result(mysql_query($q), 0, 'id') : -1;
			
			// here we are going to foreach through each of the selected techs
			// obviously if no tech is selected this section will be skipped by virtue of the way it is written
			$totalAssignedTime = 0;
			$totalCompleteTime = 0;
			$techTotalAssignedTime = 0;
			$techTotalCompletedTime = 0;
				
			foreach ($this->techs as $k=>$v)
			{
				$techTotalAssignedTime = 0;		// reset the values
				$techTotalCompletedTime = 0;
				
				$loop_user = new User($k);
				$this->htmlBuffer .= "<ul>\n";
				$this->htmlBuffer .= "<h3>" . $loop_user->get('LastName', 'stripslashes') . ", " . $loop_user->get('FirstName', 'stripslashes') . "</h3>\n";
				$this->htmlBuffer .= "<li>Type: " . $loop_user->getStringLevel() . "</li>\n";
				$this->htmlBuffer .= "<li>Email Address: " . $loop_user->get('email_addr') . "</li>\n";
				$this->htmlBuffer .= "</ul>\n";
				
				$this->htmlBuffer .= "<div style=\"padding-left:40px\">\n";
				$this->htmlBuffer .= "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">";
				
				if ($this->start == 0 && $this->end == 0) {
					$rangeClaus = '';
				}
				else $rangeClaus = "and t.mainDate between $this->start and $this->end";	
				
				
				$q = "select t.id, t.priority from " . DB_PREFIX . "data t, " . DB_PREFIX . "priorities p where (t.staff = " . $loop_user->get('id') . " and t.priority = p.pid and t.expectCompleteDate <> 0 $rangeClaus) ";
				$rs = mysql_query($q) or die(mysql_error());
				
				while ($row = mysql_fetch_assoc($rs))
				{	
					// output the report information here - the headers and footers will output as needed
					$t = new Ticket($row['id']);
					
					// we return an array containing both completed and assigned totals
					// depending on selection we will take what we need
					$totalsArray = $this->calculate($t);
					$this->htmlBuffer .= "<tr><td colspan=\"2\">Ticket #" . $t->get('id') . " :: " . $totalsArray['days'] . " Days, " . $totalsArray['hours'] . " Hours and " . $totalsArray['mins'] . " Minutes</td></tr>\n";
					
					$techTotalAssignedTime += ((24*3600*$totalsArray['days']) + (3600*$totalsArray['hours']) + (60*$totalsArray['mins']));
					$stat = $t->get('status');
					if ($stat->get('id') == $closed_status) {	// this will act as a filter
						$techTotalCompletedTime += ((24*3600*$totalsArray['days']) + (3600*$totalsArray['hours']) + (60*$totalsArray['mins']));
					}
				}
				
				// assigned hours block
				$this->htmlBuffer .= "<tr>";
				$this->htmlBuffer .= "<td></td>";
				if (isset($this->information['assignedHours'])) {
					$this->htmlBuffer .= "<th align=\"left\">Assigned Hours: " . $this->format($techTotalAssignedTime) . "</th>";
				}
				else {
					$this->htmlBuffer .= "<td></td>";
				}
				$this->htmlBuffer .= "</tr>\n";
				
				// completed hours block
				$this->htmlBuffer .= "<tr>";
				$this->htmlBuffer .= "<td></td>";
				if (isset($this->information['completedHours'])) {
					$this->htmlBuffer .= "<th align=\"left\">Completed Hours: " . $this->format($techTotalCompletedTime) . "</th>";
				}
				else {
					$this->htmlBuffer .= "<td></td>";
				}
				$this->htmlBuffer .= "</tr>\n";
				
				// now we check and display the desired information for this tech
				$this->htmlBuffer .= "</table>\n";
				$this->htmlBuffer .= "</div>\n";
				
				$totalAssignedTime += $techTotalAssignedTime;
				$totalCompleteTime += $techTotalCompletedTime;
			}
			
			
			// assigned hours block
			$this->htmlBuffer .= "<hr/>\n";
			$this->htmlBuffer .= "<h4 style=\"display:inline\">";
			if (isset($this->information['overallaHours'])) {
				$this->htmlBuffer .= "Overall Assigned Hours: " . $this->format($totalAssignedTime) . "<br/>\n";
			}
			
			// overall hours block
			if (isset($this->information['overallcHours'])) {
				$this->htmlBuffer .= "Overall Completed Hours: " . $this->format($totalCompleteTime) . "<br/>\n";
			}
			$this->htmlBuffer .= "</h4>\n";
		}
				
		// function takes two string dates
		function calculate($ticket)
		{
			// first we get both dates inmto unixtimestamps
			// note: maindate is stored as a string while expectCompleteDate is stored as a timestamp, correct this is future
			// releases, remember to update this code however
			$start = $ticket->getMainDate();
			if ($start == -1) exit("Fail");			// this should never occur
													// this indicates a storing error
			$end = $ticket->get('expectCompleteDate');
			$retArray = array(
				'days' => 0,
				'hours' => 0,
				'mins' => 0
			);
			
			$difference = $end - $start;
			while ($difference >= (24*3600))	// one day in seconds
			{
				$retArray['days']++;
				$difference -= (3600*24);
			}
			
			while ($difference >= 3600)		// seconds in one hour
			{
				$retArray['hours']++;
				$difference -= 3600;	
			}
			
			while ($difference >= 60)	// seconds in one min (you dont know this, stop right now)
			{
				$retArray['mins']++;
				$difference -= 60;
			}
			
			return $retArray;
		}
		
		// recieve the number of seconds and format that into a human readbale string
		function format($timestamp)
		{
			$retString = '';
			$counter = 0;
			while ($timestamp >= (3600*24))
			{
				$counter++;
				$timestamp -= (3600*24);		
			}
			$retString .= $counter . " Days ";
			$counter = 0;
			
			while ($timestamp >= 3600)
			{
				$counter++;
				$timestamp -= 3600;	
			}
			$retString .= $counter . " Hours ";
			$counter = 0;
			
			while ($timestamp >= 60)
			{
				$counter++;
				$timestamp -= 60;
			}
			$retString .= $counter . " Minutes";
			
			return $retString;
		}
		
		function JSSplitAndPrint($name)
		{
			$array = explode("\n", $this->htmlBuffer);
			foreach ($array as $line)
			{
				echo $name . ".document.write('" . $line . "');\n";
			}
		}
		
		function save()
		{
			$q = "select max(reportID) as rid from " . DB_PREFIX . "saved_reports";
			$s = mysql_query($q) or die(mysql_error());
			$id = intval(mysql_result($s, 0, 'rid'));
			if ($id == 0)
				$this->rid = 1;
			else 
				$this->rid = $id  + 1;
			
			$cmd =  "insert into " . DB_PREFIX . "saved_reports(reportID, name, contents) ";
			$cmd .= "values($this->rid, '" . mysql_real_escape_string($this->name) . "', '" . mysql_real_escape_string(serialize($this)) . "')";
			mysql_query($cmd) or die(mysql_error());
		}
		
		function delete()
		{
			$cmd = "delete from " . DB_PREFIX . "saved_reports where reportID = " . intval($this->rid);
			mysql_query($cmd) or die(mysql_error());
				
		}
	}
?>