<?PHP

##########################
##  AutoRank PHP 2.0.x  ##
##############################################################
##  index.php - Handle display of ranking pages             ##
##############################################################

set_magic_quotes_runtime(0);

chdir('.');

$DDIR     = './data';
$CDIR     = './cache';
$RERANK   = '3600';
$RESET    = '604800';
$USE_CRON = '0';
$TIME     = time();


if( $_SERVER['PATH_INFO'] && !$_SERVER['QUERY_STRING'] )
{
    parse_str(substr($_SERVER['PATH_INFO'], 1), $_REQUEST);
}

$page     = $_REQUEST['p'] ? $_REQUEST['p'] : 1; 
$cat      = $_REQUEST['c'] ? $_REQUEST['c'] : 'Overall';
$reranked = getFileTime("$DDIR/times/rerank");
$resetted = getFileTime("$DDIR/times/reset");


if( !$USE_CRON )
{
    if( $resetted + $RESET < $TIME )
    {
        include_once('arphp.php');
        doReset('index.php');
        $reranked = $TIME;
    }


    if( $reranked + $RERANK < $TIME )
    {
        include_once('arphp.php');
        doRerank('index.php');
        $reranked = $TIME;
    }
}


if( file_exists("$CDIR/$cat.$page.time") )
{
    $cached = getFileTime("$CDIR/$cat.$page.time");

    if( $reranked > $cached )
    {
        include_once('arphp.php');
        buildPage($cat, $page);
    }
}
else
{
    include_once('arphp.php');
    buildPage($cat, $page);
}


if( file_exists("$CDIR/$cat.$page.cache") )
{
    readfile("$CDIR/$cat.$page.cache");
}
else
{
    include_once("$DDIR/errors.php");

    print $GLOBALS['error']['1029'];
}



function getFileTime($file)
{
    $fd   = fopen($file, 'r');
    $line = fgets($fd, 4096);
    fclose($fd);
    chop($line);
    return $line;
}

?>