<?php
/*
$Date: 2002/03/31 01:10:21 $
$Revision: 1.1 $
*/

function parse_message_format($field, $replacement, $subject) {
	if (preg_match("/{($field)\|?([0-9]+)?}/i", $subject, $matches)) {
		$replacement = (!empty($matches[2]) ? substr($replacement, 0, $matches[2]) : $replacement);
		return str_replace($matches[0], $replacement, $subject);
	} else {
		return $subject;
	}
}


// echo the text or not
function pop_echo($msg) {
	echo $msg;
	return true;
}

function pop_none($msg) {
	return true;
}

// STATS FUNCTIONS (retrieval and update of stats file)

// retrieves vars in stats file
// and assigns them into global space
function retrieve_stats($filename) { 
	if (!file_exists($filename)) {
		die("stats file not found");
	}
	$fp = fopen($filename, "r"); 
	$data = fread($fp, filesize($filename)); 
	fclose($fp);
	$config = @unserialize($data);
	
	if (!is_array($config)) {
		die("stats file empty, run reset_stats.php (or whatever you've called it)");
	}

	while(list($name, $value) = each($config)) {
		global $$name;
		$$name = $value;
	}

	return $config["config_array"];
} 

// updates config file with new vars and values
function update_stats($filename, $config_array) { 
	@touch($filename) or die("Error creating / touching file");
	$data = serialize($config_array);
	$fp = fopen($filename, "w"); 
	fwrite($fp, $data); 
	fclose($fp); 
} 

?>
