<?php

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

if (!function_exists(get_vba_links)) {

function get_vba_links($filter, $hitssince, $order, $template, $catsee, $linksee, $ncols=1, $showsubcats=0) {
	global $vbulletin;
	global $links_defaults, $links_permissions, $linkscat;

	$limitfids = lookup_ldm_forum_protections($links_permissions["can_see_protected_links_on_portal"]);
	$filter[] = 'link.linkforum NOT IN ('.implode(',', $limitfids).') ';

	if ($showsubcats and $catsee) {
		$catparents = explode(',', $catsee);
		foreach ($linkscat as $thiscat) {
			$cplist = explode(',', $thiscat['parentlist']);
			foreach ($catparents as $cp) {
				if (in_array($cp, $cplist)) {
					$catsee .= ", ".$thiscat['catid'];
				}
			}
		}
	}

	if ($catsee) {
		$filter[] = 'ltoc.catid IN ('.$vbulletin->db->escape_string($catsee).')';
	}

	$query = get_mainsql($filter, $hitssince, 0, $order, 0, 0);
	$linklistarray = array();
	$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", 0, 0, 1, $linksee);

	$links = map_listbit_to_grid($linklistarray, $ncols, 1, "");
	unset($linklistarray);

	return array($links, $nhits, $query);
}

}

if ($mod_options['portal_ldm_hot_hitssince']) {

	$filter	= array("link.linkmoderate=0", "linkhits>0");
	$order	= "linkrecenthits DESC";
	$hitssince = TIMENOW-intval($mod_options['portal_ldm_hot_hitssince'])*24*60*60;

}
else {

	$filter	= array("link.linkmoderate=0", "linkhits>0");
	$order	= "linkhits DESC";
	$hitssince = 0;

}

$show_catname = $mod_options['portal_ldm_hot_showcatname'];

list ($links, $nhits, $q) =
	get_vba_links($filter, $hitssince, $order, "adv_portal_custom_ldm_hot_one",
		$mod_options["portal_ldm_hot_showcategories"],
		$mod_options["portal_ldm_hot_showentries"],
		$mod_options["portal_ldm_hot_showperrow"],
		$mod_options["portal_ldm_hot_showsubcats"]);

$collapseobj_custom_ldm_hot = $vbcollapse['collapseobj_custom_ldm_hot'];
$collapseimg_custom_ldm_hot = $vbcollapse['collapseimg_custom_ldm_hot'];

eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template('adv_portal_custom_ldm_hot') . '";');
unset($filter, $order, $links, $nhits, $q, $collapseobj_custom_ldm_hot, $collapseimg_custom_ldm_hot);

?>
