<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

function ldm_clearfromtable($table, $where="") {
	global $vbulletin;
	if (!$where) {
		$query = 'TRUNCATE TABLE '.THIS_TABLE.$table;
	}
	else {
		$query = 'DELETE FROM '.THIS_TABLE.$table.' WHERE '.$where;
	}
	$vbulletin->db->query_write($query);
}

/* ===========================================================================*/
// XML Export
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doexportxml'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}

	function patchme(&$arr) {
		global $vbulletin;

		$search = array ("\r", "\n");
		$replace = array ("\\r", "\\n");
		$arr = str_replace($search, $replace, $arr);
		foreach ($arr as $k=>$v) {
			$arr[$k] = htmlspecialchars_uni($v);
		}
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'xmlexp' => TYPE_INT,
		'xmlgzip' => TYPE_INT,
	));

	if ($vbulletin->GPC['xmlexp']==1) {
// Standard LDM format

		require_once(DIR . '/includes/class_xml.php');

// Take care - VB version specific
		if (VALID_VB_VERSION=="3.5") {
			$xml = new XMLexporter();
		}
		else {
			$xml = new XMLexporter($vbulletin);
		}
// Take care - VB version specific

		$xml->add_group('LDM', array('name' => $master_title, 'version' => $links_defaults["this_version"],
			'date' => ldm_date($vbulletin->options['dateformat'], TIMENOW).' '.ldm_date($vbulletin->options['timeformat'], TIMENOW)));

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkscat
			ORDER BY catid
			");

		$xml->add_group('categories', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('category', $myrow['catid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkslink
			ORDER BY linkid
			");

		$xml->add_group('links', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('link', $myrow['linkid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksltoc
			ORDER BY ltoc
			");

		$xml->add_group('linkcats', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('ltoc', $myrow['ltoc'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkskeys
			ORDER BY keyid
			");

		$xml->add_group('keywords', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('keyword', $myrow['keyid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksltok
			ORDER BY lkey
			");

		$xml->add_group('linkkeys', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('ltok', $myrow['lkey'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksfavs
			ORDER BY lfav
			");

		$xml->add_group('favourites', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('fav', $myrow['lfav'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksrate
			ORDER BY lrate
			");

		$xml->add_group('ratings', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('rate', $myrow['lrate'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksdownloads
			ORDER BY dlid
			");

		$xml->add_group('downloads', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			patchme($myrow);
			$xml->add_tag('hit', $myrow['dlid'], $myrow, true);
		}
		$xml->close_group();

		$xml->close_group();

		$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

		$doc .= $xml->output();
		$xml = null;

		require_once(DIR . '/includes/functions_file.php');
		if ($vbulletin->GPC['xmlgzip']) {
			file_download(gzencode($doc), 'export.xml.gz', 'application/x-gzip');
		}
		else {
			file_download($doc, 'export.xml', 'text/xml');
		}
		exit;

	}

	if ($vbulletin->GPC['xmlexp']==2) {
// Google Sitemap format

		$asb = $vbulletin->db->query_read("
			SELECT catid, catdate
			FROM ".THIS_TABLE."linkscat
			");

		$doc  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n";
		$doc .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\r\n";
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$doc .= "<url>\r\n";
			$doc .= "<loc>".$vbulletin->options['bburl']."/".$LINKS_SCRIPT.".php?catid=".$myrow['catid']."</loc>\r\n";
			$doc .= "<lastmod>".date("Y-m-d", $myrow['catdate'])."</lastmod>\r\n";
			$doc .= "</url>\r\n";
		}
		$doc .= "</urlset>";

		require_once(DIR . '/includes/functions_file.php');
		if ($vbulletin->GPC['xmlgzip']) {
			file_download(gzencode($doc), 'sitemap.xml.gz', 'application/x-gzip');
		}
		else {
			file_download($doc, 'sitemap.xml', 'text/xml');
		}
		exit;

	}


}

/* ===========================================================================*/
// CSV file import
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doimport'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}

	$file = $_FILES["import"]["tmp_name"];
	if ($file) {
		$messages = "Importing ".$_FILES["import"]["name"]."<br />";
		$tcat = 0;
		$keys = array_keys($linkscat);
		foreach ($keys as $thiskey) { $tcat++; }
		$ncat = 0;
		$nlnk = 0;
		$fp = @fopen ($file,"r");
		if (!$fp) {
			$messages .= $vbphrase['ll_error_openfail'].' '.$file;
		}
		else {
			unset ($data);

			while ($data = fgetcsv ($fp, 1000, ",")) {
				$num = count ($data);
				for ($c=0; $c < $num; $c++) {
					$data[$c] = preg_replace ("/^ *(\")(.*)\\1/", "\\2", $data[$c]);
					$data[$c] = preg_replace ("/\\x5Cr/", "\r", $data[$c]);
					$data[$c] = preg_replace ("/\\x5Cn/", "\n", $data[$c]);
				}

				if (preg_match("/category/i", $data[0])) {
					if ($tcat>0) {
						$messages .= "&gt; create cat $data[2] failed: categories already exist<br />";
						continue;
					}
					if (!isset($data[4]) or !preg_match ( "/^[\s\d-,]+$/", $data[4])) {
						$messages .= "&gt; create cat $data[2] failed: invalid parentlist $data[4]<br />";
						continue;
					}
					if (!isset($data[5])) {
						$data[5] = $links_defaults["default_forumid"];
					}
					else {
						if (!preg_match ( "/^[\s\d]+$/", $data[5])) {
							$messages .= "&gt; create cat $data[2] failed: invalid forumid $data[5]<br />";
							continue;
						}
					}

					$parentid = explode(',', $data[4]);
					$vbulletin->db->query_write("
					INSERT INTO ".THIS_TABLE."linkscat
					SET
						catid='".$data[1]."',
						catname='".$vbulletin->db->escape_string($data[2])."',
						catdesc='".$vbulletin->db->escape_string($data[3])."',
						cattext='".$vbulletin->db->escape_string($data[3])."',
						parentid='".$parentid[0]."',
						parentlist='".$data[4]."',
						catforum='".$data[5]."',
						catusername='".$vbulletin->db->escape_string(htmlspecialchars_uni($vbulletin->userinfo['username']))."',
						catuserid=".$vbulletin->userinfo[userid].",
						catentry='0',
						catdate='0',
						catmoderate='".$LINK_ACCEPTED."'
					");

					$ncat++;
					$linkscat[$data[1]] = array(); // force it to be set
				}

				if (preg_match("/link/i", $data[0])) {
					if (!isset($data[5])) {
						$data[5] = $links_defaults["default_forumid"];
					}
					else {
						if (!preg_match ( "/^\s*-*\d+$/", $data[5])) {
							$messages .= "&gt; $data[2] failed: invalid forumid $data[5]<br />";
							continue;
						}
					}
					if (!preg_match ( "/^[,\s\d]+$/", $data[4])) {
						$messages .= "&gt; $data[2] failed: invalid category id list $data[4]<br />";
						continue;
					}
					$pcatid = explode(',', $data[4]);
					foreach ($pcatid as $p) {
						if (!isset($linkscat[$p])) {
							$messages .= "&gt; $data[2] failed: non-existent category id $p<br />";
							continue 2;
						}
					}

					$linkname =&	$data[1];
					$linkurl =& $data[2];
					$linkimg =& $data[6];
					$linkdesc =& $data[3];
					$pforum =& $data[5];
					$linkreviewfreq =& $data[7];

					list($insert_status, $linkid) = create_ldm_entry ($vbulletin->userinfo['username'], $vbulletin->userinfo['userid'],
							$linkname, '', $linkurl, '', $linkimg, $linkdesc, $pforum, 0, $LINK_BROKEN, 0, 0, 0, 0, $linkreviewfreq, TIMENOW, 0);

					if ($linkid) {
						insert_link_in_ldm_category($linkid, $pcatid);
					}
					$nlnk++;
				}

			}
		}
		fclose ($fp);
		$messages .= 'Import completed: '.$ncat.' categories, '.$nlnk.' links inserted';
	}

	$this_navigation_title = $vbphrase['ll_links_administration'];
	construct_forum_jump();

	// Make Links Nav Bar
	$navbits = array();
	$navbits[LINKS_SCRIPT.".php"] = $master_title;
	$navbits[""] = $vbphrase['ll_links_administration'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	unset($pcatid);
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	$output .= '<table class="tborder" width="50%" align="center">'.
		'<tr><td class="thead" align="center">CSV Import</td></tr>'.
		'<tr><td class="alt1">'.$messages.'</td></tr>'.
		'<tr><td class="tfoot" align="center">'.
		'<input type="button" class="button" value="Validate" onclick="window.location=\''.$ADMIN_SCRIPT.'.php?action=validate\';" />'.
		'&nbsp;&nbsp;'.
		'<input type="button" class="button" value="Return" onclick="window.location=\''.$ADMIN_SCRIPT.'.php\';" />'.
		'</td></tr>'.
		'</table><br /><br />';
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ===========================================================================*/
// XML Import
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doimportxml'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}

	$vbulletin->url = $ADMIN_SCRIPT.".php?set=importexport";

	require_once(DIR . '/includes/adminfunctions.php');
	require_once(DIR . '/includes/class_xml.php');

	function import_row($table, &$row, $indexfield) {
		global $vbulletin;

		$search = array ("\r", "\n");
		$replace = array ("\\r", "\\n");

		$myrow = $row;
		$myrow = str_replace($replace, $search, $myrow);

		$tags = array();
		$values = array();
		foreach ($myrow as $tag=>$element) {
			if ($tag=='value') continue;
			if ($tag==$indexfield) continue;
			$tags[] = $tag;
			$values[] = $vbulletin->db->escape_string($element);
		}
		if (count($tags)) {
			$query = 'INSERT INTO '.THIS_TABLE.$table.
					' ('.implode(', ',$tags).') '.
					'VALUES ("'.implode('", "',$values).'")';
			$vbulletin->db->query_write($query);
			$row['value'] = $vbulletin->db->insert_id();
		}
	}

	function update_row($table, $rowid, $rowval, $fields) {
		global $vbulletin;

		$values = array();
		foreach ($fields as $tag=>$element) {
			$tags[] = $tag.'="'.$vbulletin->db->escape_string($element).'"';
		}
		if (count($tags)) {
			$query = 'UPDATE '.THIS_TABLE.$table.
					' SET '.implode(', ',$tags).
					' WHERE '.$rowid.'="'.$vbulletin->db->escape_string($rowval).'"';
			$vbulletin->db->query_write($query);
		}
	}

	function fix_table(&$arr) {
		if (array_key_exists('value', $arr)) { // one row only
			$temparray = array();
			foreach ($arr as $l=>$v) {
				$temparray[$l] = $v;
				unset($arr[$l]);
			}
			$arr[0] = $temparray;
		}
	}

	function import_table(&$arr, $table, $indexfield) {
		$nrec = 0;
		foreach ($arr as $l=>$t2) {
			import_row($table, $arr[$l], $indexfield);
			$nrec+=1;
		}
		return $nrec;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'xmlinit' => TYPE_INT,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'xmlimport' => TYPE_FILE,
	));

	if (!$vbulletin->GPC['xmlimport']['name'] or !$vbulletin->GPC['xmlimport']['tmp_name']
		or !$vbulletin->GPC['xmlimport']['size']
		or !is_uploaded_file($vbulletin->GPC['xmlimport']['tmp_name'])) {
		$err = $vbphrase['ll_error_importxml_read'].' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$fp = @gzopen($vbulletin->GPC['xmlimport']['tmp_name'], "rb");
	$xml = '';
	while (!@feof($fp)) {
		$xml .= @fread($fp, 8192);
	}
	@fclose($fp);

//	$xml = file_read($vbulletin->GPC['xmlimport']['tmp_name']);
	if (!$xml) {
		$err = construct_phrase($vbphrase['ll_error_importxml_interpret'],$vbulletin->GPC['xmlimport']).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$xmlobj = new XMLparser($xml);
	if ($xmlobj->error_no == 1 or $xmlobj->error_no == 2) {
		$err = construct_phrase($vbphrase['ll_error_importxml_createparser'],$vbulletin->GPC['xmlimport']).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!$arr =& $xmlobj->parse()) {
		$err = construct_phrase($vbphrase['ll_error_importxml_doparser'], $xmlobj->error_line(), $vbulletin->GPC['xmlimport']).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	switch ($vbulletin->GPC['xmlinit']) {
	case 1:
		ldm_clearfromtable('linksadmin', 'catid>0');
		ldm_clearfromtable('linkscat');
		ldm_clearfromtable('linkslink');
		ldm_clearfromtable('linksltoc');
		ldm_clearfromtable('linkskeys');
		ldm_clearfromtable('linksltok');
		ldm_clearfromtable('linksfavs');
		ldm_clearfromtable('linksrate');
		ldm_clearfromtable('linksdownloads');
		break;

	case 2:
		ldm_clearfromtable('linksadmin');
		ldm_clearfromtable('linksdebug');
		ldm_clearfromtable('linkscat');
		ldm_clearfromtable('linkslink');
		ldm_clearfromtable('linksltoc');
		ldm_clearfromtable('linkskeys');
		ldm_clearfromtable('linksltok');
		ldm_clearfromtable('linksfavs');
		ldm_clearfromtable('linksrate');
		ldm_clearfromtable('linksdownloads');
		ldm_clearfromtable('linkssearch');

		require_once(DIR . '/includes/local_links_admininclude.php');
		init_admin_table();
		record_links_version(THIS_VERSION, 1);
		break;
	}

	$arecats = 0;
	if (array_key_exists('categories', $arr)) {
		if (is_array($arr['categories'])) {
			if (array_key_exists('category', $arr['categories'])) {
				if (count($arr['categories']['category'])) {
					$arecats = 1;
				}
			}
		}
	}

	if (!$arecats) {
		$kcat = $klink = 0;
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_xmlimport_complete'],$kcat,$klink),0));
		exit;
	}

	$categories =& $arr['categories']['category'];
	fix_table($categories);
	$kcat = import_table($categories, 'linkscat', 'catid');

	$catid_map = array();
	foreach ($categories as $l=>$t1) {
		$catid_map[$categories[$l]['catid']] = $categories[$l]['value'];
	}
	foreach ($categories as $l=>$t1) {
		if ($categories[$l]['parentid']>0) {
			$categories[$l]['parentid'] = $catid_map[$categories[$l]['parentid']];
			$parents = explode(',', $categories[$l]['parentlist']);
			foreach ($parents as $m=>$t2) {
				if ($parents[$m]>0) {
					$parents[$m] = $catid_map[$parents[$m]];
				}
			}
			$categories[$l]['parentlist'] = implode(',', $parents);
			update_row('linkscat', 'catid', $categories[$l]['value'], array('parentid'=>$categories[$l]['parentid'], 'parentlist'=>$categories[$l]['parentlist']));
		}
	}

	$linkid_map = array();
	$klink = 0;

	if (array_key_exists('links', $arr)) {
		if (is_array($arr['links'])) {
			if (array_key_exists('link', $arr['links'])) {
				$links =& $arr['links']['link'];
				foreach ($links as $k=>$t1) {
					$links[$k]['totrate'] = $links[$k]['numrate'] = 0;
				}
				fix_table($links);
				$klink = import_table($links, 'linkslink', 'linkid');

				foreach ($links as $l=>$t1) {
					$linkid_map[$links[$l]['linkid']] = $links[$l]['value'];
				}
			}
		}
	}

	if (array_key_exists('linkcats', $arr)) {
		if (is_array($arr['linkcats'])) {
			if (array_key_exists('ltoc', $arr['linkcats'])) {
				$ltocs =& $arr['linkcats']['ltoc'];
				fix_table($ltocs);
				foreach ($ltocs as $l=>$t1) {
					$ltocs[$l]['linkid'] = $linkid_map[$ltocs[$l]['linkid']];
					$ltocs[$l]['catid']  = $catid_map[$ltocs[$l]['catid']];
				}
				$kltoc = import_table($ltocs, 'linksltoc', 'ltoc');
			}
		}
	}

	$keyids = array();
	if (array_key_exists('keywords', $arr)) {
		if (is_array($arr['keywords'])) {
			if (array_key_exists('keyword', $arr['keywords'])) {
				$keywords =& $arr['keywords']['keyword'];
				fix_table($keywords);
				$keyword_list = array();
				foreach ($keywords as $v) {
					$keyword_list[] = $v['keyword'];
				}
				$keyid_map = lookup_keywords($keyword_list);
			}
		}
	}

	if (array_key_exists('linkkeys', $arr)) {
		if (is_array($arr['linkkeys'])) {
			if (array_key_exists('ltok', $arr['linkkeys'])) {
				$ltoks =& $arr['linkkeys']['ltok'];
				fix_table($ltoks);
				foreach ($ltoks as $l=>$t1) {
					$ltoks[$l]['linkid'] = $linkid_map[$ltoks[$l]['linkid']];
					$ltoks[$l]['keyid']  = $keyid_map[$ltoks[$l]['keyid']-1];

				}
				$kltok = import_table($ltoks, 'linksltok', 'lkey');
			}
		}
	}

	eval(print_standard_redirect(construct_phrase($vbphrase['ll_xmlimport_complete'],$kcat,$klink),0));
	exit;

}

?>