<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Analyse hit activity
/* ===========================================================================*/

if ($adminset == "logjumps") {

	$vbulletin->input->clean_array_gpc('r', array(
		'archive' => TYPE_INT,
		'cleandates' => TYPE_INT,
		'cleanend' => TYPE_STR,
		'cleanstart' => TYPE_STR,
		'cleanuser' => TYPE_STR,
		'end' => TYPE_STR,
		'endint' => TYPE_INT,
		'hitsperpage' => TYPE_INT,
		'linkid' => TYPE_INT,
		'page2' => TYPE_INT,
		'showdates' => TYPE_INT,
		'sortby' => TYPE_STR,
		'start' => TYPE_STR,
		'startint' => TYPE_INT,
		'todo' => TYPE_INT,
		'userid' => TYPE_INT,
		'userip' => TYPE_STR,
	));

	$navbits[""] = $vbphrase['ll_viewhits'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	construct_forum_jump();
	$url = $ADMIN_SCRIPT.".php?set=logjumps";

	require_once(DIR . '/includes/functions_misc.php');

	$myrow = $vbulletin->db->query_first("
		SELECT COUNT(*) AS hits, MIN(usertime) AS first, MAX(usertime) AS last
		FROM ".THIS_TABLE."linksdownloads
		WHERE linkid>0
		");
	$totalhits = $myrow['hits'];
	$firsthit = $myrow['first'];
	$firstdate = ldm_date($vbulletin->options['dateformat'], $firsthit);
	$lasthit = $myrow['last'];
	$lastdate = ldm_date($vbulletin->options['dateformat'], $lasthit);

	$detail = 2;
	$clean = 3;

	$hitsperpage = ($vbulletin->GPC['hitsperpage'] ? $vbulletin->GPC['hitsperpage'] : ($links_defaults['perpage_downloadtable'] ? $links_defaults['perpage_downloadtable'] : 25));

	if ($vbulletin->GPC['cleandates']==-1) { // all dates
		$cleanstartat = $firsthit - 1;
		$cleanendat   = $lasthit + 1;
		$cleandatesel = -1;
	}
	elseif ($vbulletin->GPC['cleandates']==-2) { // selected dates
		if ($vbulletin->GPC['cleanstart'] and preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['cleanstart'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['cleanstart'], 3, PREG_SPLIT_NO_EMPTY);
			$cleanstartat = vbmktime ( 0, 0, 0, $chars[1], $chars[2], $chars[0]);
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		if ($vbulletin->GPC['cleanend'] and preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['cleanend'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['cleanend'], 3, PREG_SPLIT_NO_EMPTY);
			$cleanendat = vbmktime ( 23, 59, 59, $chars[1], $chars[2], $chars[0]);
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$cleandatesel = -2;
	}
	elseif ($vbulletin->GPC['cleandates']>0) {
		$cleanstartat = $firsthit - 1;
		$cleanendat   = $lasthit - $vbulletin->GPC['cleandates']*24*60*60 + 1;
		$cleandatesel = $vbulletin->GPC['cleandates'];
	}
	else {
		$cleanstartat = $firsthit - 1;
		$cleanendat   = $lasthit - 90*24*60*60 + 1;
		$cleandatesel = 90;
	}

	$cleanstartdate = vbdate ("Y-m-d", $cleanstartat);
	$cleanenddate = vbdate ("Y-m-d", $cleanendat);

	$cleanusers = array();
	if ($vbulletin->GPC['cleanuser']) {
		$cleanusers = lookup_userids(explode(';', preg_replace("/\s*;\s*$/", "", $vbulletin->GPC['cleanuser'])));
	}
	$cleanusers = count($cleanusers) ? "AND userid IN (".implode(",", $cleanusers).")" : "";

// Tidy downloads table
	if ($vbulletin->GPC['todo']==$clean) {

		if (!isset($cleanstartat) or !isset($cleanendat)) {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}

		if ($vbulletin->GPC['archive']==1) {
			$tmpfname = tempnam("", "arc");
			$temp = @fopen($tmpfname, "w");
			if ($temp) {
				fwrite($temp, "LinkID,LinkURL,UserName,UserID,UserIP,Time\r\n");
				$query = "
					SELECT *
					FROM ".THIS_TABLE."linksdownloads
					WHERE usertime>=".$cleanstartat." AND usertime<=".$cleanendat."
					AND linkid>0
					".$cleanusers;
				$asb = $vbulletin->db->query_read($query);
				while ($myrow = $vbulletin->db->fetch_array($asb)) {
					$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow["usertime"]).
						' '.
						ldm_date($vbulletin->options['timeformat'], $myrow["usertime"]);
					fwrite($temp, '"'.$myrow["linkid"].'","'.$myrow["linkurl"].'","'.$myrow["username"].'","'.$myrow["userid"].'","'
						.$myrow["userip"].'","'.$dateandtime.'"'."\r\n");
				}
				fclose($temp);

				$temp = @fopen($tmpfname, "r");
				$filesize = filesize($tmpfname);

				@header("HTTP/1.1 200");
				@header("Expires: 0");
				@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
				@header("Pragma: no-cache"); // HTTP/1.0
				@header("Content-Length: $filesize");
				@header("Content-type: application/octet-stream");
				@header("Content-disposition: attachment; filename=downloads.csv");

				while ($contents = fread($temp, $READ_BUFFER_SIZE)) {
					echo $contents;
				}

				fclose($temp);
				unlink($tmpfname);
				exit;
			}
			else {
				$err = $vbphrase['ll_error_downloads_temp'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}

		if ($vbulletin->GPC['archive']==2) {
			$query = "
				DELETE
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$cleanstartat."
				AND usertime<=".$cleanendat."
				AND linkid>0
				".$cleanusers;

			$vbulletin->db->query_write($query);

			$myrow = $vbulletin->db->query_first("
				SELECT COUNT(*) AS hits, MIN(usertime) AS first, MAX(usertime) AS last
				FROM ".THIS_TABLE."linksdownloads
				WHERE linkid>0
				");
			$totalhits = $myrow['hits'];
			$firsthit = $myrow['first'];
			$firstdate = ldm_date($vbulletin->options['dateformat'], $firsthit);
			$lasthit = $myrow['last'];
			$lastdate = ldm_date($vbulletin->options['dateformat'], $lasthit);
		}

	}

	unset($startat);
	unset($endat);

	if ($vbulletin->GPC_exists['startint']) {
		$startat = max($vbulletin->GPC['startint'], $firsthit);
		$datesel = -2;
	}
	elseif ($vbulletin->GPC_exists['endint']) {
		$startat = $firsthit - 1;
		$datesel = -2;
	}
	elseif ($vbulletin->GPC['showdates']==-1) {
		$startat = $firsthit - 1;
		$datesel = -1;
	}
	elseif ($vbulletin->GPC['showdates']>0) {
		$startat = $lasthit - $vbulletin->GPC['showdates']*24*60*60 - 1;
		$datesel = $vbulletin->GPC['showdates'];
	}
	elseif ($vbulletin->GPC['start']) {
		if (preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['start'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['start'], 3, PREG_SPLIT_NO_EMPTY);
			$startat = vbmktime ( 0, 0, 0, $chars[1], $chars[2], $chars[0]);
			$datesel = -2;
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}
	else {
		$startat = $firsthit - 1;
		$datesel = -1;
	}

	if ($vbulletin->GPC_exists['endint']) {
		$endat = min($lasthit, $vbulletin->GPC['endint']);
	}
	elseif ($vbulletin->GPC_exists['startint']) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['showdates']==-1) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['showdates']>0) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['end']) {
		if (preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['end'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['end'], 3, PREG_SPLIT_NO_EMPTY);
			$endat = vbmktime ( 23, 59, 59, $chars[1], $chars[2], $chars[0]);
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}
	else {
		$endat = $lasthit + 1;
	}

	$startdate = vbdate ("Y-m-d", $startat);
	$enddate = vbdate ("Y-m-d", $endat);

	unset($userid);
	if ($vbulletin->GPC_exists['userid']) {
		$userid = $vbulletin->GPC['userid'];
	}
	unset($linkid);
	if ($vbulletin->GPC_exists['linkid']) {
		$linkid = $vbulletin->GPC['linkid'];
	}
	unset($userip);
	if ($vbulletin->GPC_exists['userip']) {
		$userip = $vbulletin->GPC['userip'];
	}

	$sortby = iif($vbulletin->GPC_exists['sortby'], $vbulletin->GPC['sortby'], "byuser");
	$pagenumber2 = iif ($vbulletin->GPC['page2'], $vbulletin->GPC['page2'], 1);

	$script = $ADMIN_SCRIPT.".php?set=logjumps&amp;sortby=".$sortby.
		"&amp;start=".$startdate.
		"&amp;end=".$enddate;
	$logscript = $script .
		iif(isset($userid), "&amp;userid=".$userid, "") .
		iif(isset($linkid), "&amp;linkid=".$linkid, "") .
		iif(isset($userip), "&amp;userip=".$userip, "") ;

	$linktotalsbit = "";
	$linkdetailsbit = "";

	$pagenav = "";
	$pagenav2 = "";

// Summarise downloads table
	if ($vbulletin->GPC['todo']<=1) {
		$counts = array();
		switch ($sortby) {

		case "bydoc":
			$query = "
				SELECT lhits.linkid AS linkid, lhits.linkurl AS linkurl, COUNT(lhits.bytes) AS hits, SUM(lhits.bytes) AS bytes,
						links.linkname AS linkname
				FROM ".THIS_TABLE."linksdownloads AS lhits
				LEFT JOIN ".THIS_TABLE."linkslink AS links
				ON lhits.linkid=links.linkid
				WHERE lhits.usertime>=".$startat." AND lhits.usertime<=".$endat.
				iif(isset($userid), " AND lhits.userid='".$userid."'", "").
				iif(isset($userip), " AND lhits.userip='".$userip."'", "").
				iif(isset($linkid), " AND lhits.linkid='".$linkid."'", " AND lhits.linkid>0")."
				GROUP BY lhits.linkid
				ORDER BY links.linkname
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$counts[$myrow['linkname']]['hits'] = $myrow['hits'];
				$counts[$myrow['linkname']]['bytes'] = $myrow['bytes'];
				$counts[$myrow['linkname']]['title'] = iif($myrow['linkname'], $myrow['linkname'], construct_phrase($vbphrase['ll_hint_thisentry_notavail'], $myrow['linkid']));
				$counts[$myrow['linkname']]['drill'] = $script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;linkid=".$myrow['linkid'].
					iif(isset($userid),"&amp;userid=".$userid,"").iif(isset($userip),"&amp;userip=".$userip,"").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "byip":
			$query = "
				SELECT linkid, linkurl, userip, COUNT(bytes) AS hits, SUM(bytes) AS bytes
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				iif(isset($userid), " AND userid='".$userid."'", "").
				iif(isset($userip), " AND lhits.userip='".$userip."'", "").
				iif(isset($linkid), " AND linkid='".$linkid."'", " AND linkid>0")."
				GROUP BY userip
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$key = $myrow['userip'];
				if (preg_match("/(\d+)\.(\d+)\.(\d+)\.(\d+)/", $key, $matches)) {
					$key = sprintf("%03d.%03d.%03d.%03d", $matches[1], $matches[2], $matches[3], $matches[4]);
					$counts[$key]['title'] = $myrow['userip'];
				}
				else {
					$key = "unknown";
					$counts[$key]['title'] = $key;
				}
				$counts[$key]['hits'] = $myrow['hits'];
				$counts[$key]['bytes'] = $myrow['bytes'];
				$counts[$key]['drill'] = $script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userip=".$myrow['userip'].
					iif(isset($userid),"&amp;userid=".$userid,"").iif(isset($linkid),"&amp;linkid=".$linkid,"").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "bydate":
			$query = "
				SELECT linkid, linkurl, bytes, usertime
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				iif(isset($userid), " AND userid='".$userid."'", "").
				iif(isset($userip), " AND lhits.userip='".$userip."'", "").
				iif(isset($linkid), " AND linkid='".$linkid."'", " AND linkid>0")."
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$key	= date('ymd', $myrow['usertime']);
				$kstartat = vbmktime ( 0, 0, 0, substr($key,2,2), substr($key,4,2), substr($key,0,2));
				$kendat	= $kstartat + 24*60*60;
				$counts[$key]['hits'] += 1;
				$counts[$key]['bytes'] += $myrow['bytes'];
				$counts[$key]['title'] = ldm_date($vbulletin->options['dateformat'], $myrow['usertime']);
				$counts[$key]['drill'] = $script."&amp;todo=".$detail."&amp;startint=".$kstartat."&amp;endint=".$kendat.
					iif(isset($userid),"&amp;userid=".$userid,"").iif(isset($linkid),"&amp;linkid=".$linkid,"").iif(isset($userip),"&amp;userip=".$userip,"").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "byuser":
		default:
			$query = "
				SELECT linkid, linkurl, userid, username, COUNT(bytes) AS hits, SUM(bytes) AS bytes
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				iif(isset($userid), " AND userid='".$userid."'", "").
				iif(isset($userip), " AND lhits.userip='".$userip."'", "").
				iif(isset($linkid), " AND linkid='".$linkid."'", " AND linkid>0")."
				GROUP BY userid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$my_user = ($myrow['userid'] ? unhtmlentities($myrow['username']) : $vbphrase['unregistered']);
				$key = strtolower($my_user);
				$counts[$key]['hits'] = $myrow['hits'];
				$counts[$key]['bytes'] = $myrow['bytes'];
				$counts[$key]['title'] = unhtmlentities($my_user);
				$counts[$key]['drill'] = $script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userid=".$myrow['userid'].
					iif(isset($linkid),"&amp;linkid=".$linkid,"").iif(isset($userip),"&amp;userip=".$userip,"").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		}

		ksort($counts);

		$nstart	= ($pagenumber-1)*$hitsperpage+1;
		$nend	= $pagenumber*$hitsperpage;
		$nrow	= 0;
		$itemhits 	= 0;

		foreach ($counts as $key=>$this_count) {
			$nrow++;
			$itemhits += $this_count['hits'];
			if ($nrow<$nstart or $nrow>$nend) {
				continue;
			}
			$this_count['encode_byes'] = encode_bytes($this_count['bytes']);
			eval("\$linktotalsbit .= \"".fetch_template('links_admin_downloads_group')."\";");
		}

		if (isset($userid)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byuser'], $itemhits, $userid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($userip)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byip'], $itemhits, $userip, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($linkid)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byentry'], $itemhits, $linkid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		else {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $itemhits, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}

		$pagenav = construct_page_nav($pagenumber, $hitsperpage, count($counts), $logscript,"&amp;hitsperpage=$hitsperpage");

	}

// Detail downloads table
	else {

		$query = "
			SELECT hits.usertime AS usertime, hits.bytes AS bytes, hits.linkid AS linkid,
				hits.linkurl AS linkurl, hits.username AS username, hits.userid AS userid,
				hits.userip AS userip, links.linkname AS linkname
			FROM ".THIS_TABLE."linksdownloads AS hits
			LEFT JOIN ".THIS_TABLE."linkslink AS links
			ON hits.linkid=links.linkid
			WHERE hits.usertime>=".$startat."
			AND hits.usertime<=".$endat."
			AND hits.linkid>0
			";

		$subquery = "";
		if (isset($userid)) {
			$subquery .= "AND hits.userid='".$userid."'";
			$subsort = "ORDER BY hits.usertime";
		}
		if (isset($linkid)) {
			$subquery .= "AND hits.linkid='".$linkid."'";
			$subsort = "ORDER BY hits.username";
		}
		if (isset($userip)) {
			$subquery .= "AND hits.userip='".$vbulletin->db->escape_string($userip)."'";
			$subsort = "ORDER BY hits.usertime";
		}
		$query .= $subquery . ' ' . $subsort;

		$asb = $vbulletin->db->query_read($query);

		$nrow = 0;
		$nstart = ($pagenumber2-1)*$hitsperpage+1;
		$nend = $nstart + $hitsperpage;

		while ($myrow=$vbulletin->db->fetch_array($asb)) {

			$nrow++;
			if ($nrow<$nstart or $nrow>$nend) {
				continue;
			}

			$my_bytes = $myrow['bytes'] ? format_bytes($myrow['bytes']) : 'OK';
			$my_whenh = ldm_date($vbulletin->options['timeformat'], $myrow['usertime']);
			$my_whend = ldm_date($vbulletin->options['dateformat'], $myrow['usertime']);
			$my_ip = $myrow['userip'];
			if (!isset($userip)) {
				$my_ip .= ' '.
					'<a title="'.construct_phrase($vbphrase['ll_hint_thisip'], $myrow['userip']).'" href="'.$script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.
					'&amp;userip='.$myrow['userip'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? '<img border="0" src="'.$ldm_icon_cache['magnify'].'" alt="'.$vbphrase['ll_hint_thisip'].'" />' : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			$my_userid = construct_phrase($vbphrase['ll_admin_userid'], $myrow['userid']);
			$my_user = ($myrow['userid'] ? unhtmlentities($myrow['username']) : $vbphrase['unregistered']);
			if (!isset($userid)) {
				$my_user .= ' '.
					'<a title="'.$vbphrase['ll_hint_thisuser'].'" href="'.$script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.
					'&amp;userid='.$myrow['userid'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? '<img border="0" src="'.$ldm_icon_cache['magnify'].'" alt="'.$vbphrase['ll_hint_thisuser'].'" />' : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			$my_entryname = $myrow['linkname'] ? $myrow['linkname'] : construct_phrase($vbphrase['ll_hint_thisentry_notavail'],$myrow['linkid']);
			$my_entry = $my_entryname;
			if (!isset($linkid)) {
				$my_hint = construct_phrase($vbphrase['ll_hint_thisentry'], $myrow['linkid']);
				$my_entry .= ' '.
					'<a title="'.$my_hint.'" href="'.$script."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat.'&amp;linkid='.$myrow['linkid'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? '<img border="0" src="'.$ldm_icon_cache['magnify'].'" alt="'.$my_hint.'" />' : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			eval("\$linkdetailsbit .= \"".fetch_template('links_admin_downloads_item')."\";");
		}

		if (!$linkdetailsbit) {
			eval("\$linkdetailsbit = \"".fetch_template('links_admin_downloads_item_none')."\";");
		}

		if (isset($userid)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byuser'], $nrow, $userid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($userip)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byip'], $nrow, $userip, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($linkid)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byentry'], $nrow, $linkid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		else {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $nrow, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}

		$drillscript = $logscript."&amp;todo=".$detail."&amp;startint=".$startat."&amp;endint=".$endat;
		$pagenav2 = construct_page_nav($pagenumber2, $hitsperpage, $nrow, $drillscript, "&amp;hitsperpage=$hitsperpage");
		$pagenav2 = preg_replace("/;page=/", ";page2=", $pagenav2);

	}

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	$hitstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $totalhits, $firstdate, $lastdate);
	eval("\$logjumpsbit = \"".fetch_template('links_admin_downloads')."\";");

}

?>