<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Mass Edits - By category, forumid or non-hits
/* ===========================================================================*/

if ($this_action == "massedit") {

	$url = ADMIN_SCRIPT.".php?action=admin&set=categories";

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'expire' => TYPE_STR,
		'fid' => TYPE_INT,
		'searchid' => TYPE_INT,
		'numupdates' => TYPE_INT,
	));

	unset($expire);
	unset($catid);
	unset($forumid);
	unset($searchid);
	unset($num_updates);

	$navbits = array();
	$navbits[$LINKS_SCRIPT.".php"] = $master_title;
	$this_navigation_title = $navbits[$ADMIN_SCRIPT.".php"] = $vbphrase['ll_links_administration'];
	$navbits[$ADMIN_SCRIPT.".php?action=admin&amp;set=categories"] = $vbphrase['ll_menu_admcats'];

	if ($vbulletin->GPC_exists['numupdates']) {
		$num_updates = construct_phrase($vbphrase['ll_admin_masseditnumupdates'], $vbulletin->GPC['numupdates']);
	}

	if ($vbulletin->GPC_exists['expire']) {
		$linkids = array(-1);

		$expire_cats = array();
		foreach ($linkscat as $catid=>$thiscat) {
			$expire = lookup_setting($catid, 'links_expiry_days');
			if ($expire>0) $expire_cats[$catid] = TIMENOW - $expire*24*60*60;
		}

		if (count($expire_cats)) {
// find those that have expired in at least one category
			$query1 = "
				SELECT link.linkid AS linkid, link.linkdate AS linkdate, ltoc.catid AS linkcatid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE ltoc.catid IN (".implode(',',array_keys($expire_cats)).")
				";
			$asb = $vbulletin->db->query_read($query1);
			$lastid = -1;
			while ($rec = $vbulletin->db->fetch_array($asb)) {
				$lastid = $rec['linkid'];
				if ($rec['linkdate']<$expire_cats[$rec['linkcatid']]) {
					$linkids[$lastid] = $lastid;
				}
			}
// kick out those that are not expired in another category
			$query1 = "
				SELECT link.linkid AS linkid, link.linkdate AS linkdate, ltoc.catid AS linkcatid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE link.linkid IN (".implode(',',$linkids).")
				";
			$asb = $vbulletin->db->query_read($query1);
			while ($rec = $vbulletin->db->fetch_array($asb)) {
				if ($rec['linkdate']>=$expire_cats[$rec['linkcatid']]) {
					if (isset($linkids[$rec['linkid']])) {
						unset($linkids[$rec['linkid']]);
					}
				}
			}

		}

		$count = count($linkids)-1;
		$linkids = implode(',', $linkids);
		$navbits[""] = $title = $vbphrase['ll_admin_expire'];

		$where = "WHERE link.linkid IN (".$linkids.")";

	}
	elseif ($vbulletin->GPC_exists['fid']) {
		$forumid = $curforumid = $vbulletin->GPC['fid'];
		$rec = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS links FROM ".THIS_TABLE."linkslink
			WHERE linkforum='".$forumid."'
			");
		$count = $rec['links'];
		$navbits[""] = $title = $vbphrase['ll_admin_masseditforum'].' '.iif($forumid>0,$vbulletin->forumcache[$curforumid]['title'],$vbphrase['ll_forumdefault']);

		$where = "WHERE link.linkforum='".$forumid."'";

	}
	elseif ($vbulletin->GPC_exists['searchid']) {
		$searchid = $vbulletin->GPC['searchid'];
		$query = "SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$searchid."
			AND   searchexpires>=".TIMENOW."
			LIMIT 1
			";
		$asb = $vbulletin->db->query_read($query);
		if ($vbulletin->db->num_rows($asb)) {
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$search = unserialize($row['searchparam']);
			}
		}
		else {
			eval(standard_error(construct_phrase($vbphrase['ll_error_searchid'], $searchid).'<br/><a href="'.$ADMIN_SCRIPT.'.php?set=statistics">'.$vbphrase['ll_return'].'</a>'));
			exit;
		}
		$asb = $vbulletin->db->query_read($search['query']);
		$count = $vbulletin->db->num_rows($asb);
		$query = $search['query']." LIMIT ".($pagenumber-1)*$perpage.", ".$perpage;
		$navbits[""] = $title = construct_phrase($vbphrase['ll_searchid'], $searchid);

	}
	elseif ($vbulletin->GPC_exists['catid'] and $vbulletin->GPC['catid']>0) {
		$catid = $vbulletin->GPC['catid'];
		if (!catid_is_valid($catid)) {
			$vbulletin->url = ADMIN_SCRIPT.".php?action=admin&set=categories";
			eval(print_standard_redirect($vbphrase['ll_error_category'].' '.$catid,0));
			exit;
		}
		$rec = $vbulletin->db->query_first("
			SELECT COUNT(link.linkid) AS links FROM ".THIS_TABLE."linkslink AS link,
			".THIS_TABLE."linksltoc AS ltoc
			WHERE link.linkid=ltoc.linkid AND ltoc.catid='".$catid."'
			");
		$count = $rec['links'];
		$title = $vbphrase['ll_cat'].' '.$linkscat[$catid]['catname_clean'];
		$navbits[""] = $vbphrase['ll_admin_masseditcat'].' '.$linkscat[$catid]["catname_clean"];

		$where = "WHERE ltoc.catid='".$catid."'";

	}
	elseif ($vbulletin->GPC_exists['catid'] and $vbulletin->GPC['catid']==-1) {
		$catid = $vbulletin->GPC['catid'];
		$rec = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS links FROM ".THIS_TABLE."linkslink
			");
		$count = $rec['links'];
		$title = $vbphrase['ll_links_database'];
		$navbits[""] = $vbphrase['ll_admin_masseditcat'];

		$where = "";
	}
	else { // everything
		print_no_permission();
		exit;
	}

	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = iif($curforumid<=0,$vbphrase['ll_none'],iif(forumid_is_valid($curforumid),$vbulletin->forumcache[$curforumid]['title'],$curforumid));
	$optbit = construct_category_list(array($catid), "links_catjump", 0, "pcatid", "pcatid");

	if (!$query) {
		$query = "
		SELECT
			link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
			link.linkuserid AS linkuserid, link.linkusername AS linkusername, link.linkurl AS linkurl,
			link.linkimg AS linkimg, link.linkimgthumb AS linkimgthumb, link.linkhits AS linkhits,
			link.linkforum AS linkforum, link.linkstatus AS linkstatus, link.linksize AS linksize,
			link.linkdate AS linkdate, ltoc.displayorder AS displayorder,
			ltoc.catid AS linkcatid
		FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
		".$where."
		ORDER BY linkname ASC
		LIMIT ".($pagenumber-1)*$perpage.", ".$perpage;
	}

	$asb = $vbulletin->db->query_read($query);

	$lastid = -1;
	$links = array();
	$linkids = array(-1);
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$linkid = $rec['linkid'];
		if ($linkid!=$lastid) {
			$rec['keywords'] = "";
			$rec['lasthit'] = $vbphrase['ll_never'];
			$links[] = $rec;
		}
		$linkids[] = $lastid = $linkid;
	}

	$linkids = implode(',', $linkids);
	$query = "
		SELECT lkeys.keyword AS keyword, ltok.linkid AS linkid
		FROM ".THIS_TABLE."linksltok AS ltok
		LEFT JOIN ".THIS_TABLE."linkskeys AS lkeys
		ON ltok.keyid = lkeys.keyid
		WHERE ltok.linkid IN (".$linkids.")
		";
	$asb = $vbulletin->db->query_read($query);
	$lkeys = array();
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$lkeys[$rec['linkid']] .= $rec['keyword'].' ';
	}
	$asb = $vbulletin->db->query_read("
		SELECT usertime, linkid
		FROM ".THIS_TABLE."linksdownloads
		WHERE linkid IN (".$linkids.")
		ORDER BY usertime DESC
		");
	$lhits = array();
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		if (!isset($lhits[$rec['linkid']])) $lhits[$rec['linkid']] = $rec['usertime'];
	}

	foreach ($links as $k=>$thislink) {
		$thisid = $thislink['linkid'];
		if (isset($lkeys[$thisid])) $links[$k]['keywords'] = $lkeys[$thisid];
		if (isset($lhits[$thisid])) $links[$k]['lasthit'] = ldm_date($vbulletin->options['dateformat'], $lhits[$thisid]);
	}

	$linklistbit = "";
	$have_thumbs = 0;
	$nlist = 0;
	foreach ($links as $rec) {
		$linkid = $rec['linkid'];
		$linkname = htmlspecialchars_uni(iif(strlen($rec['linkname'])>24, substr($rec['linkname'],0,20).' ...', $rec['linkname']));
		$linkurl = $rec['linkurl'];
		$linkimg = $rec['linkimg'];
		$linkhits = $rec['linkhits'];
		$linkfile = $rec['linkfile'];
		$linklasthit = $rec['lasthit'];
		$linkkeywords = trim($rec['keywords']);
		$linkimgthumb = $rec['linkimgthumb'];
		if ($linkimgthumb) {
			$have_thumbs += 1;
		}
		$linkcatid = $rec['linkcatid'];
		$linkdisplayorder = $rec['displayorder'];
		$linkusername = htmlspecialchars_uni($rec['linkusername']);
		$linkbriefurl = "";
		$linkdate = ldm_date($vbulletin->options['dateformat'], $rec['linkdate']);
		if ($linkurl) {
			$urlinfo = ldm_parse_url($linkurl);
			if (!$urlinfo['scheme']) {
				$fullurl = mk_file_name($links_defaults['local_file_root_prefix'],$linkurl);
				if (!$links_defaults['local_file_root']) {
					$linkbriefurl = '<a title="'.$vbphrase['ll_view'].'" href="'.$fullurl.'" target="_blank">'.
						iif(strlen($linkurl)>48, substr($linkurl,0,44).' ...', $linkurl).
						'</a>';
				}
				else {
					$linkbriefurl = '<span style="color:green">'.
						iif(strlen($linkurl)>48, substr($linkurl,0,44).' ...', $linkurl).'</span>';
				}
				if ($links_defaults['local_file_root_prefix']) $linkbriefurl = '<span style="color:red">... </span>'.$linkbriefurl;
			}
			else {
				$linkbriefurl = '<a title="'.$vbphrase['ll_view'].'" href="'.$linkurl.'" target="_blank">'.
					iif(strlen($linkurl)>52, substr($linkurl,0,48).' ...', $linkurl).
					'</a>';
			}
		}
		$linkbriefimg = "";
		if ($linkimg) {
			$urlinfo = ldm_parse_url($linkimg);
			if (!$urlinfo['scheme']) {
				$fullurl = mk_file_name($links_defaults['local_file_root_prefix'],$linkimg);
				if (!$links_defaults['local_file_root']) {
					$linkbriefimg = '<a title="'.$vbphrase['ll_view'].'" href="'.$fullurl.'" target="_blank">'.
						iif(strlen($linkimg)>48, substr($linkimg,0,44).' ...', $linkimg).
						'</a>';
				}
				else {
					$linkbriefimg = '<span style="color:green">'.
						iif(strlen($linkimg)>48, substr($linkimg,0,44).' ...', $linkimg).'</span>';
				}
				if ($links_defaults['local_file_root_prefix']) $linkbriefimg = '<span style="color:red">... </span>'.$linkbriefimg;
			}
			else {
				$linkbriefimg = '<a title="'.$vbphrase['ll_view'].'" href="'.$linkimg.'" target="_blank">'.
					iif(strlen($linkimg)>52, substr($linkimg,0,48).' ...', $linkimg).
					'</a>';
			}
		}
		switch ($rec['linkstatus']) {
			case $LINK_HIDDEN:	  $linkstatus = "LINK_HIDDEN"; break;
			case $LINK_OK:		  $linkstatus = "LINK_OK"; break;
			case $LINK_UPLOAD:	  $linkstatus = "LINK_UPLOAD"; break;
			case $LINK_NO_ACCESS: $linkstatus = "LINK_NO_ACCESS"; break;
			case $LINK_BROKEN:	  $linkstatus = "VALIDATE"; break;
			default: 			  $linkstatus = $rec['linkstatus'];
		}
		$linksize = format_bytes($rec['linksize']);
		$linkforum = iif($rec['linkforum']>0,$vbulletin->forumcache[$rec['linkforum']]['title'],$vbphrase['ll_forumdefault']);
		$linkforum = iif(strlen($linkforum)>16, substr($linkforum,0,12).' ...', $linkforum);
		$linkcatname = $linkscat[$linkcatid]['catname_clean'];
		$linkcatname = iif(strlen($linkcatname)>16, substr($linkcatname,0,12).' ...', $linkcatname);
		$alt = iif($alt==1,2,1);
		eval('$linklistbit .= "' . fetch_template('links_massedit_linkbit') . '";');
		$nlist += 1;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$links_permissions["can_delete_category"] = 0;
	$viewcatid=-1;

	$pagenav = construct_page_nav($pagenumber, $perpage, $count, $ADMIN_SCRIPT.".php?action=massedit".
		iif($vbulletin->GPC_exists['expire'],"&amp;expire=".$vbulletin->GPC['expire'],"").
		iif($vbulletin->GPC_exists['catid'],"&amp;catid=".$vbulletin->GPC['catid'],"").
		iif($vbulletin->GPC_exists['searchid'],"&amp;searchid=".$vbulletin->GPC['searchid'],"").
		iif($vbulletin->GPC_exists['fid'],"&amp;fid=".$vbulletin->GPC['fid'],"")
			, "&amp;pp=$perpage");

	eval('$adminoptions = "' . fetch_template('links_admin_options') . '";');
	eval('$adminenvinmt = "' . fetch_template('links_admin_environment') . '";');

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_massedit')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ===========================================================================*/
// Follow-up action: Do (Mass Edit) Links
/* ===========================================================================*/

if ($this_action == "domassedit") {

	$url  = ADMIN_SCRIPT.".php?action=admin&amp;set=categories";

	$vbulletin->input->clean_array_gpc('p', array(
		'allpages' => TYPE_INT,
		'cancel' => TYPE_STR,
		'catid' => TYPE_INT,
		'disp_p' => TYPE_ARRAY_INT,
		'expire' => TYPE_INT,
		'fid' => TYPE_INT,
		'force' => TYPE_INT,
		'linkid' => TYPE_ARRAY_INT,
		'newkeywords' => TYPE_STR,
		'oldkeywords' => TYPE_STR,
		'pcatid' => TYPE_INT,
		'pforum' => TYPE_INT,
		'regexfield' => TYPE_INT,
		'regexfind' => TYPE_STR,
		'regexrepl' => TYPE_STR,
		'regexswitch' => TYPE_STR,
		'searchid' => TYPE_INT,
		'submit' => TYPE_STR,
	));

	if ($vbulletin->GPC_exists['cancel'] or !$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_accepted'],0));
		exit;
	}

	$url2 = ADMIN_SCRIPT.".php?action=massedit";
	if ($vbulletin->GPC_exists['fid']) {
		$url2 .= '&amp;fid='.$vbulletin->GPC['fid'];
	}
	elseif ($vbulletin->GPC_exists['catid']) {
		$url2 .= '&amp;catid='.$vbulletin->GPC['catid'];
	}
	elseif ($vbulletin->GPC_exists['expire']) {
		$url2 .= '&amp;expire='.$vbulletin->GPC['expire'];
	}
	elseif ($vbulletin->GPC_exists['searchid']) {
		$url2 .= '&amp;searchid='.$vbulletin->GPC['searchid'];
	}
	$url2 .= '&amp;pp='.$perpage.'&amp;page='.$pagenumber;

	$links = array(0);
	if ($vbulletin->GPC['allpages'] and ($vbulletin->GPC_exists['fid'] or $vbulletin->GPC_exists['catid'])) {
		$where = "";
		if ($vbulletin->GPC_exists['fid']) {
			$where = "WHERE link.linkforum='".$vbulletin->GPC['fid']."'";
		}
		elseif ($vbulletin->GPC_exists['catid'] and $vbulletin->GPC['catid']>0) {
			$where = "WHERE ltoc.catid='".$vbulletin->GPC['catid']."'";
		}
		$query = "
			SELECT
			link.linkid AS linkid, link.linkforum AS linkforum, ltoc.catid AS linkcatid
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			".$where;
		$asb = $vbulletin->db->query_read($query);
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			$links[] = $rec['linkid'];
		}
	}
	else {
		foreach($vbulletin->GPC['linkid'] as $thislink=>$select) {
			if ($select) $links[] = $thislink;
		}
	}

	$FORCE_regex = 1;
	$FORCE_regeximg = 2;
	$FORCE_cat = 3;
	$FORCE_forum = 4;
	$FORCE_hide = 5;
	$FORCE_unhide = 6;
	$FORCE_delete = 7;
	$FORCE_keys = 8;
	$FORCE_thumb = 9;
	$FORCE_displayorder = 10;

	$num_updates = 0;

	switch ($vbulletin->GPC['force']) {

	case $FORCE_cat: // change category
		$pcatid	 = $vbulletin->GPC['pcatid'];
		if (!catid_is_valid($pcatid)) {
			eval(standard_error($vbphrase['ll_error_category'].' '.$pcatid.
				' <a href="'.$url2.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		$query = "
			SELECT ltoc.ltoc AS ltocid
			FROM " . THIS_TABLE . "linkslink AS link
			LEFT JOIN ". THIS_TABLE. "linksltoc AS ltoc
			ON link.linkid=ltoc.linkid
			WHERE link.linkid IN (".implode(',', $links).")
		";
		$ltocs = array(0);
		$asb = $vbulletin->db->query_read($query);
		while ($myrow=$vbulletin->db->fetch_array($asb)) $ltocs[] = $myrow['ltocid'];
		$ltocs = implode(',', $ltocs);
		$query = "
			UPDATE ".THIS_TABLE."linksltoc
			SET
				catid='".$pcatid."'
			WHERE ltoc IN (".$ltocs.")
		";
		$vbulletin->db->query_write($query);
		$num_updates = count($links)-1;
		break;

	case $FORCE_delete: // delete
		$num_updates = count($links)-1;
		delete_ldm_entry($links);
		fix_cat_count();
		break;

	case $FORCE_displayorder: // change display order
		$num_updates = 0;
		foreach ($vbulletin->GPC['disp_p'] as $thisid=>$this_display) {
			if ($thisid>0) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linksltoc SET
					displayorder='".$this_display."'
					WHERE linkid=".$thisid."
					".iif($vbulletin->GPC_exists['catid'],"AND catid=".$vbulletin->GPC['catid'],"")."
					");
				$num_updates++;
			}
		}
		break;

		break;

	case $FORCE_forum: // change parent forum
		$pforum = $vbulletin->GPC['pforum'];
		if (!forumid_is_valid($pforum)) {
			eval(standard_error($vbphrase['ll_error_forum'].' '.$pforum.
				' <a href="'.$url2.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkforum='".$pforum."'
			WHERE linkid IN (".implode(',', $links).")
		";
		$vbulletin->db->query_write($query);
		$num_updates = count($links)-1;
		break;

	case $FORCE_hide: // hide
	 	$hide = $LINK_HIDDEN;
	 	$mod  = $LINK_TO_MODERATE;
	 	$statustime  = TIMENOW;
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkmoderate='".$mod."',
				linkstatus='".$hide."',
				linkmoddate='".$statustime."'
			WHERE linkid IN (".implode(',', $links).")
		";
		$vbulletin->db->query_write($query);
		$num_updates = count($links)-1;
		break;

	case $FORCE_unhide: // unhide
	 	$hide = $LINK_OK;
	 	$mod  = $LINK_ACCEPTED;
	 	$statustime  = TIMENOW;
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkmoderate='".$mod."',
				linkstatus='".$hide."',
				linkmoddate='".$statustime."'
			WHERE linkid IN (".implode(',', $links).")
		";
		$vbulletin->db->query_write($query);
		$num_updates = count($links)-1;
		break;

	case $FORCE_regex: // edit url with a regular expression

		$regexfind = $vbulletin->GPC['regexfind'];
		$regexrepl = $vbulletin->GPC['regexrepl'];
		$regexswitch = $vbulletin->GPC['regexswitch'];

		$len_regexfind = strlen($regexfind);
		$sep_regexfind = $regexfind{0};
// test for a valid regex
		if ($sep_regexfind!=$regexfind{$len_regexfind-1} or $len_regexfind<=2) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_regex'],$regexfind,$regexrepl,$regexswitch).'<br />'.$vbphrase['ll_goback']));
			exit;
		}

		$len_regexrepl = strlen($regexrepl);
		if ($regexrepl{0}!=$regexrepl{$len_regexrepl-1} or $len_regexrepl<2) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_regex'],$regexfind,$regexrepl,$regexswitch).'<br />'.$vbphrase['ll_goback']));
			exit;
		}
		$repl = substr($regexrepl, 1, $len_regexrepl-2);

		if (preg_match("/[^imsxeuADSUX]/", $regexswitch)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_regex'],$regexfind,$regexrepl,$regexswitch).'<br />'.$vbphrase['ll_goback']));
			exit;
		}

		$regex_matches = @preg_match($regexfind.$regexswitch, "");
		if ($regex_matches===FALSE) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_regex'],$regexfind,$regexrepl,$regexswitch).'<br />'.$vbphrase['ll_goback']));
			exit;
		}

		switch ($vbulletin->GPC['regexfield']) {
		case 1:
			$regexfield = "linkname";
			break;
		case 2:
			$regexfield = "linkdesc";
			break;
		case 3:
			$regexfield = "linkurl";
			break;
		case 4:
			$regexfield = "linkimg";
			break;
		default:
// should not happen
			eval(standard_error(construct_phrase($vbphrase['ll_error_regex_field'],$regexfield)));
			exit;
		}

		$asb = $vbulletin->db->query_read("
			SELECT linkid, ".$regexfield."
			FROM ".THIS_TABLE."linkslink
			WHERE linkid IN (".implode(',', $links).")
			");
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			$regex_matches = @preg_match($regexfind.$regexswitch, $rec[$regexfield]);
			if (!$regex_matches) continue;
			$edit = @preg_replace($regexfind.$regexswitch, $repl, $rec[$regexfield]);
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					".$regexfield."='".$vbulletin->db->escape_string($edit)."'
				WHERE linkid=".$rec['linkid']."
				";
			$vbulletin->db->query_write($query);
			$num_updates += 1;
		}
		break;

	case $FORCE_thumb: // rebuild thumbnails
		$asb = $vbulletin->db->query_read("
			SELECT linkid, linkimgthumb
			FROM ".THIS_TABLE."linkslink
			WHERE linkid IN (".implode(',', $links).")
			");
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			if ($rec['linkimgthumb']) {
				delete_thumb($rec['linkimgthumb']);
			}
		}
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkimgthumb=''
			WHERE linkid IN (".implode(',', $links).")
			";
		$vbulletin->db->query_write($query);
		$num_updates = count($links)-1;
		break;

	case $FORCE_keys: // add keywords
		associate_keywords($links, lookup_keywords(explode_keywords($vbulletin->GPC['oldkeywords'])), -1);
		associate_keywords($links, lookup_keywords(explode_keywords($vbulletin->GPC['newkeywords'])),  1);
		$num_updates = count($links)-1;
		break;

	}

	fix_cat_count();
	$vbulletin->url = $url2 . "&amp;numupdates=".intval($num_updates);
	eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	exit;

}

?>