<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ======== Initialisation====================================================*/

ldm_general_init();
ldm_trace();

function ldm_general_init() {

	global $vbulletin, $vbphrase, $phrasegroups, $LDM_environment, $protocol_schemes;
	global $links_permissions, $links_defaults, $usergroupids, $ldm_mysearch;
	global $linkscat, $catstyle;
	global $ldm_headtag_include, $ldm_header_include, $ldm_footer_include;
	global $ldm_mimetype_cache, $ldm_icon_cache, $ldm_linkbitcache, $ldm_catbitcache, $stylecache;
	global $links_fav, $child, $holdcat, $holdsort;

	global $LINK_BROKEN, $LINK_OK, $LINK_UPLOAD, $LINK_NO_ACCESS, $LINK_NO_REMOTE_DOWNLOADS, $LINK_HIDDEN;
	global $LINK_ALL, $LINK_TO_MODERATE, $LINK_ACCEPTED, $MIN_VOTE, $MAX_VOTE;
	global $BASE_CAT, $FAVS_CAT, $HIDE_CAT, $AVL_CAT, $BRKN_CAT, $INVD_CAT, $HOT_CAT, $NEW_CAT, $RND_CAT, $MY_CAT, $UPLD_CAT, $FEAT_CAT, $NEW_RATE;
	global $DEFAULT_FORUMID, $READ_BUFFER_SIZE, $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD;
	global $LINKS_SCRIPT, $ACTION_SCRIPT, $ADMIN_SCRIPT, $SEARCH_SCRIPT, $STREAM_SCRIPT, $RESIZE_SCRIPT;
	global $ADMINCP_FORUMPERM_SCRIPT, $ADMINCP_ATTACH_SCRIPT;
	global $HTTP_CODES;

	if (!defined('VALID_VB_VERSION')) {
		ldm_general_failure(
			"Critical Error: ".
			"Links and Downloads Manager v.".THIS_VERSION." requires VBulletin version 3.5/3.6"
			);
	}

	if (!defined('LDM_DOCUMENT_ROOT')) {
		ldm_general_failure(
			"Critical Error: ".
			"Document Root not set, ".
			"Edit local_links_init.php"
			);
	}

	$asb = $vbulletin->db->query_read("SHOW TABLES");
	$LDM_table_prefix = THIS_TABLE."links";
	$LDM_tables = 0;
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		foreach ($myrow AS $table) {
			if (preg_match ("/^$LDM_table_prefix/", $table)) {
				$LDM_tables ++;
			}
		}
	}
	if (!$LDM_tables) {
		ldm_general_failure(
			"Critical Error: ".
			"Cannot find Links and Downloads Manager database tables"
			);
	}
	$vbulletin->db->free_result($asb);

// Link statuses
	$LINK_BROKEN				=	 0;
	$LINK_OK					=	 1;
	$LINK_UPLOAD				=	 2;
	$LINK_NO_ACCESS				=   -1;
	$LINK_NO_REMOTE_DOWNLOADS	=   -2;
	$LINK_HIDDEN				=   -3;

// Validation request statuses
	$LINK_ALL			=	 3;

// Moderation statuses
	$LINK_TO_MODERATE	=   -2;
	$LINK_ACCEPTED		=    0;

// Voting limits
	$MIN_VOTE			=	 0;
	$MAX_VOTE			=	 5;

// Special categories
	$BASE_CAT			= 	-1;
	$FAVS_CAT			=	-2;
	$HIDE_CAT			=   -3;
	$AVL_CAT			=   -4;
	$BRKN_CAT			=   -5;
	$INVD_CAT			=   -6;
	$HOT_CAT			=   -7;
	$NEW_CAT			=   -8;
	$RND_CAT			=   -9;
	$MY_CAT				=  -10;
	$UPLD_CAT			=  -11;
	$FEAT_CAT			=  -12;
	$NEW_RATE			=  -13;

// Special Forum
	$DEFAULT_FORUMID	= -999;

// Size of chunk read from files and thrown at the user's browser
	$READ_BUFFER_SIZE   = READ_BUFFER;

// Styles used in admin settings
	$UNKNOWN  = 'class="alt1"';
	$INHERIT  = 'class="inlinemod"';
	$CUSTOM   = 'class="inlinemod"';
	$STANDARD = 'class="alt1"';

// Protocols supported
	$protocol_schemes = array(
		"http"=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"https"=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"ftp"=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"irc"=> array("mode"=>MODE_OPEN, "validate"=>0, "musicbox"=>0, "savemusicbox"=>0),
		"mms"=> array("mode"=>MODE_HIDE, "validate"=>0, "musicbox"=>2, "savemusicbox"=>0),
	);

	$admincpdir =& $vbulletin->config['Misc']['admincpdir'];
	$ADMINCP_FORUMPERM_SCRIPT = $admincpdir.'/forumpermission.php?do=modify';
	$ADMINCP_ATTACH_SCRIPT = $admincpdir.'/attachment.php?do=types';

	$LINKS_SCRIPT = LINKS_SCRIPT;
	$ACTION_SCRIPT = ACTION_SCRIPT;
	$ADMIN_SCRIPT = ADMIN_SCRIPT;
	$SEARCH_SCRIPT = SEARCH_SCRIPT;
	$STREAM_SCRIPT = STREAM_SCRIPT;
	$RESIZE_SCRIPT = RESIZE_SCRIPT;

	$ldm_headtag_include = "";
	$ldm_header_include = "";
	$ldm_footer_include = "";

	$usergroupids = explode(',', $vbulletin->userinfo['membergroupids']);
	$usergroupids[] = $vbulletin->userinfo['usergroupid'];

	$links_permissions = array();
	$links_defaults	= array();

// Moderation off by default
	$links_defaults["moderate_links"] = '0';

// Must cache the categories first
	get_linkscat();

	if (isset($_REQUEST['catid'])) {
		$cache_catid = $_REQUEST['catid'];
	}
	else {
		$cache_catid = $BASE_CAT;
	}

	$links_defaults = cache_LDMsettings($cache_catid);
	if ($links_defaults["version_installed"] != 1) {
		eval(standard_error($vbphrase['ll_error_critical_installed'].
			'<br />'.$vbphrase['ll_error_cannotcontinue']));
		exit;
	}
	elseif ($links_defaults["this_version"] != THIS_VERSION) {
		eval(standard_error($vbphrase['ll_error_critical_version'].'<br />Software: '.THIS_VERSION.' database: '.
			$links_defaults['this_version'].'<br />'.$vbphrase['ll_error_cannotcontinue']));
		exit;
	}

	$values = cache_LDMpermissions($cache_catid);
	foreach ($values as $k=>$v) {
		$vk = explode(',', $v);
		$links_permissions[$k] = 0;
		foreach ($usergroupids as $i) {
			if (in_array($i, $vk)) $links_permissions[$k] = 1;
		}
	}

	$ldm_linkbitcache = cache_LDMbits($cache_catid, "define_linkbit");
	$ldm_catbitcache  = cache_LDMbits($cache_catid, "define_catbit");

	$stylecache = array();
	$catstyle = 1;

	($hook = vBulletinHook::fetch_hook('ldm_cache_built')) ? eval($hook) : false;

	$LDM_environment = array();

	$LDM_environment['allow_url_fopen']		= ini_get('allow_url_fopen');
	$LDM_environment['curl_available']		= (function_exists('curl_init') & !$links_defaults['force_fopen']);
	$LDM_environment['gd2_available']		= function_exists('imagecreatefromstring');
	$LDM_environment['post_max_size']		= ini_get('post_max_size');
	$LDM_environment['upload_max_filesize'] = ini_get('upload_max_filesize');

	$LDM_environment['user_os'] = "Unknown";
	if (strstr($_SERVER['HTTP_USER_AGENT'],"Windows")!==FALSE) {
		$LDM_environment['user_os'] = "Windows";
	}
	elseif (strstr($_SERVER['HTTP_USER_AGENT'],"Mac")!==FALSE) {
		$LDM_environment['user_os'] = "Mac";
	}
	elseif (strstr($_SERVER['HTTP_USER_AGENT'],"Linux")!==FALSE) {
		$LDM_environment['user_os'] = "Linux";
	}

	$LDM_environment['open_basedir'] = trim(
		str_replace(PATH_SEPARATOR, PATH_SEPARATOR." ", 
			str_replace(DIRECTORY_SEPARATOR, "/", ini_get('open_basedir'))
			)
		);
	if (strtolower($LDM_environment['open_basedir'])=="none") {
		$LDM_environment['open_basedir'] = "";
	}

	$LDM_environment['HOST'] = "zzz-unknown";
	$site = parse_url($vbulletin->options['homeurl']);
	if (isset($site['host'])) {
		$LDM_environment['HOST'] = "http://".$site['host'];
	}

	$LDM_admins = ADMIN_USER_GROUP;
	$LDM_environment['is_admin'] = 0;
	if ($LDM_admins) {
		$LDM_admins = explode(',', $LDM_admins);
		foreach ($LDM_admins AS $k_admin) {
			if ($k_admin and is_member_of($vbulletin->userinfo, $k_admin)) {
				$LDM_environment['is_admin'] = 1;
				break;
			}
		}
	}

	if (!forumid_is_valid($links_defaults["default_forumid"])) {
		if ($LDM_environment['is_admin']) {
			$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linksadmin
					SET setting = ".$DEFAULT_FORUMID."
					WHERE settingname='default_forumid'
					LIMIT 1
				");
			eval(standard_error($vbphrase['ll_admin_critical_forum']));
			exit;
		}
		else {
			eval(standard_error($vbphrase['ll_error_critical_forum'].'<br />'.
					$vbphrase['ll_error_cannotcontinue']));
			exit;
		}
	}

	$LDM_environment['thumb_types'] = array("jpg", "jpeg", "gif", "png", "mp3");
	$LDM_environment['lfd_version'] = THIS_VERSION;

// Admin group always has admin permissions to prevent getting locked out
	if ($LDM_environment['is_admin']) {
		$links_permissions['can_admin_links'] = 1;
	}

// Moderator privileges can also be picked up from VB forums
	$links_permissions["can_moderate_forums"] = can_moderate(0, 'canmoderateposts');

	$ldm_mysearch = array();
	make_myprofilesearch($ldm_mysearch, $links_defaults["profile_searchfield"]);

	$ldm_mimetype_cache = array();
	$links_fav = array();
	$ldm_icon_cache = array();
	$child = array();
	$holdcat = array();
	$holdsort = 0;

// Required for vbAdvanced
	if (!in_array('local_links', $phrasegroups)) {
		require_once(DIR . '/includes/functions_databuild.php');
		fetch_phrase_group('local_links');
	}

// HTTP codes
	$HTTP_CODES = array(
	"0"=>"Unknown",
	"100"=>"Continue",
	"101"=>"Switching Protocols",
	"200"=>"OK",
	"201"=>"Created",
	"202"=>"Accepted",
	"203"=>"Non-Authoritative Information",
	"204"=>"No Content",
	"205"=>"Reset Content",
	"206"=>"Partial Content",
	"300"=>"Multiple Choices",
	"301"=>"Moved Permanently",
	"302"=>"Found Temporarily",
	"303"=>"See Other",
	"304"=>"Not Modified",
	"305"=>"Use Proxy",
	"307"=>"Temporary Redirect",
	"400"=>"Bad Request",
	"401"=>"Unauthorized",
	"402"=>"Payment Required",
	"404"=>"Not Found",
	"405"=>"Method Not Allowed",
	"406"=>"Not Acceptable",
	"407"=>"Proxy Authentication Required",
	"408"=>"Request Timeout",
	"409"=>"Conflict",
	"410"=>"Gone",
	"411"=>"Length Required",
	"412"=>"Precondition Failed",
	"413"=>"Request Entity Too Large",
	"414"=>"Request-URI Too Long",
	"415"=>"Unsupported Media Type",
	"416"=>"Requested Range Not Satisfiable",
	"417"=>"Expectation Failed",
	"500"=>"Internal Server Error",
	"502"=>"Bad Gateway",
	"503"=>"Service Unavailable",
	"504"=>"Gateway Timeout",
	"505"=>"HTTP Version Not Supported",
	);

}

/* ======== Failure/debugging =======================================*/

function ldm_debug($text, $values) {
	global $links_defaults;
	if ($links_defaults['DEBUG']) {
		ldm_savedebug('DEBUG:'.$text, $_SERVER["PHP_SELF"], $values);
	}
}

function ldm_trace() {
	global $vbulletin, $links_defaults;
	if ($links_defaults['TRACE']) {
		ldm_savedebug('TRACE', $_SERVER["PHP_SELF"], $links_defaults);
	}
}

function ldm_savedebug($string, $command, $settings) {
	global $vbulletin;

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linksdebug
		SET
			userid='".$vbulletin->userinfo['userid']."',
			settingtime='".TIMENOW."',
			message='".$vbulletin->db->escape_string($string)."',
			command='".$vbulletin->db->escape_string($command)."',
			settings='".$vbulletin->db->escape_string(serialize($settings))."',
			get='".$vbulletin->db->escape_string(serialize($_GET))."',
			post='".$vbulletin->db->escape_string(serialize($_POST))."',
			files='".$vbulletin->db->escape_string(serialize($_FILES))."',
			cookie='".$vbulletin->db->escape_string(serialize($_COOKIE))."'
	");

	$week = TIMENOW-3600*24*7;
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksdebug
		WHERE settingtime<'".$week."'
	");

}

function ldm_general_failure($why) {
	for ($k=1; $k<40; $k++) echo '=';
	echo "<br />Unexpected critical failure<br />";
	echo $why.'<br />';
	for ($k=1; $k<40; $k++) echo '=';
	exit;
}

function ldmjump_access_error() {
	global $vbulletin, $show, $stylevar, $master_title;
	global $header, $footer, $headinclude, $vbphrase, $vboptions, $stylevar, $pmbox;
	global $links_permissions, $links_defaults, $LDM_environment;

	$usergroupid = $vbulletin->userinfo['usergroupid'];

	$this_navigation_title = $master_title;
	construct_forum_jump();
	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_access_error')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ======== Cache Functions ==================================================*/

function cache_LDMadmintable() {
	global $master_settings, $vbulletin;

	if (!isset($master_settings)) {
		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksadmin
			ORDER BY sequence
		");
		while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
			$master_settings[$admin_settings["settingname"]][$admin_settings["catid"]] = $admin_settings;
		}
		$vbulletin->db->free_result($asb);
	}

}

function cache_LDMsettings($catid) {
	global $vbulletin, $linkscat, $master_settings;

	cache_LDMadmintable();

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if (
					$this_set[$c_catid]["rowtype"]!="usergroup_check" and
					$this_set[$c_catid]["rowtype"]!="define_linkbit" and
					$this_set[$c_catid]["rowtype"]!="define_mediaplayer"
					) {
					$values[$this_set[$c_catid]["settingname"]] = $this_set[$c_catid]["setting"];
					break;
				}
			}
		}
	}
	unset($this_set, $cat_choice, $c_catid);
	return $values;

}

function cache_LDMpermissions($catid) {
	global $vbulletin, $linkscat, $master_settings;

	cache_LDMadmintable();

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if (
					$this_set[$c_catid]["rowtype"] == "usergroup_check"
					) {
					$values[$this_set[$c_catid]["settingname"]] = $this_set[$c_catid]["setting"];
					break;
				}
			}
		}
	}
	unset($this_set, $cat_choice, $c_catid);
	return $values;

}

function cache_LDMbits($catid, $rowtype) {
	global $vbulletin, $linkscat, $master_settings;

	cache_LDMadmintable();

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if ($this_set[$c_catid]["rowtype"]==$rowtype) {
					$values[$this_set[$c_catid]["settingname"]] = unserialize($this_set[$c_catid]["setting"]);
					break;
				}
			}
		}
	}

	unset($this_set, $cat_choice, $c_catid);
	return $values;

}

function get_linkscat() {
	global $vbulletin, $linkscat, $LDM_environment, $BASE_CAT, $vbphrase;

	$linkscat = array();
	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkscat
		ORDER BY displayorder, catname
		");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$linkscat[$myrow["catid"]] = $myrow;
	}
	$vbulletin->db->free_result($asb);

// Build the counts
	$mustfix = 0;
	foreach ($linkscat as $catid => $thiscat) {

		$linkscat[$catid]['childlinks'] = $thiscat['catentry'];
		$linkscat[$catid]['childcats'] = 0;
		$linkscat[$catid]['catsub'] = 0;
		$linkscat[$catid]['catname_clean'] = htmlspecialchars_uni(kill_bbcodes($linkscat[$catid]['catname']));

// Sanity check on the category hierarchy just in case
		if ($linkscat[$catid]['parentid'] == $BASE_CAT
			and $linkscat[$catid]['parentlist'] == $BASE_CAT
			) continue;
		if ($linkscat[$catid]['parentid'] > 0
			and isset($linkscat[$linkscat[$catid]['parentid']]['catid'])
			and in_array($BASE_CAT, explode(',', $linkscat[$catid]['parentlist']))
			) continue;

		$mustfix += 1;
	}

	if ($mustfix) {
		if ($LDM_environment['is_admin']) {
			fix_cat_parentlist();
			eval(standard_error($vbphrase['ll_admin_critical_cat']));
		}
		else {
			eval(standard_error($vbphrase['ll_error_critical_cat'].'<br />'.
					$vbphrase['ll_error_cannotcontinue']));
		}
		exit;
	}

	foreach ($linkscat as $thiscatid=>$thiscat) {
		$parents = explode(',', $thiscat['parentlist']);
		foreach ($parents as $p) {
			if (isset($linkscat[$p])) {
				$linkscat[$p]['childlinks'] += $thiscat['catentry'];
				$linkscat[$p]['childcats'] += 1;
			}
		}
		if (isset($linkscat[$thiscat['parentid']])) {
			$linkscat[$thiscat['parentid']]['catsub'] += 1;
		}
	}
}

function cache_mimetype() {
	global $ldm_mimetype_cache, $vbulletin;
	static $ldm_mimetype_cache_set = 0;

	if (!$ldm_mimetype_cache_set) {
		$jumpmime = $vbulletin->db->query_read("
			SELECT extension, mimetype, size, thumbnail
			FROM " . TABLE_PREFIX . "attachmenttype AS attachmenttype
			ORDER BY extension
			");
		while ($jump=$vbulletin->db->fetch_array($jumpmime)) {
			$ldm_mimetype_cache[$jump['extension']]['mimetype'] = unserialize($jump['mimetype']);
			$ldm_mimetype_cache[$jump['extension']]['size'] = $jump['size'];
			$ldm_mimetype_cache[$jump['extension']]['thumbnail'] = $jump['thumbnail'];
		}
		$ldm_mimetype_cache_set = 1;
		$vbulletin->db->free_result($jumpmime);
	}

}

function cache_LDMusergroup() {
	global $ldm_usergroup_cache, $vbulletin;
	static $ldm_usergroup_cache_set = 0;

	if (!$ldm_usergroup_cache_set) {
		$asb = $vbulletin->db->query_read("
			SELECT usergroupid, title
			FROM " . TABLE_PREFIX . "usergroup
		");
		while ($row = $vbulletin->db->fetch_array($asb)) {
			$ldm_usergroup_cache[$row['usergroupid']] = $row['title'];
		}
		$ldm_usergroup_cache_set = 1;
		$vbulletin->db->free_result($jumpmime);
	}

}

function get_linksfav() {
	global $vbulletin, $links_fav;
	static $links_fav_set = 0;

	if (!$links_fav_set) {
		$asb = $vbulletin->db->query_read("
			SELECT linkid
			FROM ".THIS_TABLE."linksfavs
			WHERE userid='".$vbulletin->userinfo['userid']."'
		");
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$links_fav[$myrow['linkid']] = 1;
		}
		$links_fav_set = 1;
		$vbulletin->db->free_result($asb);
	}
}

function get_icons() {
	global $links_defaults, $ldm_icon_cache;
	static $ldm_icon_cache_set = 0;
	if (!$ldm_icon_cache_set and $links_defaults["file_icons_dir"]!="") {
		if ($handle = @opendir($links_defaults["file_icons_dir"])) {
		    while (false !== ($file = readdir($handle))) {
		        if (preg_match("/(.*?).(gif|png|jpg)$/", $file, $matches)) {
		            $ldm_icon_cache[$matches[1]] = mk_file_name($links_defaults["file_icons_dir"],$file);
		        }
		    }
		    closedir($handle);
		}
		$ldm_icon_cache_set = 1;
	}

}

/* ======== End of Cache Functions =============================================*/

function ldm_date($format, $timestamp) {
	global $vbulletin;
	if ($format==$vbulletin->options['dateformat'] or $format==$vbulletin->options['timeformat']) {
		return vbdate($format, $timestamp);
	}
	else {
		return vbdate($format, $timestamp, false, false);
	}
}

function lookup_setting($catid, $settingname) {
	global $master_settings, $linkscat;

	$cat_list = isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : '-1';
	$cat_list = $catid . ',' . $cat_list;
	$cat_choice = explode(',', $cat_list);
	if (isset($master_settings[$settingname])) {
		foreach ($cat_choice as $c_catid) {
			if (isset($master_settings[$settingname][$c_catid])) {
				return($master_settings[$settingname][$c_catid]["setting"]);
			}
		}
	}
	ldm_general_failure('lookup_setting('.$catid.','.$settingname.')');
}

function lookup_permission($catid, $settingname) {
	global $master_settings, $linkscat, $vbulletin, $usergroupids;

	$cat_choice = explode(',', $catid.','.iif(isset($linkscat[$catid]['parentlist']), $linkscat[$catid]['parentlist'], "-1"));
	if (isset($master_settings[$settingname])) {
		foreach ($cat_choice as $c_catid) {
			if (isset($master_settings[$settingname][$c_catid])) {
				$sets = explode(',', $master_settings[$settingname][$c_catid]["setting"]);
				foreach ($usergroupids as $i) {
					if (in_array($i, $sets)) return 1;
				}
			}
		}
		return 0;
	}
	ldm_general_failure('lookup_setting('.$catid.','.$settingname.')');
}

function get_mimetype($type) {
	global $ldm_mimetype_cache;
	$ltype = strtolower($type);
	cache_mimetype();
	if (strlen($type) <= 1) {
		$mimetype = '';
	}
	elseif (isset($ldm_mimetype_cache[$type])) {
		$mimetype = $ldm_mimetype_cache[$type]['mimetype'];
	}
	elseif (isset($ldm_mimetype_cache[$ltype])) {
		$mimetype = $ldm_mimetype_cache[$ltype]['mimetype'];
	}
	else {
		$mimetype = '';
	}
	return $mimetype;
}

function make_myprofilesearch(&$ldm_mysearch, $profile_searchfield) {
	global $vbulletin, $vbphrase;

	$ldm_mysearch = array();
	$keywords = array();
	$counts = array();
	$nsearch = 0;

	if (!$profile_searchfield or trim($profile_searchfield)=='-1') {
		return;
	}

	$fields = explode(',', $profile_searchfield);
	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."profilefield
	");

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if (in_array($myrow['profilefieldid'], $fields)) {

			$field = $vbulletin->userinfo['field'.$myrow['profilefieldid']];
			switch ($myrow['type']) {

			case 'input':
			case 'textarea':
				$choices = explode(' ', preg_replace("/[\W\"']+/"," ",html_entity_decode($field)));
				foreach ($choices as $k=>$c) {
					if ($c) {
						$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
						$ldm_mysearch[$nsearch]['profilefieldtitle'] = $myrow['title'];
						$ldm_mysearch[$nsearch]['text'] = $c;
						$ldm_mysearch[$nsearch]['title'] =
							iif(strlen($ldm_mysearch[$nsearch]['text'])>15,
								substr($ldm_mysearch[$nsearch]['text'],0, 12).'...',
								$ldm_mysearch[$nsearch]['text']);
						$keywords[] = $ldm_mysearch[$nsearch]['text'];
						$nsearch++;
					}
				}
				break;

			case 'radio':
			case 'select':

				$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
				$ldm_mysearch[$nsearch]['profilefieldtitle'] = $myrow['title'];
				$ldm_mysearch[$nsearch]['text'] = preg_replace("/[\W\"']+/"," ",html_entity_decode($field));
				$ldm_mysearch[$nsearch]['title'] =
					iif(strlen($ldm_mysearch[$nsearch]['text'])>15,
						substr($ldm_mysearch[$nsearch]['text'],0, 12).'...',
						$ldm_mysearch[$nsearch]['text']);
				$keywords[] = $ldm_mysearch[$nsearch]['text'];
				$nsearch++;
				break;

			case 'select_multiple':
			case 'checkbox':

				$mask = $vbulletin->userinfo['field'.$myrow['profilefieldid']];
				$choices = unserialize($myrow['data']);
				foreach ($choices as $k=>$c) {
					$pow = pow(2,$k);
					if ($mask & $pow) {
						$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
						$ldm_mysearch[$nsearch]['profilefieldtitle'] = $myrow['title'];
						$ldm_mysearch[$nsearch]['text'] = preg_replace("/[\W\"']+/"," ",html_entity_decode($c));
						$ldm_mysearch[$nsearch]['title'] =
							iif(strlen($ldm_mysearch[$nsearch]['text'])>15,
								substr($ldm_mysearch[$nsearch]['text'],0, 12).'...',
								$ldm_mysearch[$nsearch]['text']);
						$keywords[] = $ldm_mysearch[$nsearch]['text'];
						$nsearch++;
					}
				}
				break;

			}
		}
	}
	$vbulletin->db->free_result($asb);

	if (count($keywords)) {
		foreach ($keywords as $k) {
			$count[$k] = 0;
		}
		$fields = implode("','", $keywords);
		$query = "
			SELECT lkeys.keyword AS keyword
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON ltok.linkid=link.linkid
			WHERE lkeys.keyword IN ('".$fields."')
			AND link.linkdate>".$vbulletin->userinfo['lastvisit']."
			";
		$asb = $vbulletin->db->query_read($query);
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			$count[$rec['keyword']]+=1;
		}
		$vbulletin->db->free_result($asb);
	}

	if (count($ldm_mysearch)) {
		$menu = '<tr><td class="thead" colspan="2">'.$vbphrase['ll_menu_mysearch'].'</td></tr>';
		foreach ($ldm_mysearch as $k=>$s) {
			$menu .= '<tr><td class="vbmenu_option" width="5"><a href="profile.php?do=editprofile" title="'.
				$vbphrase['edit_profile'].'" target="_blank">*</a></td><td class="vbmenu_option">';
			if ($s['text']) {
				$menu .= '<a href="'.SEARCH_SCRIPT.'.php?action=show&amp;mysearch='.$k.'" title="'.
					$count[$s['text']].' '.$vbphrase['ll_sincelastvisit'].'">'.$s['title'].'</a>';
			}
			else {
				$menu .= $s['profilefieldtitle'].' '.$vbphrase['ll_unset'];
			}
			$menu .= '</td></tr>';
		}
		$ldm_mysearch['menu'] = $menu;
	}
}

function parse_me($string) {
	global $links_defaults, $vbulletin;

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$result = $string;
	if ($links_defaults['apply_censor']) {
		$result = fetch_censored_text($result);
	}

	$saved = $vbulletin->registry->options['word_wrap'];
	$vbulletin->options['wordwrap'] = $links_defaults['word_wrap'];
	$result = $bbcode_parser->do_parse(
		$result,
		$links_defaults['allow_html'],
		$links_defaults['allow_smilies'],
		$links_defaults['allow_bbcode'],
		$links_defaults['allow_images']
		);
	$vbulletin->options['wordwrap'] = $saved;

// unfix any line breaks;
	$result = str_replace("&lt;br /&gt;", "<br />", $result);
	return $result;

}

function construct_category_item($thisparent, $prepend, $cat_selected, $linkscat, $template, $list_name, $list_id, $secure, $with_closed) {
	global $links_permissions, $links_defaults, $limitfids, $child, $limitcats, $stylevar, $vbphrase;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$optbit = "";
	$select_stage = 2;

	if (isset($child["$thisparent"])) {
		$thesechildren = $child["$thisparent"];
		foreach ($thesechildren as $c) {
			$myrow = $linkscat[$c];

			$catid	= $myrow["catid"];
			if ($secure and in_array($linkscat[$catid]["catforum"]	, $limitfids)) {
				continue;
			}
			$catname  = $prepend." ".$myrow["catname_clean"];
			$catsel = iif (in_array($catid, $cat_selected), 1, 0);
			$catclosed = $linkscat[$catid]["catclosed"];
			$disabled = iif($catclosed and !$with_closed and !$links_permissions["can_admin_links"],1,0);
			if (!in_array($catid, $limitcats)) {
				eval("\$optbit .= \"".fetch_template($template)."\";");
			}
			$optbit .= construct_category_item($catid, $prepend."-", $cat_selected, $linkscat, $template, $list_name, $list_id, $secure, $with_closed);
		}
	}
	return $optbit;
}

function construct_category_list($cat_selected, $template, $allow_none, $list_name, $list_id, $secure=0, $with_permission="", $with_closed=1) {
	global $vbulletin, $linkscat, $vbphrase;
	global $links_permissions, $links_defaults;
	global $limitfids, $child, $limitcats, $stylevar, $vbphrase;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	if ($secure) {
		if (!isset($limitfids)) {
			$can_bypass = $links_permissions['can_bypass_forumperms'];
			$limitfids = lookup_ldm_forum_protections($can_bypass);
		}
	}
	$limitcats = array(-1);
	if ($with_permission) {
		foreach ($linkscat as $k=>$thiscat) {
			if (!lookup_permission($thiscat['catid'], $with_permission)) {
				$limitcats[] = $thiscat['catid'];
			}
		}
	}

	$child = array();
	foreach ($linkscat as $k=>$thiscat) {
		$child[$linkscat[$k]['parentid']][] = $k;
	}

	$catsel = iif (in_array(0, $cat_selected), 1, 0);
	$select_stage = 1;
	eval("\$optbit = \"".fetch_template($template)."\";");
	if ($allow_none) {
		$catname = $vbphrase['ll_none'];
		$catid = "-1";
		$catsel = iif (in_array($catid, $cat_selected), 1, 0);
		$select_stage = 2;
		eval("\$optbit .= \"".fetch_template($template)."\";");
	}
	$optbit .= construct_category_item(-1, "", $cat_selected, $linkscat, $template, $list_name, $list_id, $secure, $with_closed);
	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template($template)."\";");

	return $optbit;
}

function construct_parent_list($pcatid) {
	global $linkscat;
	$pbit = "";
	foreach ($pcatid as $thiscat) {
		if (isset($linkscat[$thiscat])) {
			if ($pbit <> "") $pbit .= ", ";
			$pbit .= $linkscat[$thiscat]["catname_clean"];
		}
	}
	if ($pbit == "") $pbit = "None";
	return $pbit;
}

function build_cat_parentlist($catid) {
	global $vbulletin, $linkscat, $BASE_CAT, $vbphrase;

	if ($catid == $BASE_CAT) {
		foreach ($linkscat as $thisid=>$cat) {
			$linkscat[$thisid]['parentlist'] = "";
		}
	}

	$ids = array_keys($linkscat);
	foreach ($ids as $thisid) {
		if ($linkscat[$thisid]['parentid'] == $catid) {
			if ($linkscat[$thisid]['parentlist'] != "") {
				eval(standard_error($vbphrase['ll_error_recursive_cat'].'<br />'.
				$vbphrase['ll_error_cannotcontinue']));
				exit;
			}
			if ($catid == $BASE_CAT) {
				$linkscat[$thisid]['parentlist'] = $catid;
			}
			else {
				$linkscat[$thisid]['parentlist'] = $catid.",".$linkscat[$catid]['parentlist'];
			}
			build_cat_parentlist($thisid);
		}
	}

// Look for orphans
	if ($catid == $BASE_CAT) {
		foreach ($linkscat as $thisid=>$cat) {
			if ($linkscat[$thisid]['parentlist'] == "") {
				$linkscat[$thisid]['parentlist'] == $BASE_CAT;
			}
		}
	}

}

// Fix parents and parentlists if necessary

function fix_cat_parentlist() {
	global $vbulletin, $linkscat, $BASE_CAT;
	$tmpcat = array();
	foreach ($linkscat as $thisid=>$cat) {
		$tmpcat[$thisid] = $linkscat[$thisid];
		if ($linkscat[$thisid]['parentid'] == $BASE_CAT
			and $linkscat[$thisid]['parentlist'] == $BASE_CAT) continue;
		if ($linkscat[$thisid]['parentid'] > 0
			and isset($linkscat[$linkscat[$thisid]['parentid']]['catid'])
			and in_array($BASE_CAT, explode(',', $linkscat[$thisid]['parentlist']))
			) continue;
		$linkscat[$thisid]['parentid'] = $BASE_CAT; // Parentage is corrupt - re-root at the base of the tree

	}
	build_cat_parentlist($BASE_CAT);
	foreach ($linkscat as $thisid=>$cat) {
		if ($linkscat[$thisid]['parentlist'] != $tmpcat[$thisid]['parentlist']
			or $linkscat[$thisid]['parentid'] != $tmpcat[$thisid]['parentid']) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET parentid = ".$linkscat[$thisid]['parentid'].",
				    parentlist='".$linkscat[$thisid]['parentlist']."'
				WHERE catid='$thisid'
				LIMIT 1
			");
		}
	}
}

// Fix the category counts and dates
function fix_cat_count() {
	global $vbulletin, $linkscat;

	$catcount = array();
	$catdate = array();
	foreach ($linkscat as $catid => $cat) {
		$catcount[$catid] = 0;
		$catdate[$catid] = 0;
	}
	$asb = $vbulletin->db->query_read("
		SELECT ltoc.catid AS catid, link.linkdate AS linkdate
		FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
	");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if (!isset($catdate[$myrow['catid']])) {
			$catcount[$myrow['catid']] = 1;
			$catdate[$myrow['catid']] = $myrow['linkdate'];
		}
		else {
			$catcount[$myrow['catid']] +=1;
			$catdate[$myrow['catid']] = max($catdate[$myrow['catid']], $myrow['linkdate']);
		}
	}
	$vbulletin->db->free_result($asb);
	foreach ($catcount as $catid => $count) {
		if (isset($linkscat[$catid])) {
			if ($linkscat[$catid]['catentry'] != $count or $linkscat[$catid]['catdate'] != $catdate[$catid]) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linkscat
					SET catentry=".$count.", catdate=".$catdate[$catid]."
					WHERE catid='$catid'
					LIMIT 1
				");
				$linkscat[$catid]['catentry'] = $count;
				$linkscat[$catid]['catdate'] = $catdate[$catid];
			}
		}
	}
}

function catcmp($a, $b) {
	global $holdsort, $holdcat;

// Display order always over-rides the rest
	if ($holdcat[$a]['displayorder'] < $holdcat[$b]['displayorder']) return(-1);
	if ($holdcat[$a]['displayorder'] > $holdcat[$b]['displayorder']) return( 1);

	switch ($holdsort) {
	case 'd':
		if ($holdcat[$a]['catdate'] == $holdcat[$b]['catdate']) return(0);
		if ($holdcat[$a]['catdate'] <  $holdcat[$b]['catdate']) return(1);
		return(-1);

	case 'D':
		if ($holdcat[$a]['catdate'] == $holdcat[$b]['catdate']) return(0);
		if ($holdcat[$a]['catdate'] >  $holdcat[$b]['catdate']) return(1);
		return(-1);

	case 'n':
		if ($holdcat[$a]['catname'] == $holdcat[$b]['catname']) return(0);
		if ($holdcat[$a]['catname'] <  $holdcat[$b]['catname']) return(1);
		return(-1);

	default:
		if ($holdcat[$a]['catname'] == $holdcat[$b]['catname']) return(0);
		if ($holdcat[$a]['catname'] >  $holdcat[$b]['catname']) return(1);
		return(-1);
	}

}

function cat_walk($level, $dig, $sort='') {
	global $linkscat, $links_defaults;
	global $holdcat, $holdsort;
	static $holdcat_set = 0;

	if (!$holdcat_set) {
		$holdsort = iif ($sort=="", iif(isset($links_defaults['default_sort_order']), $links_defaults['default_sort_order'], 'N'), $sort);
		$holdcat = $linkscat;
		uksort($holdcat, "catcmp");
		$holdcat_set = 1;
	}

	$tree = array();
	if ($dig) {
		$keys = array_keys($holdcat);
		foreach ($keys as $thiskey) {
			$thiscat = $holdcat[$thiskey];
			if ($thiscat['parentid'] == $level) {
				$tree[$thiscat['catid']] = cat_walk($thiscat['catid'], $dig-1, $sort);
			}
		}
	}

	return $tree;
}

// Taken from includes/adminfunctions_template.php as 'including' file conflicts with other hacks
function cache_styles($getids = false, $styleid = -1, $depth = 0)
{
	global $vbulletin, $stylecache, $count;
	static $i, $cache;

	// check to see if we have already got the results from the database
	if (empty($cache)) {
		$styles = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "style
			ORDER BY displayorder
			");
		define('STYLECOUNT', $vbulletin->db->num_rows($styles));
		while ($style = $vbulletin->db->fetch_array($styles)) {
			$cache["$style[parentid]"]["$style[displayorder]"]["$style[styleid]"] = $style;
		}
		$vbulletin->db->free_result($styles);
	}

	// database has already been queried
	if (isset($cache["$styleid"])) {
		foreach ($cache["$styleid"] AS $holder) {
			foreach ($holder AS $style) {
				$stylecache["$style[styleid]"] = $style;
				$stylecache["$style[styleid]"]['depth'] = $depth;
				cache_styles($getids, $style['styleid'], $depth + 1);

			}
		}
	}

}

function construct_style_list($style_selected, $list_id) {
	global $vbphrase, $links_defaults, $stylecache, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	cache_styles();

	$stylewidth = "width:300px";
	$selectsubmit = 0;
	$stylesize = 3;

	$select_stage = 1;
	$label = $vbphrase['ll_stylelabel'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");
	$stylename = $vbphrase['ll_usedefaultsetting'];
	$styleid = "-1";
	$stylesel = iif ($styleid==$style_selected, 1, 0);

	$select_stage = 2;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	foreach ($stylecache as $style) {
		$styleid	= $style["styleid"];
		$stylename  = "-- ".htmlspecialchars_uni($style["title"]);
		$stylesel = iif ($styleid==$style_selected, 1, 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	return $optbit;
}

function construct_keyword_list($list_id, $catid=0, $keyid_selected=0) {
	global $vbulletin, $vbphrase, $stylevar;

	$select_stage = 1;
	$stylewidth = "width:200px";
	$stylesize = "1";
	$selectsubmit = 1;
	$nkeys = 0;
	$label = $vbphrase['ll_keywords'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");

	$select_stage = 2;
	if (!$catid) {
		$asb = $vbulletin->db->query_read("
			SELECT keyid, keyword
			FROM ". THIS_TABLE . "linkskeys
			ORDER BY keyword
		");
	}
	else {
		$asb = $vbulletin->db->query_read("
			SELECT DISTINCT lkeys.keyid AS keyid, lkeys.keyword AS keyword
			FROM ". THIS_TABLE . "linkskeys AS lkeys
			LEFT JOIN ". THIS_TABLE . "linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ". THIS_TABLE . "linksltoc AS ltoc
			ON ltok.linkid = ltoc.linkid
			WHERE ltoc.catid = ".$catid."
			ORDER BY keyword
		");
	}
	$styleid = 0;
	$stylename = $vbphrase['ll_none'];
	$stylesel = iif($keyid_selected, 0, 1);
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$nkeys += 1;
		$styleid = $row['keyid'];
		$stylename = $row['keyword'];
		$stylesel = iif($styleid==$keyid_selected, 1, 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}
	$vbulletin->db->free_result($asb);

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	if (!$nkeys) $optbit = "";
	return $optbit;

}

function make_hidden_vars($vararray) {
	$vars = "";
	foreach ($vararray as $k=>$v) {
		$vars .= '<input type="hidden" name="'.$k.'" value="'.$v.'" />';
	}
	return $vars;
}

/* ======== URL/File utilities =================================================*/

// Convert a set of strings into a file path, checking on directory separators
function mk_file_name() {
	$arg = func_get_args();
	$res = "";
	foreach ($arg as $a) {
		if (!$res) {
			$res = $a;
		}
		elseif (substr($res,-1,1) != '/') {
			$res .= iif(substr($a,0,1)=='/', $a, '/'.$a);
		}
		else {
			$res .= iif(substr($a,0,1)=='/', substr($a,1,strlen($a)-1), $a);
		}
	}
	return $res;
}

/**
* Check whether directory is accessible within current open_basedir settings
*
* @param	str		Full path to target directory
* @return	int		1=success, 0=fail
*/

function ldm_can_openbasedir($fullpath) {
	global $LDM_environment;

	if (!$LDM_environment['open_basedir']) {
		return 1;
	}

	$ldir = str_replace(DIRECTORY_SEPARATOR, "/", trim($fullpath));
	foreach (explode(PATH_SEPARATOR, $LDM_environment['open_basedir']) as $thisdir) {
		$thisdir = trim($thisdir);
		if ($thisdir and preg_match("#^$thisdir#i", $ldir)) {
			return 1;
		}
	}

	return 0;
}

/**
* Check whether directory exists and is readable
*
* @param	str		Target directory
* @param	int		0/1, directory specified relative to server/filesystem
* @return	int		1=success, 0=fail
*/

function ldm_can_accessdir($dir, $use_file_root=1) {
	global $vbulletin, $LDM_environment;

	$ldir = trim($dir);

	if (!$use_file_root and $ldir{0} != "/") {
		$ldir = "./".$ldir;
		$ldir = realpath($ldir);
	}
	else {
		$ldir = local_filename($dir, $use_file_root);
	}

	if ($fp=@opendir($ldir)) {
		@closedir($fp);
		return 1;
	}

	return 0;
}

// Convert path into an absolute filename
function local_filename($path, $use_file_root=1, $new_local_file_root="###", $new_local_file_root_prefix="###") {
	global $links_defaults;
	$lpath = preg_replace("/(.*)\?.*/", "\\1", $path);
	$lfr	= ($new_local_file_root=="###" ? $links_defaults["local_file_root"] : $new_local_file_root);
	$lfrp	= ($new_local_file_root_prefix=="###" ? $links_defaults["local_file_root_prefix"] : $new_local_file_root_prefix);
	if ($use_file_root) {
		if ($lfr) {
			$lpath = mk_file_name($lfrp,$path);
			$return_path = realpath($lpath);
			if (!$return_path) $return_path = $lpath;
			$return_path = str_replace("\\","/",$return_path);
		}
		else {
			$return_path = mk_file_name(LDM_DOCUMENT_ROOT, $lfrp, $lpath);
		}
	}
	else {
		$return_path = mk_file_name(LDM_DOCUMENT_ROOT, $lpath);
	}
	ldm_debug("local_filename", array($path, $return_path));
	return($return_path);
}

// variant on parse_url, catching windows files that start x:
function ldm_parse_url($url) {
	$urlInfo = @parse_url($url);
	if (!is_array($urlInfo)) {
		$urlInfo = array();
		$urlInfo['path'] = $url;
	}
	elseif (array_key_exists('scheme', $urlInfo)) {
		if (preg_match("/^[a-z]$/", strtolower($urlInfo['scheme']))) {
			unset($urlInfo);
			$urlInfo['path'] = $url;
		}
	}
	return($urlInfo);
}

// Strip out username and password and place it in a curl option
function unglue_username_and_password($urlInfo, &$url, &$userpassword) {
	$userpassword = "";
	if ($urlInfo['user']) {
		$userpassword = $urlInfo['user'].($urlInfo['pass']? ':'.$urlInfo['pass'] : '');
		$url  = $urlInfo['scheme'] ? $urlInfo['scheme'].'://' : '';
		$url .= $urlInfo['host'] ? $urlInfo['host'] : '';
		$url .= $urlInfo['port'] ? ':'.$urlInfo['port'] : '';
		$url .= $urlInfo['path'] ? $urlInfo['path'] : '';
		$url .= $urlInfo['query'] ? '?'.$urlInfo['query'] : '';
		$url .= $urlInfo['fragment'] ? '#'.$urlInfo['fragment'] : '';
	}
}

// Set linkimg to linkurl if appropriate
function set_autoimage($linkurl, &$linkimg) {
	global $links_defaults, $LDM_environment, $LINK_OK;

//	if ($links_defaults['link_imagesize']<=0) {
//		return;
//	}

	$urlInfo = ldm_parse_url($linkurl);
	if ($urlInfo['host'] and !$links_defaults['allow_remote_downloads']) {
		return;
	}

	($hook = vBulletinHook::fetch_hook('ldm_link_autoimage')) ? eval($hook) : false;

	if ($linkimg) {
		return;
	}

	$file_type = strtolower(substr(strrchr(basename($urlInfo['path']), "."), 1));
	if (in_array($file_type, $LDM_environment['thumb_types'])) {
		$linkimg = $linkurl;
		return;
	}

}

// Tidy up a (potentially local/relative) url so that we can use it within an fopen()
function cleanto_fopen($url) {
	global $protocol_schemes, $links_defaults;
	$URLInfo = ldm_parse_url($url);
	if (!$URLInfo['scheme'] and !$URLInfo['host']) {
		$url_clean = local_filename($url);
	} elseif (array_key_exists($URLInfo['scheme'], $protocol_schemes)) {
		$url_clean = preg_replace("/ *$/","",$URLInfo['path']);
		$url_clean = $URLInfo['scheme'].'://'.
			iif($URLInfo['user'], $URLInfo['user'].iif($URLInfo['pass'], ':'.$URLInfo['pass'], '').'@', '').
			$URLInfo['host'].
			preg_replace("/ /","%20",$url_clean);
	}
	else {
		$url_clean = $url;
	}

	ldm_debug("cleanto_fopen", array($url, $url_clean));
	return $url_clean;
}

/**
* Return list of potential mirror sites for url
*
* @param	str		URL to test
* @param	array	Download mirror data structure, normally obtained by unserializing links_defaults['download_mirrors']
* @return	array	Array of mirrors with current response codes
*/

function ldm_mirrors($url, $download_mirrors) {
	global $vbulletin, $links_defaults, $HTTP_CODES;

	$mirrors = array();

	($hook = vBulletinHook::fetch_hook('ldm_precheck_mirrors')) ? eval($hook) : false;

	foreach ($download_mirrors as $this_mirror) {
		if (!$this_mirror['active']) {
			continue;
		}
		$this_find = preg_replace("/#/", "//#", $this_mirror['find']);
		if (preg_match('#^'.$this_find.'#i', $url)) {
			$this_site = preg_replace('#^'.$this_find.'#i', $this_mirror['replace'], $url);
			$this_status = 0;
			$header = ldm_fetch_headers($this_site);
			if ($header !== false) {
				$nmatches = preg_match_all("/HTTP.1.. (\d\d\d)/", $header, $matches);
				if ($nmatches) {  // find the last HTTP code
					$this_status = $matches[1][$nmatches-1];
				}
			}
			if ($this_status==0) {
				$this_alive = -1;
			}
			elseif ($this_status<400) {
				$this_alive = 1;
			}
			else {
				$this_alive = 0;
			}
			if (isset($HTTP_CODES[$this_status])) {
				$this_code = $HTTP_CODES[$this_status];
			}
			else {
				$this_code = $HTTP_CODES["0"];
			}
			$mirrors[] = array(
				'name' => $this_mirror['name'],
				'url' => $this_site,
				'status' => $this_status,
				'code' => $this_code,
				'alive' => $this_alive,
				);
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_postcheck_mirrors')) ? eval($hook) : false;

	return $mirrors;

}

/**
* Parse the $_SERVER superglobal, returning headers
*
* @return	array		header array [Key]=>value
*/

function ldm_parse_headers() {

	$headers = array();
	while (list($key, $value) = each ($_SERVER)) {
		if (strncmp($key, "HTTP_", 5) == 0) {
			$key = strtr(ucwords(strtolower(strtr(substr($key, 5), "_", " "))), " ", "-");
			$headers[$key] = $value;
		}
	}
	return $headers;
}

/**
* Visit url and attempt to fetch headers
*
* @param	str		url
* @return	str		header
*/

function ldm_fetch_headers($url) {
	global $LDM_environment;
	static $last_fetch;

	$headers = false;

	if (isset($last_fetch['url']) and $last_fetch['url']==$url) {
		$headers = $last_fetch['header'];
	}

	if ($LDM_environment['curl_available']) {
		$ch = @curl_init();
		if ($URLInfo['user']) {
			unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($ch, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		@curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($ch, CURLOPT_HEADER, true);
		@curl_setopt($ch, CURLOPT_NOBODY, true);
		@curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'HEAD');
		@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$headers = @curl_exec($ch);
		$error = @curl_error($ch);
		@curl_close($ch);
		$last_curl['url'] = $url;
		$last_curl['header'] = $headers;
	}

	return $headers;

}

// Status of url/file: update $url if scheme omitted and url found
function check_ldm_url(&$url) {
	global $LINK_BROKEN, $LINK_OK, $LINK_NO_ACCESS, $LINK_NO_REMOTE_DOWNLOADS;
	global $protocol_schemes, $links_defaults, $LDM_environment;

	$URLInfo = ldm_parse_url($url);
	unset($holdurl);

	if ($URLInfo['scheme']) {
		if (!array_key_exists($URLInfo['scheme'], $protocol_schemes)) {
			ldm_debug("check_ldm_url:LINK_NO_ACCESS:", $URLInfo);
			return $LINK_NO_ACCESS;
		}
		elseif ($protocol_schemes[$URLInfo['scheme']]["validate"]==0) {
			ldm_debug("check_ldm_url:no validate LINK_OK:", $URLInfo);
			return $LINK_OK;
		}
	}

	if (!$URLInfo['host']) {
		$url_clean = local_filename($url);
		$conn = @fopen($url_clean, "rb");
		if ($conn) {
			fclose($conn);
			ldm_debug("check_ldm_url:LINK_OK:", array($url, $url_clean));
			return $LINK_OK;
		}
	}

// check if this is a url with http:// omitted
	if (!$URLInfo['host']) {
		if (preg_match("/^[a-z0-9]+\.[a-z0-9]+\.*[a-z0-9]+/i", $url)) {
			$holdurl = $url;
			$url = "http://".$url;
			$URLInfo = ldm_parse_url($url);
		}
		else {
			ldm_debug("check_ldm_url:LINK_BROKEN:", array($url, $url_clean));
			return $LINK_BROKEN;
		}
	}

	$type = substr(strrchr(basename($URLInfo['path']), "."), 1);
	$mimetype = get_mimetype($type);
	if (is_array($mimetype) and !$links_defaults['allow_remote_downloads']) {
		ldm_debug("check_ldm_url:LINK_NO_REMOTE_DOWNLOADS:", $URLInfo);
		return $LINK_NO_REMOTE_DOWNLOADS;
	}

// can't check - assume ok so as not to kill everything
	if (!$LDM_environment['curl_available'] and !$LDM_environment['allow_url_fopen']) {
		if ($holdurl) {
			$url = $holdurl;
		}
		ldm_debug("no curl or fopen:$url:nocheck:returns LINK_OK:", $URLInfo);
		return $LINK_OK;
	}

	$header = ldm_fetch_headers($url);
	if ($header !== false) {
		if (preg_match("/HTTP.1.. 200/", $header)) {  // somewhere in the reply - may not be at the start if there is a 302 recursion
			return $LINK_OK;
		}
		else {
			ldm_debug("check_ldm_url:header:LINK_BROKEN:", array($url, $holdurl, $error));
			if ($holdurl) $url = $holdurl;  //restore
			return $LINK_BROKEN;
		}
	} else {
		ldm_debug("check_ldm_url:noheader:LINK_BROKEN:", array($url, $holdurl, $error));
	}

	if ($LDM_environment['allow_url_fopen']) {
		$url_clean = cleanto_fopen($url);
		$conn = @fopen($url_clean, "rb");
		if ($conn) {
			fclose($conn);
			ldm_debug("check_ldm_url:fopen:LINK_OK:", array($url, $url_clean));
			return $LINK_OK;
		}
		else {
			ldm_debug("check_ldm_url:fopen:LINK_BROKEN:", array($url, $holdurl, $error));
		}
	}

// everything failed, give up
	if ($holdurl) $url = $holdurl;
	ldm_debug("check_ldm_url:giving up:", array($url));
	return $LINK_BROKEN;

}

// Return filesize of url if pointing to a filetype other than .htm/.html
function size_url($url) {
	global $LDM_environment;

	$URLInfo = ldm_parse_url($url);

	if (!$URLInfo['path']) {
		return (0);
	}

	$type = strtolower(substr(strrchr($URLInfo['path'], "."), 1));
	if (strlen($type)<1 or $type=="html" or $type=="htm") {
		return 0;
	}

	if (!$URLInfo['scheme'] and !$URLInfo['host']) {
		$url_clean = local_filename($url);
		$conn = @fopen($url_clean, "rb");
		if (!$conn) {
			return(0);
		}
		else {
			$stat = @fstat($conn);
			fclose($conn);
			return(iif($stat[7]>0, $stat[7], 0));
		}
	}

	$header = ldm_fetch_headers($url);
	if ($header !== false) {
		$regex = '/Content-Length:\s([0-9].+?)\s/';
		$count = preg_match($regex, $header, $matches);
		return iif (isset($matches[1]), $matches[1], 0);
	}

	return(0);
}

function delete_upload($linkurl) {
	if ($linkurl) {
		$fullfile = local_filename($linkurl);
		@unlink($fullfile);
	}
}

function delete_thumb($thumb) {
	if ($thumb) {
		$fullfile = local_filename($thumb, 0);
		@unlink($fullfile);
	}
}

function decode_bytes($val) {

	if (!preg_match("/^\s*([\d\.]+)\s*([a-z]*)\s*$/", strtolower($val), $matches)) {
		return (-1);
	}

	$val = $matches[1];
	switch($matches[2]) {
	case 'g':
	case 'gb':
	case 'gbyte':
	case 'gbytes':
		$val *= 1024;
	case 'm':
	case 'mb':
	case 'mbyte':
	case 'mbytes':
		$val *= 1024;
	case 'k':
	case 'kb':
	case 'kbyte':
	case 'kbytes':
		$val *= 1024;
	case '':
		break;
	default:
		return (-1);
	}

	return round($val);
}

function encode_bytes($val) {
	$K1 = 1024; $M1 = 1024*$K1; $G1 = 1024*$M1;
	if ($val>9.5*$G1) {
		$res = round($val/$G1).'G';
	}
	elseif ($val>9.5*$M1) {
		$res = round($val/$M1).'M';
	}
	elseif ($val>9.5*$K1) {
		$res = round($val/$K1).'K';
	}
	else {
		$res = $val;
	}
	return $res;
}

function format_bytes($val, $decimal=2) {
	global $vbphrase;
	$K1 = 1024; $M1 = 1024*$K1; $G1 = 1024*$M1;
	if (!$val) {
		$val = 0;
	}
	if ($val>=$G1) {
		return sprintf("%.".$decimal."f", $val/$G1).' '.$vbphrase['ll_bytesG'];
	}
	elseif ($val>=$M1) {
		return sprintf("%.".$decimal."f", $val/$M1).' '.$vbphrase['ll_bytesM'];
	}
	elseif ($val>=$K1) {
		return sprintf("%.".$decimal."f", $val/$K1).' '.$vbphrase['ll_bytesK'];
	}
	else {
		return $val.' '.$vbphrase['ll_bytes'];
	}
}

// Check if $forumid is an existing forum/the default pseudo-forum
function forumid_is_valid($forumid) {
	global $DEFAULT_FORUMID;
	if ($forumid == $DEFAULT_FORUMID) {
		return 1;
	}
	elseif ($forumid <= 0) {
		return 0;
	}
	else {
		return verify_id('forum', $forumid, 0, 0, 0);
	}
}

// Return array of forumids for which the 'canview' or 'canviewothers' permission is turned off
function lookup_ldm_forum_protections($can_bypass=0) {
	global $vbulletin, $links_permissions;

	$perms = array(
		$vbulletin->bf_ugp_forumpermissions['canview'],
		$vbulletin->bf_ugp_forumpermissions['canviewothers'],
		);

	if ($can_bypass) {
		return array(0);
	}
	else {
		$forumperms = array();
		$limitfids = array(0,);
		foreach ($vbulletin->forumcache AS $forum) {
			if (isset($forum['forumid'])) {
				$forumperms["$forum[forumid]"] = fetch_permissions($forum['forumid']);
				$blocked = 0;
				foreach ($perms as $thisperm) {
					if (!($forumperms["$forum[forumid]"] & $thisperm)) {
						$blocked = 1;
					}
				}
				if ($blocked) {
					$limitfids[] = $forum['forumid'];
				}
			}
		}
		return $limitfids;
	}
}

// Check if $catid is an existing category id
function catid_is_valid($catid) {
	global $linkscat;
	if (is_array($catid)) {
		if (count($catid)<=0) return 0;
		foreach ($catid as $thiscat) {
			if (!is_numeric($thiscat)) return 0;
			if (intval($thiscat)!=$thiscat) return 0;
			if (!isset($linkscat[$thiscat]['parentid'])) return 0;
		}
	}
	else {
		if (!is_numeric($catid)) return 0;
		if (intval($catid)!=$catid) return 0;
		if (!isset($linkscat[$catid]['catid'])) return 0;
	}
	return 1;
}

// Find out the categories containing $linkid
function lookup_ldm_category($linkid) {
	global $vbulletin;

	$catids = array();
	$asb = $vbulletin->db->query_read("
		SELECT link.linkid AS linkid, ltoc.catid AS linkcatid
		FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid=ltoc.linkid
		WHERE link.linkid='".$linkid."'
				");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$catids[] = $rec['linkcatid'];
	}
	return $catids;
}

// Check array of usernames and return array of userids where valid, 0 otherwise

function lookup_userids($usernames) {
	global $vbulletin;

	$ids = array();
	foreach ($usernames as $k=>$v) {
		$usernames[$k] = trim($vbulletin->db->escape_string(htmlspecialchars_uni($v)));
		$ids[$k] = 0;
	}
	$userlist = implode("' ,'", $usernames);
	if (!trim($userlist)) return $ids;

	$query = "
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user AS user
		WHERE username IN ('" . $userlist . "')
		";
	$asb = $vbulletin->db->query_read($query);

	while ($rec=$vbulletin->db->fetch_array($asb)) {
		foreach ($usernames as $k=>$v) {
			if ($v==$rec['username']) {
				$ids[$k] = $rec['userid'];
				continue;
			}
		}
	}
	$vbulletin->db->free_result($asb);

	return $ids;
}

// Highlight selected words, allowing for quoted structures, embedded html and bbcodes

// Prepare the find and replace regexes for highlighting $words
function make_ldm_highlight_regex($words, &$find, &$replace) {

	$find = array();
	$replace = array();

	$words = preg_replace("/&quot;/", '"', $words);

// Find and extract double-quoted sequences
	if (preg_match_all("/\"(.*?)\"/", $words, $quoted, PREG_PATTERN_ORDER) != 0) {
		foreach ($quoted[1] as $w) {
			if ($w) {
				$find[] = '/('.$w.')/i';
			}
		}
	}

// Tidy up what's left
	$words = preg_replace(
		array(
				"/\".*?\"/",					// 1) double quoted sequences
				"/[\\\+\-<>\(\)\~\"\/]/",		// 2) characters + - > < ( ) ~ " /
				"/^\s+/",						// 3) white space at the beginning
				"/\s+$/",						// 4) white space at the end
				"/^\s*\*|\s\*/",				// 5) bare asterisks
				"/\*/",							// 6) other asterisks
			),
		array(	"",								// 1) kill them
				"",								// 2) kill them
				"",								// 3) kill it
				"",								// 4) kill it
				"\w+",							// 5) replace by 'match one or more word characaters'
				"\w*",							// 6) replace by 'match zero of more word characters'
			),
		$words);

// Break into 'words' separated by white space
	$words = preg_split("/\s+/", $words);
	foreach ($words AS $w) {
		if ($w != "") {
			$find[] = '/(\b'.$w.'\b)/i';
		}
	}

// Replace each 'find' by bracketed highlight span
	foreach ($find AS $f) {
		$replace[] = '<span class="highlight">$1</span>';
	}

}

// Apply the $find and $replace regex to $string
function apply_ldm_highlight($string, $find, $replace) {

	$res = "";
	$substrings = preg_split("/(<\w+\s*\/*>|\[.*?\])/", $string, -1, PREG_SPLIT_DELIM_CAPTURE);
	$resstrings = preg_replace($find, $replace, $substrings);

	foreach ($resstrings as $k=>$r) {
		if (preg_match("/(<\w+\s*\/*>|\[.*?\])/", $substrings[$k])) {
			$res .= $substrings[$k];
		}
		else {
			$res .= $resstrings[$k];
		}
	}

	return $res;
}

function make_highlighted_keys($keywords, $find, $replace) {
	$list = "";
	foreach ($keywords as $k) {
		$w = '<a href="'.SEARCH_SCRIPT.'.php?action=show&amp;keys=1&amp;keyword='.htmlspecialchars_uni($k).'">'.
			apply_ldm_highlight($k,$find, $replace).
			'</a>';
		$list .= $w.' ';
	}
	return trim($list);
}

// Removes bbcodes and html, leaving the middle,
// i.e [color=red]fred[/color] => fred,
// except for img tags, where whole code is stripped out
// because the middle is the image url

function kill_bbcodes($string) {

	$fixstring = $string;

// img
	$find = '#\[img\].*\[/img]#siU';
	$replace = '';
	$fixstring = preg_replace($find, $replace, $fixstring);

// others
	$find = '#\[(.*) *=?.*\](.*)\[/\1\]#siU';
	$replace = '$2';
	while (preg_match($find, $fixstring)) {
		$fixstring = preg_replace($find, $replace, $fixstring);
	}

// html
	$find = '#<(.*) *=?.*>(.*)</\1>#siU';
	while (preg_match($find, $fixstring)) {
		$fixstring = preg_replace($find, $replace, $fixstring);
	}

	return $fixstring;
}

// Check user's files/bandwidth allowances and consumption...
// $check=0 - return array based on user's current allowances and consumption
// $check>0 - include in return assumed download of an entry that is $check bytes in size
// $linkid - user is trying to access this linkid (not used in this code but may be required within hooks)

function check_user_allowances($check, $linkid=0) {
	global $links_defaults, $links_permissions, $vbulletin, $vbphrase;
	global $LINK_UPLOAD;
	static $allow;

	$usergroupid = $vbulletin->userinfo['usergroupid'];
	$allow = array(
				'bytescredit' => 0, 'bytesdaily' => 0, 'bytesenable' => 0, 'byteshit' => 0,
				'filescredit' => 0, 'filesdaily' => 0, 'filesenable' => 0, 'fileshit' => 0,
				'uploadlimit' => 0, 'uploadenable' => 0, 'can_upload' => 1,
				'carryforward' => 1, 'can_download' => 1, 'errormessage' => '',
				);

	if ($links_permissions['can_bypass_bandwidth_limits']) {
		return $allow;
	}

	if ($links_defaults['bandwidth_limit']) {
		$limit = unserialize($links_defaults['bandwidth_limit']);
		if (isset($limit[$usergroupid])) {
			foreach ($limit[$usergroupid] as $k=>$v) {
				$allow[$k] = $v;
			}
			$allow['bytesdaily'] = decode_bytes($allow['bytesdaily']);
		}
	}

	$days = iif($allow['carryforward'],$allow['carryforward'],1);
	$allow['filesavail'] = $allow['filesdaily']*$days;
	$allow['bytesavail'] = $allow['bytesdaily']*$days;

	$usertime = TIMENOW - iif($allow['carryforward'],$allow['carryforward'],1)*60*60*24;

	$usertest_upload = "linkuserid='".intval($vbulletin->userinfo['userid'])."'";
	if ($vbulletin->userinfo['userid']) {
		$usertest = "userid='".intval($vbulletin->userinfo['userid'])."'";
	}
	elseif (isset($_SERVER[REMOTE_ADDR])) {
		$usertest = "userip='".$_SERVER[REMOTE_ADDR]."'";
	}
	else {
		$usertest = "userid='0'";
	}

	($hook = vBulletinHook::fetch_hook('ldm_precheck_user_allowances')) ? eval($hook) : false;

	if ($allow['bytesenable'] or $allow['filesenable']) { // read recent consumption

		$query = "
			SELECT COUNT(dlid) AS hits, SUM(bytes) AS data
			FROM ".THIS_TABLE."linksdownloads
			WHERE ".$usertest."
			AND usertime>'".$usertime."'
			AND linkid>0
			AND bytes>0
			";
		$myrow = $vbulletin->db->query_first($query);
		$allow['fileshit'] = iif($myrow['hits'],$myrow['hits'],0);
		$allow['byteshit'] = iif($myrow['data'],$myrow['data'],0);

	}

	if ($allow['uploadenable']) { // read disk space used

		$query = "
			SELECT SUM(linksize) AS spaceused
			FROM ".THIS_TABLE."linkslink
			WHERE ".$usertest_upload."
			AND linkstatus=$LINK_UPLOAD
			";
		$myrow = $vbulletin->db->query_first($query);
		$allow['uploadused'] = iif($myrow['spaceused'],$myrow['spaceused'],0);

	}

	if ($allow['filesenable'] and (($allow['fileshit']+1)>$allow['filesavail'])) $allow['can_download'] = 0;
	if ($allow['bytesenable'] and (($allow['byteshit']+$check)>$allow['bytesavail'])) $allow['can_download'] = 0;
	if ($allow['uploadenable'] and ($allow['uploadused']>=$allow['uploadlimit'])) $allow['can_upload'] = 0;

	$allow['consumption'] = $allow['filesbit'] = $allow['bytesbit'] = "";
	if ($allow['filesenable']) {
		$allow['filesbit'] = construct_phrase($vbphrase['ll_band_filesuse'], $allow['filesavail'], $allow['fileshit']);
	}
	if ($allow['bytesenable']) {
		$bytesav = format_bytes($allow['bytesavail']);
		$bytesus = format_bytes($allow['byteshit']);
		$allow['bytesbit'] = construct_phrase($vbphrase['ll_band_bytesuse'], $bytesav, $bytesus);
	}
	if ($allow['uploadenable']) {
		$bytesav = format_bytes($allow['uploadlimit']);
		$bytesus = format_bytes($allow['uploadused']);
		$allow['uploadbit'] = construct_phrase($vbphrase['ll_band_uploaduse'], $bytesav, $bytesus);
	}
	if ($allow['filesenable'] or $allow['bytesenable'] or $allow['uploadenable']) {
		eval("\$c  = \"".fetch_template('links_bandwidthbit')."\";");
		$allow['consumption'] = $c;
	}

	if (!$allow['can_download']) {
		$allow['errormessage'] = construct_phrase($vbphrase['ll_error_allowances'], $allow['consumption']);
	}

	($hook = vBulletinHook::fetch_hook('ldm_check_user_allowances')) ? eval($hook) : false;

	return $allow;

}

// Create link's url/<a> tag according to current permissions

function get_url_atag($linkmode, $catid, $linkid, $linkname, $linkurl="", $title="") {
	global $links_permissions, $links_defaults, $vbulletin, $vbphrase;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$target = "target='_blank'";
	if ($linkurl) {
		$URLInfo = ldm_parse_url($linkurl);
		if (array_key_exists('scheme', $URLInfo)) {
			if (!$links_defaults['open_remote_links_newwindow']) $target = "";
		}
		else {
			if (!$links_defaults['open_local_links_newwindow']) $target = "";
		}
	}

	switch ($linkmode) {
	case -2: // just the url, no tag
		$atag = $vbulletin->options['bburl']."/".$LINKS_SCRIPT.
			iif($links_defaults['seo_friendly'],"/links/$catid/$linkid",".php?catid=$catid".iif($linkid,"&linkid=$linkid",""));
		return $atag;

	case -1: // view tags
		$atag = '<a href="'.$vbulletin->options['bburl']."/".$LINKS_SCRIPT.
			iif($links_defaults['seo_friendly'],"/links/$catid/$linkid",".php?catid=$catid".iif($linkid,"&amp;linkid=$linkid","")).
			'" title="'. $title .'">'.
			$linkname.'</a>';
		break;
	case 0: // masked jump tags
	case 1:
		$atag = '<a href="'.$vbulletin->options['bburl']."/".$LINKS_SCRIPT.
			iif($links_defaults['seo_friendly'],"/jump/$linkid/$catid",".php?action=jump&amp;id=$linkid&amp;catid=$catid").
			'" title="'. $title .'" '.$target.">".
			$linkname.'</a>';
		break;
	case 2: // open jump tag
		if ($linkurl and !array_key_exists('host', $URLInfo)) {
			if ($links_defaults['local_file_root']) { // can't provide a clean url
				$atag = '<a href="'.$vbulletin->options['bburl']."/".$LINKS_SCRIPT.
					iif($links_defaults['seo_friendly'],"/jump/$linkid/$catid",".php?action=jump&amp;id=$linkid&amp;catid=$catid").
					'" title="'. $title .'" '.$target.">".
					$linkname.'</a>';
				break;
			}
			elseif ($links_defaults['local_file_root_prefix']) {
				$linkurl = mk_file_name($links_defaults['local_file_root_prefix'], $linkurl);
			}
		}
		$atag = '<a href="'.$linkurl.'" title="'. $title .'" '.$target.'>'.
			$linkname.'</a>';
		break;
	}

	return process_permission($atag, $linkname);
}

function process_permission($atag, $linkname) {
	global $links_defaults, $links_permissions, $vbphrase, $vbulletin;

	if (!$links_permissions['can_access_link']) {
		switch ($links_defaults['protected_link']) {
		case 0:
			return $linkname; // no hyperlink
		case 1:
			return $atag; // will generate informative 'no permission' message when selected
		case 2:
			if ($vbulletin->userinfo['userid'] == 0) {
				return '<a href="register.php" title="'. $vbphrase['ll_registertoview']. '">'.$linkname.'</a>'; // force registration
			}
			else {
				return $atag; // will generate informative 'no permission' message when selected
			}
		}
	}
	return $atag; // OK

}

// Obtain the master sql query
// $where : array of where conditions
// $hitssince : if>0, obtain a count of hits since that time
// $joinfavs : if set, include a join on the favourites table
// $order : sort condition
// $limit : maximum number of hits
// $othercats : whether to double join in ltoc table to find other categories
// $joinkeys : whether to join keywords tables

function get_mainsql($where, $hitssince=0, $joinfavs=0, $order=0, $limit=0, $othercats=1, $joinkeys=0) {
	global $vbulletin, $links_defaults;
	$query = "
		SELECT
			link.linkid AS linkid, link.linkname AS linkname, link.linkdoi AS linkdoi,
			link.linkuserid AS linkuserid, link.linkusername AS linkusername,
			link.linkurl AS linkurl, link.linkimg AS linkimg,
			link.linkimgthumb AS linkimgthumb, link.linkimgthumbsize AS linkimgthumbsize, link.linkforum AS linkforum,
			link.linkdesc AS linkdesc, link.numrate AS numrate, link.totrate AS totrate,
			link.linkhits AS linkhits, link.linksize AS linksize, link.linkstatus AS linkstatus,
			link.linkdate AS linkdate, link.linkmoderate AS linkmoderate, link.linkmoddate AS linkmoddate,
			link.linkreviewfreq AS linkreviewfreq,
			ltoc.catid AS linkcatid, ltoc.displayorder AS linkdorder
			".iif($links_defaults['show_avatars'], ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight')."
			".iif($othercats,", ltoc2.catid AS linkcatid2","")."
			".iif($hitssince,", COUNT(lhits.linkid) AS linkrecenthits","")."
			".iif($joinkeys,", lkeys.keyword AS linkkey","")."
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc ON link.linkid = ltoc.linkid
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = link.linkuserid)")."
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)")."
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)")."
	";

	if ($othercats) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc2
			ON link.linkid = ltoc2.linkid
		";
	}
	if ($hitssince) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksdownloads AS lhits
			ON link.linkid = lhits.linkid
		";
	}
	if ($joinfavs) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksfavs AS lfav
			ON link.linkid = lfav.linkid
		";
	};
	if ($joinkeys) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON link.linkid = ltok.linkid
			LEFT JOIN ".THIS_TABLE."linkskeys AS lkeys
			ON ltok.keyid = lkeys.keyid
		";
	};
	$nw = 0;
	foreach ($where as $w) {
		$query .= iif($nw++," AND "," WHERE ").$w.' ';
	}
	if ($hitssince) {
		$query .= iif($nw++," AND "," WHERE ")."lhits.usertime>=".$hitssince."
			GROUP BY linkid, linkcatid".iif($othercats,", linkcatid2","").iif($joinkeys,", linkkey","")."
		";
	}
	if ($order) {
		$query .= "
			ORDER BY ".$order;
	}
	if ($limit) {
		$query .= "
			LIMIT ".$limit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_mainsql_complete')) ? eval($hook) : false;

	return $query;
}

// Obtain the sql sub-query used to sort linkbit searches

function get_sortsql($sort, $withlinkdorder=1) {
	$linkdorder = iif($withlinkdorder,"linkdorder ASC, ","");
	if (is_numeric($sort)) {
		$sorder = $linkdorder."  linkrecenthits DESC, linkname ASC, linkcatid ASC";
	}
	else {
		switch ($sort) {
		case 'r': $sorder = $linkdorder."  IF(numrate>0,(totrate/numrate),numrate) DESC, linkname ASC, linkcatid ASC"; break;
		case 'R': $sorder = $linkdorder."  IF(numrate>0,(totrate/numrate),numrate) ASC,  linkname ASC, linkcatid ASC"; break;
		case 'd': $sorder = $linkdorder."  linkdate DESC, linkname ASC, linkcatid ASC"; break;
		case 'D': $sorder = $linkdorder."  linkdate ASC,  linkname ASC, linkcatid ASC"; break;
		case 'h': $sorder = $linkdorder."  linkhits DESC, linkname ASC, linkcatid ASC"; break;
		case 'H': $sorder = $linkdorder."  linkhits ASC,  linkname ASC, linkcatid ASC"; break;
		case 'u': $sorder = $linkdorder."  linkusername DESC,  linkname ASC, linkcatid ASC"; break;
		case 'U': $sorder = $linkdorder."  linkusername ASC,  linkname ASC, linkcatid ASC"; break;
		case 'n': $sorder = $linkdorder."  linkname DESC, linkcatid ASC"; break;
		case 'N':
		default:  $sorder = $linkdorder."  linkname ASC,  linkcatid ASC"; break;
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_sortsql_complete')) ? eval($hook) : false;

	return $sorder;
}

// Prepare summary information to show on category home page

function get_ldm_summary() {
	global $vbulletin, $linkscat, $limitfids, $vbphrase, $stylevar;
	global $links_permissions, $links_defaults;
	global $HOT_CAT, $NEW_CAT, $LINK_ACCEPTED, $LINK_TO_MODERATE;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$mquery = "";
	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		if ($vbulletin->userinfo['userid'] == 0) {
			$mquery .= "
			AND link.linkmoderate = $LINK_ACCEPTED
			";
		}
		else {
			$mquery .= "
			AND
				(link.linkmoderate = $LINK_ACCEPTED
				OR
					(link.linkmoderate = $LINK_TO_MODERATE
					AND link.linkuserid = ".$vbulletin->userinfo['userid']."
					)
				)
			";
		}
	}

	$timelimit = iif($links_defaults["days_seen_on_portal"],
		TIMENOW-intval($links_defaults["days_seen_on_portal"])*24*60*60,
		$vbulletin->userinfo['lastvisit']);

	$query = "
		SELECT COUNT(linkid) AS newlinks
		FROM ".THIS_TABLE."linkslink AS link
		WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
		AND linkdate > ".$timelimit."
		$mquery
		";
	$count = $vbulletin->db->query_first("$query");
	$linkstats['new_timelimit'] = $count['newlinks'];

	$recent	= construct_phrase($vbphrase['ll_recent'], ldm_date($vbulletin->options['dateformat'], $timelimit),
				$linkstats['new_timelimit'],
				iif($count['newlinks'],'[<a href="'.$SEARCH_SCRIPT.'.php?action=find&amp;catid='.$NEW_CAT.'">'.$vbphrase['ll_view'].'</a>] '));

	eval("\$text  = \"".fetch_template('links_introbit')."\";");
	return($text);
}

// Construct 'hit parade'

function get_ldm_hitparade($catid) {

	global $vbulletin;
	global $links_defaults, $links_permissions;

	$filter = array();
	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);
	$limitfilter = $filter[] = 'link.linkforum NOT IN ('.implode(',', $limitfids).') ';

	$join = "";
	if ($catid>0) {
		$filter[] = "ltoc.catid = '".$catid."'";
	}

	$linksee = iif (isset($links_defaults['links_seen_on_portal']), $links_defaults['links_seen_on_portal'], 3);
	$since = iif($links_defaults["days_seen_on_portal"],
		TIMENOW-intval($links_defaults["days_seen_on_portal"])*24*60*60,
		$vbulletin->userinfo['lastvisit']);

	if ($catid<=0) {
		$query = "
			SELECT hits.linkid AS linkid, COUNT(hits.linkid) AS linkhits
			FROM ".THIS_TABLE."linksdownloads AS hits
			".iif($cansee, "", "LEFT JOIN ".THIS_TABLE."linkslink AS link ON hits.linkid=link.linkid")."
			WHERE hits.usertime>'".$since."'
			AND hits.linkid>0
			".iif($cansee,"","AND ".$limitfilter)."
			GROUP BY hits.linkid
			ORDER BY linkhits DESC
			LIMIT ".$linksee."
			";
	}
	else {
		$query = "
			SELECT hits.linkid AS linkid, COUNT(hits.linkid) AS linkhits
			FROM ".THIS_TABLE."linksdownloads AS hits
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON hits.linkid=ltoc.linkid
			".iif($cansee, "", "LEFT JOIN ".THIS_TABLE."linkslink AS link ON hits.linkid=link.linkid")."
			WHERE ltoc.catid='".$catid."'
			AND hits.usertime>'".$since."'
			AND hits.linkid>0
			".iif($cansee,"","AND ".$limitfilter)."
			GROUP BY hits.linkid
			ORDER BY linkhits DESC
			LIMIT ".$linksee."
			";
	}

	$tophits = array();
	$asb = $vbulletin->db->query_read($query);
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$tophits[$rec['linkid']]['linkrecenthits'] = $rec['linkhits'];
	}

	if (count($tophits)) {
		$filter[] = "link.linkid IN (".implode(',', array_keys($tophits)).")";
		$query = get_mainsql($filter, 0, 0, $order, 0, 0);
		list($links, $nhits) = get_links2($query, $linksee, "links_hitparade", $tophits);
		return $links;
	}
	else {
		return "";
	}

}


// Simplified linkbit constructor used by portal interfaces and hit parades

function get_links($filter, $order, $template) {
	global $vbulletin;
	global $links_defaults, $links_permissions;

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);
	$filter[] = 'link.linkforum NOT IN ('.implode(',', $limitfids).') ';

	$catsee = iif(isset($links_defaults["categories_seen_on_portal"]), $links_defaults["categories_seen_on_portal"], '');
	if ($catsee) {
		$filter[] = 'ltoc.catid IN ('.$catsee.')';
	}

	$linksee = iif (isset($links_defaults['links_seen_on_portal']), $links_defaults[links_seen_on_portal], 3);
	$query = get_mainsql($filter, 0, 0, $order, 0, 0);
	list($links, $nhits) = get_links2($query, $linksee, $template);
	return array($links, $nhits, $query);
}

function get_links2($query, $linksee, $template, $addvars=0) {
	global $vbulletin, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $links_defaults, $links_permissions, $linkscat, $ldm_icon_cache;
	global $show_catname;

	get_icons();
	$nhits = 1;
	$hits = array();
	$linkbit = array();

	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb) and $nhits<=$linksee) {
		$linkid	   = $myrow["linkid"];
		if (is_array($addvars)) {
			if (isset($addvars[$linkid])) {
				foreach ($addvars[$linkid] as $thiskey=>$thisval) {
					$myrow[$thiskey] = $thisval;
				}
			}
		}
		if (isset($hits[$linkid])) {
			continue;
		}
		$hits[$linkid] = 1;
		$nhits++;
		$catid		= $myrow["linkcatid"];
		$linkname	= parse_me($myrow["linkname"]);
		$linkdesc	= parse_me($myrow["linkdesc"]);
		if (array_key_exists("linkrecenthits", $myrow)) {
			$linkhits = $myrow["linkrecenthits"];
		}
		else {
			$linkhits = $myrow["linkhits"];
		}
		$linkstatus = $myrow["linkstatus"];
		$linksize   = format_bytes($myrow["linksize"]);
		$linkurllink = get_url_atag(-1, $catid, $linkid, $linkname);
		$linkimg	= $myrow["linkimg"];
		$linkimgthumb = $myrow["linkimgthumb"];
		$linkimgthumbsize = $myrow["linkimgthumbsize"];
		$linkdate	= ldm_date($vbulletin->options['dateformat'], $myrow["linkdate"]);
		$linkusername = $myrow["linkusername"];
		$linkuserid = $myrow["linkuserid"];

		$linkurl	= $myrow["linkurl"];
		$urlInfo	= ldm_parse_url($linkurl);

		$linkname_clean = str_replace(array("'", '"'), "", $linkname);
		$linkimgshow = iif($linkimg,
			iif($linkimgthumb  and $linkimgthumbsize==$links_default['link_imagesize'] and !$urlInfo['user'],
					"<img src='".create_full_url(iif($linkimgthumb{0}!= '/',"/","").$linkimgthumb)."' border='0' alt='".$linkname_clean."' />",
					"<img src='".mk_file_name($vbulletin->options['bburl'],$RESIZE_SCRIPT.".php")."?linkid=$linkid' border='0' alt='".$linkname_clean."' />"
				),
			"");
		$linkimgjump = get_url_atag(-1, $catid, $linkid, $linkimgshow);
		$linkcatname = $linkscat[$catid]["catname_clean"];
		$urlType	= substr(strrchr(basename($urlInfo['path']), "."), 1);
		if ($urlType and array_key_exists($urlType, $ldm_icon_cache)) {
			$linktypebit = '<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$ldm_icon_cache[$urlType]).'" alt="'.$urlType.'" /> ';
		}
		else {
			$linktypebit = " ";
		}
		$linkhit	= $nhits;
        eval("\$linkbit[$linkid] = \"".fetch_template($template)."\";");
	}
	$vbulletin->db->free_result($asb);
	unset($hits); unset($myrow);

	if (is_array($addvars)) {
// return results sorted in same order as addvars
		$sortbit = array();
		foreach ($addvars as $thisid=>$thisvar) {
			$sortbit[] = $linkbit[$thisid];
		}
		$linkbit = implode(" ", $sortbit);
	}
	else {
		$linkbit = implode(" ", $linkbit);
	}

	return array($linkbit, $nhits);
}

// Construct main catbit

function get_catsubbit ($subtemplate, $subtree, $limit, $depth=0) {
	global $linkscat, $limitfids, $links_defaults, $ldm_icon_cache;
	global $vbphrase, $vbulletin, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	static $count;
	$subcatbit = '';
	$subicon = "";
	if ($depth==0) {
		$count = 0;
	}
	foreach ($subtree as $subid=>$subchildren) {
		if (in_array($linkscat[$subid]["catforum"], $limitfids)) continue;
		$subname = $linkscat[$subid]["catname_clean"];
		$sublink = $linkscat[$subid]["childlinks"];
		$subcatnew = iif($vbulletin->userinfo['lastvisit'] < $linkscat[$subid]['catdate'],1,0);
		$this_subicon_setting = lookup_setting($subid, 'subcat_icon');
		if ($this_subicon_setting=="0") {
			$this_subicon = "";
		}
		elseif ($this_subicon_setting=="") {
			$this_subicon = isset($ldm_icon_cache['category']) ? $ldm_icon_cache['category'] : "";
		}
		else {
			$this_subicon = $this_subicon_setting;
		}
		if ($this_subicon and $this_subicon!=$subicon) {
			$subcatbit .= '<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$this_subicon).'" alt="" />';
		}
		$subicon = $this_subicon;
		$linebreak = 0;
		if ($links_defaults['cat_sub_display_perline']) {
			if ($count and !($count%$links_defaults['cat_sub_display_perline'])) $linebreak = 1;
		}
		$count++;
		if ($limit and ($limit-$count<0)) {
			$subcatbit .= " ...";
			return $subcatbit;
		}
		eval("\$subcatbit .= \"".fetch_template($subtemplate)."\";");
		$subcatbit .= get_catsubbit($subtemplate, $subchildren, $limit, $depth+1);
	}
	return $subcatbit;
}

function get_catlistbit (&$catlistarray, $template, $subtemplate, $thisid, $thischildren, $modcats, $subdepth=1, $categorypage=1) {
	global $limitfids, $linkscat, $catstyle, $links_defaults;
	global $tomod, $vbphrase, $links_permissions, $ldm_icon_cache;
	global $vbulletin, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$thiscat = $linkscat[$thisid];
	if (in_array($thiscat["catforum"], $limitfids)) return;
	if ($thiscat['catmoderate'] and $vbulletin->userinfo['userid'] != $thiscat['catuserid']) {
		if (!$links_permissions['can_moderate_links'] and !$links_permissions['can_moderate_forums']) {
			return;
		}
	}
	if ($modcats and $thiscat['catforum'] and !$links_permissions['can_moderate_links']) {
		if (!can_moderate($thiscat['catforum'], 'canmoderateposts')) {
			return;
		}
	}

	$catid	= $thiscat["catid"];
	$catname = parse_me($thiscat["catname"]);

	$catusername = $thiscat['catusername'];
	$catuserid = $thiscat['catuserid'];
	$catdesc  = parse_me($thiscat["catdesc"]);
	$cattext  = parse_me($thiscat["cattext"]);

	$catdate = ldm_date($vbulletin->options['dateformat'], $thiscat['catdate']);
	$catnew = iif($vbulletin->userinfo['lastvisit'] < $thiscat['catdate'],1,0);
	$catsub = $thiscat["catsub"];
	$catchildsub = $thiscat["childcats"];
	$catentry = $thiscat["catentry"];
	$catchildentry = $thiscat["childlinks"];
	$catclosed = $thiscat["catclosed"];
	$catsyncdone = $thiscat["catsyncdone"];

	get_icons();

	$iconnew_setting = lookup_setting($catid, 'cat_icon_new');
	if ($iconnew_setting=="0") {
		$iconnew = "";
	}
	elseif ($iconnew_setting=="") {
		$iconnew = isset($ldm_icon_cache['category_new']) ? $ldm_icon_cache['category_new'] : "";
	}
	else {
		$iconnew = $iconnew_setting;
	}

	$iconold_setting = lookup_setting($catid, 'cat_icon');
	if ($iconold_setting=="0") {
		$iconold = "";
	}
	elseif ($iconold_setting=="") {
		$iconold = isset($ldm_icon_cache['category']) ? $ldm_icon_cache['category'] : "";
	}
	else {
		$iconold = $iconold_setting;
	}

	$caticonbit = iif($catnew,
				iif($iconnew,'<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$iconnew).'" alt="'.$vbphrase['ll_newentries'].'" />',""),
				iif($iconold,'<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$iconold).'" alt="" />',"")
				);

	$catmoderate = 0;
	if ($links_permissions['can_moderate_links']) {
		$catmoderate = $thiscat["catmoderate"];
	}
	elseif ($thiscat['catforum']>0 and $links_permissions['can_moderate_forums']) {
		if (can_moderate($thiscat['catforum'], 'canmoderateposts')) {
			$catmoderate = $thiscat["catmoderate"];
		}
	}
	$linkmoderate = $tomod[$thiscat['catid']];

	$subcatnames = "";

	if ($subdepth>=$links_defaults['cat_depth_display'] and $links_defaults['cat_sub_display']>0) {
		$subtree = cat_walk($thisid, $links_defaults['cat_sub_display']);
		$subcatnames = get_catsubbit($subtemplate, $subtree, $links_defaults['cat_sub_display_limit']);
	}

	$displayorder = $thiscat["displayorder"];
	if (isset($thisorder) and $displayorder != $thisorder) {
		eval("\$catlistarray[] = \"".fetch_template('links_linkseparator')."\";");
		$catstyle = 1;
	}

	($hook = vBulletinHook::fetch_hook('ldm_catbit_create')) ? eval($hook) : false;

	$catindent = ($subdepth-1)*$links_defaults['cat_depth_indent']+1;

	eval("\$catlistarray[] = \"".fetch_template($template)."\";");
	$catstyle = iif($catstyle==1,2,1);
	$thisorder = $displayorder;

	if (is_array($thischildren)) {
		foreach ($thischildren as $childid=>$grandchildren) {
			get_catlistbit ($catlistarray, $template, $subtemplate, $childid, $grandchildren, $modcats, $subdepth+1);
		}
	}

	return;
}

// Map a listbit vector onto a grid to produce multicolumn layouts
// Listbit vectors are zero-based arrays of listbits; listbits are either
// a table row (<tr>..</tr>) or null.  Null listbits introduce a spacer row
// using the $separator template.

function map_listbit_to_grid($listbit, $columns=1, $horizontal=0, $separator='links_linkseparator') {

	$ilast = count($listbit)-1;
	if ($ilast<0) {
		return "";
	}

	$result = "";
	$linkseparator = "";
	if ($separator) {
		eval("\$linkseparator = \"".fetch_template($separator)."\";");
	}

	$istart = 0;
	$inext = 0;
	while (1) {
// End of array?
		if ($inext>$ilast) {
			break;
		}

		if ($listbit[$inext]) {
			$inext++;
			continue;
		}

// We've hit a separator
		if ($inext>$istart) {
			$result .= layout_ldm_listbit(array_slice($listbit, $istart, $inext-$istart), $columns, $horizontal);
		}

		if ($inext<$ilast) {
			$result .= $linkseparator;
		}

		$inext++;
		$istart = $inext;

	}

	if ($istart<=$ilast) {
		$result .= layout_ldm_listbit(array_slice($listbit, $istart), $columns, $horizontal);
	}
	return $result;

}

// Do the detailed work for map_listbit_to_grid for one group of listbits

function layout_ldm_listbit($listbit, $columns, $horizontal) {
	global $stylevar;
	$result = "";

// Straightforward single column cases
	if ($columns==1) {
		$alt = 1;
		foreach ($listbit as $thisbit) {
			$result .= '<tr><td colspan="2" class="alt'.$alt.'">'.
				'<table width="100%" border="0" cellpadding="0" cellspacing="0">'.
				$thisbit.
				'</table></td></tr>';
			$alt = iif($alt==1,2,1);
		}
		return $result;
	}

// Multicolumn cases
	$emptycell = '<tr><td>&nbsp;</td></tr>';
	if ($horizontal) {

		$kr = 1; $kc = 1;
		foreach ($listbit as $thisbit) {
			$table[$kr][$kc] = $thisbit;
			$kc+=1;
			if ($kc>$columns) {
				$kc=1;
				$kr+=1;
			}
		}
		if ($kc>1) {
			while ($kc<=$columns) {
				$table[$kr][$kc] = $emptycell;
				$kc+=1;
			}
		}

	}
	else {

		$nr = 1 + (int) (count($listbit)-1)/$columns;
		$kr = 1;
		$kc = 1;
		$table = array();
		foreach ($listbit as $thisbit) {
			$table[$kr][$kc] = $thisbit;
			$kr+=1;
			if ($kr>$nr) {
				$kr=1;
				$kc+=1;
			}
		}
		while ($kc<=$columns) {
			while ($kr<=$nr) {
				$table[$kr][$kc] = $emptycell;
				$kr+=1;
			}
			$kc+=1;
		}
	}

	$alt = 1;
	foreach ($table as $kr=>$row) {
		$result .= '<tr><td colspan="2" class="alt'.$alt.'">'."\n".
			'<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr>'."\n";
		foreach ($row as $kc=>$cell) {
			$width = iif($kc<$columns, (int) round(100/$columns), 100-($columns-1)*((int) round(100/$columns)));
			$result .= '<td valign="top" align="center" width="'.$width.'%">'.
				'<table width="100%" border="0" cellpadding="0" cellspacing="0">'.
				$cell.
				"</table></td>\n";
			if ($kc<$columns) {
				$result .= '<td width="'.$stylevar['cellpadding'].'">&nbsp;</td>'."\n";
			}
		}
		$result .= "</tr></table></td></tr>\n";
		$alt = iif($alt==1,2,1);
	}

	unset($table);
	return $result;

}

function catbit_columns($template) {
	global $links_defaults, $ldm_catbitcache;
	if (!$links_defaults['cat_cols_display']) {
		$ncols = $ldm_catbitcache[$template]['defcol'];
	}
	elseif ($links_defaults['cat_cols_display']>$ldm_catbitcache[$template]['maxcol']) {
		$ncols = $ldm_catbitcache[$template]['maxcol'];
	}
	else {
		$ncols = $links_defaults['cat_cols_display'];
	}
	return $ncols;
}

function linkbit_columns($template) {
	global $links_defaults, $ldm_linkbitcache;
	if (!$links_defaults['link_cols_display']) {
		$ncols = $ldm_linkbitcache[$template]['defcol'];
	}
	elseif ($links_defaults['link_cols_display']>$ldm_linkbitcache[$template]['maxcol']) {
		$ncols = $ldm_linkbitcache[$template]['maxcol'];
	}
	else {
		$ncols = $links_defaults['link_cols_display'];
	}
	return $ncols;
}

// Decipher avatar

function get_avatarinfo($avatarinfo) {
	global $vbulletin, $links_defaults;

	if (!$links_defaults['show_avatars']) {
		return '';
	}
	elseif (!empty($avatarinfo['avatarpath'])) {
		return '<img src="' . $avatarinfo['avatarpath'] . '" alt="" border="0" />';
	}
	elseif ($avatarinfo['hascustomavatar']) {
		$avatarurl = array();
		if ($vbulletin->options['usefileavatar']) {
			$avatarurl[] = $vbulletin->options['avatarurl'] . "/avatar".$avatarinfo['linkuserid']."_".$avatarinfo['avatarrevision'].".gif";
		}
		else {
			$avatarurl[] = "image.php?u=".$avatarinfo['linkuserid']."&amp;dateline=".$avatarinfo['avatardateline'];
		}

		if ($avatarinfo['width'] AND $avatarinfo['height']) {
			$avatarurl[] = " width=\"$avatarinfo[width]\" height=\"$avatarinfo[height]\" ";
		}
		return '<img src="' . $avatarurl[0] . '" ' . $avatarurl[1] . ' alt="" border="0" />';
	}
	else {
		return '<img src="' . $vbulletin->options['cleargifurl']  . '" alt="" border="0" />';
	}

}

// Construct main linkbit - full version

function get_linklistbit(&$linklistarray, &$hitids, &$expiredids, $template, $query, $highlight, $showcatname=0,
						$forcedisplayorder=0, $pagenumber=1, $perpage=999999) {

	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $LINK_TO_MODERATE, $LINK_HIDDEN;

	global $vbulletin, $stylevar, $viewcatid, $viewlinkid, $links_permissions, $links_defaults;
	global $linkscat, $ldm_icon_cache, $LDM_environment;
	global $protocol_schemes;
	global $links_fav, $vbphrase, $sort;

	$first = $pagenumber*$perpage - $perpage;
	$last = $first + $perpage - 1;
	$thits = 0;

	$linkstyle = 1;
	$nhits = 0;
	$thisid = -1;
	$hitids = array();
	$expiredids = array();
	$linkcatlist = array();
	$linkkeylist = array();
	$linklistarrayids = array();
	$linklistarraykey = 0;
	$linkcatname = "";
	$linkcat = 0;

	get_icons();

	$expire = 0;
	if ($links_defaults['links_expiry_days']>0) {
		$expire = $links_defaults['links_expiry_days']*86400;
	}

	$highlight_find = array();
	$highlight_repl = array();
	if ($highlight['string']) {
		make_ldm_highlight_regex($highlight['string'], $highlight_find, $highlight_repl);
	}

	require_once(DIR . '/includes/local_links_players.php');

	$linksavetext = iif(is_browser('mozilla'),$vbphrase['ll_visitdownload_moz'],$vbphrase['ll_visitdownload']);

	unset($thisorder);
	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb)) {

		($hook = vBulletinHook::fetch_hook('ldm_linkbit_read')) ? eval($hook) : false;

		if ($myrow["linkid"] == $thisid) {
			if (isset($myrow["linkcatid2"]) and $myrow["linkcatid2"] != $myrow["linkcatid"] and !in_array($myrow["linkcatid2"], $linkcatlist)) {
				$linkcatlist[] = $myrow["linkcatid2"];
			}
			if ($myrow["linkkey"] and !in_array($myrow["linkkey"], $linkkeylist)) {
				if ($links_defaults['apply_censor']) {
					$linkkeylist[] = fetch_censored_text($myrow["linkkey"]);
				}
				else {
					$linkkeylist[] = $myrow["linkkey"];
				}
			}
			continue;
		}

		if ($thisid > 0) {
			if ($thits >= $first and $nhits <= $perpage-1) {
				$linkkeys = make_highlighted_keys($linkkeylist, $highlight_find, $highlight_repl);
				$linkkeysraw = implode(' ', $linkkeylist);
				eval("\$linkratebit = \"".fetch_template('links_ratebit')."\";");
				$linkratebit = trim($linkratebit);
				$linkothercatsbit = "";
				$linkshowothercatbit = 0;
				foreach ($linkcatlist as $linkothercat) {
					$linkothercatname = $linkscat[$linkothercat]["catname_clean"];
					if (!$showcatname) $linkshowothercatbit = 1;
					eval("\$linkothercatsbit .= \"".fetch_template('links_othercatsbit')."\";");
				}

				($hook = vBulletinHook::fetch_hook('ldm_linkbit_create')) ? eval($hook) : false;

				if (($linkstatus!=$LINK_HIDDEN and !$linkexpired) or $links_permissions["can_view_hidden"]) {
					eval("\$linklistarray[$linklistarraykey] = \"".fetch_template($template)."\";");
					$linklistarrayids[$linkid] = $linklistarraykey;
					$linklistarraykey++;
					$hitids[$linkid] = $linkcatid;
					$linkstyle = iif($linkstyle==1,2,1);
					$nhits++;
				}
				if (!$forcedisplayorder and isset($thisorder) and $myrow["linkdorder"] != $thisorder) {
					$linklistarray[$linklistarraykey] = "";
					$linklistarraykey++;
				}
			}

			if (!$linkexpired or $links_permissions["can_view_hidden"]) {
				$thits++;
			}

			$thisid = -1;
			unset ($linkcatlist);
			$linkcatlist = array();
			$linkkeylist = array();
			$linkcatname = "";
		}

		$thisid = $linkid = $myrow["linkid"];
		$thisorder = $myrow["linkdorder"];

		if ($thits+1 < $first) continue;  // watch out for problems with this...
		if ($thits > $last) continue;

		$linkcatid = $myrow["linkcatid"];
		if (!$linkcatname) $linkcatname = $linkscat[$linkcatid]["catname_clean"];

		$linkavatar = get_avatarinfo($myrow);

		if ($showcatname) {
			if (!in_array($myrow["linkcatid"],$linkcatlist)) {
				$linkcatlist[] = $myrow["linkcatid"];
			}
		}
		if (isset($myrow["linkcatid2"]) and $myrow["linkcatid2"] != $myrow["linkcatid"]) {
			$linkcatlist[] = $myrow["linkcatid2"];
		}

		if ($myrow["linkkey"] and !in_array($myrow["linkkey"], $linkkeylist)) {
			$linkkeylist[] = $myrow["linkkey"];
		}

		$linkname	= $myrow["linkname"];
		$linkdoi	= $myrow["linkdoi"];
		$linkdesc	= $myrow["linkdesc"];
		$linkname	= parse_me(trim($linkname));
		$linkdesc	= parse_me(trim($linkdesc));
		if ($highlight['desc']) {
			$linkname	= apply_ldm_highlight($linkname, $highlight_find, $highlight_repl);
			$linkdesc	= apply_ldm_highlight($linkdesc, $highlight_find, $highlight_repl);
		}
		if (!trim($linkname)) $linkname = "&nbsp;";
		if (!trim($linkdesc)) $linkdesc = "&nbsp;";

		$linkurl	= $myrow["linkurl"];
		$linkshorturl = iif(strlen($linkurl)>24, substr($linkurl, 0, 24).'...', $linkurl);
		$urlInfo = iif($linkurl, ldm_parse_url($linkurl), array());
		$linkurljump = $linkname;
		$linktypebit = '';
		$linkurlextra = '';

		$linkimgsize = $links_defaults["link_imagesize"];
		$linkimg	= iif($linkimgsize,$myrow["linkimg"],"");
		$linkimgthumb = $myrow["linkimgthumb"];
		$linkimgthumbsize = $myrow["linkimgthumbsize"];

		$linkmoddate = $myrow['linkmoddate'];
		$linkreviewfreq = $myrow['linkreviewfreq'];
		if ($linkreviewfreq>0) {
			$linkmoddate = $linkmoddate ? ldm_date($vbulletin->options['dateformat'], $linkmoddate) : $vbphrase['ll_never'];
		}

		$is_favicon = preg_match("/\.ico$/",$linkimg);

		if ($linkimgthumb and $linkimgthumbsize==$links_defaults['link_imagesize'] and !$urlInfo['user']) {
			$lf = local_filename($linkimgthumb,0);
			$conn = @fopen($lf, "r");
			if ($conn) {
				$linkimgsrc = create_full_url(iif($linkimgthumb{0}!= '/',"/","").$linkimgthumb);
				fclose($conn);
			}
			else {
				$linkimgsrc = $RESIZE_SCRIPT.'.php?linkid='.$linkid;
			}
		}
		else {
			$linkimgsrc = $RESIZE_SCRIPT.'.php?linkid='.$linkid;
		}
		if ($linkimg and !$is_favicon) {
			$linkimgshow = "<img src='".$linkimgsrc."' border='0' alt='' />";
		}
		else {
			$linkimgshow = "";
		}
		if ($linkimg and !$is_favicon) {
			eval("\$linkimgmag = \"".fetch_template('links_imgmag')."\";");
		}

		$linkurllink = get_url_atag(-1, $linkcatid, $linkid, $linkname);
		$linkimglink = iif ($linkimg, get_url_atag(-1, $linkcatid, $linkid, $linkimgshow), "");
		$linkimgjump = "";
		$linksize = 0;

		if ($linkurl) {
			$urlInfo	= ldm_parse_url($linkurl);
			$urlType	= substr(strrchr(basename($urlInfo['path']), "."), 1);
			if (isset($urlInfo['scheme'])) {
				$linkmode = iif(isset($protocol_schemes[$urlInfo['scheme']]), $protocol_schemes[$urlInfo['scheme']]["mode"], MODE_OPEN);
			}
			else {
				$linkmode = 1;
			}

			$linkmode	= max($linkmode, $links_defaults["force_redirect"]);
			$linktypebit = '';
			$linkurljump = "";
			$linkurlsave = "";
			$linkimgjump = "";

			$link_known_mimetype = get_mimetype($urlType);

			$lc_urlType = strtolower($urlType);
			$is_musicbox = 0;

			if (get_playerid($linkid, $linkurl, $lc_urlType)>=0) {
				$is_musicbox = 1;
				$linkimgmag = "";
			}

			$musicbox_window	= iif($links_defaults['open_musicbox_newwindow'], 'target="player" onclick="ldm_popup(this.href);return false;"', 'target="_top"');
			$musicbox_template	= '<a href="'.mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT).'.php?action=play&amp;linkid='.$linkid.'&amp;catid='.$linkcatid.'&amp;page='.$pagenumber.'" '.$musicbox_window.' title="'.$vbphrase['ll_playme'].'">%s</a>';

			$linktypebit = get_typebit($urlInfo, iif($is_musicbox and $links_permissions["can_play_musicbox"],$musicbox_template,""));
			if (!$linktypebit and $is_favicon) {
				$linktypebit = '<img border="0" src="'.$linkimg.'" alt="" />';
			}

			$linksavebit = '';
			if ($link_known_mimetype) {
				eval("\$linksavebit .= \"".fetch_template('links_downloadbit', 0, 0)."\";");
			}

			$linkpopup = iif($link_known_mimetype,$linksavetext,$vbphrase['ll_visiturl']);
			$linkurljump = get_url_atag($linkmode, $linkcatid, $linkid, $linkname, $linkurl, $linkpopup);
			$linkimgjump = iif ($linkimg, get_url_atag($linkmode, $linkcatid, $linkid, $linkimgshow, $linkurl, $linkpopup), "");

			if ($is_musicbox) {
				if ($links_permissions["can_play_musicbox"]) {
					$linkurljump = process_permission(sprintf($musicbox_template, $linkname), $linkname);
					$linkimgjump = iif($linkimg, $linkimgshow, "");
				}
				if (isset($urlInfo['scheme'])) {
					if ($protocol_schemes[$urlInfo['scheme']]["musicbox"]==0) {
						$linkurljump = get_url_atag($linkmode, $linkcatid, $linkid, $linkname, $linkurl, $vbphrase['ll_playme']);
						$linkimgjump = iif ($linkimg, get_url_atag($linkmode, $linkcatid, $linkid, $linkimgshow, $linkurl, $vbphrase['ll_playme']), "");
					}
					if ($links_permissions["can_save_musicbox"] and $protocol_schemes[$urlInfo['scheme']]["savemusicbox"]) {
						$linkurlsave = get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, $vbphrase['ll_save']);
					}
				}
				elseif ($links_permissions["can_save_musicbox"]) {
					$linkurlsave = get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, $vbphrase['ll_save']);
				}
			}
			elseif ($link_known_mimetype) {
				$linkurlsave = get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, iif(is_browser('mozilla'),$vbphrase['ll_visitdownload_moz'],$vbphrase['ll_visitdownload']));
			}

			$linksize = $myrow["linksize"]>1 ? format_bytes($myrow["linksize"], 2) : 0;
		}

		$linkdatebin = $myrow["linkdate"];
		$linkdate	= ldm_date($vbulletin->options['dateformat'], $linkdatebin);

		$linkdateexp = "";
		$linkexpired = 0;
		if ($expire) {
			if ($linkdatebin>TIMENOW+60) {
				$linkexpired = -1;  // post-dated, so just invisible
			}
			elseif ($linkdatebin+$expire<TIMENOW) {
				$expiredids[] = array("linkid"=>$linkid, "catid"=>$linkcatid);
				$linkexpired = +1;
			}
			else {
				$linkdateexp	= ldm_date($vbulletin->options['dateformat'], $linkdatebin+$expire);
			}
		}

		if (array_key_exists("linkrecenthits", $myrow)) {
			$linkhits = $myrow["linkrecenthits"];
		}
		else {
			$linkhits = $myrow["linkhits"];
		}

		$linkhit 	= $thits + 1;
		$linkstatus = $myrow["linkstatus"];
		$linkuserid = $myrow["linkuserid"];
		$linkusername = $myrow["linkusername"];
		$linkmoderate = $myrow["linkmoderate"];
		if ($vbulletin->userinfo['lastvisit'] < $myrow['linkdate']) {
			$linknew = iif (isset($ldm_icon_cache['new']), '<img border="0" src="'.$ldm_icon_cache['new'].'" alt="'.$vbphrase['ll_new'].'" />', $vbphrase['ll_new']);
		}
		else {
			$linknew = 0;
		}
		$linkrate = "";
		$linkraters = $myrow["numrate"];
		if ($linkraters>0) {
			$linkrate = round($myrow["totrate"]/$myrow["numrate"]);
		}

		$linklegendbuttons = 0;
		$linkfavbit = "";
		if ($links_permissions["can_mark_link"]) {
			$linkfav = iif(isset($links_fav[$linkid]),1,0);
			$linkfavicon = $ldm_icon_cache['myfav'];
			eval("\$linkfavbit = \"".fetch_template('links_favbit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		$linkeditbit = "";
		if ($links_permissions['can_edit_link'] or $vbulletin->userinfo['userid']==$linkuserid) {
			$linkediticon = $ldm_icon_cache['pencil'];
			eval("\$linkeditbit = \"".fetch_template('links_editbit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		$linklikebit = "";
		if ($myrow["linkhits"] and $links_defaults['search_like_num']) {
			$linklikeicon = $ldm_icon_cache['similar'];
			eval("\$linklikebit = \"".fetch_template('links_likebit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		if ($links_permissions['can_send_tofriend'] or
			($links_permissions['can_report_link'] and $linkuserid != $vbulletin->userinfo['userid'])) {
			$linklegendbuttons = 1;
		}

	}

	if ($thisid > 0) {
		if ($thits >= $first and $nhits <= $perpage-1) {
			$linkkeys = make_highlighted_keys($linkkeylist, $highlight_find, $highlight_repl);
			$linkkeysraw = implode(' ', $linkkeylist);
			eval("\$linkratebit = \"".fetch_template('links_ratebit')."\";");
			$linkratebit = trim($linkratebit);
			$linkothercatsbit = "";
			$linkshowothercatbit = 0;
			foreach ($linkcatlist as $linkothercat) {
				$linkothercatname = $linkscat[$linkothercat]["catname_clean"];
				if (!$showcatname) $linkshowothercatbit = 1;
				eval("\$linkothercatsbit .= \"".fetch_template('links_othercatsbit')."\";");
			}

			($hook = vBulletinHook::fetch_hook('ldm_linkbit_create')) ? eval($hook) : false;

			if (($linkstatus!=$LINK_HIDDEN and !$linkexpired) or $links_permissions["can_view_hidden"]) {
				eval("\$linklistarray[$linklistarraykey] = \"".fetch_template($template)."\";");
				$linklistarrayids[$linkid] = $linklistarraykey;
				$linklistarraykey++;
				$hitids[$linkid] = $linkcatid;
			}
		}
		if (!$linkexpired or $links_permissions["can_view_hidden"]) {
			$thits ++;
		}
	}

	if ($links_defaults["inline_comment_and_rate"]) {
// patch in the inline ratings
		$linkratings = get_ratingsbits($hitids, $pagenumber, 0, 1);
		foreach ($hitids as $thisid=>$thishit) {
			if (isset($linklistarrayids[$thisid])) {
				$linklistarray[$linklistarrayids[$thisid]] =
					str_replace("<!--$thisid::rate-->", $linkratings[$thisid], $linklistarray[$linklistarrayids[$thisid]]);
			}
		}
	}

	$vbulletin->db->free_result($asb);
	return $thits;
}

function get_typebit($urlInfo, $musicbox_template="") {
	global $ldm_icon_cache, $vbphrase, $vbulletin;

	get_icons();

	$urlType = substr(strrchr(basename($urlInfo['path']), "."), 1);
	$lc_urlType = strtolower($urlType);

	($hook = vBulletinHook::fetch_hook('ldm_linkbit_gettypebit')) ? eval($hook) : false;

	$icon = "";
	$alt = "";
	if (isset($ldm_icon_cache[$lc_urlType])) {
		$alt = $lc_urlType;
		$icon = $ldm_icon_cache[$lc_urlType];
	}
	elseif (isset($ldm_icon_cache[$urlInfo['scheme']])) {
		$alt = $urlInfo['scheme'];
		$icon = $ldm_icon_cache[$alt];
	}

	$linktypebit = '';
	if ($icon) {
		if ($musicbox_template) {
			$linktypebit = sprintf($musicbox_template, '<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$icon).'" alt="'.$vbphrase['ll_playme'].'" />');
		}
		else {
			$linktypebit = '<img border="0" src="'.mk_file_name($vbulletin->options['bburl'],$icon).'" alt="'.$alt.'" />';
		}
		$linktypebit .= '&nbsp;';
	}

	return $linktypebit;

}

function cleanto_width_rows($text, $width, $rows) {
	$maxlength = $width*$rows;
	$newtext = htmlspecialchars_uni(kill_bbcodes($text));
	$sub = "";
	$start = 0;
	$reply = "";
	for ($i=0; $i<$rows; $i++) {
		$sub = substr($newtext, $start, $width);
		if (!$sub) {
			break;
		}
		if ($reply) {
			$reply .= '<br />';
		}
		$pos = strrpos($sub, " ");
		if (!$pos or $pos<($width-10)) {
			$reply .= $sub;
			$start += $width;
		}
		else {
			$reply .= substr($sub, 0, $pos);
			$start += $pos+1;
		}
	}
	return $reply;
}

function get_catextdesc_popupbit($catid) {
	global $linkscat, $links_defaults;
	global $vbphrase, $vbulletin, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$catmouseovertext = "";
	foreach ($linkscat as $thiscat) {
		if ($thiscat['parentid']!=$catid) {
			continue;
		}
		$cattext  = parse_me($thiscat["cattext"]);
		if ($cattext) {
			eval("\$catmouseovertext .= \"".fetch_template("links_catmouseover")."\";");
		}
	}
	return $catmouseovertext;
}

/**
* Return the ratings bits for the selected linkids
*
* @param	intarr	Array of linkids
* @param	int		Current display page number, passed to templates for correct returns
* @param	int		Passed to templates to defined target window
* @return	strarr	Array of constructed ratebits
*/
function get_ratingsbits($linkids, $pagenumber, $target=0, $inline=0) {
	global $vbulletin, $stylevar, $vbphrase;
	global $links_defaults;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$linkratearray = array();
	$linkid = 0;

	if ($inline) {
		$maxrate = $links_defaults["inline_comment_and_rate"];
		$ratetemplate =  'links_viewone_inline_comment';
		$width = $links_defaults["inline_width_comment_and_rate"];
		$rows = $links_defaults["inline_rows_comment_and_rate"];
	}
	else {
		$maxrate = $links_defaults["dropdown_comment_and_rate"];
		$ratetemplate =  'links_viewone_popup_comment';
		$width = $links_defaults["dropdown_width_comment_and_rate"];
		$rows = $links_defaults["dropdown_rows_comment_and_rate"];
	}

	if (count($linkids)) {
		$linkid_list = implode(',', array_keys($linkids));

//		$query = "
//			SELECT lrate, linkid, linkusername, linkvote, lcomment, ltime
//			FROM ".THIS_TABLE."linksrate
//			WHERE linkid IN (".$linkid_list.")
//			ORDER BY linkid ASC, ltime DESC
//		";
		$query = "
			SELECT lrate.lrate AS lrate, lrate.linkid AS linkid, lrate.linkuserid AS linkuserid,
				lrate.linkusername AS linkusername, lrate.linkvote AS linkvote, lrate.lcomment AS lcomment, lrate.ltime AS ltime
				".iif($links_defaults['show_avatars'], ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight')."
			FROM ".THIS_TABLE."linksrate AS lrate
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = lrate.linkuserid)")."
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)")."
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)")."
			WHERE linkid IN (".$linkid_list.")
			ORDER BY linkid ASC, ltime DESC
		";

		$asb = $vbulletin->db->query_read($query);
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if ($myrow['linkid']!=$linkid) {
				if ($linkid) {
					$stage = 3;
					eval("\$linkratearray[$linkid] .= \"".fetch_template($ratetemplate)."\";");
				}
				$numrate = 0;
				$linkid = $myrow['linkid'];
				$viewcatid = $linkids[$linkid];
				$linkid_menu = "ratings".$linkid."_menu";
				$stage = 1;
				eval("\$linkratearray[$linkid] .= \"".fetch_template($ratetemplate)."\";");
			}
			$numrate += 1;
			if ($numrate<=$maxrate) {
				$comment = parse_me(cleanto_width_rows($myrow['lcomment'], $width, $rows));
				$linkusername = $myrow["linkusername"];
				$linkvote	= $myrow['linkvote'];
				$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow['ltime']).' '.ldm_date($vbulletin->options['timeformat'], $myrow['ltime']);
				$linkavatar = get_avatarinfo($myrow);
				$stage = 2;
				eval("\$linkratearray[$linkid] .= \"".fetch_template($ratetemplate)."\";");
			}
			elseif ($numrate==$maxrate+1) {
				$stage = 4;
				eval("\$linkratearray[$linkid] .= \"".fetch_template($ratetemplate)."\";");
			}
		}

		if ($linkid) {
			$stage = 3;
			eval("\$linkratearray[$linkid] .= \"".fetch_template('links_viewone_popup_comment')."\";");
		}
	}
	$vbulletin->db->free_result($asb);
	return $linkratearray;
}

function get_keywordlistbit($linkid=0) {
	global $vbulletin, $stylevar, $links_defaults, $links_permissions;

	$keywordlistbit = "";
	$keys = array();
	$chosen = array();

	$asb = $vbulletin->db->query_read("
		SELECT ltok.linkid AS linkid, ltok.keyid AS keyid, lkeys.keyword AS keyword
		FROM ". THIS_TABLE . "linksltok AS ltok
		LEFT JOIN ". THIS_TABLE . "linkskeys AS lkeys
		ON ltok.keyid=lkeys.keyid
		WHERE linkid='".intval($linkid)."'
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$keys[$rec['keyid']] = $rec['keyword'];
	}

	$myset = array();
	foreach ($keys as $keyid=>$keyword) {
		$selected = 1;
		eval("\$myset[] = \"".fetch_template('links_selectkeyword')."\";");
	}

	$vbulletin->db->free_result($asb);

	$keywordlistbit = map_listbit_to_grid($myset, 5);
	return $keywordlistbit;
}

function get_ldm_tagcloud($limit, $useLogCurve, $minFontSize, $maxFontSize, $weightbyhits) {
	global $links_defaults, $links_permissions;
	global $vbulletin, $vbphrase;

	$limit_aug = $limit + 50; // give some leeway for censored words, etc
	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);

	if ($weightbyhits) {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount1, SUM(link.linkhits) AS keycount, link.linkforum
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON ltok.linkid=link.linkid
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";
	}
	elseif (count($limitfids)<=1) {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";
		}
	else {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount, link.linkforum
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON link.linkid=ltok.linkid
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";
	}

	$asb = $vbulletin->db->query_read($query);
	$nkeys = 0;
	$tags = array();
	while ($rec=$vbulletin->db->fetch_array($asb) and $nkeys<$limit) {
		if ($rec['keycount']<=0 or !trim($rec['keyword'])) continue;
		if ($links_defaults['apply_censor']) {
			if ($rec['keyword'] != fetch_censored_text($rec['keyword'])) continue;
		}
		$tags[$nkeys]['keyword'] = $rec['keyword'];
		$tags[$nkeys]['count'] = $rec['keycount'];
		$nkeys++;
	}
	$vbulletin->db->free_result($asb);

	$fontRange = $maxFontSize - $minFontSize;
	$maxTagCnt = 0;
	$minTagCnt = 10000000;

	foreach ($tags as $tag => $trec) {
		$cnt = $trec['count'];
		if ($cnt > $maxTagCnt) {
			$maxTagCnt = $cnt;
		}
		if ($cnt < $minTagCnt) {
			$minTagCnt = $cnt;
		}
	}
	$tagCntRange = $maxTagCnt+1 - $minTagCnt;

	$minLog = log($minTagCnt);
	$maxLog = log($maxTagCnt);
	$logRange = $maxLog - $minLog;
	if ($maxLog == $minLog) {
		$logRange = 1;
	}

	$tagcloud = array();
	foreach ($tags as $utag => $trec) {
		$cnt = $trec['count'];
		$logcnt = log($cnt);
		$tag = $trec['keyword'];
		$url =  $vbulletin->options['bburl']."/".SEARCH_SCRIPT.".php?action=show&sort=h&keys=1&keyword=".$tag;
		if ($useLogCurve) {
			$fsize = $minFontSize + $fontRange * ($logcnt-$minLog)/$logRange;
		}
		else {
			$fsize = $minFontSize + $fontRange * ($cnt - $minTagCnt)/$tagCntRange;
		}
		$tagcloud[$tag] = '<a href='.$url.' style="font-size:'.(int)$fsize.'px;" title="'.$vbphrase['ll_showkeys'].'">'.$tag.'</a> ';
	}
	ksort($tagcloud);
	$tagcloud = implode(' ', $tagcloud);

	return $tagcloud;
}

// translate a string into a list of lowercase keywords
function explode_keywords($words) {
	if (trim($words)) {
		return preg_split("/[,;\s]+/", strtolower($words));
	}
	else {
		return array();
	}
}

// Return array of indices for keywords in $list, in the process adding new words to the keyword table
function lookup_keywords($list) {
	global $vbulletin;

	$indices = array();
	if (!count($list)) return $indices;

	$words = array();
	foreach ($list as $w) {
		if (!in_array($w, $words)) $words[] = $vbulletin->db->escape_string($w);
	}

	$query = "
		SELECT keyid, keyword
			FROM ". THIS_TABLE . "linkskeys
			WHERE keyword IN ('".implode("', '", $words)."')
			";
	$asb = $vbulletin->db->query_read($query);
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		foreach ($words as $k=>$w) {
			if ($rec['keyword']==$w) {
				$indices[$k] = $rec['keyid'];
			}
		}
	}
	$vbulletin->db->free_result($asb);

	foreach ($words as $k=>$w) {
		if (!isset($indices[$k])) {
			$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linkskeys
				SET
					keyword='".$vbulletin->db->escape_string($w)."'
			");
			$indices[$k] = $vbulletin->db->insert_id();
		}
	}

	return $indices;
}

// (De)associate keywords with linkid according to $add
function associate_keywords($linkid, $keyids, $add) {
	global $vbulletin;

	if (!is_array($linkid)) {
		$linkids = array($linkid);
	}
	else {
		$linkids = $linkid;
	}

	switch ($add) {
	case -1: // deassociate
	case  1: // add to current list
		if (count($keyids) and count($linkids)) {
			$query = "
				DELETE FROM ".THIS_TABLE."linksltok
				WHERE keyid IN (".implode(',', $keyids).")
				AND linkid IN  (".implode(',', $linkids).")
			";
			$vbulletin->db->query_write($query);
		}
		break;

	case  0: // only these words
		$query = "
			DELETE FROM ".THIS_TABLE."linksltok
			WHERE linkid='".intval($linkid)."'
			";
		$vbulletin->db->query_write($query);
		break;
	}

	switch ($add) {
	case  0:
	case  1:
		foreach ($keyids as $kid) {
			if ($kid) {
				foreach ($linkids as $lid) {
					if ($lid) {
						$query = "
						INSERT INTO ".THIS_TABLE."linksltok
						SET
							linkid='".$lid."',
							keyid='".intval($kid)."'
						";
						$vbulletin->db->query_write($query);
					}
				}
			}
		}
		break;

	case -1:
		break;
	}

}

// -----------------------------------------------------------------------------
// Link creation/deletion functions
// -----------------------------------------------------------------------------

/**
* Move expired entries to holding categories when appropriate
*
* @param	array	Array of arrays("linkid"=>LID, "catid"=>"CID")
* @return	int		Number of entries moved to new categories
*/

function process_ldm_expired($expiredids) {
	global $links_defaults, $linkscat;
	global $vbulletin;

	$lastcatid = -1;
	$moved = 0;
	foreach ($expiredids as $expirek) {
		$thiscatid = $expirek["catid"];
		if ($thiscatid<=0) {
			continue;
		}
		if ($thiscatid!=$lastcatid) {
			$expirecatid = lookup_setting($thiscatid, 'links_expired_catid');
			$lastcatid = $thiscatid;
		}
		if ($expirecatid<=0 or $expirecatid==$thiscatid) {
			continue;
		}
		$thisid = $expirek["linkid"];

		$query = "
			UPDATE ".THIS_TABLE."linksltoc
			SET
				catid='".intval($expirecatid)."'
			WHERE linkid='".intval($thisid)."'
			AND catid='".intval($thiscatid)."'
			";
		$vbulletin->db->query_write($query);
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkforum='".$linkscat[$expirecatid]['catforum']."'
			WHERE linkid='".intval($thisid)."'
			";
		$vbulletin->db->query_write($query);
		$moved++;
	}

	if ($moved) {
		fix_cat_count();
	}

	return $moved;
}


// Create new link and returns an array (1, newlinkid) if ok
// If the url already exists in the database, test value of allowduplicate:
//   =1:  create a new entry; return (1, newlinkid)
//   =0:  do not create new entry; return (0, oldlinkid)
//   =-1: make no changes to the database; return (-1, oldlinkid)

function create_ldm_entry($username, $userid, $linkname, $linkdoi, $linkurl, $linkfile, $linkimg, $linkdesc,
						$pforum, $filesize, $linkstatus, $linkimgstatus, $imgthumb, $imgthumbsize,
						$moderate, $linkreviewfreq, $linkdate=TIMENOW, $allowduplicate=1) {
	global $vbulletin;

	$insert = 1;
	$linkid = -1;

	$asb = $vbulletin->db->query_read("
		SELECT linkid FROM ".THIS_TABLE."linkslink
		WHERE linkurl='".$vbulletin->db->escape_string($linkurl)."'
		");
	$count = $vbulletin->db->num_rows($asb);
	$vbulletin->db->free_result($asb);

	if ($allowduplicate != 1 and $count) {
		$myrow = $vbulletin->db->fetch_array($asb);
		$linkid = $myrow["linkid"];
		return array($allowduplicate, $linkid);
	}

	$query = "
		INSERT INTO ".THIS_TABLE."linkslink
		SET
			linkname='".$vbulletin->db->escape_string($linkname)."',
			linkdoi='".$vbulletin->db->escape_string($linkdoi)."',
			linkurl='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkurl))."',
			linkfile='".$vbulletin->db->escape_string($linkfile)."',
			linkimg='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkimg))."',
			linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $imgthumb))."',
			linkimgthumbsize='".intval($imgthumbsize)."',
			linkdesc='".$vbulletin->db->escape_string($linkdesc)."',
			linkhits='0',
			linkforum='".intval($pforum)."',
			linkcheck=".TIMENOW.",
			linksize='".intval($filesize)."',
			linkstatus='".intval($linkstatus)."',
			linkimgstatus='".intval($linkimgstatus)."',
			linkdate=".$linkdate.",
			linkusername='".$vbulletin->db->escape_string(htmlspecialchars_uni($username))."',
			linkuserid='".intval($userid)."',
			linkmoderate='".intval($moderate)."',
			linkreviewfreq='".intval($linkreviewfreq)."'
		";
	$vbulletin->db->query_write($query);
	$linkid = $vbulletin->db->insert_id();

	return array(1, $linkid);

}

function insert_link_in_ldm_category ($linkid, $pcatid, $displayorder=0, $moderate=0) {
	global $vbulletin;
	global $linkscat;

	foreach ($pcatid as $k=>$p) {
		$do = iif(is_array($displayorder), $displayorder[$k], 1);
		$vbulletin->db->query_write("
			REPLACE INTO ".THIS_TABLE."linksltoc (linkid, catid, displayorder)
			VALUES ('".intval($linkid)."', '".intval($p)."', '".intval($do)."')
		");
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat
			SET
				catentry=catentry+1,
				catdate=".TIMENOW."
			WHERE catid='".intval($p)."'
			LIMIT 1
		");
		$linkscat[$p]['catentry']+=1;
		$linkscat[$p]['catdate']=TIMENOW;
	}

}

// Delete one or an array of links and tidy up
function delete_ldm_entry($linkid) {
	global $vbulletin, $LINK_UPLOAD;

	if (!is_array($linkid)) {
		$ids = $linkid;
	}
	else {
		if (count($linkid)<=0) return;
		$ids = implode(',', $linkid);
	}

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkurl
		FROM ". THIS_TABLE . "linkslink
		WHERE linkstatus=" . $LINK_UPLOAD ."
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		delete_upload($rec['linkurl']);
	}
	$vbulletin->db->free_result($asb);

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkimg
		FROM ". THIS_TABLE . "linkslink
		WHERE linkimgstatus=" . $LINK_UPLOAD ."
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		delete_upload($rec['linkimg']);
	}
	$vbulletin->db->free_result($asb);

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkimgthumb
		FROM ". THIS_TABLE . "linkslink
		WHERE linkimgthumb!=''
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		delete_thumb($rec['linkimgthumb']);
	}
	$vbulletin->db->free_result($asb);

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linkslink
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksltoc
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksfavs
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksltok
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksrate
		WHERE linkid IN (". $ids .")
		");

}

// Category creation
function create_ldm_category ($username, $userid, $catname, $catdesc, $cattext, $pcatid, $pcatlist,
						$pforum, $moderate, $catsyncdir, $display_order, $catdate=TIMENOW, $catclosed=0) {
	global $vbulletin;
	global $links_defaults, $linkscat;

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linkscat
		SET
			catname='".$vbulletin->db->escape_string($catname)."',
			catdesc='".$vbulletin->db->escape_string($catdesc)."',
			cattext='".$vbulletin->db->escape_string($cattext)."',
			parentid='".$pcatid."',
			parentlist='".$pcatlist."',
			catforum='".$pforum."',
			catusername='".$vbulletin->db->escape_string($username)."',
			catuserid=".$userid.",
			catentry='0',
			catdate='".$catdate."',
			catmoderate='".$moderate."',
			catsyncdir='".$vbulletin->db->escape_string($catsyncdir)."',
			catsynctime='0',
			catsyncdone='0',
			displayorder='".intval($display_order)."',
			catclosed='".intval($catclosed)."'
		");
	$catid = $vbulletin->db->insert_id();

	if ($catid) {
		get_linkscat();
	}

	return $catid;
}

// Empty one or more categories and optionally all its subcategories
// NB: entries that also appear in other categories remain in these categories
function empty_ldm_category($catid, $empty_subcats=0) {
	global $vbulletin;
	global $linkscat;

	if (!is_array($catid)) {
		$catlist = array($catid);
	}
	else {
		$catlist = $catid;
	}

	if ($empty_subcats) {
		foreach ($linkscat as $thiscat) {
			if (!isset($thiscat['catid'])) continue;
			$parentlist = explode(',',$thiscat['parentlist']);
			foreach ($catlist as $c) {
				if (in_array($c,$parentlist)) {
					$catlist[] = $thiscat['catid'];
				}
			}
		}
	}

	if (!count($catlist)) return;

	$cids = implode(',', $catlist);
	$ids = array();

	$query = "
		SELECT linkid, catid
			FROM ".THIS_TABLE."linksltoc
			WHERE catid IN (".$cids.")
		";

	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$ids[$myrow['linkid']] = $myrow['linkid'];
	}
	$vbulletin->db->free_result($asb);
	if (!count($ids)) return;

	$query = "
		DELETE FROM ".THIS_TABLE."linksltoc
			WHERE catid IN (".$cids.")
		";
	$asb = $vbulletin->db->query_write($query);

// check for links that are in multiple categories
	$query = "
		SELECT linkid, catid
			FROM ".THIS_TABLE."linksltoc
			WHERE linkid IN (".implode(',',$ids).")
		";
	$asb = $vbulletin->db->query_read($query);

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		unset($ids[$myrow['linkid']]);
	}
	$vbulletin->db->free_result($asb);

	if (!count($ids)) return;

	delete_ldm_entry($ids);

}

// Delete one or more categories and all subcategories:
// NB: Call empty_ldm_category first to remove entries
function delete_ldm_category($catid) {
	global $vbulletin;
	global $linkscat;

	if (!is_array($catid)) {
		$catlist = array($catid);
	}
	else {
		$catlist = $catid;
	}

	foreach ($linkscat as $thiscat) {
		if (!isset($thiscat['catid'])) continue;
		$parentlist = explode(',',$thiscat['parentlist']);
		foreach ($catlist as $c) {
			if (in_array($c,$parentlist)) $catlist[] = $thiscat['catid'];
		}
	}

	if (!count($catlist)) return;

	$ids = implode(',', $catlist);

	require_once(DIR . '/includes/local_links_forumsinterface.php');
	foreach ($catlist as $thiscatid) {
		ldm_insert_cat_in_forum(-1, $thiscatid, $linkscat[$thiscatid]['catforumlink']);
	}

	$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linkscat
			WHERE catid IN (".$ids.")
			");

	$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksadmin
			WHERE catid IN (".$ids.")
			");

	foreach ($catlist as $id) {
		unset($linkscat[$id]);
	}

}

// Record a hit, catching double clicks within timeout period

function record_hit($id, $url, $status, $size=0) {
	global $vbulletin, $links_permissions, $links_defaults, $LINK_BROKEN, $_SERVER;

	if ($links_defaults["prune_downloadtable"]>0) {
		$when = TIMENOW-24*60*60*intval($links_defaults["prune_downloadtable"]);
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksdownloads
			WHERE usertime<'".$when."'
		");
	}

	if ($links_permissions["can_bypass_hit_recording"]) {
		return;
	}

	$userip = iif (isset($_SERVER[REMOTE_ADDR]), $_SERVER[REMOTE_ADDR], 'unknown');
	$username = $vbulletin->userinfo['username'];
	$userid = $vbulletin->userinfo['userid'];

	$time = TIMENOW;
	if ($links_defaults["timeout_hit_recording"]>0) {
		$timeout = $time - $links_defaults["timeout_hit_recording"];
		$jumplink = $vbulletin->db->query_read("
			SELECT * FROM ".THIS_TABLE."linksdownloads
			WHERE linkid='".$id."'
			AND userid='".$userid."'
			AND usertime>'".$timeout."'
			LIMIT 1
			");
		if ($vbulletin->db->num_rows($jumplink)>0) {
			return(-1);
		}
	}

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkstatus
		FROM ".THIS_TABLE."linkslink
		WHERE linkid='".intval($id)."'
		LIMIT 1
		");

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if ($status == $LINK_BROKEN and $myrow['linkstatus'] != $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkstatus=".intval($status)."
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
		elseif ($status != $LINK_BROKEN and $myrow['linkstatus'] == $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkhits=linkhits+1,
					linkstatus=".intval($status)."
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
		elseif ($status != $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					".iif($size, "linksize=".intval($size)."," , "")."
					linkhits=linkhits+1
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
	}

	if ($status != $LINK_BROKEN) {
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linksdownloads
			SET
				linkid='".intval($id)."',
				linkurl='".$vbulletin->db->escape_string($url)."',
				username='".$vbulletin->db->escape_string(htmlspecialchars_uni($username))."',
				userid='".$userid."',
				userip='".$userip."',
				usertime=".$time.",
				bytes=".iif($links_permissions['can_bypass_bandwidth_limits'], 0, intval($size))."
		");
	}

	($hook = vBulletinHook::fetch_hook('ldm_record_hit')) ? eval($hook) : false;

	return(0);
}

// Return an appropriate message explaining why nothing is being displayed
function ldm_emptypage_warning($catid) {
	global $linkscat, $vbphrase, $vbulletin;

	if (!count($linkscat)) {
		return construct_phrase($vbphrase['ll_empty_database'], iif ($links_defaults['database_name'], $links_defaults['database_name'], $vbphrase['ll_links_database']));
	}

	$empty = 1;
	if ($catid) {
		foreach ($linkscat as $thiscat) {
			if ($thiscat['parentid']==$catid) {
				$empty = 0;
				break;
			}
		}
		if (!$hit) {
			$myrow = $vbulletin->db->query_first("
				SELECT COUNT(linkid) AS linkhits
				FROM ".THIS_TABLE."linksltoc
				WHERE catid='".intval($catid)."'
				");
			if ($myrow['linkhits']) {
				$empty = 0;
			}
		}
		if ($empty) {
			return $vbphrase['ll_empty_category'];
		}
	}

	return $vbphrase['ll_nothing_visible_to_user'];

}

?>