<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links');

if (empty($_REQUEST['action'])) $_REQUEST['action'] = "links";
if (empty($_REQUEST['do'])) $_REQUEST['do'] = $_REQUEST['action'];

// get special phrase groups
$phrasegroups = array(
	'local_links', 'threadmanage', 'posting', 'postbit', 'timezone',
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_access_error',
	'links_agreement',
	'links_agreement_declined',
	'links_bandwidthbit',
	'links_catbit',
	'links_catbit_brief',
	'links_catbit_extras',
	'links_catjump',
	'links_catmouseover',
	'links_catsortbit',
	'links_downloadbit',
	'links_editbit',
	'links_favbit',
	'links_footer',
	'links_header',
	'links_hitparade',
	'links_imgmag',
	'links_introbit',
	'links_likebit',
	'links_linkbit',
	'links_linkbit_featured',
	'links_linkbit_greg',
	'links_linkbit_jukebox',
	'links_linkbit_mtop',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkseparator',
	'links_listselect',
	'links_main',
	'links_othercatsbit',
	'links_playerbit_WimpyButton',
	'links_ratebit',
	'links_ratesortbit',
	'links_report',
	'links_scantext',
	'links_search',
	'links_search_catselect',
	'links_selectkeyword',
	'links_sendemail',
	'links_subcatbit',
	'links_timebit',
	'links_uploadinfo',
	'links_viewone_inline_comment',
	'links_viewone_popup_comment',

	'navbar',
	'option',

	);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'play' => array(
		'links_linkbit_jukebox',
		'links_play_embedded',
		'links_play_standalone',
		'links_playbit',
		'links_playerbit_DivX',
		'links_playerbit_MediaPlayer',
		'links_playerbit_QuickTime',
		'links_playerbit_RealPlayer',
		'links_playerbit_Wimpy',
		'links_playerbit_WimpyFlash',
	),
	'addcat' => array(
		'links_addnewcat',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_catinput_one',
		'links_admin_oneperm',
		'links_admin_oneperm_end',
		'links_admin_onesetting',
		'links_admin_onesetting_end',
		'links_admin_onesetting_start',
		'links_admin_setting_foot',
		'links_admin_setting_title',
	),
	'editcat' => array(
		'links_addnewcat',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_admin_oneperm',
		'links_admin_oneperm_end',
		'links_admin_onesetting',
		'links_admin_onesetting_end',
		'links_admin_onesetting_start',
		'links_admin_setting_foot',
		'links_admin_setting_title',
	),
	'addlink' => array(
		'editor_clientscript',
		'editor_jsoptions_font',
		'editor_jsoptions_size',
		'editor_smilie',
		'editor_smiliebox',
		'editor_smiliebox_row',
		'editor_smiliebox_straggler',
		'editor_toolbar_off',
		'editor_toolbar_on',
		'links_addnewlink',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'newpost_disablesmiliesoption',
	),
	'addmultilink' => array(
		'editor_clientscript',
		'editor_jsoptions_font',
		'editor_jsoptions_size',
		'editor_smilie',
		'editor_smiliebox',
		'editor_smiliebox_row',
		'editor_smiliebox_straggler',
		'editor_toolbar_off',
		'editor_toolbar_on',
		'links_addnewmultilink',
		'links_addnewmultilink_one',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'newpost_disablesmiliesoption',
	),
	'editlink' => array(
		'editor_clientscript',
		'editor_jsoptions_font',
		'editor_jsoptions_size',
		'editor_smilie',
		'editor_smiliebox',
		'editor_smiliebox_row',
		'editor_smiliebox_straggler',
		'editor_toolbar_off',
		'editor_toolbar_on',
		'links_addnewlink',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'newpost_disablesmiliesoption',
	),
	'ratelink' => array(
		'editor_clientscript',
		'editor_jsoptions_font',
		'editor_jsoptions_size',
		'editor_smilie',
		'editor_smiliebox',
		'editor_smiliebox_row',
		'editor_smiliebox_straggler',
		'editor_toolbar_on',
		'links_viewall_comment',
		'links_viewone_comment',
		'newpost_disablesmiliesoption',
	),
	'iframe' => array(
		'links_iframed',
		'links_linkbit_jukebox',
	),
	'jump' => array(
		'links_mirror_select',
		'links_mirror_select_one',
	),
	'mod' => array(
		'links_moderate_main',
		'links_moderate_catbit',
		'links_moderate_catbit_null',
	),
	'reportlink' => array(
		'imagereg',
	),
);

// fire up VBulletin backend
require_once('./global.php');

if (!$vbulletin->products[THIS_PRODUCT_NAME]) {
	eval(standard_error($vbphrase['ll_error_product_disabled']));
	exit;
}

if (!empty($vbulletin->db->explain)) {
	$vbulletin->db->timer_start('Including LDM Initialisation Functions.php');
	require_once(DIR . '/includes/local_links_init.php');
	require_once(DIR . '/includes/local_links_include.php');
	$vbulletin->db->timer_stop(false);
}
else {
	require_once(DIR . '/includes/local_links_init.php');
	require_once(DIR . '/includes/local_links_include.php');
}

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;

// Abbreviated quick jump .. script.php?go=N
if (array_key_exists('go', $_REQUEST)) {
	$_REQUEST['action'] = "jump";
	$_REQUEST['linkid'] = intval($_REQUEST['go']);
	unset($_REQUEST['go']);
}

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT,
	));

$this_action = iif($vbulletin->GPC_exists['action'], $vbulletin->GPC['action'], "links");

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) {
		$perpage = $vbulletin->options['maxposts'];
	}
	$perpage = iif($links_defaults['links_per_page']!=0, $links_defaults['links_per_page'], $perpage);
}

$pagenumber = iif($vbulletin->GPC_exists['page'],$vbulletin->GPC['page'],1);
$master_title = htmlspecialchars_uni(iif ($links_defaults['database_name'], $links_defaults['database_name'], $vbphrase['ll_links_database']));

// Process 'accept me' form.  User's agreement used to be recorded in a cookie, but this proved
// unreliable, so now we set an entry in the links_downloads table with linkid=0.  Acceptance good
// until 24 hours after that record's timestamp...
function lookup_ldm_accept() {
	global $vbulletin, $links_defaults;

	if (!$links_defaults['force_accept']) {
		return 1;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'ldm_accept_form' => TYPE_STR,
		));

	$ldm_accept = 0;
	if ($vbulletin->GPC_exists['ldm_accept_form']) {
		$ldm_accept = $vbulletin->GPC['ldm_accept_form'];
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=0
			AND userid=".$vbulletin->userinfo['userid']."
			");
		if ($ldm_accept>0) {
			$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksdownloads
				SET
					linkid=0,
					linkurl='Accepts site terms',
					bytes=0,
					userid='".$vbulletin->userinfo['userid']."',
					username='".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."',
					usertime='".TIMENOW."',
					userip='".iif(isset($_SERVER[REMOTE_ADDR]), $_SERVER[REMOTE_ADDR], 'unknown')."'
				");
		}
	}
	else {
		$asb = $vbulletin->db->query_read("
			SELECT linkid, userid, usertime
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=0
			AND ".
				iif($vbulletin->userinfo['userid'],
					"userid='".$vbulletin->userinfo['userid']."'",
					"userid='0' AND userip='".iif(isset($_SERVER[REMOTE_ADDR]), $_SERVER[REMOTE_ADDR], 'unknown')."'"
					)."
			ORDER BY usertime DESC
			LIMIT 1
		");
		if ($vbulletin->db->num_rows($asb)) {
			$ldm_accept_timeout = 24*60*60; // one day
			$rec = $vbulletin->db->fetch_array($asb);
			if (($rec['usertime']+$ldm_accept_timeout)>TIMENOW) {
				$ldm_accept = 1;
			}
		}
	}
	return $ldm_accept;
}

/* ===========================================================================*/
// Main command functions
/* ===========================================================================*/

if ($this_action == "links") {

	($hook = vBulletinHook::fetch_hook('ldm_maindisplay_begin')) ? eval($hook) : false;

	construct_forum_jump();

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);
	$vbulletin->input->clean_array_gpc('r', array(
		'catid'	=> TYPE_INT,
		'doi' => TYPE_STR,
		'keyid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'ratings' => TYPE_INT,
		'resync' => TYPE_INT,
		'sort'	=> TYPE_STR,
		));

	if ($vbulletin->GPC['linkid']) {
		$viewlinkid = $vbulletin->GPC['linkid'];
		$asb = $vbulletin->db->query_read("
				SELECT link.linkname AS linkname, ltoc.catid AS linkcatid, link.linkurl AS linkurl
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				WHERE link.linkid='".$viewlinkid."'
				");
		$catids = array();
		unset($viewlinkname);
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			$viewlinkname = $rec['linkname'];
			$viewlinkurl = $rec['linkurl'];
			$catids[] = $rec['linkcatid'];
		}
		$vbulletin->db->free_result($asb);
		if (!isset($viewlinkname)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).
				$vbphrase['ll_goback']));
			exit;
		}
		elseif ($vbulletin->GPC['catid']) {
			if (!in_array($vbulletin->GPC['catid'], $catids)) {
				$newurl = get_url_atag(-2, $catids[0], $viewlinkid, $viewlinkname);
// implement as a 301 redirect
				@header( "HTTP/1.1 301 Moved Permanently" );
				@header( "Location: ".$newurl );
				exit;
			}
		}
		else {
			$viewlinkcatid = $catids[0];
		}
	}
	elseif ($vbulletin->GPC['doi']) {
		$viewdoi = $vbulletin->GPC['doi'];
		$rec = $vbulletin->db->query_first("
				SELECT link.linkid AS linkid, link.linkname AS linkname, ltoc.catid AS linkcatid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				WHERE link.linkdoi LIKE ('".$vbulletin->db->escape_string($viewdoi)."')
				LIMIT 1
				");
		if (!isset($rec['linkname'])) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_doi'], $viewdoi).
				$vbphrase['ll_goback']));
			exit;
		}
		$viewlinkid = $rec['linkid'];
		$viewlinkname = $rec['linkname'];
		$viewlinkcatid = $rec['linkcatid'];
	}
	else {
		$viewlinkid = 0;
	}

	if ($vbulletin->GPC['catid']) {
		$viewcatid = $vbulletin->GPC['catid'];
	}
	elseif ($viewlinkid) {
		$viewcatid = $viewlinkcatid;
	}
	else {
		$viewcatid = $BASE_CAT;
	}

	if ($vbulletin->GPC['keyid']) {
		$viewkeyid = $vbulletin->GPC['keyid'];
	}

	if (!$vbulletin->GPC['sort']) {
		$vbulletin->GPC['sort']=="";
		$sort = iif(isset($links_defaults['default_sort_order']), $links_defaults['default_sort_order'], 'N');
	}
	else {
		$sort = $vbulletin->GPC['sort'];
	}

	if (isset($linkscat[$viewcatid]) and in_array($linkscat[$viewcatid]["catforum"], $limitfids)) {
		print_no_permission();
		exit;
	}

	$resync = $vbulletin->GPC['resync'];

	$viewcatstats = $viewcatstatstitle = $viewcathits = $viewcathitstitle = "";

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($viewcatid>0) {

		if (!catid_is_valid($viewcatid)) {
			eval(standard_error($vbphrase['ll_error_category'].'<br /><br />'.$vbphrase['ll_goback']));
			exit;
		}

		$viewcatforum = $linkscat["$viewcatid"]["catforum"];
		if ($viewcatforum>0) {
			$foruminfo = fetch_foruminfo($viewcatforum);
			verify_forum_password($viewcatforum, $foruminfo["password"]);
		}

		if ($links_defaults['sync_enabled'] and $linkscat[$viewcatid]['catsyncdir']) {
			require_once(DIR . '/includes/local_links_misc.php');
			synchronise_ldm_category($viewcatid, iif($resync, $links_defaults['sync_maxcpu_allowed_manual'], $links_defaults['sync_maxcpu_allowed']), $resync);
		}

		$viewcatname  = parse_me($linkscat["$viewcatid"]["catname"]);
		$viewcatdesc  = parse_me($linkscat["$viewcatid"]["catdesc"]);
		$viewcattext  = parse_me($linkscat["$viewcatid"]["cattext"]);
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		if (!$viewlinkid) {
			$navbits[""] = $linkscat["$viewcatid"]["catname_clean"];
		}
		else {
			$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
			$navbits[""] = parse_me($viewlinkname);
		}
		if ($linkscat["$viewcatid"]["catforumlink"]>0 and $linkscat["$viewcatid"]["catforum"]>0) {
			$viewcatforumname = $foruminfo['title_clean'];
			get_icons();
			$viewcatforumicon = iif(isset($ldm_icon_cache['forum_link']),'<img border="0" src="'.$ldm_icon_cache['forum_link'].'" alt="'.$vbphrase['ll_linkedforum'].'" />',"");
		}
		else {
			$viewcatforum = "";
		}
		if ($links_defaults['show_hit_parade'] == 2) {
			$viewcatstats = "";
			$viewcatstatstitle = "";
			$viewcathits  = get_ldm_hitparade($viewcatid);
			if ($links_defaults["days_seen_on_portal"]) {
				$sincewhen = $links_defaults["days_seen_on_portal"];
			}
			else {
				$sincewhen = intval((TIMENOW-$vbulletin->userinfo['lastvisit'])/(24*60*60));
			}
			$viewcathitstitle = construct_phrase($vbphrase['ll_charts'], $sincewhen);
		}
	}
	elseif ($viewcatid == $BASE_CAT) {
		$viewcatdesc  = $viewcattext  = $viewcatforum = "";
		$viewcatname  = $master_title;
		if ($links_defaults['show_hit_parade']) {
			$viewcathits  = get_ldm_hitparade($BASE_CAT);
			if ($links_defaults["days_seen_on_portal"]) {
				$sincewhen = $links_defaults["days_seen_on_portal"];
				$viewcatstats = get_ldm_summary();
			}
			else {
				$sincewhen = intval((TIMENOW-$vbulletin->userinfo['lastvisit'])/(24*60*60));
			}
			$viewcathitstitle = construct_phrase($vbphrase['ll_charts'], $sincewhen);
		}
	}
	else {
		eval(standard_error($vbphrase['ll_error_category'].' '.$vbphrase['ll_goback']));
		exit;
	}

	if ($viewcatid>0 and $viewlinkid>0) {
		$this_navigation_title = $master_title . ' - ' . $linkscat["$viewcatid"]["catname_clean"] . ' - ' . htmlspecialchars_uni(kill_bbcodes($viewlinkname));
	}
	elseif ($viewcatid>0) {
		$this_navigation_title = $master_title . ' - ' . $linkscat["$viewcatid"]["catname_clean"];
	}
	else {
		$this_navigation_title = $master_title;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	if ($vbulletin->GPC['linkid'] and !$viewlinkurl) {
// We're viewing a single entry that has no url.  Treat it as a hit
		require_once(DIR . '/includes/local_links_misc.php');
		$hit = record_hit($vbulletin->GPC['linkid'], construct_phrase($vbphrase['ll_null_link'], $viewlinkname), $LINK_OK);
	}

	$linklistbit = $linkratingspopupbit = "";
	$linklistarray = array();
	if ($viewcatid>0) {

		$joinfavs = 0;
		$query = array();
		$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
		$query[] = "ltoc.catid = '".$viewcatid."'";

		if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
			if ($vbulletin->userinfo['userid'] == 0) {
				$query[] = "link.linkmoderate = $LINK_ACCEPTED";
			}
			else {
				$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
					(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
			}
		}

		$showcatname = 0;
		if ($viewlinkid) {
			$query[] = "link.linkid = '".$viewlinkid."'";
			$showcatname = 1;
		}

		if ($viewkeyid) {
			$query[] = "lkeys.keyid = '".$viewkeyid."'";
		}

		$forcedisplayorder = 1;
		$sorder = get_sortsql($sort, 1);
		$forcedisplayorder = 0;

		get_linksfav();

		$template = $links_defaults["template_linkbit"];
		$allowlinkexpand = iif($viewlinkid or !$ldm_linkbitcache[$template]["collapse"], 0, 1 );
		if ($viewlinkid) {
			$template = iif($ldm_linkbitcache[$template]["altbit"],$ldm_linkbitcache[$template]["altbit"],$links_defaults["template_altbit"]);
		}
		elseif ($allowlinkexpand and isset($vbcollapse['collapsecel_linkrefreshbit'])) {
			$template = $ldm_linkbitcache[$template]["collapse"];
		}

		if (is_numeric($sort)) {
			$sortsince = TIMENOW - $sort*24*60*60;
		}
		else {
			$sortsince = "";
		}

		$query = get_mainsql($query, $sortsince, $joinfavs, $sorder, "", $links_defaults['links_show_othercats'], 1);
		$ncols = iif($viewlinkid, 1, linkbit_columns($template));
		$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);
		$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", $showcatname, $forcedisplayorder, $pagenumber, $thispage);
		$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

		$linkratings = get_ratingsbits($hitids, $pagenumber);
		$linkratingspopupbit = implode("", $linkratings);
		process_ldm_expired($expiredids);

		$pagenav = construct_page_nav($pagenumber, $thispage, $nhits, $LINKS_SCRIPT.".php?catid=$viewcatid&amp;sort=$sort", "&amp;pp=$thispage");

	}

	$emptylistbit = "";
	$linkerrorbit = "";
	if ($viewcatid>0 and !$nhits) {
		if ($vbulletin->GPC['linkid']) {
			eval("\$linkerrorbit = \"".fetch_template('links_access_error')."\";");
		}
		elseif (is_numeric($sort)) {
			$emptylistbit = $vbphrase['ll_zerohits_sort'];
		}
	}

	$pcatid   = $linkscat[$viewcatid]["parentid"];
	$catstyle = 1;

	unset ($thisorder);

	$catlistarray = array();
	if (!$viewlinkid) {
		$cattree = cat_walk($viewcatid, $links_defaults['cat_depth_display'], $sort);
		$cat_template = $links_defaults['template_catbit'];
		foreach ($cattree AS $thisid=>$thischildren) {
			get_catlistbit($catlistarray, $cat_template, $ldm_catbitcache[$cat_template]['subbit'], $thisid, $thischildren, 0);
		}
		$catlistbit = map_listbit_to_grid($catlistarray, catbit_columns($cat_template));
		$catfulltextpopupbit = "";
		if ($links_defaults['cat_desc_popup']) {
			$catfulltextpopupbit = get_catextdesc_popupbit($viewcatid);
		}
	}

	$linkfeatbit = "";
	$flinklistarray = array();
	if ($links_defaults['featured_user_favs'] and $links_defaults['featured_sites'] and !$viewlinkid) {
		$feat_users = lookup_userids(explode(';', $links_defaults['featured_user_favs']));
		$feat_users[] = -1;
		$joinfavs = 1;
		$fquery[] = "lfav.userid IN (".implode(',', $feat_users).")";
		$fquery[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
		if (!$links_defaults['featured_all_categories'] and $viewcatid>0) {
			$fquery[] = "ltoc.catid = '".$viewcatid."'";
		}
		$query = get_mainsql($fquery, 0, 1, "RAND()", $links_defaults['featured_sites'], 0);
		$nhits = get_linklistbit($flinklistarray, $hitids, $expiredids, $links_defaults['featured_linkbit'], $query, "", 1);
		$linkfeatbit = map_listbit_to_grid($flinklistarray, 1);
	}

	$catuserid   = $linkscat[$viewcatid]["catuserid"];

	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
		$links_permissions["can_edit_category"] = 1;
	}

	$catclosed = $linkscat[$viewcatid]["catclosed"];
	if ($catclosed) {
		if (!$links_permissions["can_admin_links"]) {
			$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
			$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
		}
	}
	$catsync = $catsync_next = $catsync_last = "";
	if ($links_defaults['sync_enabled'] and $linkscat[$viewcatid]['catsyncdir']) {
		$links_permissions["can_add_link"] = 0;
		if ($linkscat[$viewcatid]['catsynctime']) {
			$catsync_last = ldm_date($vbulletin->options['dateformat'], $linkscat[$viewcatid]['catsynctime']).' '.ldm_date($vbulletin->options['timeformat'], $linkscat[$viewcatid]['catsynctime']);
		}
		else {
			$catsync_last = $vbphrase['ll_never'];
		}
		$catsync_last = construct_phrase($vbphrase['ll_synctime_last'], $catsync_last);
		if ($linkscat[$viewcatid]['catsyncdone']) {
			$catsync_done = "";
			if ($links_defaults['sync_freq']>0) {
				$catsync_next = ldm_date($vbulletin->options['dateformat'], $links_defaults['sync_freq']+$linkscat[$viewcatid]['catsynctime']).' '.ldm_date($vbulletin->options['timeformat'], $links_defaults['sync_freq']+$linkscat[$viewcatid]['catsynctime']);
				$catsync_next = construct_phrase($vbphrase['ll_synctime_next'], $catsync_next);
			}
			else {
				$catsync_next = $vbphrase['ll_synctime_manual'];
			}
		}
		else {
			$catsync_done = $vbphrase['ll_sync_notcompleted'];
			if ($links_defaults['sync_freq']<=0) {
				$catsync_next = $vbphrase['ll_synctime_manual'];
			}
		}
	}

	$searchnav = 1;
	if ($vbulletin->GPC['linkid'] or $viewcatid<0 or (!$linklistbit and !is_numeric($sort))) {
		$searchnav = 0;
	}

	if ($searchnav) {
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = make_hidden_vars(array("catid"=>$viewcatid, "keyid"=>$viewkeyid, "page"=>1, "pp"=>$perpage));
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
		$keyfilterbit = construct_keyword_list("keyid", $viewcatid, $viewkeyid);
		if ($keyfilterbit) {
			$keyreturnbit = make_hidden_vars(array("catid"=>$viewcatid, "sort"=>$sort, "page"=>1, "pp"=>$perpage));
		}
	}

	$catjumpbit = "";
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = construct_category_list(array($viewcatid), "links_catjump", 0, "catid", "catid", 1);
	}
	$allow = check_user_allowances(0);

	$viewcatautocreate = "";
	if ($links_defaults['autocreate_active'] and ($links_defaults['autocreate_forum']>0 or $linkscat['catforum']>0)) {
		$autoforum = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $linkscat['catforum'];
		$autoforuminfo = fetch_foruminfo($autoforum);
		if (isset($autoforuminfo['title_clean'])) {
			$viewcatautocreate = construct_phrase($vbphrase['ll_autocreate_forum'], $autoforuminfo['title_clean'], $autoforum);
		}
	}

	eval("\$viewcatextra = \"".fetch_template('links_catbit_extras')."\";");

	$script = LINKS_SCRIPT;

	($hook = vBulletinHook::fetch_hook('ldm_maindisplay_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");

	if (!count($linklistarray) and !count($flinklistarray) and !count($catlistarray)) {
		$emptylistbit = ldm_emptypage_warning($viewcatid);
	}

	unset($linklistarray);
	unset($catlistarray);
	unset($flinklistarray);

	$ldm_accept = lookup_ldm_accept();
	switch ($ldm_accept) {
	case 1:
		eval("\$output .= \"".fetch_template('links_main')."\";");
		break;
	case 0:
		eval("\$output .= \"".fetch_template('links_agreement')."\";");
		break;
	default:
		eval("\$output .= \"".fetch_template('links_agreement_declined')."\";");
	}
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Moderate

if ($this_action == "mod") {

	($hook = vBulletinHook::fetch_hook('ldm_moddisplay_begin')) ? eval($hook) : false;

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = kill_bbcodes($vbphrase['ll_links_moderation']);
	construct_forum_jump();

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$navbits[""] = $vbphrase['ll_links_moderation'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);

	$asb = $vbulletin->db->query_read("
		SELECT forumid, title
		FROM ". TABLE_PREFIX . "forum
	");
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$forum[$row['forumid']] = $row['title'];
	}
	$vbulletin->db->free_result($asb);

	foreach ($linkscat AS $thiscat) {
		$tomod[$thiscat['catid']] = 0;
	}

	$asb = $vbulletin->db->query_read("
		SELECT link.linkid AS linkid, ltoc.catid AS linkcatid, link.linkmoderate AS linkmoderate
		FROM ". THIS_TABLE . "linkslink AS link
		LEFT JOIN ". THIS_TABLE . "linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
		WHERE
			link.linkforum NOT IN (".implode(',', $limitfids).")
			AND (
			link.linkmoderate = $LINK_TO_MODERATE
				OR
			(link.linkreviewfreq>0 AND (link.linkmoddate+link.linkreviewfreq*24*60*60)<".TIMENOW.")
			)
	");

	while ($row=$vbulletin->db->fetch_array($asb)) {
		$tomod[$row['linkcatid']] += 1;
	}
	$vbulletin->db->free_result($asb);

	$links_permissions["can_edit_category"] = 0;
	$categorypage = iif($pagenumber, $pagenumber, 1);

	$numcatsmod = 0;
	$catlistarray = array();
	foreach ($linkscat AS $thiscat) {
		if (!in_array($thiscat["catforum"], $limitfids) and
			($tomod[$thiscat['catid']] > 0 or $thiscat['catmoderate'] == $LINK_TO_MODERATE)) {
			get_catlistbit ($catlistarray, 'links_moderate_catbit', 'links_subcatbit', $thiscat['catid'], array(), 1, 1, $categorypage);
			if ($thiscat['catmoderate'] == $LINK_TO_MODERATE) {
				$numcatsmod++;
			}
		}
	}

	$pagenav = "";
	$searchnav = "";

	if (count($catlistarray)==0) {
		eval("\$catlistbit  = \"".fetch_template('links_moderate_catbit_null')."\";");
	}
	else {
		$catlistbit = map_listbit_to_grid(array_slice($catlistarray,($pagenumber-1)*$perpage,$perpage), 1);
		$pagenav = construct_page_nav($pagenumber, $perpage, count($catlistarray), $LINKS_SCRIPT.".php?action=mod", "&amp;pp=$perpage");
	}

	$catjumpbit = "";
	if ($links_defaults['category_jump_menu']) {
		$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$script = LINKS_SCRIPT;
	$linkfeatbit = "";

	($hook = vBulletinHook::fetch_hook('ldm_moddisplay_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_moderate_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Add Entry

if ($this_action == "addlink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_addlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'url' 			=> TYPE_STR,
		'name' 			=> TYPE_STR,
		'description' 	=> TYPE_STR,
		'catid'			=> TYPE_INT
	));

	$viewcatid = iif($vbulletin->GPC_exists['catid'], $vbulletin->GPC['catid'], $BASE_CAT);

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	if (!$links_permissions["can_upload_files"] and !$links_permissions["can_link_files"] and !$links_defaults['allow_null_links']) {
		eval(standard_error($vbphrase['ll_error_uploadandlink']));
		exit;
	}

	$linkurl = "";
	if ($vbulletin->GPC_exists['url']) {
		$linkurl = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['url']);
	}
	$linkname = "";
	if ($vbulletin->GPC_exists['name']) {
		$linkname = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['name']);
	}
	$linkdesc = "";
	if ($vbulletin->GPC_exists['description']) {
		$linkdesc = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['description']);
	}
	$linkimg = "";
	$linkfile = "";

	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}
	$viewlinkid  = -1;
	$linkmod  = 0;

	if ($linkscat[$viewcatid]["catclosed"] != 0 and !$links_permissions["can_admin_links"]) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_catclosed'],$linkscat[$viewcatid]["catname_clean"]).' <a href="'.$LINKS_SCRIPT.'.php?catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if (!isset($links_defaults["default_forumid"]) or
		!forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$curforumid = $linkscat[$viewcatid]["catforum"];

	$this_navigation_title = kill_bbcodes($vbphrase['ll_menu_addlink']);

	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$linkusername = $vbulletin->userinfo['username'];
	$linkdatebits = get_datetimebit(TIMENOW);

	// draw nav bar
	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_menu_addlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid = array($viewcatid);
	$template = iif($links_permissions["can_select_category"],$links_defaults["template_category_selection"].SELECT_MULTI_CAT,"links_addnewlink_catselect_hidden");
	$optbit = construct_category_list($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_add_link", $links_permissions["can_admin_links"]);
	$expandcatlist = ($template=="links_addnewlink_catselect".SELECT_MULTI_CAT ? 1 : 0);
	$link_pcatbit = construct_parent_list($pcatid);

	$action = "doaddlink";

	$display_order = $links_defaults["default_link_dseq"];
	$instructions = parse_me($links_defaults["use_instructions"]);

	$haveupload = 0;
	$haveimgupload = 0;
	fetch_uploadinfo($maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);
	if (!$links_defaults['upload_enabled']) {
		$links_permissions["can_upload_files"] = 0;
	}
	eval("\$uploadbit = \"".fetch_template('links_addnewlink_upload')."\";");

	$keywordlistbit = get_keywordlistbit();

	$links_permissions["can_add_link"] = $links_permissions["can_delete_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	$pcatid = $viewcatid;
	$linkreviewfreq = $links_defaults['link_review_freq'];
	unset($linkstatus);

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($linkdesc, false, 'nonforum',$links_defaults['allow_smilies'],$links_defaults['allow_smilies']);

	($hook = vBulletinHook::fetch_hook('ldm_addlink_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewlink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Add Multiple Entries

if ($this_action == "addmultilink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_addmultilink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('g', array(
		'catid'		=> TYPE_INT,
		'numadd'	=> TYPE_INT,
	));

	$viewcatid = $vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT;
	$numadd = $vbulletin->GPC['numadd'] ? min($vbulletin->GPC['numadd'], $links_defaults['allow_add_multi']) : $links_defaults['allow_add_multi'];
	$catuserid   = $linkscat[$viewcatid]["catuserid"];

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	if (!$links_permissions["can_upload_files"] and !$links_permissions["can_link_files"] and !$links_defaults['allow_null_links']) {
		eval(standard_error($vbphrase['ll_error_uploadandlink']));
		exit;
	}

	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}
	$viewlinkid  = -1;
	$linkmod  = 0;

	if ($linkscat[$viewcatid]["catclosed"] != 0 and !$links_permissions["can_admin_links"]) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_catclosed'],$linkscat[$viewcatid]["catname_clean"]).' <a href="'.$LINKS_SCRIPT.'.php?catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if (!isset($links_defaults["default_forumid"]) or
		!forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$curforumid = $linkscat[$viewcatid]["catforum"];

	$this_navigation_title = kill_bbcodes($vbphrase['ll_menu_addlink']);

	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = iif($curforumid<=0,$vbphrase['ll_none'],$vbulletin->forumcache[$curforumid][title]);

	$linkusername = $vbulletin->userinfo['username'];
	$linkdatebits = get_datetimebit(TIMENOW);

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_menu_addlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid = array($viewcatid);
	$template = iif($links_permissions["can_select_category"],$links_defaults["template_category_selection"].SELECT_MULTI_CAT,"links_addnewlink_catselect_hidden");
	$optbit = construct_category_list($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_add_link", $links_permissions["can_admin_links"]);
	$expandcatlist = iif($template=="links_addnewlink_catselect".SELECT_MULTI_CAT,1,0);
	$link_pcatbit = construct_parent_list ($pcatid);

	$display_order = $links_defaults["default_link_dseq"];
	$instructions = parse_me($links_defaults["use_instructions"]);

	fetch_uploadinfo($maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);
	if (!$links_defaults['upload_enabled']) {
		$links_permissions["can_upload_files"] = 0;
	}

	$keywordlistbit = get_keywordlistbit();

	$links_permissions["can_add_link"] = $links_permissions["can_delete_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	$pcatid = $viewcatid;
	$linkreviewfreq = $links_defaults['link_review_freq'];
	unset($linkstatus);

	$linkaddmultibit = "";
	for ($linknum=1; $linknum<=$numadd; $linknum++) {
		eval("\$linkaddmultibit .= \"".fetch_template('links_addnewmultilink_one')."\";");
	}

	($hook = vBulletinHook::fetch_hook('ldm_addmultilink_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewmultilink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Edit Entry

if ($this_action == "editlink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_editlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' 	=> TYPE_INT,
		'catid' 	=> TYPE_INT,
	));

	$viewlinkid = $vbulletin->GPC['linkid'];
	$viewcatid  = $vbulletin->GPC['catid'];
	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkslink
		WHERE linkid=$viewlinkid
		LIMIT 1
	");
	if ($vbulletin->db->num_rows($asb)) {
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$linkname = htmlspecialchars_uni($myrow["linkname"]);
			$linkdoi = $myrow["linkdoi"];
			$linkurl = $myrow["linkurl"];
			$linkfile = $myrow["linkfile"];
			$linkimg = $myrow["linkimg"];
			$linkdesc = $myrow["linkdesc"];
			$linkforum = $myrow["linkforum"];
			$linkuserid	= $myrow["linkuserid"];
			$linkusername  = $myrow["linkusername"];
			$linkreviewfreq = $myrow["linkreviewfreq"];
			$linkstatus = $myrow["linkstatus"];
			$linkimgstatus = $myrow["linkimgstatus"];
			$linkdate = $myrow["linkdate"];
		}
		$vbulletin->db->free_result($asb);
	}
	else {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$LINKS_SCRIPT.'.php">'.$vbphrase['ll_return'].'</a>'));
		exit;
	}

	if ($vbulletin->userinfo['userid']<>$linkuserid and (!isset($links_permissions["can_edit_link"]) or !$links_permissions["can_edit_link"])) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = kill_bbcodes($vbphrase['ll_editlink']);
	$linkdatebits = get_datetimebit($linkdate);

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_editlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$curforumid = $linkforum;
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = iif($curforumid<=0,$vbphrase['ll_none'],$vbulletin->forumcache[$curforumid][title]);

	$pcatid = array();
	$asb = $vbulletin->db->query_read("
		SELECT catid FROM ".THIS_TABLE."linksltoc
		WHERE linkid=$viewlinkid
	");
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$pcatid[] = $myrow["catid"];
	}
	$vbulletin->db->free_result($asb);

	$template = iif($links_permissions["can_select_category"],$links_defaults["template_category_selection"].SELECT_MULTI_CAT,"links_addnewlink_catselect_hidden");
	$optbit = construct_category_list ($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_add_link", $links_permissions["can_admin_links"]);
	$expandcatlist = iif($template=="links_addnewlink_catselect".SELECT_MULTI_CAT,1,0);
	$link_pcatbit = construct_parent_list ($pcatid);

	$action = "doeditlink";

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksltoc
		WHERE linkid=$viewlinkid AND catid=$viewcatid
		LIMIT 1
	");
	if ($vbulletin->db->num_rows($asb)) {
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$display_order = $myrow["displayorder"];
		}
		$vbulletin->db->free_result($asb);
	}
	else {
		$display_order = $links_defaults["default_link_dseq"];
	}

	$instructions = parse_me($links_defaults["use_instructions"]);
	$haveupload = iif($linkstatus==$LINK_UPLOAD, 1, 0);
	$haveimgupload = iif($linkimgstatus==$LINK_UPLOAD, 1, 0);
	fetch_uploadinfo($maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);

	if (!$links_defaults['upload_enabled']) {
		$links_permissions["can_upload_files"] = 0;
	}
	eval("\$uploadbit = \"".fetch_template('links_addnewlink_upload')."\";");

	$keywordlistbit = get_keywordlistbit($viewlinkid);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$pcatid = $viewcatid;

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($linkdesc, false, 'nonforum',$links_defaults['allow_smilies'],$links_defaults['allow_smilies']);

	($hook = vBulletinHook::fetch_hook('ldm_editlink_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewlink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### View Link and its Comments/Ratings

if ($this_action == "ratelink") {

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' 	=> TYPE_INT,
		'catid' 	=> TYPE_INT,
		'lpage' 	=> TYPE_INT,
		'rateid'	=> TYPE_INT,
		'ratesort'	=> TYPE_STR
	));

	if (!$vbulletin->GPC_exists['linkid']) {
		$vbulletin->url = $LINKS_SCRIPT.".php";
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_linkid'], 0),0));
		exit;
	}

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];
	$lpage = iif($vbulletin->GPC_exists['lpage'], $vbulletin->GPC['lpage'], 1);
	$lrate = iif($vbulletin->GPC_exists['rateid'], $vbulletin->GPC['rateid'], 0);
	$ratesort = iif($vbulletin->GPC['ratesort'],$vbulletin->GPC['ratesort'],'D');

	$this_navigation_title = kill_bbcodes($vbphrase['ll_rating_and_comments']);

	construct_forum_jump();
	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);

	$navbits = array();
	$navbits[$LINKS_SCRIPT.".php?"] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_rating_and_comments'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$where[] = "link.linkid = '".$linkid."'";
	$where[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
	if ($viewcatid>0) {
		$where[] = "ltoc.catid = '".$viewcatid."'";
	}
	$query = get_mainsql($where, 0, 0, 0, "", $links_defaults['links_show_othercats'], 1);
	$template = $links_defaults["template_linkbit"];
	$template = iif($ldm_linkbitcache[$template]["altbit"],$ldm_linkbitcache[$template]["altbit"],$links_defaults["template_altbit"]);

	$linklistarray = array();
	$hold = $links_permissions['can_rate_link'];
	$links_permissions['can_rate_link'] = 0; // hide the ratings popup
	$nhits  = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", 1, 0);
	$links_permissions['can_rate_link'] = $hold;
	$ncols = iif($viewlinkid, 1, linkbit_columns($template));
	$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratingspopupbit = "";

	switch ($ratesort) {
		case 'U': $ratesortorder = "linkusername ASC, ltime ASC"; break;
		case 'd': $ratesortorder = "ltime DESC"; break;
		case 'D':
		default : $ratesortorder = "ltime ASC"; break;
	}

	$linkcommentsbit = "";
	$thits = 0;
	$nhits = 0;
	$message = "";
	$messageusername = "";
	$messageuserid = 0;
	$rating = 0;

	$first = $pagenumber*$perpage - $perpage;
	$last = $first + $perpage - 1;

	$switch = 1;
	$asb = $vbulletin->db->query_read("
		SELECT lrate.lrate AS lrate, lrate.linkid AS linkid, lrate.linkuserid AS linkuserid,
			lrate.linkusername AS linkusername, lrate.linkvote AS linkvote, lrate.lcomment AS lcomment, lrate.ltime AS ltime
			".iif($links_defaults['show_avatars'], ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight')."
		FROM ".THIS_TABLE."linksrate AS lrate
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = lrate.linkuserid)")."
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)")."
			".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)")."
		WHERE linkid=".$linkid."
		ORDER BY ".$ratesortorder."
	");

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if ($thits >= $first and $nhits <= $perpage-1) {
			$comment = parse_me($myrow['lcomment']);
			$linkuserid = $myrow["linkuserid"];
			$linkusername = $myrow["linkusername"];
			$linkvote = $myrow['linkvote'];
			$rateid = $myrow['lrate'];
			if (!$lrate and $linkuserid==$vbulletin->userinfo['userid']) {
				$rating = $myrow['linkvote'];
			}
			if ($myrow['lrate']==$lrate) {
				$message = $myrow['lcomment'];
				$messageusername = $myrow['linkusername'];
				$messageuserid = $myrow['linkuserid'];
				$rating = $myrow['linkvote'];
			}
			if (strlen($comment) == 0) {
				$comment = $vbphrase['ll_noremark'];
			}
			$linkavatar = get_avatarinfo($myrow);
			$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow['ltime']).' '.ldm_date($vbulletin->options['timeformat'], $myrow['ltime']);
			eval("\$linkcommentsbit .= \"".fetch_template('links_viewone_comment')."\";");
			$nhits++;
			$switch = iif($switch==1,2,1);
		}
		$thits++;
	}
	$vbulletin->db->free_result($asb);

	if ($thits == 0) {
		$link_viewall_comments = $vbphrase['ll_noremark'];
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $thits, $LINKS_SCRIPT.".php?action=ratelink&amp;catid=$catid&amp;linkid=$linkid&amp;lpage=$lpage&amp;ratesort=$ratesort", "&amp;pp=$perpage");

	$sortvar = "ratesort";
	$sortset = $ratesort;
	$sortsubmit = 1;
	$ratearray = array("action"=>"ratelink", "catid"=>$viewcatid, "linkid"=>$linkid,
						"lpage"=>$lpage, "page"=>"1", "pp"=>$perpage);
	if ($vbulletin->GPC_exists['rateid']) $ratearray["rateid"] = $lrate;
	$ratereturnbit = make_hidden_vars($ratearray);
	eval("\$ratesortbit  = \"".fetch_template('links_ratesortbit')."\";");

	$returnscript = iif($viewcatid>=$BASE_CAT,$LINKS_SCRIPT,$SEARCH_SCRIPT);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$links_permissions["can_delete_category"] = 0;

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($message, false, 'nonforum',$links_defaults['allow_smilies'],$links_defaults['allow_smilies']);

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_viewall_comment')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");
	print_output($output);
	exit;

}

// #################### Report bad link

if ($this_action == "reportlink") {

	if (!$links_permissions["can_report_link"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_reportlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' => TYPE_INT,
		'catid' => TYPE_INT
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$this_navigation_title = kill_bbcodes($vbphrase['ll_report_bad_link']);
	construct_forum_jump();

	$navbits = array();
	$navbits[$LINKS_SCRIPT.".php?"] = $master_title;
	$parentlist = $linkscat[$viewcatid["parentlist"]];
	$parentlist = array_reverse(explode(',', $parentlist));
	foreach ($parentlist AS $pid) {
		if ($pid > 0) {
			$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
		}
	}
	$navbits[$LINKS_SCRIPT.".php?catid=".$viewcatid] = $linkscat[$viewcatid]["catname_clean"];
	$navbits[""] = $vbphrase['ll_report_bad_link'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$where[] = "link.linkid = '".$linkid."'";
	$query = get_mainsql($where, 0, 0, 0);

	$template = $links_defaults["template_linkbit"];
	$template = iif($ldm_linkbitcache[$template]["altbit"],$ldm_linkbitcache[$template]["altbit"],$links_defaults["template_altbit"]);

	$linklistarray = array();
	$nhits  = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", 1, 0);
	$ncols = iif($viewlinkid, 1, linkbit_columns($template));
	$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratings = get_ratingsbits($hitids, $pagenumber);
	$linkratingspopupbit = implode("", $linkratings);

	$imagereg = '';
	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['contactustype'] == 2 AND $vbulletin->options['regimagetype']) 	{
		require_once(DIR . '/includes/functions_regimage.php');
		$imagehash = fetch_regimage_hash();
		eval('$imagereg = "' . fetch_template('imagereg') . '";');
	}

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_reportlink_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_report')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Send email about link

if ($this_action == "sendtofriend") {

	if (!$links_permissions["can_send_tofriend"]) {
		eval(standard_error($vbphrase['ll_error_nosend']));
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' => TYPE_INT,
		'catid' => TYPE_INT
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$this_navigation_title = $master_title;
	construct_forum_jump();

	// Make Links Nav Bar
	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$parentlist = $linkscat[$viewcatid["parentlist"]];
	$parentlist = array_reverse(explode(',', $parentlist));
	foreach ($parentlist AS $pid) {
		if ($pid > 0) {
			$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
		}
	}
	$navbits[$LINKS_SCRIPT.".php?catid=".$viewcatid] = $linkscat[$viewcatid]["catname_clean"];
	$navbits[""] = $vbphrase['ll_sendtofriend'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$asb = $vbulletin->db->query_read("
		SELECT link.linkforum AS linkforum, link.linkname AS linkname, link.linkdesc AS linkdesc
		FROM ".THIS_TABLE."linkslink AS link
		WHERE linkid='".$linkid."'
		LIMIT 1
		");
	unset($linkname);
	while ($jump=$vbulletin->db->fetch_array($asb)) {
		$linkforum = $jump['linkforum'];
		$linkname  = $jump['linkname'];
		$linkdesc  = $jump['linkdesc'];
	}
	$vbulletin->db->free_result($asb);
	if (!isset($linkname)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $id)));
		exit;
	}

	if (!forumid_is_valid($linkforum)) {
		eval(standard_error($vbphrase['ll_error_unknownaccess'].' '.$id.', '.$linkforum));
		exit;
	}
	elseif ($linkforum > 0) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			print_no_permission();
			exit;
		}
	}

	$where[] = "link.linkid = '".$linkid."'";
	$query = get_mainsql($where, 0, 0, 0);

	$template = $links_defaults["template_linkbit"];
	$template = iif($ldm_linkbitcache[$template]["altbit"],$ldm_linkbitcache[$template]["altbit"],$links_defaults["template_altbit"]);

	$linklistarray = array();
	$nhits  = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", 1, 0);
	$ncols = iif($viewlinkid, 1, linkbit_columns($template));
	$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratings = get_ratingsbits($hitids, $pagenumber);
	$linkratingspopupbit = implode("", $linkratings);

	$imagereg = '';
	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['contactustype'] == 2 AND $vbulletin->options['regimagetype']) 	{
		require_once(DIR . '/includes/functions_regimage.php');
		$imagehash = fetch_regimage_hash();
		eval('$imagereg = "' . fetch_template('imagereg') . '";');
	}

	$title = $linkname;
	$url = get_url_atag(-2, iif($catid>0,$catid,$MY_CAT), $linkid, $linkname);
	$message = $vbphrase['ll_seethis']."\r\n\r\n"
		. $url
		. "\r\n\r\n" .$linkdesc;

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_sendemail')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Add Category

if ($this_action == "addcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	$catmod  = 0;

	if (!isset($links_permissions["can_add_category"]) or !$links_permissions["can_add_category"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_addcat_begin')) ? eval($hook) : false;

	if (!isset($links_defaults["default_forumid"]) or
		!forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$forum = $curforumid = $links_defaults["default_forumid"];
	$this_navigation_title = kill_bbcodes($vbphrase['ll_addcat']);
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = iif($curforumid<=0,$vbphrase['ll_none'],$vbulletin->forumcache[$curforumid][title]);

	$vbulletin->input->clean_array_gpc('r', array('catid' => TYPE_INT));
	$pcatid = array();
	$pcatid[0] = iif($vbulletin->GPC_exists['catid'], $vbulletin->GPC['catid'], $BASE_CAT);

	$template = iif($links_permissions["can_select_category"],$links_defaults["template_category_selection"].SELECT_ONE_CAT,"links_addnewlink_catselect_hidden");
	$optbit = construct_category_list($pcatid, $template, 1, "pcatid", "linkcat", 1);
//	$optbit = construct_category_list($pcatid, $links_defaults["template_category_selection"].SELECT_ONE_CAT, 1, "pcatid", "linkcat", 1);

	$expandcatlist = iif($links_defaults["template_category_selection"]=="links_addnewlink_catselect",1,0);
	$display_order = $links_defaults["default_cat_dseq"];

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($pcatid[0]>0 and isset($linkscat[$pcatid[0]])) {
		$parentlist = $linkscat[$pcatid[0]]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=".$pcatid[0]] = $linkscat[$pcatid[0]]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_addcat'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$action	   = "doaddcat";
	$viewcatid = iif($vbulletin->GPC_exists['catid'], $vbulletin->GPC['catid'], $BASE_CAT);
	$catname   = "";
	$catdesc   = "";
	$cattext   = "";
	$catforumlink = 0;
	$forumname = $catname;
	$catsyncdir = "";

	$catusername  = $vbulletin->userinfo['username'];
	$catclosed = 0;

	$cat_settings = build_settings(iif($pcatid[0]<0, "-1", $pcatid[0]), $linkscat[$pcatid[0]]['parentlist']);
	$cat_perms = build_permissions(iif($pcatid[0]<0, "-1", $pcatid[0]), $linkscat[$pcatid[0]]['parentlist']);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$links_permissions["can_delete_category"] = 0;
	$pcatid = $pcatid[0];

	($hook = vBulletinHook::fetch_hook('ldm_addcat_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewcat')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Edit Category

if ($this_action == "editcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_editcat_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'mod' => TYPE_INT
	));

	$catmod  = iif($vbulletin->GPC['mod']==1, 1, 0); // may be moderating
	$viewcatid = $vbulletin->GPC['catid'];

	if (!catid_is_valid($viewcatid)) {
		eval(standard_error($vbphrase['ll_error_category'].' '.$viewcatid.' <a href="'.$LINKS_SCRIPT.'.php"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$pcatid = array();

	$catname	= htmlspecialchars_uni($linkscat[$viewcatid]["catname"]);
	$catdesc	= htmlspecialchars_uni($linkscat[$viewcatid]["catdesc"]);
	$cattext	= htmlspecialchars_uni($linkscat[$viewcatid]["cattext"]);
	$pcatid[0]	= $linkscat[$viewcatid]["parentid"];
	$forum		= $linkscat[$viewcatid]["catforum"];
	$catuserid	= $linkscat[$viewcatid]["catuserid"];
	$catusername = htmlspecialchars_uni($linkscat[$viewcatid]["catusername"]);
	$catforumlink = $linkscat[$viewcatid]["catforumlink"];
	$catclosed	= $linkscat[$viewcatid]["catclosed"];
	$catsyncdir	= $linkscat[$viewcatid]["catsyncdir"];

	$forumname = iif ($catforumlink, $vbulletin->forumcache[$linkscat[$viewcatid]["catforumlink"]][title], $linkscat[$viewcatid]["catname_clean"]);

	if ($vbulletin->userinfo['userid']<>$catuserid and (!isset($links_permissions["can_edit_category"]) or !$links_permissions["can_edit_category"])) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = kill_bbcodes($vbphrase['ll_editcat']);

	$display_order = $linkscat[$viewcatid]["displayorder"];

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_editcat'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$curforumid = $forum;
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = iif($curforumid<=0,$vbphrase['ll_none'],$vbulletin->forumcache[$curforumid][title]);

	$template = iif($links_permissions["can_select_category"],$links_defaults["template_category_selection"].SELECT_ONE_CAT,"links_addnewlink_catselect_hidden");
	$optbit = construct_category_list($pcatid, $template, 1, "pcatid", "linkcat", 1);
//	$optbit = construct_category_list($pcatid, $links_defaults["template_category_selection"].SELECT_ONE_CAT, 1, "pcatid", "linkcat", 1);

	$expandcatlist = iif($links_defaults["template_category_selection"]=="links_addnewlink_catselect",1,0);

	$action = "doeditcat";

	$cat_settings = build_settings($viewcatid, $linkscat[$viewcatid]['parentlist']);
	$cat_perms = build_permissions($viewcatid, $linkscat[$viewcatid]['parentlist']);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$pcatid = $pcatid[0];

	($hook = vBulletinHook::fetch_hook('ldm_editcat_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewcat')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ===========================================================================*/
// Action [play, download] functions
/* ===========================================================================*/

// Embedded linkbit only, for Jukebox

if ($this_action == "iframe") {

	($hook = vBulletinHook::fetch_hook('ldm_iframe_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'sort'	=> TYPE_STR,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$perpage = iif($links_defaults['musicbox_files_seen'], $links_defaults['musicbox_files_seen'], $perpage);

	if ($viewcatid>0) {

		$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
		$limitfids = lookup_ldm_forum_protections($can_bypass);
		$viewcatname  = parse_me($linkscat["$viewcatid"]["catname"]);

		$query = array();
		$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
		$query[] = "ltoc.catid = '".$viewcatid."'";

		if ($vbulletin->userinfo['userid'] == 0) {
			$query[] = "link.linkmoderate = $LINK_ACCEPTED";
		}
		else {
			$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
				(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
		}

		$sort = $vbulletin->GPC['sort'];
		if (!$sort) {
			$sort = iif(isset($links_defaults['musicbox_default_sort_order']), $links_defaults['musicbox_default_sort_order'], 'h');
		}
		$sorder = get_sortsql($sort, 1);

		$query = get_mainsql($query, 0, 0, $sorder, "", 0, 0);
		$linklistarray = array();

		$template = "links_linkbit_jukebox";

		$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", 0, 0, $pagenumber, $perpage);
		$ncols = 1;
		$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

		$pagenav = construct_page_nav($pagenumber, $perpage, $nhits, $LINKS_SCRIPT.".php?action=iframe&amp;linkid=$linkid&amp;catid=$viewcatid&amp;sort=$sort", "&amp;pp=$perpage");

		$searchnav = 1;
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = make_hidden_vars(array("action"=>"iframe", "linkid"=>$linkid, "catid"=>$viewcatid, "page"=>1, "pp"=>$perpage));
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");

		$script = LINKS_SCRIPT;

		$catuserid   = $linkscat[$viewcatid]["catuserid"];
		if ($vbulletin->userinfo['userid']==$catuserid) {
			$links_permissions["can_add_link"] = 1;
		}

	}

	eval("\$output .= \"".fetch_template('links_iframed')."\";");

	print_output($output);

	($hook = vBulletinHook::fetch_hook('ldm_iframe_complete')) ? eval($hook) : false;

	exit;
}

// Launch embedded media player

if ($this_action == "play") {

	require_once(DIR . '/includes/local_links_misc.php');

	if (!$links_permissions["can_play_musicbox"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_playlink_begin')) ? eval($hook) : false;

	$this_navigation_title = kill_bbcodes($vbphrase['ll_links_jukebox']);

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'player' => TYPE_STR,
		'sort'	=> TYPE_STR,
	));

	if ($vbulletin->GPC_exists['linkid']) {
		$linkid = $vbulletin->GPC['linkid'];

		$query = "
			SELECT link.linkurl AS linkurl, link.linkname AS linkname, link.linkdesc AS linkdesc,
				link.linkdate AS linkdate, link.linkforum AS linkforum, link.linkstatus AS linkstatus,
				link.linksize AS linksize, link.linkimg AS linkimg, link.linkuserid AS linkuserid,
				link.linkusername AS linkusername, link.linkuserid AS linkuserid
				".iif($links_defaults['show_avatars'], ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight')."
			FROM ".THIS_TABLE."linkslink AS link
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = link.linkuserid)")."
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)")."
				".iif($links_defaults['show_avatars'], "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)")."
			WHERE linkid='$linkid'
			LIMIT 1
		";
		$asb = $vbulletin->db->query_read($query);

		unset($url);
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url		= $jump['linkurl'];
			$linkname	= $jump['linkname'];
			$linkdesc	= $jump['linkdesc'];
			$linkdate	= $jump['linkdate'];
			$linkforum	= $jump['linkforum'];
			$linkimg	= $jump['linkimg'];
			$linkstatus	= $jump['linkstatus'];
			$linksize	= $jump['linksize'];
			$linkraters = $jump['numrate'];
			$linkuserid = $jump['linkuserid'];
			$linkusername = $jump["linkusername"];
			$linkrate = 0;
			if ($linkraters>0) {
				$linkrate = round($jump["totrate"]/$jump["numrate"]);
			}
			$linkavatar = get_avatarinfo($jump);
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $id)));
			exit;
		}

	}
	else {
		eval(standard_error($vbphrase['ll_error_nolinkid']));
		exit;
	}

	if (!forumid_is_valid($linkforum)) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkslink
			SET linkstatus=".$LINK_NO_ACCESS.", linkcheck=".TIMENOW."
			WHERE linkid='$linkid'
			LIMIT 1
		");
		eval(standard_error($vbphrase['ll_error_unknownaccess']." $linkid, $linkforum"));
		exit;

	}
	elseif ($linkforum > 0) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			print_no_permission();
			exit;
		}
		$foruminfo = fetch_foruminfo($linkforum);
		verify_forum_password($linkforum, $foruminfo["password"]);
	}
	elseif ($links_defaults['links_expiry_days']>0 and !$links_permissions['can_view_hidden']) {

		$linkexpired = 0;
		$expire = $links_defaults['links_expiry_days']*86400;
		if ($linkdate>TIMENOW) {
			ldmjump_access_error(); // post-dated, so invisible
            exit;
		}
		elseif ($linkdate+$expire<TIMENOW) {
			ldmjump_access_error(); // expired
            exit;
		}

	}
	elseif ($links_permissions['must_rate_play'] and $linkuserid!=$vbulletin->userinfo['userid']) {
		$count = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS ratings
			FROM ".THIS_TABLE."linksrate
	        WHERE linkuserid='".$vbulletin->userinfo['userid']."'
			AND linkid='".$linkid."'
        ");
	    if (!$count['ratings']) {
			eval(standard_error($vbphrase['ll_must_rate_play']));
            exit;
	    }
		$vbulletin->db->free_result($asb);
	}


	$catid = 0;
	if ($vbulletin->GPC_exists['catid']) {
		$catid = $vbulletin->GPC['catid'];
	}
	if ($catid<=0) {
		$catids = lookup_ldm_category($linkid);
		if (count($catids)) {
			$catid = $catids[0];
		}
	}
	if (!catid_is_valid($catid)) {
		eval(standard_error($vbphrase['ll_error_category'].$vbphrase['ll_goback']));
		exit;
	}

// patch any variables in url
	$url = ldm_mod_rewrite($url, $catid, $linkid);

// Check that user has sufficient allowance to complete the download
	$allow = check_user_allowances( ($urlInfo['scheme'] and $protocol_schemes[$urlInfo['scheme']]['mode']!=MODE_HIDE) ? 0 : $linksize, $linkid);
	if (!$allow['can_download']) {
		eval(standard_error($allow['errormessage']));
		exit;
	}

	$urlInfo = ldm_parse_url($url);
	$dfname	= basename($urlInfo['path']);
	$type	= substr(strrchr(basename($urlInfo['path']), "."), 1);

	if ($urlInfo['scheme'] and $protocol_schemes[$urlInfo['scheme']]['mode']!=MODE_HIDE) {

		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_redirect'],0));

	}
	else {

		$viewcatid = $catid;
		$viewlinkid = $linkid;
		$ldm_accept = lookup_ldm_accept();
		if ($ldm_accept<=0) {
			$navbits = array();
			$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
			$navbits[""] = $vbphrase['ll_links_moderation'];
			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template('navbar') . '";');
			$sort = $vbulletin->GPC['sort'];
			switch ($ldm_accept) {
			case 0:
				eval("\$output  = \"".fetch_template('links_header')."\";");
				eval("\$output .= \"".fetch_template('links_agreement')."\";");
				eval("\$output .= \"".fetch_template('links_footer')."\";");
				print_output($output);
				exit;
			case -1:
				eval("\$output  = \"".fetch_template('links_header')."\";");
				eval("\$output .= \"".fetch_template('links_agreement_declined')."\";");
				eval("\$output .= \"".fetch_template('links_footer')."\";");
				print_output($output);
				exit;
			}
		}

		$linkname	= parse_me($linkname);
		$linkdesc	= parse_me($linkdesc);

		get_icons();
		if (isset($ldm_icon_cache['jukebox'])) {
			$jukeboxpic = '<img border="0" src="'.$ldm_icon_cache['jukebox'].'" alt="'.$vbphrase['ll_links_jukebox'].'" />';
		}

		($hook = vBulletinHook::fetch_hook('ldm_playme_preplaybit')) ? eval($hook) : false;

		require_once(DIR . '/includes/local_links_players.php');
		$playerbit_player = get_playerbit($linkid, $catid, $url, $vbulletin->GPC['player']);

		if (!$playerbit_player) {
			eval(standard_error($vbphrase['ll_error_filetype']));
			exit;
		}

		eval("\$playerbit = \"".fetch_template('links_playbit')."\";");

		$target = 1;
		eval("\$linkratebit = \"".fetch_template('links_ratebit')."\";");
		$linkratings = get_ratingsbits(array($linkid=>$linkid,), 1, 1);
		$linkratingspopupbit = implode("", $linkratings);

		if ($links_defaults['open_musicbox_newwindow']) {

			eval("\$output  = \"".fetch_template('links_play_standalone')."\";");
		}
		else {

			construct_forum_jump();
			$navbits = array();
			$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
			$viewcatname  = parse_me($linkscat["$catid"]["catname"]);
			$viewcatdesc  = parse_me($linkscat["$catid"]["catdesc"]);
			$viewcattext  = parse_me($linkscat["$catid"]["cattext"]);
			$parentlist = $linkscat["$catid"]["parentlist"];
			$parentlist = array_reverse(explode(',', $parentlist));
			foreach ($parentlist AS $pid) {
				if ($pid > 0) {
					$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
				}
			}
			$navbits[$LINKS_SCRIPT.".php?catid=$catid"] = $linkscat["$catid"]["catname_clean"];
			$navbits[""] = parse_me($linkname);

			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template('navbar') . '";');

			$script = LINKS_SCRIPT;

			$catjumpbit = "";
			if ($links_defaults['category_jump_menu']) {
				$catjumpbit = construct_category_list(array($catid), "links_catjump", 0, "catid", "catid", 1);
			}

			$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
			$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

			eval("\$output  = \"".fetch_template('links_header')."\";");
			eval("\$output .= \"".fetch_template('links_play_embedded')."\";");
			eval("\$output .= \"".fetch_template('links_footer')."\";");
		}

		print_output($output);

		($hook = vBulletinHook::fetch_hook('ldm_playme_complete')) ? eval($hook) : false;

	}

	exit;
}

// Jump to link - open/download

if ($this_action == "jump") {

	require_once(DIR . '/includes/local_links_misc.php');

	if (!$links_permissions["can_access_link"]) {
		ldmjump_access_error();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_jumplink_begin')) ? eval($hook) : false;

	$time = TIMENOW;
	unset($url);

	if (isset($_REQUEST['id']) and !isset($_REQUEST['linkid'])) {
		$_REQUEST['linkid'] = $_REQUEST['id'];
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'doi' => TYPE_STR,
		'link' => TYPE_STR,
		'mirror' => TYPE_STR,
	));

	unset($catid);
	if ($vbulletin->GPC_exists['catid']) {
		$catid = $vbulletin->GPC['catid'];
	}

	if ($vbulletin->GPC_exists['link']) {
		$link = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['link']);
		if (preg_match("/(.*)\/(.*)/", $link, $match)) {
			$lname = $vbulletin->db->escape_string($match[2]);
			$cname = $vbulletin->db->escape_string($match[1]);
		}
		else {
			$lname = $vbulletin->db->escape_string($link);
			$cname = "%";
		}
		$asb = $vbulletin->db->query_read("
			SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
				link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
				link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
				ltoc.catid AS catid, cat.catname AS catname
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			LEFT JOIN ".THIS_TABLE."linkscat AS cat
			ON ltoc.catid = cat.catid
			WHERE link.linkname LIKE '$lname' AND cat.catname LIKE '$cname'
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url = $jump['linkurl'];
			$linkid = $jump['linkid'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $lname.'/'.$cname)));
			exit;
		}

	}
	elseif ($vbulletin->GPC_exists['doi']) {
		$jumplink = $vbulletin->db->query_read("
			SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
				link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
				link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
				ltoc.catid AS catid
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			WHERE link.linkdoi LIKE ('".$vbulletin->GPC['doi']."')
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($jumplink)) {
			$url = $jump['linkurl'];
			$linkid = $jump['linkid'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_doi'], $vbulletin->GPC['doi'])));
			exit;
		}

	}
	elseif ($vbulletin->GPC_exists['linkid']) {
		$linkid = $vbulletin->GPC['linkid'];
		$asb = $vbulletin->db->query_read("
			SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
				link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
				link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
				ltoc.catid AS catid
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			WHERE link.linkid='".$linkid."'
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url = $jump['linkurl'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
			exit;
		}

	}
	else {
		eval(standard_error($vbphrase['ll_error_nolinkid']));
		exit;
	}

	if ($links_defaults["timeout_hit_allow"]>0) {
		$timeout = $time - $links_defaults["timeout_hit_allow"];
		$asb = $vbulletin->db->query_read("
			SELECT userid, usertime
			FROM ".THIS_TABLE."linksdownloads
	        WHERE userid='".$vbulletin->userinfo['userid']."'
			AND linkid<>'".$linkid."'
			AND linkid>0
	        ORDER BY usertime DESC
	        LIMIT 1
        ");
	    while ($jump=$vbulletin->db->fetch_array($asb)) {
	        $timeleft = $jump['usertime'] - $timeout;
	        if ($jump['usertime'] > $timeout) {
				$wait = construct_phrase($vbphrase['ll_wait'], $timeleft, $links_defaults["timeout_hit_allow"]);
				eval(standard_error($wait));
	            exit;
	        }
	    }
		$vbulletin->db->free_result($asb);
	}

	if (!forumid_is_valid($linkforum)) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkslink
			SET linkstatus=".$LINK_NO_ACCESS.", linkcheck=".TIMENOW."
			WHERE linkid='".$linkid."'
			LIMIT 1
		");
		eval(standard_error($vbphrase['ll_error_unknownaccess']." ".$linkid.", ".$linkforum));
		exit;

	}
	elseif ($linkforum > 0 and !$links_permissions["can_bypass_forumperms"]) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			ldmjump_access_error();
			exit;
		}
		$foruminfo = fetch_foruminfo($linkforum);
		verify_forum_password($linkforum, $foruminfo["password"]);
	}
	elseif ($links_defaults['links_expiry_days']>0 and !$links_permissions['can_view_hidden']) {
		$linkexpired = 0;
		$expire = $links_defaults['links_expiry_days']*86400;
		if ($linkdate>TIMENOW) {
			ldmjump_access_error(); // post-dated, so invisible
            exit;
		}
		elseif ($linkdate+$expire<TIMENOW) {
			ldmjump_access_error(); // expired
            exit;
		}
	}
	elseif ($links_permissions['must_rate_download'] and $linkuserid!=$vbulletin->userinfo['userid']) {
		$count = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS ratings
			FROM ".THIS_TABLE."linksrate
	        WHERE linkuserid='".$vbulletin->userinfo['userid']."'
			AND linkid='".$linkid."'
        ");
	    if (!$count['ratings']) {
			eval(standard_error($vbphrase['ll_must_rate_download']));
            exit;
	    }
		$vbulletin->db->free_result($asb);
	}

// 'Accept me' form required/accepted?
	$ldm_accept = lookup_ldm_accept();
	if ($ldm_accept<=0) {
		$url = $LINKS_SCRIPT.".php?linkid=".$linkid."&amp;catid=".$catid;
		eval(standard_error(construct_phrase($vbphrase['ll_error_accept'], $url)));
	}

// Patch any variables in url
	$url = ldm_mod_rewrite($url, $catid, $linkid);

// Handle mirrors if any
	$download_mirrors = unserialize($links_defaults['download_mirrors']);
	if (count($download_mirrors)) {
		$mirror_urls = ldm_mirrors($url, $download_mirrors);
		if (count($mirror_urls)==1) {
			$mirror = current($mirror_urls);
			$url = $mirror['url'];
		}
		elseif (count($mirror_urls)>1) {
			if ($vbulletin->GPC_exists['mirror']) {
				$mirror = "";
				foreach ($mirror_urls as $thismirror) {
					if (strcasecmp($thismirror['name'], $vbulletin->GPC['mirror'])==0) {
						$mirror = $thismirror;
						break;
					}
				}
				if (!$mirror) { // can't find requested mirror, so just use the first
					reset($mirror_urls);
					$mirror = current($mirror_url);
				}
				$url = $mirror['url'];
			}
			else {
				$this_navigation_title = $vbphrase['ll_mirrors'];
				$mirrorbit = "";
				foreach ($mirror_urls as $mirror_name=>$thismirror) {
					$mirrorbit .= "<br />";
					eval('$mirrorbit .= "' . fetch_template('links_mirror_select_one') . '";');
				}
				eval("\$output = \"".fetch_template('links_mirror_select')."\";");
				print_output($output);
				exit;
			}
		}
	}

// Down to a single url.  Go for it...
	$urlInfo = ldm_parse_url($url);
	if ($urlInfo['scheme'] and !array_key_exists($urlInfo['scheme'], $protocol_schemes)) {
		$hit = record_hit($linkid, $url, $LINK_BROKEN);
		eval(standard_error($vbphrase['ll_error_protocol'].' '.$urlInfo['scheme']));
		exit;
	}

	$dfname   = iif($linkfile, $linkfile, basename($urlInfo['path']));
	$type	  = substr(strrchr($dfname, "."), 1);
	$mimetype = get_mimetype($type);

// Access by redirecting if:
// 		in force redirect mode
//		full url and not a known mimetype
//		qualified mimetype (a la Sourceforge)
//		local file, not a known mimetype, and neither local_file_root nor local_file_root_prefix is set

	if (	  $links_defaults["force_redirect"]
		or 	( $urlInfo['scheme'] and $protocol_schemes[$urlInfo['scheme']]['mode']==MODE_REDIRECT)
		or 	( $urlInfo['host'] and !is_array($mimetype))
		or 	  $urlInfo['query']
		or 	(!$urlInfo['host'] and !is_array($mimetype) and !$links_defaults["local_file_root"] and !$links_defaults["local_file_root_prefix"])
		) {
		$transfer_mode = MODE_REDIRECT;
	}
	else {
		$transfer_mode = MODE_OPEN;
	}

// Check allowances and keep a record of bytes transferred if:
// 		MODE_OPEN
// 		held on this server
// 		held on a mirror server

	$handle_allowances = 0;
	if (	$transfer_mode==MODE_OPEN
		or  !$urlInfo['host'] 
		or ($urlInfo['host']==$_SERVER["HTTP_HOST"])
		or  $mirror
		) {
		$handle_allowances = 1;
	}

	if ($handle_allowances) {
		$allow = check_user_allowances($linksize, $linkid);
		if (!$allow['can_download']) {
			eval(standard_error($allow['errormessage']));
			exit;
		}
	}

// About to start - last chance to change things...
	($hook = vBulletinHook::fetch_hook('ldm_download_begin')) ? eval($hook) : false;

	if ($transfer_mode == MODE_REDIRECT) {

		if ($handle_allowances) {
			$linksize = size_url($url);
			$hit = record_hit($linkid, $url, $LINK_OK, $linksize);
		}
		else {
			$hit = record_hit($linkid, $url, $LINK_OK);
		}
		if ($urlInfo['user']) {
			unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			if ($LDM_environment['curl_available']) {
				$conn = @curl_init();
				if ($conn) {
					@header("HTTP/1.1 200");
					@header("Expires: 0");
					@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
					@header("Pragma: no-cache"); // HTTP/1.0
					if ($type == 'htm' or $type == 'html') {
						@header("Content-type: text/html");
					}
					else {
						@header("Content-type: unknown/unknown");
					}
					@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
					@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
					@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
					@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
					@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
					@curl_setopt($conn, CURLOPT_HEADER, 0);
					@curl_exec($conn);
					@curl_close($conn);
				}
				else { // otherwise we just have to try the redirect without username and password...
					$vbulletin->url = $rawurl;
					eval(print_standard_redirect($vbphrase['ll_redirect'],0));
				}
			}
		}
		else {
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_redirect'],0));
		}

		exit;
	}

	if ($urlInfo['host'] and !$links_defaults['allow_remote_downloads']) {
		eval(standard_error($vbphrase['ll_error_dldisable']));
		exit;
	}

	if ($urlInfo['host'] and !$LDM_environment['allow_url_fopen'] and !$LDM_environment['curl_available']) {
		eval(standard_error($vbphrase['ll_error_dldisable']));
		exit;
	}

// Recheck filesize before sending headers...
	$linksize = size_url($url);
	$do206 = 0;
	$ilast = 0;

// Request for partial range(s) - only honour requests for a single range...
//	if ($linksize and isset($HTTP_SERVER_VARS['HTTP_RANGE'])) {
//		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $HTTP_SERVER_VARS['HTTP_RANGE'], $ranges, PREG_SET_ORDER)) {
	$curr_headers = ldm_parse_headers();
	if ($linksize and isset($curr_headers['Range'])) {
		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $curr_headers['Range'], $ranges, PREG_SET_ORDER)) {
			$do206  = 1;
			$istart = $ranges[0][1];
			$iend   = $ranges[0][2];
			if ($istart>=$linksize) {
				@header('HTTP/1.1 416 Requested Range Not Satisfiable');
				@header('Accept-Ranges: bytes');
				@header('Content-Range: bytes */'. $attachmentinfo['filesize']);
				exit;
			}

			if (!$iend or $iend>=$linksize) {
				$iend  = $linksize-1;
				$ilast = 1;
			}
			$ichars = $iend-$istart+1;
		}
	}

	$file = cleanto_fopen($url);
	$use_curl = 0;
	$conn = 0;
	if ($urlInfo['host'] == "") {
		$conn = @fopen($file, "rb");
	}
	elseif ($LDM_environment['curl_available']) {
		$conn = @curl_init();
		$use_curl = 1;
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$conn = @fopen($file, "rb");
	}

	if (!$conn) {
		$hit = record_hit($linkid, $url, $LINK_BROKEN);
		eval(standard_error($vbphrase['ll_error_linknotavail']));
		exit;
	}

	if (!$do206 or $ilast) {
		$hit = record_hit($linkid, $url, iif($linkstatus==$LINK_UPLOAD, $LINK_UPLOAD, $LINK_OK), $linksize);
	}

// Turn off php timeouts so that downloads complete correctly
	if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0) {
		@set_time_limit(0);
	}

	@ini_set('zlib.output_compression', 'Off');

	@header("HTTP/1.1 ".iif($do206, "206 Partial content", "200"));
	@header("Expires: 0");
	@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
	@header("Pragma: no-cache"); // HTTP/1.0

	if ($linksize>1) {
		if ($do206) {
			@header("Accept-Ranges: bytes");
			@header("Content-Range: bytes $istart-$iend/$linksize");
			@header("Content-Length: $ichars");
		}
		else {
			@header("Accept-Ranges: ".iif($type=='pdf', "none", "bytes"));
			@header("Content-Length: $linksize");
		}
	}

	if ($type!='txt') {
		@header('Content-transfer-encoding: binary');
	}

	if ($links_defaults['force_saveas']) {
		@header("Content-type: application/x-download");
		@header("Content-disposition: attachment; filename=".str_replace(" ", "_", $dfname)."");
	}
	else {
		@header("Content-disposition: inline; filename=".str_replace(" ", "_", $dfname)."");
		if (is_array($mimetype)) {
			foreach ($mimetype AS $header) {
				@header($header);
			}
		}
		elseif ($type == 'htm' or $type == 'html') {
			@header("Content-type: text/html");
		}
		else {
			@header("Content-type: unknown/unknown");
		}
	}

	if ($use_curl) {
		if ($urlInfo['user']) {
			unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($conn, CURLOPT_HEADER, 0);
		@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
		@curl_setopt($conn, CURLOPT_USERAGENT, "LDM Downloader");
		if ($do206) {
			@curl_setopt($conn, CURLOPT_RANGE, "$istart-$iend");
		}
		@curl_exec($conn);
		$res = @curl_getinfo($conn);
		$bytes = $res["size_download"];
		@curl_close($conn);

	}
	else {
		$bytes = 0;
		if (!$do206) {
			while ($contents = fread ($conn, $READ_BUFFER_SIZE)) {
				echo $contents;
				$bytes += strlen($contents);
			}
		}
		else {
			$jchar = 0;
			while ($jchar<$istart) {
				$nchar = iif(($istart-$jchar)<$READ_BUFFER_SIZE,($istart-$jchar),$READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				$jchar += strlen($contents);
			}
			while ($jchar<$iend) {
				$nchar = iif(($iend-$jchar+1)<$READ_BUFFER_SIZE,($iend-$jchar+1),$READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				echo $contents;
				$jchar += strlen($contents);
			}
			$bytes = $jchar;
		}
		flush();
		fclose($conn);
	}

	if (!$do206 or $ilast) {
		($hook = vBulletinHook::fetch_hook('ldm_download_complete')) ? eval($hook) : false;
	}

	if (is_object($vbulletin->session)) {
		$vbulletin->session->save();
	}

	exit;
}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

($hook = vBulletinHook::fetch_hook('ldm_fallthrough_error')) ? eval($hook) : false;

$vbulletin->url = $LINKS_SCRIPT.'.php';
eval(print_standard_redirect('',0));
exit;

?>