<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_actions');

// get special phrase groups
$phrasegroups = array(
	'local_links', 'threadmanage', 'posting', 'postbit'
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_downloadbit',
	'links_editbit',
	'links_favbit',
	'links_footer',
	'links_header',
	'links_imgmag',
	'links_linkseparator',
	'links_main',
	'links_moderate_linkbit',
	'links_moderate_select',
	'links_othercatsbit',
	'links_ratebit',
	'navbar',
	);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// fire up VBulletin backend
require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

($hook = vBulletinHook::fetch_hook('ldm_actions_start')) ? eval($hook) : false;

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT
	));

$this_action = $vbulletin->GPC['action'];

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) $perpage = $vbulletin->options['maxposts'];
	$perpage = iif($links_defaults['links_per_page']!=0, $links_defaults['links_per_page'], $perpage);
}

$pagenumber = iif($vbulletin->GPC_exists['page'],$vbulletin->GPC['page'],1);
$master_title = htmlspecialchars_uni(iif ($links_defaults['database_name'], $links_defaults['database_name'], $vbphrase['ll_links_database']));

/* ===========================================================================*/
// Functions used only in this module
/* ===========================================================================*/

// Fetch the list of moderators

function ldm_fetch_moderators($catid, $fetch_all=0) {
	global $vbulletin, $linkscat;

	$mods = array();

	unset ($foruminfo);
	if (isset($linkscat[$catid]['catforum']) and $linkscat[$catid]['catforum']>0) {
		$foruminfo = fetch_foruminfo($linkscat[$catid]['catforum']);
	}

	if ($foruminfo) {

		$moderators = $vbulletin->db->query_read("
			SELECT DISTINCT user.email, user.languageid, user.userid
			FROM " . TABLE_PREFIX . "moderator AS moderator," . TABLE_PREFIX . "user AS user
			WHERE user.userid = moderator.userid
			AND moderator.forumid IN ($foruminfo[parentlist])
			AND moderator.forumid <> -1
			");

		while ($moderator = $vbulletin->db->fetch_array($moderators)) {
			$mods["$moderator[userid]"] = $moderator;
		}
	}

// Take care - VB version specific ==================================================
	if (VALID_VB_VERSION=="3.5") {
		if (empty($mods) OR ($fetch_all AND $foruminfo['options'] & $vbulletin->bf_misc_forumoptions['warnall'])) {
			$moderators = $vbulletin->db->query_read("
				SELECT user.email, user.languageid, user.userid
				FROM " . TABLE_PREFIX . "user AS user
				INNER JOIN " . TABLE_PREFIX . "usergroup AS usergroup USING (usergroupid)
				WHERE usergroup.adminpermissions <> 0
				" . (!empty($mods) ? "AND userid NOT IN (" . implode(',', array_keys($mods)) . ")" : "") . "
			");

			while ($moderator = $vbulletin->db->fetch_array($moderators)) {
				$mods["$moderator[userid]"] = $moderator;
			}
		}
	}
	else {
		if (empty($mods) OR ($fetch_all AND $vbulletin->options['rpemail'] == 2)) {
			$moderators = $vbulletin->db->query_read("
				SELECT user.email, user.languageid, user.userid
				FROM " . TABLE_PREFIX . "user AS user
				INNER JOIN " . TABLE_PREFIX . "usergroup AS usergroup USING (usergroupid)
				WHERE usergroup.adminpermissions <> 0
				" . (!empty($mods) ? "AND userid NOT IN (" . implode(',', array_keys($mods)) . ")" : "") . "
			");

			while ($moderator = $vbulletin->db->fetch_array($moderators)) {
				$mods["$moderator[userid]"] = $moderator;
			}
		}
	}
// Take care - VB version specific ==================================================

	return $mods;
}

// Correct the cached ratings information for an entry

function ldm_fix_rating_counts($linkid) {
	global $vbulletin;

	$rates = array();
	$asb = $vbulletin->db->query_read("
		SELECT linkvote, linkuserid
		FROM ".THIS_TABLE."linksrate
		WHERE linkid='".$linkid."'
		ORDER BY ltime DESC
	");

	$totrate = $numrate = 0;
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$rates[$myrow['linkuserid']] = $myrow['linkvote'];
	}
	$vbulletin->db->free_result($asb);

	foreach ($rates as $r) {
		$numrate += 1;
		$totrate += $r;
	}

	$asb = $vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linkslink
		SET totrate = ".$totrate.", numrate = ".$numrate."
		WHERE linkid='".$linkid."'
	");
	$vbulletin->db->free_result($asb);
}

// Notify users of outcome of moderation

function ldm_notify_moderated($linkid, $catid, $accept) {
	global $vbulletin, $vbphrase;
	global $LINKS_SCRIPT;

	$asb = $vbulletin->db->query_read("
		SELECT	user.userid AS userid, user.username AS username,
				user.email AS email, user.options AS options,
		       links.linkname AS linkname, links.linkurl AS linkurl
		FROM ".TABLE_PREFIX."user AS user
		LEFT JOIN ".THIS_TABLE."linkslink AS links
		ON user.userid = links.linkuserid
		WHERE links.linkid = '".$linkid."'
		");

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if ($sent[$myrow['email']]) continue;
		if (!$myrow['email']) continue;
		if (!$myrow['options'] & $vbulletin->bf_misc_useroptions['adminemail']) continue;

		$subject = construct_phrase($vbphrase['ll_admin_entryaccepted_subject'], $vbulletin->options['bbtitle']);
		if ($accept) {
			$message = construct_phrase($vbphrase['ll_admin_entryaccepted_body'],
				$myrow['username'], $myrow['linkname'], $myrow['linkurl'],
				mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?catid='.$catid.'&linkid='.$linkid)
				);
		}
		else {
			$message = construct_phrase($vbphrase['ll_admin_entrydeclined_body'],
				$myrow['username'], $myrow['linkname'], $myrow['linkurl']
			);
		}

		$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

		($hook = vBulletinHook::fetch_hook('ldm_editlink_sendmoderatedemail')) ? eval($hook) : false;

		vbmail($myrow['email'], $subject, $message, true);
	}

}

// Notify users who have downloaded an entry that the entry has changed

function ldm_notify_updated($linkid, $catid) {
	global $vbulletin, $vbphrase;
	global $LINKS_SCRIPT;

	$query = "
		SELECT linkid, linkname
		FROM ".THIS_TABLE."linkslink
		WHERE linkid = '".intval($linkid)."'
		LIMIT 1
		";
	$myrow = $vbulletin->db->query_first($query);
	$subject = construct_phrase($vbphrase['ll_admin_entryupdated_subject'], $vbulletin->options['bbtitle']);
	$message = construct_phrase($vbphrase['ll_admin_entryupdated_body'], $myrow['linkname'],
					mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?catid='.$catid.'&linkid='.$linkid)
					);
	$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

	($hook = vBulletinHook::fetch_hook('ldm_editlink_sendupdatedemail')) ? eval($hook) : false;

	$sent = array();
	$query = "
		SELECT	user.userid AS userid, user.email AS email, user.options AS options, downloads.linkid AS linkid
		FROM ".TABLE_PREFIX."user AS user
		LEFT JOIN ".THIS_TABLE."linksdownloads AS downloads
		ON user.userid=downloads.userid
		WHERE downloads.linkid = '".intval($linkid)."'
		";
	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if ($sent[$myrow['email']]) continue;
		if (!$myrow['email']) continue;
		if (!$myrow['options'] & $vbulletin->bf_misc_useroptions['adminemail']) continue;
		vbmail($myrow['email'], $subject, $message, true);
		$sent[$myrow['email']] = 1;
	}

}

// Validate an upload FILE and if successful move it into user's upload directory

function ldm_process_upload(&$GPC, &$linkurl, $dir="") {
	global $links_defaults, $links_permissions, $vbulletin, $ldm_mimetype_cache;
	global $LDM_environment;

	require_once(DIR . '/includes/functions_file.php');

	($hook = vBulletinHook::fetch_hook('ldm_upload_precheck')) ? eval($hook) : false;

	if (!$links_permissions['can_upload_files'] or !$links_defaults['upload_enabled']) {
		return(21); // uploads prohibited
	}

	switch ($GPC['error']) {
	case 0:  break;
	case 1:  // upload too large (php.ini)
	case 2:  // upload too large (form)
	case 3:  // partial upload
	case 4:  // no upload
	case 6:  // missing temporary directory
	case 7:  // can't create temporary file
		return($GPC['error']);
	default: return(99); // general failure
	}

	if (!$GPC['name'] or !$GPC['tmp_name'] or !$GPC['size']) return(4);

	cache_mimetype();
	$type = strtolower(substr(strrchr(basename($GPC['name']), "."), 1));
	$def = preg_replace('/\s/','',$links_defaults['upload_filetypes']);
	if ($def) {
		$limit_mimetypes = explode(',', $def);
	}
	else {
		$limit_mimetypes = array();
	}
	if (!$type or !isset($ldm_mimetype_cache[$type])) return(23); // invalid filetype
	if (count($limit_mimetypes) and !in_array($type, $limit_mimetypes)) return(23);

	if (!$LDM_environment['is_admin'] and $ldm_mimetype_cache[$type]['size'] and $ldm_mimetype_cache[$type]['size']<$GPC['size']) {
		return(24); // upload too large
	}

	if ($type != 'mp3' and in_array($type, $LDM_environment['thumb_types'])) {
		if (!@getimagesize($GPC['tmp_name'])) return(25); // not a valid image - someone's playing silly games
		// try vb.com's test to verify that file is playing nice
		$fp = @fopen($GPC['tmp_name'], 'rb');
		if ($fp) {
			$header = fread($fp, 200);
			fclose($fp);
			if (preg_match('#<html|<head|<body|<script#si', $header)) {
				return 25;
			}
		}
		else {
			return 25;
		}
	}
	if (!is_uploaded_file($GPC['tmp_name'])) return(25); // again, something funny going on

	$userid = intval($vbulletin->userinfo['userid']);
	$path = mk_file_name($links_defaults['upload_dir'],iif($dir,$dir,implode('/', preg_split('//', $userid,  -1, PREG_SPLIT_NO_EMPTY))));
	$fullpath = local_filename($path);
	if (!file_exists($fullpath)) {
		if (!vbmkdir($fullpath, 0777)) {
			return(26); // can't create user directory
		}
	}
	for ($k=0; $k<999; $k++) {
		$file = mk_file_name($path, rand(1000,9999).TIMENOW.rand(1000,9999).'.'.$type);
		$fullfile = local_filename($file);
		if (!file_exists($fullfile)) break;
	}

// useful if people want a different file naming convention for uploads
	($hook = vBulletinHook::fetch_hook('ldm_upload_filesave')) ? eval($hook) : false;

	if (file_exists($fullfile)) {
		return(27);
	}
	if (!@move_uploaded_file($GPC['tmp_name'], $fullfile)) return(27); // can't move file to user directory

	$linkurl = $file;
	return(0);
}


/**
* Check whether a string is likely to be a valid filename across all systems and fix if necessary
*
* @param	&str	string to test
* @param	int		if true, fix the string
* @return	int		0=ok, 1=fixed
*/

function ldm_fix_filename(&$filename, $fix=0) {
	$invalids = array("\\", "/", ":", "%", "$", "*", "|", "?", "\"", "<", ">");
	$fixed = 0;
	foreach ($invalids as $invalid) {
		if (strpos($filename, $invalid) !== FALSE) {
			$fixed = 1;
			if ($fix) {
				$filename = str_replace($invalid, "", $filename);
			}
		}
	}
	return $fixed;
}

/* ===========================================================================*/
// Follow-up ('do') command functions
/* ===========================================================================*/

if ($this_action == "domod") {

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_INT,
		'catid' => TYPE_INT,
		'catpage' => TYPE_INT,
	));

	$this_navigation_title = $vbphrase['ll_links_moderation'];

	construct_forum_jump();
	unset($linkid);
	unset($viewcatid);
	if ($vbulletin->GPC_exists['id']) {
		$linkid = $vbulletin->GPC['id'];
	}

	$viewcatid = $vbulletin->GPC['catid'];
	if (!isset($linkid) and !isset($viewcatid)) {
		eval(standard_error($vbphrase['ll_error_catlinknull'].' <a href="'.$LINKS_SCRIPT.'.php"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$catpage = iif($vbulletin->GPC['catpage'], $vbulletin->GPC['catpage'], 1);

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);

	if (isset($linkid)) {
		$where[] = "link.linkid = '".$linkid."'";
	}
	$where[] = "ltoc.catid = '".$viewcatid."'";
	$where[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
	$where[] = "(link.linkmoderate = ".$LINK_TO_MODERATE."
					OR
				(link.linkreviewfreq>0 AND (link.linkmoddate+link.linkreviewfreq*24*60*60)<".TIMENOW.")
				)";
	$order = "linkcatid, linkname";
	$query = get_mainsql($where, 0, 0, $order);
	$catlistbit   = "";

	$linklistarray = array();
	$pagenav = "";
	if (isset($viewcatid)) {
		$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, 'links_moderate_linkbit', $query, 0, 1, 1, $pagenumber, $perpage);
		$linklistbit = map_listbit_to_grid($linklistarray, 1, 1);
		$pagenav = construct_page_nav($pagenumber, $perpage, $nhits, $ACTION_SCRIPT.".php?action=domod&amp;catid=$viewcatid&amp;catpage=$catpage", "&amp;pp=$perpage");
	}
	else {
		$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, 'links_moderate_linkbit', $query, 0, 1, 1);
		$linklistbit = map_listbit_to_grid($linklistarray, 1, 1);
	}

	$linkratings = get_ratingsbits($hitids, $pagenumber);
	$linkratingspopupbit = implode("", $linkratings);

	$navbits = array();
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $this_navigation_title;

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid   = $linkscat[$viewcatid]["parentid"];
	$viewcatname  = $linkscat[$viewcatid]["catname_clean"];
	$message = iif($nhits, $nhits, 0) . ' ' . $vbphrase['ll_entries_to_moderate'];
	$viewcatdesc = $message;
	$viewcattext = $message;

	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$links_permissions["can_add_link"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_moderate_select')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_moderate_select')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Do (Moderate) Categories

if ($this_action == "domodcats") {

	$url = $LINKS_SCRIPT.".php";

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'modcatid' => TYPE_ARRAY_INT,
		'catpage' => TYPE_INT,
		'domod' => TYPE_STR,
	));

	$domod = $vbulletin->GPC['domod'];
	$catpage = iif($vbulletin->GPC['catpage'], $vbulletin->GPC['catpage'], 1);

	$url = $LINKS_SCRIPT.".php?action=mod&amp;page=".$catpage;

	switch ($domod) {
	case 'accept':
		$query = "UPDATE ".THIS_TABLE."linkscat
			SET
				catmoderate='".$LINK_ACCEPTED."'
			WHERE catid IN (0,".implode(',',$vbulletin->GPC['modcatid']).")
			";
		$vbulletin->db->query_write($query);
		$reply = $vbphrase['ll_accepted'];
		break;

	case 'delete':
		empty_ldm_category($vbulletin->GPC['modcatid'], 1);
		delete_ldm_category($vbulletin->GPC['modcatid']);
		fix_cat_count();
		$reply = $vbphrase['ll_deleted'];
		break;

	default:
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_moderate_category_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($reply,0));

}

// #################### Do (Moderate) Entries

if ($this_action == "domodlinks") {

	$url = $LINKS_SCRIPT.".php";

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'linkid' => TYPE_ARRAY_INT,
		'catid' => TYPE_INT,
		'catpage' => TYPE_INT,
		'domod' => TYPE_STR,
	));

	$domod = $vbulletin->GPC['domod'];
	$viewcatid = $vbulletin->GPC['catid'];
	$catpage = iif($vbulletin->GPC['catpage'], $vbulletin->GPC['catpage'], 1);

	$url = $ACTION_SCRIPT.".php?action=domod&amp;catid=".$viewcatid.'&amp;catpage='.$catpage;

	if (count($vbulletin->GPC['linkid'])) {

		switch ($domod) {

		case 'accept':
			if ($links_defaults['autocreate_active']) {

				$query = "
					SELECT links.linkid AS linkid, links.linkname AS linkname, links.linkdesc AS linkdesc,
						links.linkimg AS linkimg, links.linkforum AS linkforum, ltoc.catid AS catid
					FROM ".THIS_TABLE."linkslink AS links
					LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
					ON links.linkid=ltoc.linkid
					WHERE links.linkid IN (".implode(',', $vbulletin->GPC['linkid']).")
					AND links.linkthread=0
					ORDER BY links.linkid
					";
				$asb = $vbulletin->db->query_read($query);

				$thislinkid = -1;
				while ($row=$vbulletin->db->fetch_array($asb)) {
					if ($thislinkid!=$row['linkid']) {
						$thislinkid = $row['linkid'];
						$auto_announced = array();
					}
					$thiscatid = $row['catid'];
					$auto_active = lookup_setting($thiscatid, 'autocreate_active');
					$auto_forum = lookup_setting($thiscatid, 'autocreate_forum');
					$auto_forum = ($auto_forum>0 ? $auto_forum : $row['linkforum']);
					if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$thislinkid])) {
						continue;
					}
					$auto_announced[$thislinkid] = 1;
					require_once(DIR . '/includes/local_links_forumsinterface.php');
					list($error, $reply) = ldm_announce_in_forum(
						$auto_forum,
						lookup_setting($thiscatid, 'autocreate_both_ways'),
						$thislinkid,
						$thiscatid,
						$row['linkname'],
						$row['linkdesc'],
						(in_array(strtolower(substr(strrchr(basename($row['linkimg']), "."), 1)), array("jpg", "gif", "png")) ? $row['linkimg'] : ""),
						lookup_setting($thiscatid, 'autocreate_username'),
						lookup_setting($thiscatid, 'autocreate_userid')
						);
				}
			}
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_ACCEPTED."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);

			if ($links_defaults['moderate_email_accept']) {
				require_once(DIR . '/includes/local_links_misc.php');
				foreach ($vbulletin->GPC['linkid'] as $linkid) {
					ldm_notify_moderated($linkid, $viewcatid, 1);
				}
			}

			$reply = $vbphrase['ll_accepted'];
			break;

		case 'hide':
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_TO_MODERATE."',
					linkstatus='".$LINK_HIDDEN."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);
			$reply = $vbphrase['ll_hidden'];
			break;

		case 'unhide':
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_TO_MODERATE."',
					linkstatus='".$LINK_OK."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);
			$reply = $vbphrase['ll_unhidden'];
			break;

		case 'delete':
			delete_ldm_entry($vbulletin->GPC['linkid']);
			fix_cat_count();

			if ($links_defaults['moderate_email_accept']) {
				require_once(DIR . '/includes/local_links_misc.php');
				foreach ($vbulletin->GPC['linkid'] as $linkid) {
					ldm_notify_moderated($linkid, $viewcatid, 0);
				}
			}

			$reply = $vbphrase['ll_deleted'];
			break;

		default:
			print_no_permission();
			exit;
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_moderate_entry_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($reply,0));

}

// #################### Do (Add) Entry

if ($this_action == "doaddlink") {

	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_INT,
		'date' => TYPE_ARRAY_STR,
		'display_order' => TYPE_INT,
		'hide' => TYPE_INT,
		'keywords' => TYPE_ARRAY_STR,
		'linkdoi' => TYPE_STR,
		'linkdups' => TYPE_INT,
		'linkfile' => TYPE_STR,
		'linkimg' => TYPE_STR,
		'linkname' => TYPE_STR,
		'linkreviewfreq' => TYPE_INT,
		'linkurl' => TYPE_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_STR,
		'newkeywords' => TYPE_STR,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$viewcatid 	= $vbulletin->GPC['catid'];

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	$pcatid		= $vbulletin->GPC['pcatid'];  // an array ...
	$pforum		= $vbulletin->GPC['pforum'];
	$linkname 	= $vbulletin->GPC['linkname'];
	$linkdoi 	= $vbulletin->GPC['linkdoi'];
	$linkurl 	= $vbulletin->GPC['linkurl'];
	$linkimg 	= $vbulletin->GPC['linkimg'];
	$linkfile	= $vbulletin->GPC['linkfile'];
	$linkdesc	= $message;
	$linkdups	= $vbulletin->GPC['linkdups'];
	$display_order = $vbulletin->GPC['display_order'];
	$change_display_order = $vbulletin->GPC['change_display_order'];
	$linkreviewfreq = $vbulletin->GPC['linkreviewfreq'];
	$linkuser 	= $vbulletin->GPC['linkuser'];

	$url = $LINKS_SCRIPT.".php?catid=$viewcatid";

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; }

	$linkusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($linkusergroupid<=1) {
		if (!is_valid_email($linkuser)) {
			$err = $vbphrase['ll_error_email'].' '.$linkuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$linkuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($linkuser) {
			$userinfo = lookup_userids(array($linkuser));
			$linkuserid = $userinfo[0];
			if (!$linkuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$linkuser = $vbulletin->userinfo['username'];
			$linkuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!forumid_is_valid($pforum)) {
		$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!catid_is_valid($pcatid)) {
		$err = $vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$closed = "";
	foreach ($pcatid as $thiscat) {
		if ($linkscat[$thiscat]["catclosed"] and !$links_permissions["can_admin_links"]) {
			$closed .= $linkscat[$thiscat]["catname_clean"].' ';
		}
	}
	if ($closed) {
		$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if (!$linkname) {
		$err = $vbphrase['ll_error_linknull'].$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if ($links_permissions['must_add_keyword'] and
		!count($vbulletin->GPC['keywords']) and !$vbulletin->GPC['newkeywords']) {
		$err = $vbphrase['ll_keywords_required'].$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if ($linkdoi) {
		$row = $vbulletin->db->query_first("
			SELECT linkid, linkdoi
			FROM ".THIS_TABLE."linkslink
			WHERE linkdoi LIKE ('".$linkdoi."')
			LIMIT 1
		");
		if ($row['linkid']) {
			$err = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?linkid='.$row['linkid']).
				$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
	}

	$date = $vbulletin->GPC['date'];
	if ($date['ampm']==2 and $date['hour']<=12) $date['hour'] +=12;
	if ($date['now']) {
		$linkdate = TIMENOW;
	}
	else {
		require_once(DIR . '/includes/functions_misc.php');
		$linkdate = vbmktime($date['hour'], $date['min'], 0, $date['month'], $date['day'], $date['year']);
		if ($linkdate<0 or $date['hour']<0 or $date['hour']>24 or $date['min']<0 or $date['min']>60 or $date['day']>31) {
			$err = $vbphrase['ll_error_date'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}

	if (vbstrlen($linkdesc)>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
		eval(standard_error(fetch_error('toolong', vbstrlen($linkdesc), $links_defaults['max_textlength'])));
	}

	if ($linkurl) {

		$statuscheck = check_ldm_url($linkurl);
		$filesize = iif($statuscheck==$LINK_OK, size_url($linkurl), 0);

	}
	else {
		$vbulletin->input->clean_array_gpc('f', array(
			'linkupload' => TYPE_FILE
		));
		if ($vbulletin->GPC['linkupload']['name']) {
			$status = ldm_process_upload($vbulletin->GPC['linkupload'], $linkurl);
			if ($status) {
				$err = $vbphrase['ll_error_upload_'.$status];
				eval(standard_error($err.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
				exit;
			}
			$statuscheck = $LINK_UPLOAD;
			$filesize = $vbulletin->GPC['linkupload']['size'];
			if (!$linkfile) {
				$linkfile = $vbulletin->GPC['linkupload']['name'];
				ldm_fix_filename($linkfile, 1);
			}
		}
		elseif ($links_defaults["allow_null_links"]) {
			$statuscheck = $LINK_OK;
			$filesize = 0;
			$linkdups = 1;
		}
		else {
			$err = $vbphrase['ll_error_urlnull'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

	}

	if ($linkfile and $linkurl) {
		if (ldm_fix_filename($linkfile)) {
			$err = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile).$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		$lft_url = strtolower(substr(strrchr($linkurl, '.'), 1));
		$lft_fil = strtolower(substr(strrchr($linkfile, '.'), 1));
		if ($lft_fil != $lft_url) {
			$err = $vbphrase['ll_error_rename_type'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
	}

	if ($statuscheck == $LINK_NO_ACCESS) {
		$err = $vbphrase['ll_error_protocol'].' '.$linkurl.$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}
	elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
		$err = $vbphrase['ll_error_remote'].' '.$linkurl.$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	$imgstatuscheck = 0;

	$vbulletin->input->clean_array_gpc('f', array(
		'imgupload' => TYPE_FILE
	));

	if ($vbulletin->GPC['imgupload']['name']) {
		$status = ldm_process_upload($vbulletin->GPC['imgupload'], $linkimg, "imageuploads");
		if ($status>0) {
			eval(standard_error($vbphrase['ll_error_upload_'.$status].$vbphrase['ll_goback']));
			exit;
		}
		$imgstatuscheck = $LINK_UPLOAD;
	}

	if (!$linkimg) {
		set_autoimage($linkurl, $linkimg);
	}

	if ($linkimg) {
		if ($linkimg==$linkurl) {
			$imgcheck = $statuscheck;
		}
		else {
			$imgcheck = check_ldm_url($linkimg);
		}
		if ($imgcheck == $LINK_NO_ACCESS) {
			$err = $vbphrase['ll_error_protocol'].' '.$linkimg.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$err = $vbphrase['ll_error_remote'].' '.$linkimg.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		if (!$imgstatuscheck) $imgstatuscheck = $imgcheck;
	}

	$linkimgthumb = "";
	$linkimgthumbsize = 0;
	if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
		require_once(DIR . '/includes/local_links_resize.php');
		$thumb = make_thumbnail($linkimg, $links_defaults['link_imagesize']);
		if ($thumb) {
			$linkimgthumb = save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			$linkimgthumbsize = $links_defaults['link_imagesize'];
		}
	}

	$moderate = $LINK_ACCEPTED;
	if (!$links_permissions["can_moderate_links"]) {
		$moderate_email_submit = 0;
		foreach ($pcatid as $thiscat) {
			if (lookup_setting($thiscat, 'moderate_links')) {
				$moderate = $LINK_TO_MODERATE;
			}
			if (lookup_setting($thiscat, 'moderate_email_submit')) {
				$moderate_email_submit = 1;
			}
		}
	}

	if ($vbulletin->GPC['hide'] and ($statuscheck==$LINK_OK or $statuscheck==$LINK_UPLOAD)) {
		$statuscheck = $LINK_HIDDEN;
	}

	require_once(DIR . '/includes/functions_newpost.php');
	$linkdesc = convert_url_to_bbcode($linkdesc);

	($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

	list ($insert_status, $linkid) = create_ldm_entry($linkuser, $linkuserid, $linkname, $linkdoi, $linkurl, $linkfile, $linkimg,
			$linkdesc, $pforum, $filesize, $statuscheck, $imgstatuscheck, $linkimgthumb, $linkimgthumbsize, $moderate, $linkreviewfreq, $linkdate, $linkdups);

	if ($insert_status<=0) {
		$message = $vbphrase['ll_error_linkduplicate'];
		if ($LDM_environment['is_admin']) {
			$message .= $vbphrase['ll_goback'];
		}
		eval(standard_error($message));
		exit;
	}

	$dorder = array();
	foreach ($pcatid as $k=>$p) {
		$dorder[$k] = iif($change_display_order==2, $display_order, iif($p==$viewcatid, $display_order, 1));
	}
	insert_link_in_ldm_category($linkid, $pcatid, $dorder);

	if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
		associate_keywords($linkid, $vbulletin->GPC['keywords'], 0);
		associate_keywords($linkid, lookup_keywords(explode_keywords($vbulletin->GPC['newkeywords'])), 1);
	}

	if ($moderate != $LINK_TO_MODERATE) {

		$message = $vbphrase['ll_accepted'];
		$error = 0;

		$auto_announced = array();
		$auto_img = (in_array(strtolower(substr(strrchr(basename($linkimg), "."), 1)), array("jpg", "gif", "png")) ? $linkimg : "");

		foreach ($pcatid as $thiscat) {
			$auto_active = lookup_setting($thiscat, 'autocreate_active');
			$auto_forum = lookup_setting($thiscat, 'autocreate_forum');
			$auto_forum = ($auto_forum>0 ? $auto_forum : $pforum);
			if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$auto_forum])) {
				continue;
			}
			require_once(DIR . '/includes/local_links_forumsinterface.php');
			$auto_announced[$auto_forum] = 1;
			$auto_userid = lookup_setting($thiscat, 'autocreate_userid');
			if ($auto_userid) {
				$auto_username = lookup_setting($thiscat, 'autocreate_username');
			}
			else {
				$auto_username = $vbulletin->userinfo['username'];
				$auto_userid = $vbulletin->userinfo['userid'];
			}
			$auto_bothways = lookup_setting($thiscat, 'autocreate_both_ways');

			list($error, $message) = ldm_announce_in_forum(
				$auto_forum, $auto_bothways, $linkid, $thiscat, $linkname, $linkdesc,
				$auto_img, $auto_username, $auto_userid
				);

		}

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.".php?action=editlink&amp;linkid=$linkid&amp;catid=$viewcatid";
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.'</a><br /><br />'.
				'<a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.$vbphrase['ll_modify'].'</b></a>'
				;
			eval(standard_error($message));
		}

		($hook = vBulletinHook::fetch_hook('ldm_addlink_inserted')) ? eval($hook) : false;

		$vbulletin->url = $url."#linkid".$linkid;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($message,0));

	}
	else {

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.".php?action=editlink&linkid=$linkid&catid=$viewcatid";
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.
				'</a><br /><a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.
				$vbphrase['ll_modify'].'</b></a>'
				;
			eval(standard_error($message));
		}
		if ($moderate_email_submit) {
			$subject = construct_phrase($vbphrase['ll_admin_newentry_subject'], $vbulletin->options['bbtitle']);
			$message = construct_phrase($vbphrase['ll_admin_newentry_body'],
				$vbulletin->userinfo['username'],
				$vbulletin->userinfo['email'],
				mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?catid='.$viewcatid.'&linkid='.$linkid)
				);
			$mods = ldm_fetch_moderators($viewcatid, 0);
			$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);
			foreach ($mods AS $index => $moderator) {
				if (!empty($moderator['email'])) {
					vbmail($moderator['email'], $subject, $message, true);
				}
			}
		}
		$message = $vbphrase['ll_submit_moderation'];
		$error = 0;
		($hook = vBulletinHook::fetch_hook('ldm_addlink_inserted_tomoderate')) ? eval($hook) : false;
		$vbulletin->url = $url."#linkid".$linkid;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($vbphrase['ll_submit_moderation'],0));
	}
	exit;

}

// #################### Do (Add) Multiple Entries

if ($this_action == "domultilink") {

	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_INT,
		'date' => TYPE_ARRAY_STR,
		'display_order' => TYPE_INT,
		'linkdoi' => TYPE_ARRAY_STR,
		'linkdups' => TYPE_ARRAY_INT,
		'linkfile' => TYPE_ARRAY_STR,
		'linkhide' => TYPE_ARRAY_INT,
		'linkimg' => TYPE_ARRAY_STR,
		'linkname' => TYPE_ARRAY_STR,
		'linkreviewfreq' => TYPE_INT,
		'linkurl' => TYPE_ARRAY_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_ARRAY_STR,
		'newkeywords' => TYPE_ARRAY_STR,
		'numadd' => TYPE_INT,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'linkupload' => TYPE_FILE,
		'imgupload' => TYPE_FILE,
	));


	$viewcatid 	= $vbulletin->GPC['catid'];
	$numadd 	= $vbulletin->GPC['numadd'];

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	$url = $LINKS_SCRIPT.".php?catid=$viewcatid";

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	$pcatid	= $vbulletin->GPC['pcatid'];  // an array ...
	$linkreviewfreq = $vbulletin->GPC['linkreviewfreq'];
	$linkuser = $vbulletin->GPC['linkuser'];
	$change_display_order = $vbulletin->GPC['change_display_order'];
	$display_order = $vbulletin->GPC['display_order'];

	$pforum	= $vbulletin->GPC['pforum'];
	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; }

	$linkusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($linkusergroupid<=1) {
		if (!is_valid_email($linkuser)) {
			$err = $vbphrase['ll_error_email'].' '.$linkuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$linkuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($linkuser) {
			$userinfo = lookup_userids(array($linkuser));
			$linkuserid = $userinfo[0];
			if (!$linkuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$linkuser = $vbulletin->userinfo['username'];
			$linkuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!forumid_is_valid($pforum)) {
		$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!catid_is_valid($pcatid)) {
		$err = $vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$closed = "";
	foreach ($pcatid as $thiscat) {
		if ($linkscat[$thiscat]["catclosed"] and !$links_permissions["can_admin_links"]) {
			$closed .= $linkscat[$thiscat]["catname_clean"].' ';
		}
	}
	if ($closed) {
		$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	$date = $vbulletin->GPC['date'];
	if ($date['ampm']==2 and $date['hour']<=12) $date['hour'] +=12;
	if ($date['now']) {
		$linkdate = TIMENOW;
	}
	else {
		require_once(DIR . '/includes/functions_misc.php');
		$linkdate = vbmktime($date['hour'], $date['min'], 0, $date['month'], $date['day'], $date['year']);
		if ($linkdate<0 or $date['hour']<0 or $date['hour']>24 or $date['min']<0 or $date['min']>60 or $date['day']>31) {
			$err = $vbphrase['ll_error_date'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}

	$moderate = $LINK_ACCEPTED;
	if (!$links_permissions["can_moderate_links"]) {
		$moderate_email_submit = 0;
		foreach ($pcatid as $thiscat) {
			if (lookup_setting($thiscat, 'moderate_links')) {
				$moderate = $LINK_TO_MODERATE;
			}
			if (lookup_setting($thiscat, 'moderate_email_submit')) {
				$moderate_email_submit = 1;
			}
		}
	}

	$array_linkname 	= $vbulletin->GPC['linkname'];
	$array_linkurl 		= $vbulletin->GPC['linkurl'];
	$array_linkimg 		= $vbulletin->GPC['linkimg'];
	$array_linkhide		= $vbulletin->GPC['linkhide'];
	$array_linkfile		= $vbulletin->GPC['linkfile'];
	$array_linkdoi 		= $vbulletin->GPC['linkdoi'];
	$array_linkdesc		= $vbulletin->GPC['message'];
	$array_linkupload	= $vbulletin->GPC['linkupload'];
	$array_imgupload	= $vbulletin->GPC['imgupload'];
	$array_newkeywords	= $vbulletin->GPC['newkeywords'];
	$array_linkdups		= $vbulletin->GPC['linkdups'];

	$errors = array();

	for ($thislink=1; $thislink<=$numadd; $thislink++) {

		$linkname	= $array_linkname[$thislink];
		$linkurl	= $array_linkurl[$thislink];
		$linkimg 	= $array_linkimg[$thislink];
		$linkfile	= $array_linkfile[$thislink];
		$linkdoi 	= $array_linkdoi[$thislink];
		$linkdesc	= $array_linkdesc[$thislink];
		$newkeywords= $array_newkeywords[$thislink];
		$linkdups	= $array_linkdups[$thislink];

		$linkupload = array();
		foreach ($array_linkupload as $k=>$v) {
			$linkupload[$k] = $array_linkupload[$k][$thislink];
		}
		foreach ($array_imgupload as $k=>$v) {
			$imgupload[$k] = $array_imgupload[$k][$thislink];
		}

		if (!$linkname and !$linkdesc) {
			continue;
		}

		if ($links_permissions['must_add_keyword'] and !$newkeywords) {
			$errors[$thislink][] = $vbphrase['ll_keywords_required'];
		}

		if ($linkdoi) {
			$row = $vbulletin->db->query_first("
				SELECT linkid, linkdoi
				FROM ".THIS_TABLE."linkslink
				WHERE linkdoi LIKE ('".$linkdoi."')
				LIMIT 1
			");
			if ($row['linkid']) {
				$errors[$thislink][] = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?linkid='.$row['linkid']);
			}
		}

		if (vbstrlen($linkdesc)>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
			eval(standard_error(fetch_error('toolong', vbstrlen($linkdesc), $links_defaults['max_textlength'])));
		}

		if ($linkurl) {

			if ($linkdups!=1) {
				$asb = $vbulletin->db->query_read("
					SELECT linkid FROM ".THIS_TABLE."linkslink
					WHERE linkurl='".$vbulletin->db->escape_string($linkurl)."'
					");
				$count = $vbulletin->db->num_rows($asb);
				$vbulletin->db->free_result($asb);
				if ($count) {
					$errors[$thislink][] = $vbphrase['ll_error_linkduplicate'];
					continue;
				}
			}

			$statuscheck = check_ldm_url($linkurl);
			$filesize = iif($statuscheck==$LINK_OK, size_url($linkurl), 0);

		}
		else {
			if ($linkupload['name']) {
				$status = ldm_process_upload($linkupload, $linkurl);
				if ($status) {
					$errors[$thislink][] = $vbphrase['ll_error_upload_'.$status];
				}
				else {
					$statuscheck = $LINK_UPLOAD;
					$filesize = $linkupload['size'];
					if (!$linkfile) {
						$linkfile = $linkupload['name'];
						ldm_fix_filename($linkfile, 1);
					}
				}
			}
			elseif ($links_defaults["allow_null_links"]) {
				$statuscheck = $LINK_OK;
				$filesize = 0;
				$linkdups = 1;
			}
			else {
				$errors[$thislink][] = $vbphrase['ll_error_urlnull'];
			}

		}

		if ($linkfile and $linkurl) {
			if (ldm_fix_filename($linkfile)) {
				$errors[$thislink][] = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile);
			}
			$lft_url = strtolower(substr(strrchr($linkurl, '.'), 1));
			$lft_fil = strtolower(substr(strrchr($linkfile, '.'), 1));
			if ($lft_fil != $lft_url) {
				$errors[$thislink][] = $vbphrase['ll_error_rename_type'];
			}
		}

		if ($statuscheck == $LINK_NO_ACCESS) {
			$errors[$thislink][] = $vbphrase['ll_error_protocol'].' '.$linkurl;
		}
		elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$errors[$thislink][] = $vbphrase['ll_error_remote'].' '.$linkurl;
		}

		$imgstatuscheck = 0;

		if ($imgupload['name']) {
			$status = ldm_process_upload($imgupload, $linkimg, "imageuploads");
			if ($status>0) {
				$errors[$thislink][] = $vbphrase['ll_error_upload_'.$status];
			}
			$imgstatuscheck = $LINK_UPLOAD;
		}

		if (!$linkimg) {
			set_autoimage($linkurl, $linkimg);
		}

		if ($linkimg) {
			if ($linkimg==$linkurl) {
				$imgcheck = $statuscheck;
			}
			else {
				$imgcheck = check_ldm_url($linkimg);
			}
			if ($imgcheck == $LINK_NO_ACCESS) {
				$errors[$thislink][] = $vbphrase['ll_error_protocol'];
			}
			elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
				$errors[$thislink][] = $vbphrase['ll_error_remote'];
			}
			if (!$imgstatuscheck) $imgstatuscheck = $imgcheck;
		}

		$linkimgthumb = "";
		$linkimgthumbsize = 0;
		if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
			require_once(DIR . '/includes/local_links_resize.php');
			$thumb = make_thumbnail($linkimg, $links_defaults['link_imagesize']);
			if ($thumb) {
				$linkimgthumb = save_thumbnail($thumb, $links_defaults['thumbs_dir']);
				$linkimgthumbsize = $links_defaults['link_imagesize'];
			}
		}

		if ($array_linkhide[$thislink] and ($statuscheck==$LINK_OK or $statuscheck==$LINK_UPLOAD)) {
			$statuscheck = $LINK_HIDDEN;
		}

		require_once(DIR . '/includes/functions_newpost.php');
		$linkdesc = convert_url_to_bbcode($linkdesc);

		$array_linkset[$thislink] = 1;
		$array_linkuser[$thislink] = $linkuser;
		$array_linkuserid[$thislink] = $linkuserid;
		$array_linkname[$thislink] = $linkname;
		$array_linkdoi[$thislink] = $linkdoi;
		$array_linkurl[$thislink] = $linkurl;
		$array_linkfile[$thislink] = $linkfile;
		$array_linkimg[$thislink] = $linkimg;
		$array_linkdesc[$thislink] = $linkdesc;
		$array_pforum[$thislink] = $pforum;
		$array_filesize[$thislink] = $filesize;
		$array_statuscheck[$thislink] = $statuscheck;
		$array_imgstatuscheck[$thislink] = $imgstatuscheck;
		$array_linkimgthumb[$thislink] = $linkimgthumb;
		$array_linkimgthumbsize[$thislink] = $linkimgthumbsize;
		$array_linkdups[$thislink] = $linkdups;

	}

	if (count($errors)) {
		$error = "";
		foreach ($errors as $k=>$v) {
			$error .= "$k<br />";
			foreach ($v as $v1) {
				$error .= "$v1<br />";
			}
		}
		$error .= $vbphrase['ll_goback'];
		eval(standard_error($error));
		exit;
	}

	for ($thislink=1; $thislink<=$numadd; $thislink++) {

		if (!$array_linkset[$thislink]) {
			continue;
		}

		($hook = vBulletinHook::fetch_hook('ldm_multilink_preinsert')) ? eval($hook) : false;

		list ($insert_status, $array_linkid[$thislink]) = create_ldm_entry($array_linkuser[$thislink], $array_linkuserid[$thislink],
			$array_linkname[$thislink], $array_linkdoi[$thislink], $array_linkurl[$thislink], $array_linkfile[$thislink], $array_linkimg[$thislink],
			$array_linkdesc[$thislink], $array_pforum[$thislink], $array_filesize[$thislink], $array_statuscheck[$thislink], $array_imgstatuscheck[$thislink],
			$array_linkimgthumb[$thislink], $array_linkimgthumbsize[$thislink], $moderate, $linkreviewfreq,
			$linkdate, $array_linkdups[$thislink]);

		$dorder = array();
		foreach ($pcatid as $k=>$p) {
			$dorder[$k] = $change_display_order==2 ? $display_order : ($p==$viewcatid ? $display_order : 1);
		}
		insert_link_in_ldm_category($array_linkid[$thislink], $pcatid, $dorder);

		if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
			associate_keywords($array_linkid[$thislink], lookup_keywords(explode_keywords($array_newkeywords[$thislink])), 1);
		}

		if ($moderate != $LINK_TO_MODERATE) {
			$auto_announced = array();
			$auto_type = strtolower(substr(strrchr(basename($array_linkimg[$thislink]), "."), 1));
			$auto_img = in_array($auto_type, array("jpg", "gif", "png")) ? $array_linkimg[$thislink] : "";

			foreach ($pcatid as $thiscat) {
				$auto_active = lookup_setting($thiscat, 'autocreate_active');
				$auto_forum = lookup_setting($thiscat, 'autocreate_forum');
				$auto_forum = ($auto_forum>0 ? $auto_forum : $pforum);
				if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$auto_forum])) {
					continue;
				}
				require_once(DIR . '/includes/local_links_forumsinterface.php');
				$auto_announced[$auto_forum] = 1;
				$auto_userid = lookup_setting($thiscat, 'autocreate_userid');
				if ($auto_userid) {
					$auto_username = lookup_setting($thiscat, 'autocreate_username');
				}
				else {
					$auto_username = $vbulletin->userinfo['username'];
					$auto_userid = $vbulletin->userinfo['userid'];
				}
				$auto_bothways = lookup_setting($thiscat, 'autocreate_both_ways');

				list($error, $message) = ldm_announce_in_forum(
					$auto_forum, $auto_bothways, $array_linkid[$thislink], $thiscat, $array_linkname[$thislink], $array_linkdesc[$thislink],
					$auto_img, $auto_username, $auto_userid
					);
			}
		}

	}

	if ($moderate != $LINK_TO_MODERATE) {
		$message = $vbphrase['ll_accepted'];
		$error = 0;

		($hook = vBulletinHook::fetch_hook('ldm_multiaddlink_inserted')) ? eval($hook) : false;

		$vbulletin->url = $url;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($message,0));
	}
	else {

		if ($moderate_email_submit) {
			$subject = construct_phrase($vbphrase['ll_admin_newentry_subject'], $vbulletin->options['bbtitle']);
			$mods = ldm_fetch_moderators($viewcatid, 0);
			for ($thislink=1; $thislink<=$numadd; $thislink++) {
				if (!$array_linkset[$thislink]) {
					continue;
				}
				$message = construct_phrase($vbphrase['ll_admin_newentry_body'],
					$vbulletin->userinfo['username'],
					$vbulletin->userinfo['email'],
					mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?catid='.$viewcatid.'&linkid='.$array_linkid[$thislink])
						);
				$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);
				foreach ($mods AS $index => $moderator) {
					if (!empty($moderator['email'])) {
						vbmail($moderator['email'], $subject, $message, true);
					}
				}
			}
		}
		$message = $vbphrase['ll_submit_moderation'];
		$error = 0;
		($hook = vBulletinHook::fetch_hook('ldm_multilink_inserted_tomoderate')) ? eval($hook) : false;
		$vbulletin->url = $url;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($vbphrase['ll_submit_moderation'],0));
	}

	exit;

}

// #################### Do (Edit) Entry

if ($this_action == "doeditlink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_INT,
		'confirmdelete' => TYPE_INT,
		'date' => TYPE_ARRAY_STR,
		'delete' => TYPE_INT,
		'display_order' => TYPE_INT,
		'expirenow' => TYPE_INT,
		'hide' => TYPE_INT,
		'keywords' => TYPE_ARRAY_STR,
		'linkdate' => TYPE_INT,
		'linkdesc' => TYPE_STR,
		'linkdoi' => TYPE_STR,
		'linkdups' => TYPE_INT,
		'linkfile' => TYPE_STR,
		'linkid' => TYPE_INT,
		'linkimg' => TYPE_STR,
		'linkimg_delete' => TYPE_INT,
		'linkimg_replace' => TYPE_STR,
		'linkname' => TYPE_STR,
		'linkreviewfreq' => TYPE_INT,
		'linkurl' => TYPE_STR,
		'linkurl_replace' => TYPE_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_STR,
		'newkeywords' => TYPE_STR,
		'notify' => TYPE_INT,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
		'updatetimestamp' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$pcatid 	= $vbulletin->GPC['pcatid'];  // an array ...

	$viewcatid 	= $vbulletin->GPC['catid'];
	$viewlinkid = $vbulletin->GPC['linkid'];
	$pforum 	= $vbulletin->GPC['pforum'];
	$linkname 	= $vbulletin->GPC['linkname'];
	$linkdoi 	= $vbulletin->GPC['linkdoi'];
	$linkurl 	= $vbulletin->GPC['linkurl'];
	$linkimg 	= $vbulletin->GPC['linkimg'];
	$linkfile 	= $vbulletin->GPC['linkfile'];
	$linkdesc 	= $message;
	$linkuser	= $vbulletin->GPC['linkuser'];

	$display_order = $vbulletin->GPC['display_order'];
	$change_display_order = $vbulletin->GPC['change_display_order'];
	$linkreviewfreq = $vbulletin->GPC['linkreviewfreq'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.'.php?catid='.$viewcatid.'&page='.$pagenumber;
	}
	else {
		$url = $SEARCH_SCRIPT.'.php?action=find&amp;catid='.$viewcatid.'&page='.$pagenumber;
	}

	if ($viewlinkid == '') {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $linkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT * FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$viewlinkid."
		LIMIT 1
		");

	if ($vbulletin->db->num_rows($asb)<=0) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$myrow=$vbulletin->db->fetch_array($asb);
	$oldurl = $myrow['linkurl'];
	$oldstatus = $myrow['linkstatus'];
	$oldimg = $myrow['linkimg'];
	$oldimgstatus = $myrow['linkimgstatus'];
	$oldthumb = $myrow['linkimgthumb'];
	$oldfile = $myrow['linkfile'];
	$olduserid = $myrow['linkuserid'];
	$oldusername = $myrow['linkusername'];

	if ($vbulletin->userinfo['userid']<>$olduserid and (!isset($links_permissions["can_edit_link"]) or !$links_permissions["can_edit_link"])) {
		print_no_permission();
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksltoc
		WHERE linkid='".$viewlinkid."'
		");
	$oldcat = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$oldcat[] = $myrow['catid'];
	}

	if ($vbulletin->GPC_exists['submit']) {
		$submit = "submit";
	}
	elseif ($vbulletin->GPC_exists['delete']) {
		$submit = "delete";
	}
	else {
		$statuscheck = check_ldm_url($oldurl);
		if ($statuscheck) {
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
			exit;
		}
		else {
			$eurl = $LINKS_SCRIPT.'.php?action=editlink&linkid='.$viewlinkid.'&catid='.$viewcatid.'&page=$pagenumber';
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.'</a><br />'.
			'<a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.$vbphrase['ll_modify'].'</b></a>'
			;
			eval(standard_error($message));
		}
	}

	if (($submit=="delete" and !$vbulletin->GPC['confirmdelete']) or ($submit!="delete" and $vbulletin->GPC['confirmdelete'])) {
		eval(standard_error($vbphrase['ll_confirm_delete'].$vbphrase['ll_goback']));
		exit;
	}

	$statustime = TIMENOW;

	if ($submit == 'submit') {

		if ($oldusername != $linkuser) {
			if ($vbulletin->userinfo['usergroupid']<=1) {
				if (!is_valid_email($linkuser)) {
					$err = $vbphrase['ll_error_email'].' '.$linkuser.$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
				$linkuserid = $vbulletin->userinfo['userid'];
			}
			elseif ($linkuser) {
				$userinfo = lookup_userids(array($linkuser));
				if ($userinfo[0]) {
					$linkuserid = $userinfo[0];
				}
				elseif (is_valid_email($linkuser)) {
					$linkuserid = 0;
				}
				else {
					$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
			}
			else {
				$linkuser = $vbulletin->userinfo['username'];
				$linkuserid = $vbulletin->userinfo['userid'];
			}
		}
		else {
			$linkuser = $oldusername;
			$linkuserid = $olduserid;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};

		if (!forumid_is_valid($pforum)) {
			$err = $vbphrase['ll_error_forum'].' '.$pforum.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if (!$links_permissions["can_admin_links"]) {
			$newcat = array_diff($pcatid, $oldcat);
			$closed = "";
			foreach ($newcat as $thiscat) {
				if ($linkscat[$thiscat]["catclosed"]) {
					$closed .= $linkscat[$thiscat]["catname_clean"].' ';
				}
			}
			if ($closed) {
				$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			foreach ($oldcat as $thiscat) { // fix browser bug with selected/disabled
				if ($linkscat[$thiscat]["catclosed"] and !in_array($thiscat, $pcatid)) $pcatid[] = $thiscat;
			}
		}

		if (!catid_is_valid($pcatid)) {
			$err = $vbphrase['ll_error_category'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($linkname == '') {
			$err = $vbphrase['ll_error_linknull'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($links_permissions['must_add_keyword'] and
			!count($vbulletin->GPC['keywords']) and !$vbulletin->GPC['newkeywords']) {
			$err = $vbphrase['ll_keywords_required'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($linkdoi) {
			$row = $vbulletin->db->query_first("
				SELECT linkid, linkdoi
				FROM ".THIS_TABLE."linkslink
				WHERE linkdoi LIKE ('".$linkdoi."')
				AND linkid <> ".$viewlinkid."
				LIMIT 1
			");
			if ($row['linkid']) {
				$err = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?linkid='.$row['linkid']).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}

		if (vbstrlen($linkdesc)>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
			eval(standard_error(fetch_error('toolong', vbstrlen($linkdesc), $links_defaults['max_textlength'])));
		}

		$vbulletin->input->clean_array_gpc('f', array(
			'linkupload' => TYPE_FILE
		));

		if ($vbulletin->GPC['linkupload']['name']) {
			$status = ldm_process_upload($vbulletin->GPC['linkupload'], $linkurl);
			if ($status>0) {
				eval(standard_error($vbphrase['ll_error_upload_'.$status].$vbphrase['ll_goback']));
				exit;
			}
			if ($oldstatus == $LINK_UPLOAD) {
				delete_upload($oldurl);
			}
			if ($oldurl == $linkimg) {
				$linkimg = "";
			}
			$statuscheck = $LINK_UPLOAD;
			$filesize = $vbulletin->GPC['linkupload']['size'];
			if (!$linkfile) {
				$linkfile = $vbulletin->GPC['linkupload']['name'];
				ldm_fix_filename($linkfile, 1);
			}
		}
		elseif ($vbulletin->GPC['linkurl_replace']) {
			if ($oldstatus == $LINK_UPLOAD) {
				delete_upload($oldurl);
			}
			$linkurl = $vbulletin->GPC['linkurl_replace'];
			$statuscheck = check_ldm_url($linkurl);
			$filesize = size_url($linkurl);
		}
		elseif (!$linkurl) {
			if ($links_defaults["allow_null_links"]) {
				$statuscheck = $LINK_OK;
				$filesize = 0;
				$linkfile	= '';
			}
			else {
				$err = $vbphrase['ll_error_urlnull'].$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$statuscheck = iif($oldstatus==$LINK_UPLOAD,$LINK_UPLOAD,check_ldm_url($linkurl));
			$filesize = size_url($linkurl);
			$linkfile = iif($linkfile!=$oldfile, $linkfile, iif($oldurl==$linkurl, $oldfile, ""));
		}

		if ($vbulletin->GPC['hide'] and ($statuscheck==$LINK_UPLOAD or $statuscheck==$LINK_OK)) {
			$statuscheck = $LINK_HIDDEN;
		}

		if ($linkfile and $linkurl) {
			if (ldm_fix_filename($linkfile)) {
				$err = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			$lft_url = strtolower(substr(strrchr($linkurl, '.'), 1));
			$lft_fil = strtolower(substr(strrchr($linkfile, '.'), 1));
			if ($lft_fil != $lft_url) {
				$err = $vbphrase['ll_error_rename_type'].$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}

		if ($statuscheck == $LINK_NO_ACCESS) {
			$err = $vbphrase['ll_error_protocol'].' '.$linkurl.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$err = $vbphrase['ll_error_remote'].' '.$linkurl.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		$vbulletin->input->clean_array_gpc('f', array(
			'imgupload' => TYPE_FILE
		));

		$imgstatuscheck = 0;
		if ($vbulletin->GPC['imgupload']['name']) {
			$status = ldm_process_upload($vbulletin->GPC['imgupload'], $linkimg, "imageuploads");
			if ($status>0) {
				eval(standard_error($vbphrase['ll_error_upload_'.$status].$vbphrase['ll_goback']));
				exit;
			}
			if ($oldimgstatus == $LINK_UPLOAD) {
				delete_upload($oldimg);
			}
			$imgstatuscheck = $LINK_UPLOAD;
		}
		elseif ($vbulletin->GPC['linkimg_delete'] and !$vbulletin->GPC['linkimg_replace']) {
			if ($oldimgstatus == $LINK_UPLOAD) {
				delete_upload($oldimg);
			}
			$linkimg = "";
		}
		elseif ($vbulletin->GPC['linkimg_replace']) {
			if ($oldimgstatus == $LINK_UPLOAD) {
				delete_upload($oldimg);
			}
			$linkimg = $vbulletin->GPC['linkimg_replace'];
		}

		if (!$linkimg) {
			set_autoimage($linkurl, $linkimg);
		}

		if ($linkimg) {
			if ($linkimg==$linkurl) {
				$imgcheck = $statuscheck;
			}
			else {
				$imgcheck = check_ldm_url($linkimg);
			}
			if ($imgcheck == $LINK_NO_ACCESS) {
				$err = $vbphrase['ll_error_protocol'].' '.$linkimg.$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
				$err = $vbphrase['ll_error_remote'].' '.$linkimg.$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			if (!$imgstatuscheck) $imgstatuscheck = $imgcheck;
		}

		$linkimgthumb = "";
		if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
			require_once(DIR . '/includes/local_links_resize.php');
			$thumb = make_thumbnail($linkimg, $links_defaults['link_imagesize']);
			delete_thumb($oldthumb);
			if ($thumb) {
				$linkimgthumb = save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			}
		}

		$date = $vbulletin->GPC['date'];
		if ($date['ampm']==2 and $date['hour']<=12) $date['hour'] +=12;
		if ($date['now']) {
			$linkdate = TIMENOW;
		}
		else {
			require_once(DIR . '/includes/functions_misc.php');
			$linkdate = vbmktime($date['hour'], $date['min'], 0, $date['month'], $date['day'], $date['year']);
			if ($linkdate<0 or $date['hour']<0 or $date['hour']>24 or $date['min']<0 or $date['min']>60 or $date['day']>31) {
				eval(standard_error($vbphrase['ll_error_date'].$vbphrase['ll_goback']));
				exit;
			}
		}

		require_once(DIR . '/includes/functions_newpost.php');
		$linkdesc = convert_url_to_bbcode($linkdesc);

		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
			linkname='".$vbulletin->db->escape_string($linkname)."',
			linkdoi='".$vbulletin->db->escape_string($linkdoi)."',
			linkurl='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkurl))."',
			linkfile='".$vbulletin->db->escape_string($linkfile)."',
			linkimg='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkimg))."',
			linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkimgthumb))."',
			linkdesc='".$vbulletin->db->escape_string($linkdesc)."',
			linkusername='".$vbulletin->db->escape_string($linkuser)."',
			linkuserid='".$linkuserid."',
			linkforum='".$pforum."',
			linkcheck='".$statustime."',
			linkstatus='".$statuscheck."',
			linksize='".$filesize."',
			linkimgstatus='".$imgstatuscheck."',
			linkdate='".$linkdate."',
			linkreviewfreq='".$linkreviewfreq."'
			WHERE linkid=".$viewlinkid."
			";
		$vbulletin->db->query_write($query);

		$np = 0;
		foreach ($pcatid as $p) { $np++; }
		if ($np==1) { // Assume that user wishes to keep the chosen display order
			$change_display_order = 2;
		}

		if ($change_display_order==2) {

			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");
			foreach ($pcatid as $p) {
				$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksltoc
				SET
					linkid='".$viewlinkid."',
					catid='".$p."',
					displayorder='".$display_order."'
				");
			}

		}
		else {

			$dn = array();
			foreach ($pcatid as $p) {  // Default is to put everything in group 1
				$dn[$p] = 1;
			}
			$asb = $vbulletin->db->query_read("
				SELECT catid, displayorder
				FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");
			while ($myrow=$vbulletin->db->fetch_array($asb)) { // Update according to existing display orders
				$dn[$myrow['catid']] = $myrow['displayorder'];
			}
			$dn[$viewcatid] = $display_order;  // Force this category to new display order

			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");

			foreach ($pcatid as $p) {
				$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksltoc
				SET
					linkid='".$viewlinkid."',
					catid='".$p."',
					displayorder='".$dn[$p]."'
				");
			}
		}

		if ($vbulletin->GPC['expirenow']) {
			$expiredids = array();
			foreach ($pcatid as $p) {
				$expiredids[] = array("linkid"=>$viewlinkid, "catid"=>$p);
			}
			process_ldm_expired($expiredids);
		}

		fix_cat_count();

		if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
			associate_keywords($viewlinkid, $vbulletin->GPC['keywords'], 0);
			associate_keywords($viewlinkid, lookup_keywords(explode_keywords($vbulletin->GPC['newkeywords'])), 1);
		}

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.'.php?action=editlink&amp;linkid='.$viewlinkid.'&amp;catid='.$viewcatid.'&amp;page='.$pagenumber;
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.
			'</a><br /><a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.
			'"><b>'.$vbphrase['ll_modify'].'</b></a>'
			;
			eval(standard_error($message));
		}
		else {

			if ($vbulletin->GPC['notify']) {
				ldm_notify_updated($viewlinkid, $viewcatid);
			}

			($hook = vBulletinHook::fetch_hook('ldm_editlink_submit_complete')) ? eval($hook) : false;

			$message = $vbphrase['ll_edited'];
			$vbulletin->url = $url."#linkid".$viewlinkid;
			eval(print_standard_redirect($message,0));
		}

	}

	if ($submit == 'delete') {
		delete_ldm_entry($viewlinkid);
		fix_cat_count();

		($hook = vBulletinHook::fetch_hook('ldm_editlink_delete_complete')) ? eval($hook) : false;

		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_deleted'],0));
	}

	exit;
}

// #################### Do (Edit) Keywords

if ($this_action == "doeditkeys") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'keywords' => TYPE_STR,
		'linkid' => TYPE_INT,
		'submit' => TYPE_INT,
		'viewlinkid' => TYPE_INT,
	));

	if (!$links_permissions["can_add_keyword"] and !$links_permissions["can_edit_keyword"]) {
		print_no_permission();
		exit;
	}

	$viewcatid 	= $vbulletin->GPC['catid'];
	$viewlinkid = $vbulletin->GPC['viewlinkid'];
	$linkid = $vbulletin->GPC['linkid'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.'.php?catid='.$viewcatid.iif($viewlinkid,'&linkid='.$viewlinkid,'').'&page='.$pagenumber."#linkid".$linkid;
	}
	else {
		$url = $SEARCH_SCRIPT.'.php?action=find&amp;catid='.$viewcatid.'&page='.$pagenumber."#linkid".$linkid;
	}

	if (!$linkid) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $linkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT * FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$linkid." LIMIT 1
		");

	if ($vbulletin->db->num_rows($asb)<=0) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	associate_keywords($linkid, lookup_keywords(explode_keywords($vbulletin->GPC['keywords'])), 0);

	$message = $vbphrase['ll_edited'];
	$vbulletin->url = $url;
	eval(print_standard_redirect($message,0));

}

// #################### Do (Rate) Entry

if ($this_action == "doratelink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'vote' => TYPE_INT,
		'message' => TYPE_STR,
		'messageusername' => TYPE_STR,
		'messageuserid' => TYPE_INT,
		'newusername' => TYPE_STR,
		'rateid' => TYPE_INT,
		'ratesort' => TYPE_STR,
		'lpage' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$viewcatid = $vbulletin->GPC['catid'];
	$linkid	   = $vbulletin->GPC['linkid'];
	$linkvote  = $vbulletin->GPC['vote'];
	$lpage     = $vbulletin->GPC['lpage'];
	$rateid    = $vbulletin->GPC['rateid'];
	$ratesort  = $vbulletin->GPC['ratesort'];
	$lcomment  = iif ($message, $vbulletin->db->escape_string($message),'');

	$url = $LINKS_SCRIPT.".php?action=ratelink&amp;linkid=$linkid&amp;catid=$viewcatid&amp;lpage=$lpage&amp;ratesort=$ratesort&amp;page=$pagenumber";

	if ($rateid>0 and $linkvote<0) {
		$rec = $vbulletin->db->query_first("
			SELECT linkuserid
			FROM ".THIS_TABLE."linksrate
			WHERE lrate='".$rateid."'
			");
		if ($rec['linkuserid']==$vbulletin->userinfo['userid'] or isset($links_permissions["can_admin_links"])) {
			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksrate
				WHERE lrate='".$rateid."'
			");
			ldm_fix_rating_counts($linkid);
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_rating_cleared'],0));
		}
		else {
			print_no_permission();
		}
		exit;
	}

	if (!isset($links_permissions["can_rate_link"]) or !$links_permissions["can_rate_link"]) {
		print_no_permission();
		exit;
	}

	if ($linkvote<$MIN_VOTE or $linkvote>$MAX_VOTE or (!$linkvote and !$lcomment) or (!$linkvote and $links_defaults['must_comment_and_rate'])) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_error_rating'],0));
		exit;
	}

	$messageusername = $vbulletin->GPC['messageusername'] ? $vbulletin->GPC['messageusername'] : $vbulletin->userinfo['username'];
	$messageuserid = $vbulletin->GPC['messageuserid'] ? $vbulletin->GPC['messageuserid'] : $vbulletin->userinfo['userid'];

	if ($vbulletin->GPC['newusername'] and $links_permissions['can_moderate_links']) {
		$userinfo = lookup_userids(array($vbulletin->GPC['newusername']));
		if ($userinfo[0]) {
			$messageuserid = $userinfo[0];
			$messageusername = $vbulletin->GPC['newusername'];
		}
	}

	$rec = $vbulletin->db->query_first("
		SELECT COUNT(linkid) AS linkcount
		FROM ".THIS_TABLE."linkslink
		WHERE linkid='".$linkid."'
		");
	if (!$rec['linkcount']) {
		$vbulletin->url = $LINKS_SCRIPT.".php?catid=$viewcatid";
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_linkid'], $linkid),0));
		exit;
	}

	if ($rateid>0) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linksrate
			SET
				lcomment = '".$lcomment."',
				linkuserid='".$messageuserid."',
				linkusername='".$vbulletin->db->escape_string($messageusername)."'
			WHERE lrate = ".$rateid."
		");
	}
	else {
		$time = TIMENOW;
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linksrate
			SET
				linkid='".$linkid."',
				linkuserid='".$messageuserid."',
				linkusername='".$vbulletin->db->escape_string($messageusername)."',
				linkvote='".$linkvote."',
				lcomment='".$lcomment."',
				ltime='".$time."'
		");
	}

	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksrate
		SET
			linkvote='".$linkvote."'
		WHERE linkid='".$linkid."'
		AND linkuserid='".$messageuserid."'
	"); // ensure consistency

	ldm_fix_rating_counts($linkid);

	if ($links_defaults['autocreate_active'] and
		$links_defaults['autocreate_sync_comments'] and
		$message and
		!$rateid) {

// Post a message if we already have an associated thread and the new message isn't blank

		$row = $vbulletin->db->query_first("
			SELECT *
			FROM ".THIS_TABLE."linkslink
			WHERE linkid=".$linkid."
			LIMIT 1
			");

		$forumid = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $row['linkforum'];
		$linkdesc = $row['linkdesc'];
		$linkname = $row['linkname'];
		$linkimg = $row['linkimg'];

		$threadid = 0;
		if ($row['linkthread']) {
			$threadid = $row['linkthread'];
		}
// Legacy test - don't try too hard - use the last threadid, if any, in the description provided it is in the correct forum
		elseif ($forumid>0 and $links_defaults['autocreate_both_ways']) {
			if ($nmatches = preg_match_all("/\[thread=(\d+)\]/i", $row['linkdesc'], $match)) {
				$threadid = $match[1][$nmatches-1];
				$thisthread = $vbulletin->db->query_first("
					SELECT forumid
					FROM ".TABLE_PREFIX."thread
					WHERE threadid=".$threadid."
					LIMIT 1
					");
				if ($thisthread['forumid']==$forumid) {
					$vbulletin->db->query_write("
						UPDATE ".THIS_TABLE."linkslink
						SET linkthread = '".intval($threadid)."'
						WHERE linkid=".$linkid."
						");
				}
				else {
					$threadid = 0;
				}
			}
		}

		if ($threadid) {
			require_once(DIR . '/includes/local_links_forumsinterface.php');
			$gotolink = mk_file_name($vbulletin->options['bburl'], LINKS_SCRIPT.'.php?linkid='.$linkid);
			$post_message = construct_phrase($vbphrase['ldm_post_addrating_body'], $message, $gotolink, $linkname);
			ldm_append_post(
				$vbphrase['ldm_post_addrating_title'],
				$post_message,
				$linkvote,
				$forumid,
				$threadid,
				$messageusername,
				$messageuserid,
				$newpost);
		}

	}

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_rating_recorded'],0));

	exit;
}

// #################### Do Add/Remove Favourite

if ($this_action == "dofavlink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'id' => TYPE_INT,
		'set' => TYPE_INT
		));

	$viewcatid = $vbulletin->GPC['catid'];
	$linkid	   = $vbulletin->GPC['id'];
	$linkset   = $vbulletin->GPC['set'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.".php?catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}
	else {
		$url = $SEARCH_SCRIPT.".php?action=find&amp;catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}

	if ($linkset < 0) {
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksfavs
			WHERE linkid='".$linkid."'
			AND   userid='".$vbulletin->userinfo['userid']."'
			");
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_myfav_deleted'],0));
		exit;
	}

	if (!isset($links_permissions["can_mark_link"]) or !$links_permissions["can_mark_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksfavs
		WHERE linkid='".$linkid."'
		AND   userid='".$vbulletin->userinfo[userid]."'
		");

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linksfavs (linkid, userid)
		VALUES (
		'".$linkid."',
		'".$vbulletin->userinfo[userid]."'
		)
	");

	($hook = vBulletinHook::fetch_hook('ldm_favourite_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_myfav_added'],0));

	exit;
}

// #################### Do (Add) Category

if ($this_action == "doaddcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	if (!isset($links_permissions["can_add_category"]) or !$links_permissions["can_add_category"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'auto_forumlink' => TYPE_INT,
		'catclosed' => TYPE_INT,
		'catdesc' => TYPE_STR,
		'catname' => TYPE_STR,
		'catsyncdir' => TYPE_STR,
		'cattext' => TYPE_STR,
		'catuser' => TYPE_STR,
		'display_order' => TYPE_INT,
		'forumname' => TYPE_STR,
		'pcatid' => TYPE_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$pcatid	 	= $vbulletin->GPC['pcatid']; // NB - single value
	$catname 	= $vbulletin->GPC['catname'];
	$catdesc 	= $vbulletin->GPC['catdesc'];
	$cattext 	= $vbulletin->GPC['cattext'];
	$catsyncdir	= $vbulletin->GPC['catsyncdir'];
	$catuser 	= $vbulletin->GPC['catuser'];
	$pforum	 	= $vbulletin->GPC['pforum'];
	$display_order = $vbulletin->GPC['display_order'];
	$auto_forumlink = iif($vbulletin->GPC_exists['auto_forumlink'], $vbulletin->GPC['auto_forumlink'], 0);
	$forumname = iif($vbulletin->GPC_exists['forumname'], $vbulletin->GPC['forumname'], $catname);
	$catclosed = iif($vbulletin->GPC['catclosed'],1,0);

	$url = $LINKS_SCRIPT.".php?catid=$pcatid";

	$catusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($catusergroupid<=1) {
		if (!is_valid_email($catuser)) {
			$err = $vbphrase['ll_error_email'].' '.$catuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$catuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($catuser) {
			$userinfo = lookup_userids(array($catuser));
			$catuserid = $userinfo[0];
			if (!$catuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$catuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$catuser = $vbulletin->userinfo['username'];
			$catuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if ($pcatid > 0) {
		if (catid_is_valid($pcatid)) {
			$pcatlist = "$pcatid,".$linkscat[$pcatid]["parentlist"];
		}
		else {
			$url = $LINKS_SCRIPT.'.php';
			eval(standard_error($vbphrase['ll_error_category'].' '.$pcatid.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
	}
	elseif ($pcatid == $BASE_CAT) {
		$pcatlist = $pcatid;
	}
	else {
		$url = $LINKS_SCRIPT.'.php';
		eval(standard_error($vbphrase['ll_error_pcatnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
	}

	if ($catname == ''){
		eval(standard_error($vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; };

	if (!forumid_is_valid($pforum)) {
		eval(standard_error($vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if ($pforum<=0 and $auto_forumlink==1) {
		eval(standard_error($vbphrase['ll_error_forumlink'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if (vbstrlen($catdesc)>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
		eval(standard_error(fetch_error('toolong', vbstrlen($catdesc), $links_defaults['max_textlength'])));
	}

	if ($cattext == '') {
		$cattext = $catdesc;
	}

	if ($catsyncdir) {
		$fulldir = cleanto_fopen($catsyncdir);
		if ($dir_handle = @opendir($fulldir)) {
			closedir($dir_handle);
		}
		else {
			eval(standard_error(construct_phrase($vbphrase['ll_error_catsyncdir'], $catsyncdir).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
	}

	if ($links_permissions["can_moderate_links"]) {
		$moderate = $LINK_ACCEPTED;
	}
	else {
		$moderate = iif($links_defaults["moderate_links"] != '0', $LINK_TO_MODERATE, $LINK_ACCEPTED);
	}

	require_once(DIR . '/includes/functions_newpost.php');
	$catdesc = convert_url_to_bbcode($catdesc);
	$cattext = convert_url_to_bbcode($cattext);

	$catid = create_ldm_category ($catuser, $catuserid,
						$catname, $catdesc, $cattext, $pcatid, $pcatlist, $pforum, $moderate,
						$catsyncdir, $display_order, TIMENOW, $catclosed);
	fix_cat_count();

	if (!update_settings($catid, $_REQUEST, $errors)) {
		$message = $vbphrase['ll_error_settings'].'<br />';
		foreach ($errors as $name=>$t) {
			$message .= $name.' ('.$t['value'].') '.$t['message'].'<br />';
		}
		eval(standard_error($message.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	update_permissions($catid, $_REQUEST);

	require_once(DIR . '/includes/local_links_forumsinterface.php');
	ldm_insert_cat_in_forum($auto_forumlink, $catid, $pforum, $forumname);

	($hook = vBulletinHook::fetch_hook('ldm_addcat_inserted')) ? eval($hook) : false;

	$vbulletin->url = $LINKS_SCRIPT.".php?catid=$catid";
	eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	exit;

}

// #################### Do (Edit) Category

if ($this_action == "doeditcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	$vbulletin->input->clean_array_gpc('r', array(
		'auto_forumlink' => TYPE_INT,
		'catname' => TYPE_STR,
		'catclosed' => TYPE_INT,
		'catdesc' => TYPE_STR,
		'catid' => TYPE_INT,
		'catsyncdir' => TYPE_STR,
		'cattext' => TYPE_STR,
		'catuser' => TYPE_STR,
		'confirmdelete' => TYPE_INT,
		'delete' => TYPE_INT,
		'display_order' => TYPE_INT,
		'force_permissions' => TYPE_INT,
		'forumname' => TYPE_STR,
		'mod' => TYPE_INT,
		'pcatid' => TYPE_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$catclosed = iif($vbulletin->GPC['catclosed'],1,0);
	$catdesc = $vbulletin->GPC['catdesc'];
	$catid	 = $vbulletin->GPC['catid'];
	$catmod	 = $vbulletin->GPC['mod'];
	$catname = $vbulletin->GPC['catname'];
	$catsyncdir	= $vbulletin->GPC['catsyncdir'];
	$cattext = $vbulletin->GPC['cattext'];
	$catuser = $vbulletin->GPC['catuser'];
	$display_order = $vbulletin->GPC['display_order'];
	$pcatid	 = $vbulletin->GPC['pcatid'];
	$pforum	 = $vbulletin->GPC['pforum'];
	$auto_forumlink = iif($vbulletin->GPC_exists['auto_forumlink'], $vbulletin->GPC['auto_forumlink'], 0);
	$forumname = iif($vbulletin->GPC_exists['forumname'], $vbulletin->GPC['forumname'], $catname);
	$force_permissions = iif(($links_permissions[can_set_permissions] and $vbulletin->GPC_exists['force_permissions']),
		$vbulletin->GPC['force_permissions'],0);

	$url = iif($catmod==1, $LINKS_SCRIPT.".php?action=mod", $LINKS_SCRIPT.".php?catid=$pcatid");

	if ($vbulletin->GPC_exists['submit']) {
		$submit = "submit";
	}
	elseif ($vbulletin->GPC_exists['delete']) {
		$submit = "delete";
	}
	else {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if (($submit=="delete" and !$vbulletin->GPC['confirmdelete']) or ($submit!="delete" and $vbulletin->GPC['confirmdelete'])) {
		eval(standard_error($vbphrase['ll_confirm_delete'].$vbphrase['ll_goback']));
		exit;
	}

	if (!catid_is_valid($catid)) {
		eval(standard_error($vbphrase['ll_error_category'].' '.$catid.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$catuserid = -1;
	$asb = $vbulletin->db->query_read("
		SELECT catuserid, catusername
		FROM ".THIS_TABLE."linkscat
		WHERE catid=".$catid."
		LIMIT 1
	");
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$olduserid = $myrow["catuserid"];
		$oldusername = $myrow["catusername"];
	}

	if ($vbulletin->userinfo['userid']<>$olduserid and (!isset($links_permissions["can_edit_category"]) or !$links_permissions["can_edit_category"])) {
		print_no_permission();
		exit;
	}

	if ($submit == 'submit') {

		if ($oldusername != $catuser) {
			if ($vbulletin->userinfo['usergroupid']<=1) {
				if (!is_valid_email($catuser)) {
					$err = $vbphrase['ll_error_email'].' '.$catuser.$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
				$catuserid = $vbulletin->userinfo['userid'];
			}
			elseif ($catuser != "") {
				$userinfo = lookup_userids(array($catuser));
				if ($userinfo[0]) {
					$catuserid = $userinfo[0];
				}
				elseif (is_valid_email($catuser)) {
					$catuserid = 0;
				}
				else {
					$err = construct_phrase($vbphrase['ll_error_username'],$catuser).$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
			}
			else {
				$catuser = $vbulletin->userinfo['username'];
				$catuserid = $vbulletin->userinfo['userid'];
			}
		}
		else {
			$catuser = $oldusername;
			$catuserid = $olduserid;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};

		if (!forumid_is_valid($pforum)) {
			$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}

		if ($catname == ''){
			eval(standard_error($vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

		if (vbstrlen($catdesc)>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
			eval(standard_error(fetch_error('toolong', vbstrlen($catdesc), $links_defaults['max_textlength'])));
		}

		if ($cattext == '') {
			$cattext = $catdesc;
		}

		if ($catsyncdir) {
			$fulldir = cleanto_fopen($catsyncdir);
			if ($dir_handle = @opendir($fulldir)) {
				closedir($dir_handle);
			}
			else {
				eval(standard_error(construct_phrase($vbphrase['ll_error_catsyncdir'], $catsyncdir).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			}
		}

		if ($pcatid > 0) {
			if (catid_is_valid($pcatid)) {
				if ($catid == $pcatid or in_array($catid, explode(",", $linkscat[$pcatid]["parentlist"]))) {
					eval(standard_error($vbphrase['ll_error_catrecurse'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
					exit;
				}
				$pcatlist = "$pcatid,".$linkscat[$pcatid]["parentlist"];
			}
			else {
				$url = $LINKS_SCRIPT.'.php';
				eval(standard_error($vbphrase['ll_error_category'].' '.$pcatid.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			}
		}
		elseif ($pcatid == $BASE_CAT) {
			$pcatlist = $pcatid;
		}
		else {
			$url = $LINKS_SCRIPT.'.php';
			eval(standard_error($vbphrase['ll_error_pcatnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}

		if ($pforum<=0 and $auto_forumlink==1) {
			eval(standard_error($vbphrase['ll_error_forumlink'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};


		if (!update_settings($catid, $_REQUEST, $errors)) {
			$message = $vbphrase['ll_error_settings'].'<br />';
			foreach ($errors as $name=>$t) {
				$message .= $name.' ('.$t['value'].') '.$t['message'].'<br />';
			}
			eval(standard_error($message.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

		update_permissions($catid, $_REQUEST);

		require_once(DIR . '/includes/functions_newpost.php');
		$catdesc = convert_url_to_bbcode($catdesc);
		$cattext = convert_url_to_bbcode($cattext);

		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat
			SET
				catid='".$catid."',
				catname='".$vbulletin->db->escape_string($catname)."',
				catdesc='".$vbulletin->db->escape_string($catdesc)."',
				cattext='".$vbulletin->db->escape_string($cattext)."',
				catusername='".$vbulletin->db->escape_string($catuser)."',
				catuserid='".$catuserid."',
				parentid='".$pcatid."',
				parentlist='".$pcatlist."',
				catforum='".$pforum."',
				catclosed='".$catclosed."',
				catsyncdir='".$vbulletin->db->escape_string($catsyncdir)."',
				catsynctime='0',
				catsyncdone='0',
				displayorder='".$display_order."'
			WHERE catid='".$catid."'
		");

		require_once(DIR . '/includes/local_links_forumsinterface.php');
		$res = ldm_insert_cat_in_forum($auto_forumlink, $catid, $pforum, $forumname);
		fix_cat_parentlist();
		fix_cat_count();

		if ($force_permissions == 1) {

			$asb = $vbulletin->db->query_read("
				SELECT DISTINCT link.linkid AS linkid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE ltoc.catid='$catid'
			");
			if ($vbulletin->db->num_rows($asb)>0) {
				$linkidlist = array();
				while ($myrow=$vbulletin->db->fetch_array($asb)) {
					$linkidlist[] = $myrow["linkid"];
				}
				$linkidlist = implode(',', $linkidlist);
				$query = "
					UPDATE ".THIS_TABLE."linkslink SET
					linkforum='$pforum'
					WHERE linkid IN($linkidlist)
				";
				$vbulletin->db->query_write($query);
			}
		}

		($hook = vBulletinHook::fetch_hook('ldm_editcat_complete')) ? eval($hook) : false;

		if ($catmod != 1) {
			$url = $LINKS_SCRIPT.".php?catid=$catid";
		}
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_edited'],0));

	}

	if ($submit == 'delete' and $catid>0) {
		$hasentries = 0;
		foreach ($linkscat as $thiscat) {
			if ($thiscat["parentid"] == $catid) {
				$hasentries = 1;
				break;
			}
		}
		if (!$hasentries) {
			$asb = $vbulletin->db->query_read("
				SELECT * FROM ".THIS_TABLE."linksltoc
				WHERE catid='".$catid."'
				");
			$hasentries = $vbulletin->db->num_rows($asb);
		}
		if ($hasentries) {
			$err = $vbphrase['ll_error_catnotempty'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		else {
			delete_ldm_category($catid);
			($hook = vBulletinHook::fetch_hook('ldm_editcat_delete_complete')) ? eval($hook) : false;
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_deleted'],0));
		}
	}

	exit;
}

// ################# Do report bad link

if ($this_action == 'doreport') {

	if (!$links_permissions["can_report_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'message'	=> TYPE_STR,
		'linkid'	=> TYPE_INT,
		'cancel'	=> TYPE_STR,
		'catid'		=> TYPE_INT,
		'imagestamp'    => TYPE_STR,
		'imagehash'     => TYPE_STR,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$catid = $vbulletin->GPC['catid'];
	if ($catid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.".php?catid=".$catid."&amp;page=".$pagenumber;
	}
	else {
		$url = $SEARCH_SCRIPT.".php?action=find&amp;catid=".$catid."&amp;page=".$pagenumber;
	}

	if ($vbulletin->GPC['cancel']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
	}

	if (!$vbulletin->GPC['message']) {
		eval(standard_error($vbphrase['ll_error_required_fields']));
	}

	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['contactustype'] == 2 AND $vbulletin->options['regimagetype']) {
		require_once(DIR . '/includes/functions_regimage.php');
		if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp'])) {
	  		eval(standard_error(fetch_error('register_imagecheck')));
	  	}
	}

	$rec = $vbulletin->db->query_first("
		SELECT linkid, linkforum
		FROM " . THIS_TABLE . "linkslink
		WHERE linkid = ".$linkid."
		LIMIT 1
	");

	$linkforum = $rec['linkforum'];
	$foruminfo = false;
	if ($linkforum>0) {
		$foruminfo = fetch_foruminfo($rec['linkforum']);
	}

	$mods = ldm_fetch_moderators($catid, 1);

	($hook = vBulletinHook::fetch_hook('ldm_report_send_process')) ? eval($hook) : false;

	$subject = construct_phrase($vbphrase['ll_admin_report_subject'], $vbulletin->options['bbtitle']);
	$message = construct_phrase($vbphrase['ll_admin_report_body'],
		$vbulletin->userinfo['username'],
		$vbulletin->userinfo['email'],
		mk_file_name($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?catid='.$catid.'&linkid='.$linkid),
		$vbulletin->GPC['message'],
		iif (isset($_SERVER[REMOTE_ADDR]), $_SERVER[REMOTE_ADDR], 'unknown')
		);

	$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

	foreach ($mods AS $index => $moderator) {
		if (!empty($moderator['email'])) {
			vbmail($moderator['email'], $subject, $message, true);
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_report_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_admin_report_thanks'],0));

}

// ################# Do send to friend

if ($this_action == 'dosendtofriend') {

	if (!$links_permissions["can_send_tofriend"]) {
		eval(standard_error($vbphrase['ll_error_nosend']));
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'emailmessage' => TYPE_STR,
		'emailsubject' => TYPE_STR,
		'linkid'	=> TYPE_INT,
		'cancel'	=> TYPE_STR,
		'catid'		=> TYPE_INT,
		'imagehash'     => TYPE_STR,
		'imagestamp'    => TYPE_STR,
		'sendtoemail' => TYPE_STR,
		'sendtoname' => TYPE_STR,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$catid = $vbulletin->GPC['catid'];
	if ($catid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.".php?catid=".$catid."&amp;page=".$pagenumber;
	}
	else {
		$url = $SEARCH_SCRIPT.".php?action=find&amp;catid=".$catid."&amp;page=".$pagenumber;
	}

	if ($vbulletin->GPC['cancel']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
	}

	if (empty($vbulletin->GPC['sendtoname']) OR !is_valid_email($vbulletin->GPC['sendtoemail'])
		OR empty($vbulletin->GPC['emailsubject']) OR empty($vbulletin->GPC['emailmessage'])
		OR !is_valid_email($vbulletin->GPC['sendtoemail'])
		) {
		eval(standard_error($vbphrase['ll_error_required_fields']));
	}

	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['contactustype'] == 2 AND $vbulletin->options['regimagetype']) {
		require_once(DIR . '/includes/functions_regimage.php');
		if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp'])) {
	  		eval(standard_error(fetch_error('register_imagecheck')));
	  	}
	}

	$postusername = $vbulletin->userinfo['username'];
	eval(fetch_email_phrases('sendtofriend'));

	vbmail($vbulletin->GPC['sendtoemail'], $vbulletin->GPC['emailsubject'], $vbulletin->GPC['emailmessage'], true);

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	$sendtoname = htmlspecialchars_uni($vbulletin->GPC['sendtoname']);
	eval(print_standard_redirect($vbphrase['ll_emailsent'].' '.$sendtoname,0));

}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $LINKS_SCRIPT.'.php';
eval(print_standard_redirect('',0));
exit;

?>