<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_search');

// get special phrase groups
$phrasegroups = array(
	'local_links'
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_access_error',
	'links_catbit',
	'links_catjump',
	'links_catsortbit',
	'links_catsortbit',
	'links_downloadbit',
	'links_editbit',
	'links_favbit',
	'links_footer',
	'links_header',
	'links_hitparade',
	'links_imgmag',
	'links_introbit',
	'links_likebit',
	'links_linkbit',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkseparator',
	'links_listselect',
	'links_main',
	'links_myldm',
	'links_othercatsbit',
	'links_play',
	'links_ratebit',
	'links_ratesortbit',
	'links_search',
	'links_search_catselect',
	'links_subcatbit',
	'links_timebit',
	'links_viewall_comment',
	'links_viewone_comment',
	'links_viewone_inline_comment',
	'links_viewone_popup_comment',
	'navbar',
	'option'
	);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// fire up VBulletin backend
require_once('./global.php');

if (!$vbulletin->products[THIS_PRODUCT_NAME]) {
	eval(standard_error($vbphrase['ll_error_product_disabled']));
	exit;
}

require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;
($hook = vBulletinHook::fetch_hook('ldm_search_start')) ? eval($hook) : false;

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT
	));

$this_action = iif($vbulletin->GPC_exists['action'], $vbulletin->GPC['action'], "search");

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) {
		$perpage = $vbulletin->options['maxposts'];
	}
	$perpage = iif($links_defaults['links_per_page']!=0, $links_defaults['links_per_page'], $perpage);
}

$pagenumber = iif($vbulletin->GPC_exists['page'],$vbulletin->GPC['page'],1);
$master_title = iif ($links_defaults['database_name'], $links_defaults['database_name'], $vbphrase['ll_links_database']);

/* ===========================================================================*/
// Main command functions
/* ===========================================================================*/

// Search for entries that are 'similar' to given entry
// Metric involves finding entries:
// a) visited/downloaded by users who have also visited/downloaded given entry
// b) marked as favourites by users who have also marked given entry as a favourite
// c) share the same keywords
// Each metric is weighted by a factor set on the main admin settings page or as
// command line parameters, and similarity is calculated according to the sum of the
// three values.

if ($this_action == "like") {

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid'		=> TYPE_INT,
		'catid'			=> TYPE_INT,
		'favwt'			=> TYPE_INT,
		'hitwt'			=> TYPE_INT,
		'keywt'			=> TYPE_INT,
		'includeown'	=> TYPE_INT,
		'num'			=> TYPE_INT,
		));

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$script = SEARCH_SCRIPT;
	$script_action="like";

	$linkid	= $vbulletin->GPC['linkid'];
	$catid	= $vbulletin->GPC['catid'];

	$favwt	= $vbulletin->GPC_exists['favwt'] ? $vbulletin->GPC['favwt'] : $links_defaults['search_like_favwt'];
	$hitwt	= $vbulletin->GPC_exists['hitwt'] ? $vbulletin->GPC['hitwt'] : $links_defaults['search_like_hitwt'];
	$keywt	= $vbulletin->GPC_exists['keywt'] ? $vbulletin->GPC['keywt'] : $links_defaults['search_like_keywt'];
	$num	= $vbulletin->GPC_exists['num'] ? $vbulletin->GPC['num'] : $links_defaults['search_like_num'];

	$includeown = $vbulletin->GPC_exists['includeown'] ? $vbulletin->GPC['includeown'] : $links_defaults['search_like_own'];

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$this_navigation_title = kill_bbcodes($master_title);
	$navbits[$SEARCH_SCRIPT.'.php?action=like'] = $vbphrase['ll_menu_showlik'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$viewcatid = $BASE_CAT;
	$catlistbit   = "";

	$query = "
		SELECT linkid, linkname
		FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$linkid."
		LIMIT 1
		";

	$row = $vbulletin->db->query_first($query);
	$message = construct_phrase($vbphrase['ll_find_like'], parse_me($row['linkname']), $LINKS_SCRIPT, $catid, $linkid);

	$viewcatname  = $vbphrase['ll_searchresults'];
	$viewcatdesc = $message;
	$viewcattext = $message;

	$ranking = array();
	$ranked_visible = array();

	if ($num>0 and $hitwt>0) {
		$query = "
			SELECT userid AS userid
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$userlist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$userlist[$row['userid']] = $row['userid'];
		}

		$totcount = count($userlist);
		if ($totcount and $hitwt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS tothits
				FROM ".THIS_TABLE."linksdownloads
				WHERE userid IN (".implode(',', $userlist).")
				".iif($includeown,"","AND userid<>".$vbulletin->userinfo['userid'])."
				AND linkid>0
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $hitwt*$row['tothits']/$totcount;
			}
		}
	}

	if ($num>0 and $favwt>0) {
		$query = "
			SELECT userid
			FROM ".THIS_TABLE."linksfavs
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$userlist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$userlist[$row['userid']] = $row['userid'];
		}

		$totcount = count($userlist);
		if ($totcount and $favwt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS totfavs
				FROM ".THIS_TABLE."linksfavs
				WHERE userid IN (".implode(',', $userlist).")
				".iif($includeown,"","AND userid<>".$vbulletin->userinfo['userid'])."
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $favwt*$row['totfavs']/$totcount;
			}
		}
	}

	if ($num>0 and $keywt>0) {
		$query = "
			SELECT keyid
			FROM ".THIS_TABLE."linksltok
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$keylist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$keylist[$row['keyid']] = $row['keyid'];
		}

		$totcount = count($keylist);
		if ($totcount and $keywt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS totkeys
				FROM ".THIS_TABLE."linksltok
				WHERE keyid IN (".implode(',', $keylist).")
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $keywt*$row['totkeys']/$totcount;
			}
		}
	}

	if ($num>0 and count($ranking)) {
		$filter = "WHERE linkid IN (".implode(',', array_keys($ranking)).")";
		$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
		$limitfids = lookup_ldm_forum_protections($can_bypass);
		$filter .= "
			AND linkforum NOT IN (".implode(',', $limitfids).")";
		if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
			$filter .= "
				AND linkstatus != $LINK_HIDDEN";
			if (!$vbulletin->userinfo['userid']) {
				$filter .= "
				AND linkmoderate = ".$LINK_ACCEPTED;
			}
			else {
				$filter .= "
					AND
					(linkmoderate = ".$LINK_ACCEPTED." OR
					(linkmoderate = ".$LINK_TO_MODERATE." AND linkuserid = ".$vbulletin->userinfo['userid'].")
					)";
			}
		}

		$query = "
			SELECT linkid
			FROM ".THIS_TABLE."linkslink
			".$filter;
		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$ranked_visible[$row['linkid']] = $ranking[$row['linkid']];
		}
	}

	if ($num>0 and count($ranked_visible)) {
		asort($ranked_visible);
		$ranked_visible_slice = array_slice(array_reverse(array_keys($ranked_visible)),  0, $num);
		$squery = array();
		$squery[] = "link.linkid IN (".implode(',', $ranked_visible_slice).")";
		$query = get_mainsql($squery, 0, 0, 0, 0, 1, 1);
		get_linksfav();
		$linklistarray = array();
		$ncols = linkbit_columns($links_defaults["search_linkbit"]);
		$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $links_defaults['search_linkbit'], $query, $highlight, 1, 1, 1, 20);
		$linklistsort = array();
		foreach ($ranked_visible_slice as $rankedid) {
			$n = 0;
			foreach ($hitids as $linkid=>$catid) {
				if ($linkid==$rankedid) {
					$linklistsort[] = $linklistarray[$n];
					break;
				}
				$n++;
			}
		}
		$linklistbit = map_listbit_to_grid($linklistsort, $ncols, 1);
		$linkratings = get_ratingsbits($hitids, 1);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$viewcatid = -2;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	$pagenav = 0;
	$searchnav = 0;
	unset($emptylistbit);
	$sortorderbit = "";

	if (!$num) {
		$emptylistbit = $vbphrase['ll_find_like_disable'];
	}
	elseif (!$linklistbit) {
		$emptylistbit = $vbphrase['ll_zerohits_sort'];
	}

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	($hook = vBulletinHook::fetch_hook('ldm_like_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Set up a Search

if ($this_action == "search") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_setup_search_begin')) ? eval($hook) : false;

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$vbulletin->input->clean_array_gpc('r', array(
		'searchid'	=> TYPE_INT,
		));

	$search = array();
	$searchid = $vbulletin->GPC['searchid'];
	if ($links_permissions["can_admin_links"] and $searchid) {
		$query = "
			SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$searchid."
			AND   searchexpires>=".TIMENOW."
			AND   searchusername LIKE ('".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."')
			LIMIT 1
			";
		$asb = $vbulletin->db->query_read($query);
		if ($vbulletin->db->num_rows($asb)) {
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$search = unserialize($row['searchparam']);
			}
		}
		else {
			$vbulletin->url = $SEARCH_SCRIPT.".php?action=search";
			eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_searchid'], $vbulletin->GPC['searchid']),0));
			exit;
		}
	}
	else {

		$search['literal']	= $links_defaults['default_search_all'];
		$search['desc']		= $links_defaults['default_search_desc'];
		$search['keys']		= $links_defaults['default_search_keys'];
		$search['cats']		= 0;
		$search['child']	= 1;
		$search['user']		= "";
		$search['savedays'] = 1;
		$search['savename'] = "";
		$search['when'] 	= 0;
		$search['after'] 	= 1;
		$search['sort']		= $links_defaults['default_sort_order'];

	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$this_navigation_title = kill_bbcodes($vbphrase['ll_search'].' '.$master_title);
	$navbits[$SEARCH_SCRIPT.'.php?action=search'] = $vbphrase['ll_search'].' '.$master_title;
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	$catbit = construct_category_list (explode(',',$search['cats']), "links_search_catselect", 0, "catsearch[]", "catsearch", 1);
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$sortset = $search['sort'];
	$sortdef = 0;
	$sortvar = "sort";
	$sortsubmit = 0;
	$sortwidth = "300";
	eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");

	if ($links_permissions["can_admin_links"]) {
		$searchidbits = make_searchidbits($searchid);
	}
	else {
		$searchidbits = "";
	}

	$viewcatid = -2;
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_setup_search_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_search')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Find special categories

if ($this_action == "find") {

	($hook = vBulletinHook::fetch_hook('ldm_find_begin')) ? eval($hook) : false;

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);

	$vbulletin->input->clean_array_gpc('r', array(
		'catid'	=> TYPE_INT,
		'sort'	=> TYPE_STR,
		'limit' => TYPE_INT,
		'lastvisit' => TYPE_STR,
		'ratings' => TYPE_INT,
		'userid' => TYPE_INT,
		));

	$viewcatid = iif($vbulletin->GPC_exists['catid'], $vbulletin->GPC['catid'], $BASE_CAT);

	if (!$vbulletin->GPC_exists['sort']) {
		$vbulletin->GPC['sort']=="";
	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]
		and ($viewcatid==$HIDE_CAT or $viewcatid==$AVL_CAT or $viewcatid==$BRKN_CAT or $viewcatid==$INVD_CAT)) {
		print_no_permission();
		exit;
	}

	$sort = $vbulletin->GPC['sort'];
	if (!$sort) {
		if ($viewcatid==$HOT_CAT) {
			$sort = 'h';
		}
		elseif ($viewcatid==$NEW_CAT) {
			$sort = 'd';
		}
		else {
			$sort = iif(isset($links_defaults['default_sort_order']), $links_defaults['default_sort_order'], 'N');
		}
	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$viewcatdesc  = $viewcattext  = $viewcatforum = "";

	switch ($viewcatid) {
	case $FAVS_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showfav'];
		break;
	case $HIDE_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showhid'];
		break;
	case $AVL_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showavl'];
		break;
	case $BRKN_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showbrk'];
		break;
	case $INVD_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showinv'];
		break;
	case $UPLD_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showupl'];
		break;
	case $HOT_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showhot'];
		break;
	case $NEW_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_shownew'];
		break;
	case $RND_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showrnd'];
		break;
	case $MY_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showmyl'];
		break;
	case $FEAT_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showfeat'];
		break;
	case $NEW_RATE:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_shownewrating'];
		break;
	default:
		print_no_permission();
		exit;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	if (is_numeric($sort)) {
		$sortsince = TIMENOW - $sort*24*60*60;
	}
	else {
		$sortsince = "";
	}

	$joinfavs = 0;
	$query = array();
	$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";

	switch ($viewcatid) {

	case $FAVS_CAT:
		$joinfavs = 1;
		$query[] = "lfav.userid = '".$vbulletin->userinfo['userid']."'";
		$query[] = "ltoc.catid <= ltoc2.catid";
		break;

	case $HIDE_CAT:
		$query[] = "link.linkstatus='".$LINK_HIDDEN."'";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $AVL_CAT:
		$query[] = "link.linkstatus>0";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $BRKN_CAT:
		$query[] = "link.linkstatus='".$LINK_BROKEN."'";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $INVD_CAT:
		$query[] = "link.linkstatus='".$LINK_NO_ACCESS."'";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $UPLD_CAT:
		$query[] = "link.linkstatus='".$LINK_UPLOAD."'";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $NEW_CAT:
		if ($vbulletin->GPC_exists['limit']) {
			$when = TIMENOW - $vbulletin->GPC['limit']*24*60*60;
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' ('.$vbulletin->GPC['limit'].' '.$vbphrase['ll_days'].')';
		}
		elseif ($vbulletin->GPC_exists['lastvisit'] or $links_defaults["days_seen_on_portal"]==0) {
			$when = $vbulletin->userinfo['lastvisit'];
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' '.$vbphrase['ll_sincelastvisit'];
		}
		else {
			$when = TIMENOW - intval($links_defaults["days_seen_on_portal"])*24*60*60;
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' ('.$links_defaults["days_seen_on_portal"].' '.$vbphrase['ll_days'].')';
		}
		$query[] = "link.linkstatus>0";
		$query[] = "ltoc.catid <= ltoc2.catid";
		$query[] = "linkdate > ".$when;
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $RND_CAT:
	case $HOT_CAT:
		if ($vbulletin->GPC_exists['limit']) {
			$limit    = "
				LIMIT ".$vbulletin->GPC['limit']."
				";
		}
		else {
			$limit    = "
				LIMIT ".intval($links_defaults["links_seen_on_portal"])."
				";
		}
		switch ($viewcatid) {
			case $HOT_CAT:
				$sorder = "linkhits DESC";
				break;
			case $RND_CAT:
				$sorder = "RAND()";
				break;
		}
// Pull linkids to use as selection criteria in a second search
		$lquery = "SELECT linkid
			FROM ".THIS_TABLE."linkslink AS link
			WHERE link.linkstatus>0
			AND link.linkforum NOT IN (".implode(',', $limitfids).")
			".iif($viewcatid==$HOT_CAT,"AND link.linkhits>0","")."
			ORDER BY $sorder
			$limit
		";
		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $myrow['linkid'];
		}
		$query[] = "link.linkid IN (".implode(',', $ids).")";
		$query[] = "ltoc.catid <= ltoc2.catid";
		if ($vbulletin->GPC_exists['userid']) {
			$query[] = "link.linkuserid='".$vbulletin->GPC['userid']."'";
		}
		break;

	case $MY_CAT:
		$query[] = "link.linkuserid=".$vbulletin->userinfo['userid'];
		$query[] = "ltoc.catid <= ltoc2.catid";
		break;

	case $FEAT_CAT:
		$feat_users = lookup_userids(explode(';', $links_defaults['featured_user_favs']));
		$feat_users[] = -1;
		$joinfavs = 1;
		$query[] = "lfav.userid IN (".implode(',', $feat_users).")";
		$query[] = "ltoc.catid <= ltoc2.catid";
		break;

	case $NEW_RATE:
		if ($vbulletin->GPC_exists['limit']) {
			$limit    = 3*$vbulletin->GPC['limit'];
		}
		else {
			$limit    = 3*intval($links_defaults["links_seen_on_portal"]);
		}
		$qlimit = "
			LIMIT ".$limit."
			";
// Pull linkids to use as selection criteria in a second search
		$lquery = "SELECT lrate.linkid AS linkid
			FROM ".THIS_TABLE."linksrate AS lrate
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON lrate.linkid=link.linkid
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			ORDER BY lrate.ltime DESC
			$qlimit
		";
		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		$nids = 0;
		while ($myrow=$vbulletin->db->fetch_array($asb) and $nids<$limit) {
			if (!in_array($myrow['linkid'], $ids)) {
				$ids[] = $myrow['linkid'];
				$nids++;
			}
		}
		$query[] = "link.linkid IN (".implode(',', $ids).")";
		$query[] = "ltoc.catid <= ltoc2.catid";
		break;

	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		if ($vbulletin->userinfo['userid'] == 0) {
			$query[] = "link.linkmoderate = $LINK_ACCEPTED";
		}
		else {
			$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
				(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
		}
	}

	$forcedisplayorder = 1;
	$showcatname = 1;
	$sorder = "";
	$limit = "";

	switch ($viewcatid) {

	case $HIDE_CAT:
	case $AVL_CAT:
	case $BRKN_CAT:
	case $INVD_CAT:
	case $UPLD_CAT:
	case $HOT_CAT:
	case $FAVS_CAT:
	case $NEW_CAT:
	case $MY_CAT:
	case $FEAT_CAT:
	case $NEW_RATE:
		$sorder = get_sortsql($sort, 1);
		$searchnav = 1;
		break;

	case $RND_CAT:
		$sorder = "linkname";
		$searchnav = 0;
		break;

	}

	get_linksfav();

	$template = $links_defaults["template_linkbit"];
	$allowlinkexpand = iif($viewlinkid or !$ldm_linkbitcache[$template]["collapse"], 0, 1 );
	if ($viewlinkid) {
		$template = iif($ldm_linkbitcache[$template]["altbit"],$ldm_linkbitcache[$template]["altbit"],$links_defaults["template_altbit"]);
	}
	elseif ($allowlinkexpand and isset($vbcollapse['collapsecel_linkrefreshbit'])) {
		$template = $ldm_linkbitcache[$template]["collapse"];
	}

	$query = get_mainsql($query, $sortsince, $joinfavs, $sorder, 0, 1, 1);

	$linklistarray = array();
	$ncols = linkbit_columns($template);
	$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);
	$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $template, $query, "", $showcatname, $forcedisplayorder, $pagenumber, $thispage);

// Where necessary, resort the linkbits into the initial linkid list order
	if ($viewcatid==$NEW_RATE) {
		$tlinklistarray = array();
		foreach ($ids as $thisid) {
			if ($thisid>0) {
				$nid = 0;
				foreach ($hitids as $thishitid=>$thishit) {
					if ($thisid==$thishitid) {
						$tlinklistarray[] = $linklistarray[$nid];
						break;
					}
					$nid++;
				}
			}
		}
		$linklistarray = $tlinklistarray;
	}
	$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);
	if (!$linklistbit and !is_numeric($sort)) {
		$searchnav = 0;
	}

	$pagenav = construct_page_nav($pagenumber, $thispage, $nhits, $SEARCH_SCRIPT.".php?action=find&amp;catid=$viewcatid&amp;sort=$sort", "&amp;pp=$thispage");

	$linkratings = get_ratingsbits($hitids, $pagenumber);
	$linkratingspopupbit = implode("", $linkratings);

	$pcatid   = "";
	$catstyle = 1;

	unset ($thisorder);
	$cattree = cat_walk($viewcatid, $links_defaults['cat_depth_display'], $sort);
	$catlistarray = array();
	$cat_template = $links_defaults['template_catbit'];
	foreach ($cattree AS $thisid=>$thischildren) {
		get_catlistbit($catlistarray, $cat_template, $ldm_catbitcache[$cat_template]['subbit'], $thisid, $thischildren, 0);
	}
	$catlistbit = map_listbit_to_grid($catlistarray, catbit_columns($cat_template));

	$pagenav = construct_page_nav($pagenumber, $perpage, $nhits, $SEARCH_SCRIPT.".php?action=find&amp;catid=$viewcatid&amp;sort=$sort", "&amp;pp=$perpage");

	$catclosed = $linkscat[$viewcatid]["catclosed"];
	$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	if ($searchnav) {
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = make_hidden_vars(array("action"=>"find", "catid"=>$viewcatid, "page"=>1, "pp"=>$thispage));
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
	}

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = construct_category_list(array($viewcatid), "links_catjump", 0, "catid", "catid", 1);
	}

	unset($emptylistbit);
	unset($linkerrorbit);
	if (!$linklistbit) {
		if (is_numeric($sort)) {
			$emptylistbit = $vbphrase['ll_zerohits_sort'];
		}
		else {
			switch ($viewcatid) {
			case $FAVS_CAT: $emptylistbit = $vbphrase['ll_zerohits_favs']; break;
			case $BASE_CAT: break;
			default: $emptylistbit = $vbphrase['ll_zerohits_sort']; break;
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_find_end')) ? eval($hook) : false;

	$script = SEARCH_SCRIPT;
	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Show Links, i.e. Execute a Search

function search_keywords($sstring, $findall) {
	global $vbulletin;

	$words = preg_split("/[\s,]+/u", $sstring);
	$ids = array();

	foreach ($words as $word) {
		$thisword = trim(str_replace("*", "%", $word));
		$query = "SELECT ltok.linkid AS linkid
			FROM ".THIS_TABLE."linksltok AS ltok
			LEFT JOIN ".THIS_TABLE."linkskeys AS lkeys
			ON lkeys.keyid=ltok.keyid
			WHERE lkeys.keyword LIKE '".$vbulletin->db->escape_string($thisword)."'"
			. iif( $findall>1  and count($ids), " AND ltok.linkid IN (".implode(", ", $ids).")", "")
			. iif( $findall==1 and count($ids), " AND ltok.linkid NOT IN (".implode(", ", $ids).")", "");

		if ($findall>1) $ids = array(); // reset else accumulate

		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $row['linkid'];
		}

		if ($findall>1 and !count($ids)) break;
	}

	return $ids;
}

function search_descwords($sstring, $findall) {
	global $vbulletin, $links_defaults;

	$ids = array();
	if ($links_defaults["match_using_like"]) {

		switch ($findall) {
		case 1:
			$query = "";
			$nwords = preg_match_all("/([\w\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = trim(str_replace("*", "%", $word));
				$query .= iif($query," OR "."").
					"(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			}
			break;
		case 2:
			$query = "";
			$nwords = preg_match_all("/([\w\*\pL\pN\pS]+)/", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = trim(str_replace("*", "%", $word));
				$query .= iif($query," AND "."").
					"(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			}
			break;
		case 3:
			$thisword = trim(str_replace("*", "%", $sstring));
			$query = "(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			break;
		}

	}
	else {

		switch ($findall) {
		case 1:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('".$vbulletin->db->escape_string($sstring)."'".
				iif(defined('CANDO_BOOLEAN')," IN BOOLEAN MODE","").")";
			break;
		case 2:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('";
			$nwords = preg_match_all("/([\w\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$query .= " +".$vbulletin->db->escape_string($word);
			}
			$query .= "'".iif(defined('CANDO_BOOLEAN')," IN BOOLEAN MODE","").")";
			break;
		case 3:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('\"".$vbulletin->db->escape_string($sstring)."\"'".
				iif(defined('CANDO_BOOLEAN')," IN BOOLEAN MODE","").")";
			break;
		}

	}

	if ($query) {
		$query = "SELECT link.linkid AS linkid
			FROM ".THIS_TABLE."linkslink AS link
			WHERE ".$query;

		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $row['linkid'];
		}
	}

	return $ids;

}

if ($this_action == "show") {

	$vbulletin->input->clean_array_gpc('r', array(
		'beforeafter' => TYPE_INT,
		'catlist'	=> TYPE_STR,
		'catsearch'	=> TYPE_ARRAY_INT,
		'childcats'	=> TYPE_INT,
		'desc'		=> TYPE_INT,
		'doi'		=> TYPE_STR,
		'filetype'	=> TYPE_STR,
		'forum' 	=> TYPE_INT,
		'keys'		=> TYPE_INT,
		'keyword'	=> TYPE_STR,
		'literal'	=> TYPE_INT,
		'mysearch'	=> TYPE_INT,
		'savedays' 	=> TYPE_INT,
		'savename' 	=> TYPE_STR,
		'savesearch' => TYPE_INT,
		'search'	=> TYPE_STR,
		'searchdate'=> TYPE_STR,
		'searchid'	=> TYPE_STR,
		'sort'		=> TYPE_STR,
		'user' 		=> TYPE_STR,
		'userid'	=> TYPE_INT,
	));

	($hook = vBulletinHook::fetch_hook('ldm_show_begin')) ? eval($hook) : false;

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'] = $master_title;
	$this_navigation_title = kill_bbcodes($vbphrase['ll_search']);
	$navbits[$SEARCH_SCRIPT.'.php?action=search'] = $vbphrase['ll_search'];
	$navbits[""] = $vbphrase['ll_searchresults'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = lookup_ldm_forum_protections($can_bypass);
	construct_forum_jump();

	$search = array();

	if ($vbulletin->GPC_exists['searchid']) {

		$query = "SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$vbulletin->GPC['searchid']."
			AND   searchexpires>=".TIMENOW."
			AND   searchusername LIKE ('".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."')
			LIMIT 1
			";
		$asb = $vbulletin->db->query_read($query);
		if ($vbulletin->db->num_rows($asb)) {
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$search = unserialize($row['searchparam']);
			}
		}
		else {
			$vbulletin->url = $SEARCH_SCRIPT.".php?action=search";
			eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_searchid'], $vbulletin->GPC['searchid']),0));
			exit;
		}

	}
	elseif ($vbulletin->GPC_exists['mysearch']) {

		$search['string'] = $ldm_mysearch[$vbulletin->GPC['mysearch']]['text'];
		if (!$search['string']) {
			if (isset($ldm_mysearch[$vbulletin->GPC['mysearch']]['profilefieldid'])) {
				$asb = $vbulletin->db->query_read("
					SELECT *
					FROM ".TABLE_PREFIX."profilefield
					WHERE profilefieldid=".$ldm_mysearch[$vbulletin->GPC['mysearch']]['profilefieldid']."
					LIMIT 1
					");
				while ($myrow=$vbulletin->db->fetch_array($asb)) {
					$field = $myrow['title'];
				}
				$error = construct_phrase($vbphrase['ll_error_mysearch'], $field);
			}
			else {
				$error = construct_phrase('', $field);
			}
			eval(standard_error($error));
			exit;
		}
		$search['literal'] = $links_defaults['default_search_all'];
		$search['desc'] = $links_defaults['default_search_desc'];
		$search['keys'] = 1;
		$search['sort'] = 'd';
		$search['forum'] = "";
		$search['doi']  = "";
		$search['user']  = "";
		$search['userid']  = 0;
		$search['type']  = "";
		$search['when'] = "";
		$search['after'] = 1;
		$search['savename'] = "";
		$search['savedays'] = 0;
		$search['searchid'] = "";
		$search['cats'] = "";
		$search['child']  = "";

	}
	elseif ($vbulletin->GPC_exists['keyword']) {

		$search['string'] = $vbulletin->GPC['keyword'];
		$search['literal'] = 1;
		$search['desc'] = 0;
		$search['keys'] = 1;
		$search['sort'] = $vbulletin->GPC['sort'] ? $vbulletin->GPC['sort'] : 'd';
		$search['forum'] = "";
		$search['doi']  = "";
		$search['user']  = "";
		$search['userid']  = 0;
		$search['type']  = "";
		$search['when'] = "";
		$search['after'] = 1;
		$search['savename'] = "";
		$search['savedays'] = 0;
		$search['searchid'] = "";
		$search['cats'] = "";
		$search['child']  = "";

	}
	else {

		$search['string'] = $vbulletin->GPC['search'];
		$search['literal'] = $vbulletin->GPC['literal'] ? $vbulletin->GPC['literal'] : 1;
		$search['keys']  = $vbulletin->GPC['keys'];
		$search['desc']  = $vbulletin->GPC['desc'];
		$search['sort']  = $vbulletin->GPC['sort'];
		$search['forum'] = $vbulletin->GPC['forum'];
		$search['doi']   = $vbulletin->GPC['doi'];
		$search['user']  = htmlspecialchars_uni($vbulletin->GPC['user']);
		$search['userid']  = $vbulletin->GPC['userid'];
		$search['type']  = $vbulletin->GPC['filetype'];
		$search['when']	 = $vbulletin->GPC['searchdate'];
		$search['after'] = $vbulletin->GPC['beforeafter'];
		$search['savename'] = $vbulletin->GPC['savename'];
		$search['savedays'] = $vbulletin->GPC['savedays'];;
		$search['searchid'] = $vbulletin->GPC['searchid'];

		$search['cats'] = "";
		$search['child']  = "";
		if ($vbulletin->GPC_exists['catsearch'] and !in_array(-1, $vbulletin->GPC['catsearch'])) {
			$search['cats']   = $vbulletin->GPC['catsearch'];
			$search['child']  = $vbulletin->GPC['childcats'];
			if ($search['child']) {
				$ccats = array();
				foreach ($linkscat as $id=>$cat) {
					if (in_array($id, $search['cats'])) continue;
					$pcat = explode(',', $cat['parentlist']);
					foreach ($search['cats'] as $searchcat) {
						if (in_array($searchcat, $pcat)) {
							$ccats[] = $id; break;
						}
					}
				}
				$search['cats'] = array_merge($search['cats'], $ccats);
			}
			if (!count($search['cats'])) $search['cats'][] = -1;
			$search['cats'] = preg_replace("/\s/", "", implode(',', $search['cats']));

		}
		elseif ($vbulletin->GPC_exists['catlist']) {
			$search['cats'] = $vbulletin->GPC['catlist'];
		}

	}

	$squery = array();
	$squery[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";

	if ($search['string']) {
		$keyed_ids = array(0);
		if ($search['keys'] and $search['string']) {
			$keyed_ids = search_keywords($search['string'], $search['literal']);
		}
		if (!count($keyed_ids)) $keyed_ids = array(0);

		$desc_ids = array(0);
		if ($search['desc'] and $search['string']) {
			$desc_ids = search_descwords($search['string'], $search['literal']);
		}
		if (!count($desc_ids)) $desc_ids = array(0);

		$squery[] =
			"(link.linkid IN (" . implode(",", $keyed_ids) . ") OR
			  link.linkid IN (" . implode(",", $desc_ids)  . "))";
	}

	if (is_numeric($search['sort'])) {
		$sortsince = TIMENOW - $search['sort']*24*60*60;
	}
	else {
		$sortsince = "";
	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		$squery[] = "link.linkstatus != $LINK_HIDDEN";
		if (!$vbulletin->userinfo['userid']) {
			$squery[] = "link.linkmoderate = ".$LINK_ACCEPTED;
		}
		else {
			$squery[] = "(link.linkmoderate = ".$LINK_ACCEPTED." OR
				(link.linkmoderate = ".$LINK_TO_MODERATE." AND link.linkuserid = ".$vbulletin->userinfo['userid']."))
			";
		}
	}

	if ($search['cats']) {
		$squery[] = "ltoc.catid IN (".$search['cats'].")";
	}

	if ($search['doi']) {
		$squery[] = "link.linkdoi LIKE ('%".$vbulletin->db->escape_string($search['doi'])."%')";
	}

	if ($search['user']) {
		$squery[] = "link.linkusername LIKE ('".$vbulletin->db->escape_string($search['user'])."')";
	}
	elseif ($search['userid']) {
		$row = $vbulletin->db->query_first("
			SELECT userid, username
			FROM ".TABLE_PREFIX."user AS user
			WHERE userid = '".$vbulletin->db->escape_string($search['userid'])."'
			LIMIT 1
			");
		if (isset($row['userid'])) {
			$search['user']=$row['username'];
			$squery[] = "link.linkusername LIKE ('".$vbulletin->db->escape_string($search['user'])."')";
		}
	}

	if ($search['forum']) {
		if (preg_match ( "/^\s*-*\d+\s*$/", $search['forum'])) {
			$squery[] = "link.linkforum IN (".$search['forum'].")";
		}
		else {
			eval(standard_error($vbphrase['ll_error_forum'].$vbphrase['ll_goback']));
			exit;
		}
	}

	if ($search['type']) {
		if (preg_match("/[^ \.,;\*a-z0-9]/", $search['type'])) {
			eval(standard_error($vbphrase['ll_error_filetype'].$vbphrase['ll_goback']));
			exit;
		}
		else {
			preg_match_all("/[a-z0-9]+/", $search['type'], $type);
			if (count($type[0])) {
				$types = implode("' OR link.linkurl LIKE '%.", $type[0]);
				$squery[] = "(link.linkurl LIKE '%.".$types."')";
			}
		}
	}

	if ($search['when']) {
		$when = iif($search['when']<0,$vbulletin->userinfo['lastvisit'],TIMENOW-$search['when']*24*60*60);
		$squery[] = "link.linkdate ".iif($search['after']==-1,"<",">=").$when;
	}

	$sorder = get_sortsql($search['sort'], 0);

	$viewcatid = $BASE_CAT;
	$catlistbit   = "";

	get_linksfav();

	$search['query'] = get_mainsql($squery, $sortsince, 0, $sorder, 0, 1, 1);

	$linklistarray = array();
	$highlight = array('string'=>$search['string'], 'keys'=>$search['keys'], 'desc'=>$search['desc']);
	$ncols = linkbit_columns($links_defaults["search_linkbit"]);
	$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);
	$nhits = get_linklistbit($linklistarray, $hitids, $expiredids, $links_defaults['search_linkbit'], $search['query'], $highlight, 1, 1, $pagenumber, $perpage);
	$linklistbit = map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratings = get_ratingsbits($hitids, $pagenumber);
	$linkratingspopupbit = implode("", $linkratings);

	$pcatid   = $linkscat[$viewcatid]["parentid"];
	$viewcatname  = $vbphrase['ll_searchresults'];

	if ($vbulletin->GPC['savesearch'] and $search['savedays']) {
		$expires = TIMENOW + $search['savedays']*24*60*60;
		$query = "
			DELETE FROM ".THIS_TABLE."linkssearch
			WHERE searchname='".$vbulletin->db->escape_string($search['savename'])."'
			AND searchusername='".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."'
			";
		$vbulletin->db->query_write($query);
		$query = "
			INSERT INTO ".THIS_TABLE."linkssearch
			SET
				searchname='".$vbulletin->db->escape_string($search['savename'])."',
				searchparam='".$vbulletin->db->escape_string(serialize($search))."',
				searchusername='".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."',
				searchtime='".TIMENOW."',
				searchexpires='".$expires."',
				searchhits='".$nhits."'
			";
		$vbulletin->db->query_write($query);
		$search['searchid'] = $vbulletin->db->insert_id();
	}

	$message = iif ($search['searchid'], construct_phrase($vbphrase['ll_searchid'], $search['searchid']).'<br />', "");

	if ($search['string']) {
		$message .= $vbphrase['ll_matching'].' '.htmlspecialchars_uni($search['string'],ENT_QUOTES);
		$message .= ' (';
		switch ($search['literal']) {
			case 1: $message .= $vbphrase['ll_searchanywords'].' '; break;
			case 2: $message .= $vbphrase['ll_searchallwords'].' '; break;
			case 3: $message .= $vbphrase['ll_searchliteral'].' '; break;
		}
		if ($search['desc']) $message .= $vbphrase['ll_searchdesc'].' ';
		if ($search['keys']) $message .= $vbphrase['ll_searchkeys'];
		$message .= ')'.'<br />';
	}
	if ($search['forum'])  $message .= $vbphrase['ll_asso_forum'].' '.$vbulletin->forumcache[$search['forum']][title].'<br />';
	if ($search['doi']) {
		$message .= $vbphrase['ll_digitalobjectidentifier'].' '.$search['doi'].'<br />';
	}
	if ($search['user']) {
		$message .= $vbphrase['ll_submitby'].' '.$search['user'].'<br />';
	}
	if ($search['cats']) {
		$message .= $vbphrase['ll_cats'].': ';
		$thesecats = array();
		foreach ($vbulletin->GPC['catsearch'] as $thiscat) $thesecats[] = $linkscat[$thiscat]['catname_clean'];
		$message .= implode(', ', $thesecats);
		if ($vbulletin->GPC['childcats']) $message .= ' ('.$vbphrase['ll_searchchildcats'].')';
		$message .= '<br />';
	}
	if ($search['type']) {
		$message .= $vbphrase['ll_filetypes'].' '.$search['type'].'<br />';
	}
	if ($search['when']) {
		$message .= $vbphrase['ll_date'].' '.
			ldm_date($vbulletin->options['dateformat'], $when).
			' '.
			iif($search['after']<0,$vbphrase['ll_and_older'],$vbphrase['ll_and_newer']).'<br />';
	}

	$message .= construct_phrase($vbphrase['ll_searchhits'], iif ($nhits,$nhits,0));

	if ($search['sort']) {
		$message .= '<br />'.$vbphrase['ll_sortedby'].' '.
		iif($search['sort']{0}=="N",  $vbphrase['ll_sortby_title_asc'], "").
		iif($search['sort']{0}=="n",  $vbphrase['ll_sortby_title_desc'], "").
		iif($search['sort']{0}=="R",  $vbphrase['ll_sortby_rank_asc'], "").
		iif($search['sort']{0}=="r",  $vbphrase['ll_sortby_title_desc'], "").
		iif($search['sort']{0}=="H",  $vbphrase['ll_sortby_hits_asc'], "").
		iif($search['sort']{0}=="h",  $vbphrase['ll_sortby_hits_desc'], "").
		iif(is_numeric($search['sort']), construct_phrase($vbphrase['ll_sortby_hits_days'], $search['sort']), "").
		iif($search['sort']{0}=="D",  $vbphrase['ll_sortby_date_asc'], "").
		iif($search['sort']{0}=="d",  $vbphrase['ll_sortby_date_desc'], "");
	}

	$viewcatdesc = $message;
	$viewcattext = $message;

	$viewcatid = -2;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	$pagenav = construct_page_nav($pagenumber, $thispage, $nhits,
		$SEARCH_SCRIPT.".php?action=show".
							"&amp;sort=".urlencode($search['sort']).
			iif($search['string'],	"&amp;search=".urlencode($search['string']), "").
			iif($search['literal'],	"&amp;literal=".$search['literal'], "").
			iif($search['desc'],	"&amp;desc=".$search['desc'], "").
			iif($search['keys'],	"&amp;keys=".$search['keys'], "").
			iif($search['forum'],	"&amp;forum=".$search['forum'], "").
			iif($search['doi'],		"&amp;doi=".$search['doi'], "").
			iif($search['user'],	"&amp;user=".$search['user'], "").
			iif($search['when'],	"&amp;searchdate=".$search['when'], "").
			iif($search['after'],	"&amp;beforeafter=".$search['after'], "").
			iif($search['type'],	"&amp;filetype=".urlencode($search['type']), "").
			iif($search['cats'],	"&amp;catlist=".urlencode($search['cats']), "").
			iif($search['child'],	"&amp;childcats=".$search['child'], "").
			iif($search['searchid'], "&amp;searchid=".$search['searchid'], "").
							"&amp;pp=$thispage");

	$searchnav = 0;
	$sortvar = "sort";
	$sortsize = 1;
	$sortset = $search['sort'];
	$sortsubmit = 1;
	$sortvars = array("action"=>"show", "page"=>"1", "pp"=>$perpage);

	if ($search['string'])	$sortvars["search"] = urlencode($search['string']);
	if ($search['literal'])	$sortvars["literal"] = $search['literal'];
	if ($search['desc'])	$sortvars["desc"] = $search['desc'];
	if ($search['keys'])	$sortvars["keys"] = $search['keys'];
	if ($search['forum'])	$sortvars["forum"] = $search['forum'];
	if ($search['doi'])		$sortvars["doi"] = $search['doi'];
	if ($search['user'])	$sortvars["user"] = $search['user'];
	if ($search['type'])	$sortvars["filetype"] = urlencode($search['type']);
	if ($search['cats'])	$sortvars["catlist"] = urlencode($search['cats']);
	if ($search['child'])	$sortvars["childcats"] = urlencode($search['child']);
	if ($search['when'])	$sortvars["searchdate"] = $search['when'];
	if ($search['after'])	$sortvars["beforeafter"] = $search['after'];
	if ($search['searchid']) $sortvars["searchid"] = $search['searchid'];

	unset($emptylistbit);
	$sortorderbit = "";
	if (!$linklistbit) {
		$emptylistbit = $vbphrase['ll_zerohits_sort'];
	} else {
		$searchnav = 1;
		$sortreturnbit = make_hidden_vars($sortvars);
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
	}
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {

		$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$script = SEARCH_SCRIPT;
	$script_action="show";

	$allow = check_user_allowances(0);

	$viewcatautocreate = "";
	eval("\$viewcatextra = \"".fetch_template('links_catbit_extras')."\";");

	($hook = vBulletinHook::fetch_hook('ldm_show_end')) ? eval($hook) : false;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}


/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $LINKS_SCRIPT.'.php';
exit;

?>