<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ---------------------------------------------------------------------------
	Displays a thumbnail image generated 'on-the-fly'.
	Used within LDM.

	Use - either

	1. place calls to local_resize.php?pic='xxx'&size=yyy in an <img> tag

	  pic='xxx'		creates a thumbnail of a local file xxx stored relative to the
	  				website's DOCUMENT_ROOT or a full url
	  size=yyy		resized picture in pixels
	  				an image that is a by b pixels in size will be resized so
	  				that the greater dimension becomes yyy.
	  				Optional, $links_defaults['link_imagesize'] used if parameter
	  				not specified

	  If size=0/omitted, the image is returned at its current size.

	  For security reasons, xxx must be an actual image file with filetype
	  matching one of the types allowed below, i.e. it cannot be a generator
	  script and the contents must be valid for the image format.

	  If xxx is a url, the script tries to use cURL, failing which
	  remote fread() calls, to read the contents.

	  Images created with these parameters are never stored as thumbs in the database

	or

	2. place calls to local_resize.php?linkid=N&size=yyy in an <img> tag

	  linkid=N      shows/creates a thumbnail for the image associated with linkid N

	  size=			as above.

	  If a size= parameter is given, a new image is created, regardless of whether one is already cached

	  The new image is cached in the database *provided* the size parameter is omitted

	or

	3. place calls to local_resize.php?mp3='xxx'&size=yyy in an <img> tag

	  as case 1, except pulls the image from the id3tags in an mp3 file

--------------------------------------------------------------------------- */

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_resize');
//define('SKIP_SESSIONCREATE', 1);
define('SESSION_BYPASS', 1);
define('NOCOOKIES', 1);
define('DIE_QUIETLY', 1);

$phrasegroups = array();
$globaltemplates = array();
$specialtemplates = array();
$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_resize.php');

/* --------------------------------------------------------------------------- */

$vbulletin->input->clean_array_gpc('g', array(
	'pic'		=> TYPE_STR,
	'linkid'	=> TYPE_INT,
	'mp3'		=> TYPE_STR,
	'size'		=> TYPE_INT,
	));

$thumb = "";

($hook = vBulletinHook::fetch_hook('ldm_resize_start')) ? eval($hook) : false;

if ($thumb) {
	@header("Content-type: image/jpeg");
	imagejpeg($thumb,"",90);
	imagedestroy($thumb);
	exit;
}

if ($vbulletin->GPC_exists['pic']) {

	$pic = $vbulletin->GPC['pic'];
	$pic = preg_replace("/\\\\/", "", $pic); // some sites escape quotes around the parameter
	$pic = preg_replace("/^([\'\"])(.*)([\'\"])$/", "$2", $pic);
	$pic_info = ldm_parse_url($pic);
	$size = iif ($vbulletin->GPC_exists['size'], max($vbulletin->GPC['size'],0), $links_defaults['link_imagesize']);

	$thumb = make_thumbnail($pic, $size);

	@header("Content-type: image/jpeg");
	imagejpeg($thumb,"",90);
	imagedestroy($thumb);
	exit;

}

if ($vbulletin->GPC_exists['linkid']) {

	$linkid = $vbulletin->GPC['linkid'];
	$query = "
		SELECT linkid, linkimg, linkimgthumb, linkimgthumbsize
		FROM ".THIS_TABLE."linkslink AS link
		WHERE link.linkid='".$linkid."'
		LIMIT 1
	";
	$rec = $vbulletin->db->query_first($query);
	$size = iif ($vbulletin->GPC_exists['size'], max($vbulletin->GPC['size'],0), $links_defaults['link_imagesize']);

	if ($rec['linkid']) {

		if ($rec['linkimgthumb'] and $rec['linkimgthumbsize']==$links_defaults['link_imagesize'] and !$vbulletin->GPC_exists['size']) {
			$file = local_filename($rec['linkimgthumb'],0);
			$fp = @fopen($file,'r');
			if ($fp) {
				$image = fread($fp, filesize($file));
				fclose($fp);
				@header("Content-type: image/jpeg");
				echo $image;
				unset($image);
				exit;
			}

			$rec['linkimgthumb'] = "";
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgthumb=''
				WHERE linkid=".$linkid."
			";
			$vbulletin->db->query_write($query);
		}

		if ($rec['linkimg']) {

			$thumb = make_thumbnail($rec['linkimg'], $size);

			if ($thumb and $links_defaults['thumbs_dir']
				and (!$vbulletin->GPC_exists['size'] or $vbulletin->GPC['size']==$links_defaults['link_imagesize'])) {
// Cache new thumb
				if ($rec['linkimgthumb']) {
					delete_thumb($rec['linkimgthumb']);
				}
				$imgthumb = save_thumbnail($thumb, $links_defaults['thumbs_dir']);
				$query = "
					UPDATE ".THIS_TABLE."linkslink
					SET
						linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $imgthumb))."',
						linkimgthumbsize='".intval($size)."'
					WHERE linkid=".$linkid."
				";
				$vbulletin->db->query_write($query);
			}
		}

	}

	if (!$thumb) {
		$thumb = make_clear_thumb();
	}

	if ($thumb) {
		@header("Content-type: image/jpeg");
		imagejpeg($thumb,"",90);
		imagedestroy($thumb);
		exit;
	}

}

if ($vbulletin->GPC_exists['mp3']) {

	$url = $vbulletin->GPC['mp3'];
	$url = preg_replace("/^(\')(.*)\'$/", "$2", $url);
	$im = 0;

	$urlInfo = ldm_parse_url($url);
	if (!$urlInfo['host']) {
		$FileName = cleanto_fopen($url);
		$im = readID3_image($FileName);
	}

	if (!$im) {
		get_icons();
		if (isset($ldm_icon_cache['jukebox'])) {
			$file = $ldm_icon_cache['jukebox'];
			$fp = @fopen($file, 'r');
			if ($fp) {
				$im = fread($fp, filesize($file));
				fclose($fp);
			}
		}
	}

	$size = iif ($vbulletin->GPC_exists['size'], max($vbulletin->GPC['size'],0), $links_defaults['link_imagesize']);

	if ($im) {
		$im = @imagecreatefromstring($im);
		$old_x=imageSX($im);
		$old_y=imageSY($im);
		$thumb_w = iif ($old_x >= $old_y, (int) ($size), (int) ($size*$old_x/$old_y));
		if ($thumb_w>$old_x) $thumb_w = $old_x;
		$thumb_h = (int) ($thumb_w*($old_y/$old_x));
		$thumb = ImageCreateTrueColor($thumb_w,$thumb_h);
		imagecopyresampled($thumb,$im,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y);
		imagedestroy($im);
	} else {
		$thumb = ImageCreateTrueColor($size,$size);
	}

	if ($thumb) {
		@header("Content-type: image/jpeg");
		imagejpeg($thumb,"",90);
		imagedestroy($thumb);
		exit;
	}

}

?>
