<?php

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT',  'local_links_stream');

$phrasegroups = array(
	'local_links',
);

$globaltemplates = array();
$specialtemplates = array();
$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

// Turn off php time out so that downloads complete correctly
if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0) {
	@set_time_limit(0);
}

$READ_BUFFER_SIZE = READ_BUFFER;

if ($_REQUEST['action'] == "stream") {

	$time = TIMENOW;

	if (isset($_REQUEST['linkid'])) {

		unset($url);
		$id = intval($_REQUEST['linkid']);
		$jumplink = $vbulletin->db->query_read("
			SELECT linkurl, linkname, linkforum, linkstatus FROM ".THIS_TABLE."linkslink
			WHERE linkid='$id'
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($jumplink)) {
			$url	   = $jump['linkurl'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linkname  = $jump['linkname'];
		}
		if (!isset($url)) {
			exit;
		}

	}
	else {
		exit;
	}

	if (!forumid_is_valid($linkforum)) {
		exit;
	}
	elseif ($linkforum > 0) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			exit;
		}
	}

// Handle mirrors if any
	$download_mirrors = unserialize($links_defaults['download_mirrors']);
	if (count($download_mirrors)) {
		$mirror_urls = ldm_mirrors($url, $download_mirrors);
		if (count($mirror_urls)) {
			$mirrorurl = "";
			foreach ($mirror_urls as $thismirror) {
				if ($thismirror['alive']!=0) {
					$mirrorurl = $thismirror['url'];
					break;
				}
			}
			if ($mirrorurl) {
				$url = $mirrorurl;
			}
			else {
				exit; // no site is alive
			}
		}
	}

// Go to it...
	$urlInfo = parse_url($url);
	if ($urlInfo['scheme'] != "" and !array_key_exists($urlInfo['scheme'], $protocol_schemes)) {
		exit;
	}

	$dfname  = basename($urlInfo['path']);
	$type	 = substr(strrchr($dfname, "."), 1);
	$mimetype = get_mimetype($type);

// Change any realaudio tags into embedded player tags
	foreach ($mimetype as $k=>$mime) {
		if (preg_match("/-real/", $mimetype[$k])) {
			$mimetype[$k] = "Content-type: audio/x-pn-realaudio-plugin";
		}
	}

// Recheck filesize before sending headers...
	$linksize = size_url($url);
	$do206 = 0;
	$ilast = 0;

// Final chance before we begin...
	($hook = vBulletinHook::fetch_hook('ldm_stream_start')) ? eval($hook) : false;

	$hit = record_hit($id, $url, $LINK_OK, $linksize);

// Request for partial range(s) - only honour requests for a single range...
//	if ($linksize and isset($HTTP_SERVER_VARS['HTTP_RANGE'])) {
//		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $HTTP_SERVER_VARS['HTTP_RANGE'], $ranges, PREG_SET_ORDER)) {
	$curr_headers = ldm_parse_headers();
	if ($linksize and isset($curr_headers['Range'])) {
		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $curr_headers['Range'], $ranges, PREG_SET_ORDER)) {
			$do206  = 1;
			$istart = $ranges[0][1];
			$iend   = $ranges[0][2];
			if (!$iend or $iend>=$linksize) {
				$iend  = $linksize-1;
				$ilast = 1;
			}
			$ichars = $iend-$istart+1;
		}
	}

	$file = cleanto_fopen($url);
	$use_curl = 0;
	$conn = 0;

	if ($urlInfo['host'] == "") {
		$conn = @fopen($file, "rb");
	}
	elseif ($LDM_environment['curl_available']) {
		$conn = @curl_init();
		$use_curl = 1;
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$conn = @fopen($file, "rb");
	}


// Turn off php time out so that downloads complete correctly
	if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0) {
		@set_time_limit(0);
	}

	@ini_set('zlib.output_compression', 'Off');

	@header("HTTP/1.1 ".iif($do206, "206 Partial content", "200"));
	@header("Expires: 0");
	@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
	@header("Pragma: no-cache"); // HTTP/1.0
	@header("Content-disposition: inline; filename=".str_replace(" ", "_", $dfname)."");
	@header('Content-transfer-encoding: binary');
	if ($linksize>1) {
		if ($do206) {
			@header("Accept-Ranges: bytes");
			@header("Content-Range: bytes $istart-$iend/$linksize");
			@header("Content-Length: $ichars");
		} else {
			@header("Accept-Ranges: bytes");
			@header("Content-Length: $linksize");
		}
	}
	if (is_array($mimetype)) {
		foreach ($mimetype AS $index => $header) {
			@header($header);
		}
	}
	else {
		@header("Content-type: unknown/unknown");
	}

	if ($use_curl) {
		if ($urlInfo['user']) {
			unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($conn, CURLOPT_HEADER, 0);
		@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
		@curl_setopt($conn, CURLOPT_USERAGENT, "LDM Downloader");
		if ($do206) {
			@curl_setopt($conn, CURLOPT_RANGE, "$istart-$iend");
		}
		@curl_exec($conn);
		$res = @curl_getinfo($conn);
		$bytes = $res["size_download"];
		@curl_close($conn);

	}
	else {
		$bytes = 0;
		if (!$do206) {
			while ($contents = fread ($conn, $READ_BUFFER_SIZE)) {
				echo $contents;
				$bytes += strlen($contents);
			}
		}
		else {
			$jchar = 0;
			while ($jchar<$istart) {
				$nchar = iif(($istart-$jchar)<$READ_BUFFER_SIZE,($istart-$jchar),$READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				$jchar += strlen($contents);
			}
			while ($jchar<$iend) {
				$nchar = iif(($iend-$jchar+1)<$READ_BUFFER_SIZE,($iend-$jchar+1),$READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				echo $contents;
				$jchar += strlen($contents);
			}
			$bytes = $jchar;
		}
		flush();
		fclose($conn);
	}

	exit;
}

?>