<?php
///////////////////////////////////////////////////
//  Advanced Poll 1.6 (PHP)                      //
//  Copyright (c)2001 Chi Kien Uong              //
//  URL: http://www.proxy2.de                    //
///////////////////////////////////////////////////

require ("./include/config.inc.php");
$poll_version = "v1.6";

if (!isset($PHP_SELF)) {
  $PHP_SELF = $HTTP_SERVER_VARS["PHP_SELF"];
  if (isset($HTTP_GET_VARS)) {
    while (list($name, $value)=each($HTTP_GET_VARS)) {
      $$name=$value;
    }
  }
  if (isset($HTTP_POST_VARS)) {
    while (list($name, $value)=each($HTTP_POST_VARS)) {
      $$name=$value;
    }
  }
  if(isset($HTTP_COOKIE_VARS)){
    while (list($name, $value)=each($HTTP_COOKIE_VARS)){
      $$name=$value;
    }
  }
}

function enter_pass($message) {
  global $poll_version, $lang, $base_gif, $PHP_SELF;
  include ("./admin/admin_login.php");
}

function poll_index() {
  global $poll_version, $poll_username, $lang, $base_gif, $time_offset;
  global $REMOTE_ADDR, $PHP_SELF;
  include ("./admin/admin_index.php");
}

function poll_new($message) {
  global $poll_version, $lang, $base_gif;
  global $PHP_SELF;
  include ("./admin/admin_new.php");
}

function poll_help() {
  global $poll_version, $lang, $base_gif;
  global $path, $PHP_SELF;
  include ("./admin/admin_help.php");
}

function poll_license() {
  global $poll_version, $lang, $base_gif;
  global $PHP_SELF;
  include ("./admin/admin_license.php");
}

function create_poll() {
  global $logging, $expire, $exp_time, $status, $comments;
  global $option_id, $question, $color;
  $timestamp = time();
  if (!isset($expire)) {
    $expire=1;
  }
  if (!isset($comments)) {
    $comments=0;
  }
  if (!isset($exp_time)) {
    $exp_time=$timestamp;
  } else {
    $exp_time=$timestamp+$exp_time*86400;
  }
  if (get_magic_quotes_gpc()) {
    $question = stripslashes($question);
  }
  chdir("./polldata");
  $hnd = opendir(".");
  while ($file = readdir($hnd)) {
    if (eregi("([0-9]+$)", $file)) {
      $poll_list[] = $file;
    }
  }
  closedir($hnd);
  if ($poll_list) {
    rsort($poll_list);
    $new_id = $poll_list[0]+1;
  } else {
    $new_id = 1;
  }
  chdir("../");
  $poll_fp = fopen("./polldata/$new_id","w");
  fwrite($poll_fp,"$question|$timestamp|$exp_time|$expire|$logging|$status|$comments\n");
  for($i=1; $i <= sizeof($option_id); $i++) {
    $option_id[$i] = trim($option_id[$i]);
    $option_id[$i] = str_replace("|","",$option_id[$i]);
    if (!empty($option_id[$i])) {
      if (get_magic_quotes_gpc()) {
        $option_id[$i] = stripslashes($option_id[$i]);
      }
      fwrite($poll_fp,"$option_id[$i]|0|$color[$i]\n");
    }
  }
  fclose($poll_fp);

}

function poll_edit($entry_id,$message) {
  global $poll_version, $lang, $base_gif;
  global $PHP_SELF;
  include ("./admin/admin_edit.php");
}

function save($poll_id) {
  global $option_id, $votes, $color, $status, $logging, $timestamp;
  global $question, $exp_time, $expire, $comments;
  if (!isset($expire)) {
    $expire=1;
  }
  if (!isset($comments)) {
    $comments=0;
  }
  $exp_time=time()+$exp_time*86400;
  $question = trim($question);
  $question = str_replace("|","",$question);
  if (!empty($question)) {
    if (get_magic_quotes_gpc()) {
      $question = stripslashes($question);
    }
    if (sizeof($option_id) < 2) {
      $message = "EditOp";
    } else {
      $poll_fp = fopen("./polldata/$poll_id","w");
      fwrite($poll_fp,"$question|$timestamp|$exp_time|$expire|$logging|$status|$comments\n");
      for($i=0; $i < sizeof($option_id); $i++) {
        if (!isset($option_id["$i"])) {
          continue;
        }
        $option_id["$i"] = trim($option_id["$i"]);
        $option_id["$i"] = str_replace("|","",$option_id["$i"]);
        if (!empty($option_id[$i])) {
           if (!eregi("^[0-9]+$", $votes[$i])) {
             $votes[$i] = 0;
           }
           if (get_magic_quotes_gpc()) {
             $option_id[$i] = stripslashes($option_id[$i]);
           }
           fwrite($poll_fp,"$option_id[$i]|$votes[$i]|$color[$i]\n");
        }
      }
      fclose($poll_fp);
      $message = "Updated";
    }
  } else {
     $message = "NewNoQue";
  }
  return $message;
}

function poll_extend($poll_id) {
  global $poll_version, $lang, $base_gif, $PHP_SELF;
  include ("./admin/admin_options.php");
}

function add_options($poll_id) {
  global $option_id,$color;
  $poll_fp = fopen("./polldata/$poll_id","a");
  for($i=0; $i < sizeof($option_id); $i++) {
    if (isset($option_id["$i"])) {
      $option_id["$i"] = trim($option_id["$i"]);
      $option_id["$i"] = str_replace("|","",$option_id["$i"]);
    }
    if (!empty($option_id["$i"])) {
      if (get_magic_quotes_gpc()) {
        $option_id["$i"] = stripslashes($option_id["$i"]);
      }
      fwrite($poll_fp,"$option_id[$i]|0|$color[$i]\n");
      $added = 1;
    }
  }
  fclose($poll_fp);
  return (isset($added)) ? "EditOk" : "EditNo";
}

function update_settings() {
  global $poll_username, $poll_password;
  global $NEWbase_gif, $NEWtitle, $NEWimg_height, $NEWimg_length, $NEWtable_width, $NEWbgcolor_tab, $NEWbgcolor_fr;
  global $NEWfont_face, $NEWfont_color, $NEWtype, $NEWcheck_ip, $NEWlock_timeout, $NEWtime_offset;
  global $NEWlang, $NEWvote_button, $NEWtotal_text, $NEWresult_text, $NEWvoted, $NEWsend_com, $NEWentry_pp;
  if (!eregi(".php|.php3", $NEWlang)) {
    $NEWlang = "english.php";
  }
  if (!eregi("^[0-9]+$", $NEWentry_pp) || $NEWentry_pp==0) {
    $NEWentry_pp = 1;
  }
  $config="<?php\n";
  $config.="# DO NOT EDIT THIS FILE. USE THE ADMIN #\n\n";
  $config.="\$poll_username = \"$poll_username\";\n";
  $config.="\$poll_password = \"$poll_password\";\n\n";
  $config.="\$base_gif = \"$NEWbase_gif\";\n";
  $config.="\$lang = \"$NEWlang\";\n";
  $config.="\$title = \"$NEWtitle\";\n";
  $config.="\$vote_button = \"$NEWvote_button\";\n";
  $config.="\$result_text = \"$NEWresult_text\";\n";
  $config.="\$total_text = \"$NEWtotal_text\";\n";
  $config.="\$voted = \"$NEWvoted\";\n";
  $config.="\$send_com = \"$NEWsend_com\";\n";
  $config.="\$img_height = \"$NEWimg_height\";\n";
  $config.="\$img_length = \"$NEWimg_length\";\n";
  $config.="\$table_width = \"$NEWtable_width\";\n";
  $config.="\$bgcolor_tab = \"$NEWbgcolor_tab\";\n";
  $config.="\$bgcolor_fr = \"$NEWbgcolor_fr\";\n";
  $config.="\$font_face = \"$NEWfont_face\";\n";
  $config.="\$font_color = \"$NEWfont_color\";\n";
  $config.="\$type = \"$NEWtype\";\n";
  $config.="\$check_ip = \"$NEWcheck_ip\";\n";
  $config.="\$lock_timeout = \"$NEWlock_timeout\";\n";
  $config.="\$time_offset = \"$NEWtime_offset\";\n";
  $config.="\$entry_pp = \"$NEWentry_pp\";\n";
  $config.="?>";
  $fp = fopen("./include/config.inc.php","w");
  fputs($fp, $config);
  fclose($fp);
  return ($fp) ? "Updated" : "NoUpdate";
}

function update_user($poll_user,$poll_pass) {
  global $PHP_SELF;
  include ("./include/config.inc.php");
  $config="<?php\n";
  $config.="# DO NOT EDIT THIS FILE. USE THE ADMIN #\n\n";
  $config.="\$poll_username = \"$poll_user\";\n";
  $config.="\$poll_password = \"$poll_pass\";\n\n";
  $config.="\$base_gif = \"$base_gif\";\n";
  $config.="\$lang = \"$lang\";\n";
  $config.="\$title = \"$title\";\n";
  $config.="\$vote_button = \"$vote_button\";\n";
  $config.="\$result_text = \"$result_text\";\n";
  $config.="\$total_text = \"$total_text\";\n";
  $config.="\$voted = \"$voted\";\n";
  $config.="\$send_com = \"$send_com\";\n";
  $config.="\$img_height = \"$img_height\";\n";
  $config.="\$img_length = \"$img_length\";\n";
  $config.="\$table_width = \"$table_width\";\n";
  $config.="\$bgcolor_tab = \"$bgcolor_tab\";\n";
  $config.="\$bgcolor_fr = \"$bgcolor_fr\";\n";
  $config.="\$font_face = \"$font_face\";\n";
  $config.="\$font_color = \"$font_color\";\n";
  $config.="\$type = \"$type\";\n";
  $config.="\$check_ip = \"$check_ip\";\n";
  $config.="\$lock_timeout = \"$lock_timeout\";\n";
  $config.="\$time_offset = \"$time_offset\";\n";
  $config.="\$entry_pp = \"$entry_pp\";\n";
  $config.="?>";
  $fp = fopen("./include/config.inc.php","w");
  fputs($fp, $config);
  fclose($fp);
  setcookie("logged_in", $poll_user, time()+7200, $PHP_SELF);
  return ($fp) ? "Updated" : "NoUpdate";
}

function delete_poll($poll_id) {
  if (file_exists("./polldata/$poll_id")) {
    unlink("./polldata/$poll_id");
  }
  if (file_exists("./polldata/$poll_id.ip")) {
    unlink("./polldata/$poll_id.ip");
  }
  if (file_exists("./polldata/$poll_id.log")) {
    unlink("./polldata/$poll_id.log");
  }
  if (file_exists("./polldata/$poll_id.dat")) {
    unlink("./polldata/$poll_id.dat");
  }
}

function poll_settings($cat,$message) {
  global $poll_version, $PHP_SELF;
  include ("./include/config.inc.php");
  if ($cat == "general") {
    include ("./admin/admin_settings.php");
  } elseif ($cat == "password") {
    include ("./admin/admin_pwd.php");
  }
}

function poll_stats($poll_id) {
  global $poll_version, $lang, $base_gif, $PHP_SELF;
  global $time_offset;
  include ("./admin/admin_stat.php");
}

function poll_comments($poll_id) {
  global $poll_version, $lang, $base_gif, $PHP_SELF;
  global $time_offset, $entry, $entry_pp;
  include ("./admin/admin_comment.php");
}

function reset_log($poll_id) {
  if (file_exists("./polldata/$poll_id.log")) {
    $fp = fopen("./polldata/$poll_id.log","w");
    fclose($fp);
  }
}

function delete_comment($poll_id,$message_id) {
  $comment_array = file("./polldata/$poll_id.dat");
  if (sizeof($comment_array)>0) {
    $poll_comment = fopen("./polldata/$poll_id.dat","w");
    for ($i=0; $i<sizeof($comment_array); $i++) {
      if ($i != $message_id) {
        fwrite($poll_comment,"$comment_array[$i]");
      }
    }
    fclose($poll_comment);
  }
}

function start_session($username) {
  global $PHP_SELF;
  setcookie("logged_in", $username, time()+7200, $PHP_SELF);
}

function check_pass($username,$password) {
  global $poll_username, $poll_password;
  return ($poll_username==$username and $poll_password==$password) ? $username : false;
}

function get_session_id($logged_in) {
  global $poll_username;
  return ($logged_in=="$poll_username") ? true : false;
}

if (!isset($logged_in)) {
  $logged_in = "";
}

if (isset($enter)) {
  if (get_magic_quotes_gpc()) {
   $username = stripslashes($username);
   $password = stripslashes($password);
  }
  $user = check_pass($username,$password);
  if ($user) {
    start_session($user);
    poll_index();
  } else {
    enter_pass('FormWrong');
  }
}

elseif (get_session_id($logged_in)) {

if (!isset($action)) {
  $action ='';
}
switch ($action) {

case "new":
  poll_new("NewTitle");
  break;

case "help":
  $path = dirname(__file__);
  poll_help();
  break;

case "delete":
  if (isset($id)) {
    delete_poll($id);
  }
  poll_index();
  break;

case "stats":
  if (isset($id)) {
    poll_stats($id);
  } else {
    poll_index();
  }
  break;

case "comments":
  if (isset($id)) {
    if (file_exists("./polldata/$id")) {
      poll_comments($id);
    } else {
      poll_index();
    }
  } else {
    poll_index();
  }
  break;

case "remove":
  if (isset($id)) {
    if (file_exists("./polldata/$id.dat")) {
      delete_comment($id,$mess_id);
      poll_comments($id);
    } else {
      poll_index();
    }
  } else {
    poll_index();
  }
  break;

case "reset":
  if (isset($id)) {
    reset_log($id);
    poll_stats($id);
  } else {
    poll_stats($id);
  }
  break;

case "update":
  if (!get_magic_quotes_gpc() and is_array($GLOBALS)==1) {
    while(list($key,$val)=each($GLOBALS)) {
      if (is_string($val)==1) {
        $GLOBALS[$key]=addslashes($val);
      }
    }
  }
  $message = update_settings();
  poll_settings("general",$message);
  break;

case "update_pwd":
  if (!empty($NEWadmin_name)) {
    $username = trim($NEWadmin_name);
    if (!get_magic_quotes_gpc()) {
      $username = addslashes($username);
    }
  }
  if (!empty($NEWadmin_pass)) {
    $userpass = trim($NEWadmin_pass);
    if (!get_magic_quotes_gpc()) {
      $userpass = addslashes($userpass);
    }
  }
  $message = update_user($username,$userpass);
  poll_settings("password",$message);
  break;

case "edit":
  if (isset($id)) {
    poll_edit($id,"EditText");
  } else {
    poll_index();
  }
  break;

case "show":
  poll_index();
  break;

case "extend":
  if(isset($add)) {
    $message = add_options($id);
    poll_edit($id,$message);
  } else {
    poll_extend($id);
  }
  break;

case "save":
  $message = save($id);
  poll_edit($id,$message);
  break;

case "create":
  $question = trim($question);
  $question = str_replace("|","",$question);
  if (!empty($question)) {
    create_poll();
    poll_index();
  } else {
    poll_new("EditMis");
  }
  break;

case "settings":
  if ($panel == "general") {
    poll_settings("general","SetText");
  } elseif ($panel == "password") {
    poll_settings("password","PwdText");
  } else {
    poll_index();
  }
  break;

case "logout":
  setcookie("logged_in", "" ,time(), $PHP_SELF);
  enter_pass("FormEnter");
  break;

case "license":
  poll_license();
  break;

default:
  poll_index();
  break;
}

} else {
  enter_pass("FormEnter");
}

?>