<?php
///////////////////////////////////////////////////
//  Advanced Poll 1.6 (PHP)                      //
//  Copyright (c)2001 Chi Kien Uong              //
//  URL: http://www.proxy2.de                    //
///////////////////////////////////////////////////

$comment_page = "comments.php"; // URL to comment page
                                // eg. http://www.yourdomain.com/poll/comments.php

$script_path = dirname(__file__);
require $script_path."/include/config.inc.php";
$include_path = "$script_path/polldata";
$poll_version = "1.6t";
$found = 0;
$valid = 1;
if (!isset($PHP_SELF)) {
  $PHP_SELF = $HTTP_SERVER_VARS["PHP_SELF"];
  if (isset($HTTP_GET_VARS)) {
    while (list($name, $value)=each($HTTP_GET_VARS)) {
      $$name=$value;
    }
  }
  if (isset($HTTP_POST_VARS)) {
    while (list($name, $value)=each($HTTP_POST_VARS)) {
      $$name=$value;
    }
  }
  if(isset($HTTP_COOKIE_VARS)){
    while (list($name, $value)=each($HTTP_COOKIE_VARS)){
      $$name=$value;
    }
  }
}

function sort_poll_keys($a,$b) {
 if ($a == $b) return 0;
 return ($a > $b) ? -1 : 1;
}

function check_poll_ip($poll_id) {
  global $include_path, $REMOTE_ADDR;
  global $lock_timeout;
  $found=0;
  $ip = $REMOTE_ADDR;
  if (!$ip) {
    $ip = getenv("REMOTE_ADDR");
  }
  if (file_exists("$include_path/$poll_id.ip")) {
    $ip_array = file("$include_path/$poll_id.ip");
    $this_time = time();
    for ($i=0; $i<sizeof($ip_array); $i++) {
      list ($ip_addr, $time_stamp) = split("\\|",$ip_array[$i]);
      if ($this_time < ($time_stamp+3600*$lock_timeout)) {
        if ($ip == $ip_addr) {
          $found=1;
          break;
        }
      }
    }
  }
  return ($found==1) ? 1 : 0;
}

function lock_ip($poll_id) {
  global $include_path, $REMOTE_ADDR;
  global $lock_timeout;
  $ip = $REMOTE_ADDR;
  if (!$ip) {
    $ip = getenv("REMOTE_ADDR");
  }
  $this_time = time();
  if (file_exists("$include_path/$poll_id.ip")) {
    $ip_array = file("$include_path/$poll_id.ip");
    $ip_table = fopen("$include_path/$poll_id.ip","w+");
    for ($i=0; $i<sizeof($ip_array); $i++) {
      list ($ip_addr, $time_stamp) = split("\\|",$ip_array[$i]);
      if ($this_time < ($time_stamp+3600*$lock_timeout)) {
        if ($ip_addr == $ip) {
          continue;
        }
        fwrite($ip_table,"$ip_addr|$time_stamp");
      }
    }
    fwrite($ip_table,"$ip|$this_time\n");
  } else {
    $ip_table = fopen("$include_path/$poll_id.ip","w");
    fwrite($ip_table,"$ip|$this_time\n");
  }
  fclose($ip_table);
}

function log_vote($poll_id) {
  global $include_path;
  global $REMOTE_ADDR, $HTTP_USER_AGENT;
  $this_time = date("j-M-Y H:i",time());
  $ip = $REMOTE_ADDR;
  if (!$ip) {
    $ip = getenv("REMOTE_ADDR");
  }
  $host = @gethostbyaddr($ip);
  $agent = $HTTP_USER_AGENT;
  if (!$agent) {
    $agent = @getenv("HTTP_USER_AGENT");
  }
  $log_table = fopen("$include_path/$poll_id.log","a");
  fwrite($log_table,"$this_time|$ip|$host|$agent\n");
  fclose($log_table);
}

function get_data($poll_id) {
  global $include_path, $poll_array, $color, $total;
  global $question, $timestamp, $exp_time, $expire, $logging, $status, $comments;
  $total=0;
  $line = file("$include_path/$poll_id");
  list($question,$timestamp,$exp_time,$expire,$logging,$status,$comments) = split("\\|",$line[0]);
  $question = htmlspecialchars($question);
  for ($i=1; $i<sizeof($line); $i++) {
    list($name,$vote,$gif_color) = split("\\|",$line[$i]);
    $poll_array[$name] = $vote;
    $color[$name] = chop($gif_color);
    $total += $vote;
  }
}

function get_status($poll_id) {
  global $include_path;
  $line = file("$include_path/$poll_id");
  list($question,$timestamp,$exp_time,$expire,$logging,$status,$comments) = split("\\|",$line[0]);
  return (sizeof($line)>0) ? array(
    "question" => "$question",
    "timestamp" => "$timestamp",
    "exp_time" => "$exp_time",
    "expire" => "$expire",
    "logging" => "$logging",
    "status" => "$status",
    "comments" => "$comments"
  ) : false;
}

function get_poll_list() {
  global $include_path;
  $hnd = opendir("$include_path");
  while ($file = readdir($hnd)) {
    if (eregi("([0-9]+$)", $file)) {
      $poll_list[] = $file;
    }
  }
  closedir($hnd);
  if ($poll_list) {
    rsort($poll_list);
    for ($i=0; $i<sizeof($poll_list); $i++) {
      $line = file("$include_path/$poll_list[$i]");
      list($question,$timestamp,$exp_time,$expire,$logging,$status,$comments) = split("\\|",$line[0]);
      if ($status==0 || $status==1) {
        if (eregi("([0-9]+$)", $poll_list[$i], $regs)) {
          $available_polls[] = $regs[1];
        }
      }
    }
  }
  return (isset($available_polls)) ? $available_polls : false ;
}

function do_vote($poll_id) {
  global $include_path, $check_ip, $logging, $vote_for;
  if (get_magic_quotes_gpc()) {
    $vote_for = stripslashes($vote_for);
  }
  if ($check_ip >= 2) {
    lock_ip($poll_id);
  }
  if ($logging == 1) {
    log_vote($poll_id);
  }
  $line = file("$include_path/$poll_id");
  $count_dat = fopen("$include_path/$poll_id","w+");
  fwrite($count_dat,$line[0]);
  for ($i=1; $i<sizeof($line); $i++) {
    list($name,$vote,$gif_color) = split("\\|",$line[$i]);
    if ($name == $vote_for) {
      $vote += 1;
    }
    fwrite($count_dat,"$name|$vote|$gif_color");
  }
  fclose($count_dat);
}


function display_poll($poll_id) {
  global $poll_array, $color, $poll_version, $PHP_SELF;
  global $question, $font_face, $font_color, $lock_timeout;
  global $vote_button, $result_text;
  global $table_width, $bgcolor_fr, $title, $bgcolor_tab;
  get_data($poll_id);
?>
<table width="<?php echo $table_width; ?>" border="0" cellspacing="0" cellpadding="1" bgcolor="<?php echo $bgcolor_fr; ?>">
<tr align="center">
<td>
<style type="text/css">
<!--
 .input { font-family: <?php echo $font_face; ?>; font-size: 8pt}
 .links { font-family: <?php echo $font_face; ?>; font-size: 7.5pt; color: <?php echo $font_color; ?>}
-->
</style>
<font face="<?php echo $font_face; ?>" size="-1" color="#FFFFFF"><b><?php echo htmlspecialchars($title); ?></b></font></td>
</tr>
<tr align="center">
 <td><table width="100%" border="0" cellspacing="0" cellpadding="2" align="center" bgcolor="<?php echo $bgcolor_tab; ?>">
<tr>
  <td height="40" valign="middle"><font face="<?php echo $font_face; ?>" color="<?php echo $font_color; ?>" size="1"><b><?php echo $question; ?></b></font></td>
</tr>
<tr align="right" valign="top">
 <td><form method="post" action="<?php echo $PHP_SELF; ?>">
  <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="190">
   <tr valign="top" align="center">
    <td><table width="100%" border="0" cellspacing="0" cellpadding="1" align="center">
<?php
  for (reset($poll_array); $key=key($poll_array); next($poll_array)) {
    $key = htmlspecialchars($key);
    echo "   <tr>
     <td width=\"15%\"><input type=\"radio\" name=\"vote_for\" value=\"$key\"></td>
     <td width=\"85%\"><font face=\"$font_face\" size=\"1\" color=\"$font_color\">$key</font></td>
   </tr>\n";
  }
?>
     </table>
     <input type="hidden" name="action" value="vote">
     <input type="hidden" name="poll_id" value="<?php echo $poll_id; ?>">
     <input type="submit" value="<?php echo $vote_button; ?>" class="input">
     <br><br>
     <font face="<?php echo $font_face; ?>" color="<?php echo $font_color; ?>" size="1"><a class="links" href="<?php echo $PHP_SELF; ?>?action=results&amp;poll_id=<?php echo "$poll_id\">$result_text"; ?></a><br><br><br></td>
 </tr>
</table>
</form>
  <font face="<?php echo $font_face; ?>" size="1"><a href="http://www.proxy2.de" target="_blank"><acronym title="Advanced Poll">Version <?php echo $poll_version; ?></acronym></a></font></td>
</tr>
</table>
</td>
</tr>
</table>
<?php }

function view_results($poll_id,$vote_stat) {
  global $poll_array, $color, $total, $question, $comments;
  global  $comment_page, $poll_version, $PHP_SELF;
  global $base_gif, $font_face, $font_color, $img_height, $img_length, $type, $total_text, $voted;
  global $table_width, $bgcolor_fr, $title, $bgcolor_tab, $send_com;
  get_data($poll_id);
?>
<table width="<?php echo $table_width; ?>" border="0" cellspacing="0" cellpadding="1" bgcolor="<?php echo $bgcolor_fr; ?>">
<tr align="center">
<td>
<style type="text/css">
<!--
 .input { font-family: <?php echo $font_face; ?>; font-size: 8pt}
 .links { font-family: <?php echo $font_face; ?>; font-size: 7.5pt; color: <?php echo $font_color; ?>}
-->
</style>
<font face="<?php echo $font_face; ?>" size="-1" color="#FFFFFF"><b><?php echo htmlspecialchars($title); ?></b></font></td>
</tr>
<tr align="center">
 <td><table width="100%" border="0" cellspacing="0" cellpadding="2" align="center" bgcolor="<?php echo $bgcolor_tab; ?>">
 <tr valign="middle">
   <td height="40"><font face="<?php echo $font_face; ?>" color="<?php echo $font_color; ?>" size="1"><b><?php echo $question; ?></b></font></td>
 </tr>
 <tr align="right" valign="bottom">
   <td>
     <table border="0" cellspacing="0" cellpadding="1" width="100%" align="center" height="210">
       <tr valign="top">
        <td>
         <table width="100%" border="0" cellspacing="0" cellpadding="1" align="center">
<?php
  if (count($poll_array)) {
    uasort($poll_array,"sort_poll_keys");
    $top_pos = reset($poll_array);
  }
  $total_votes = ($total<=0) ? 1 : $total;
  $top_pos = ($total==0) ? 1 : $top_pos;
  for (reset($poll_array); $key=key($poll_array); next($poll_array)) {
    $vote_val = ($type=="percent") ? sprintf("%.1f",($poll_array[$key]*100/$total_votes))."%" : $poll_array[$key];
    $img_width = (int) ($poll_array[$key]*$img_length/$top_pos);
    $image = chop($color[$key]);
    $key_val = htmlspecialchars($key);
    echo "        <tr>
          <td height=\"22\"><font face=\"$font_face\" color=\"$font_color\" size=\"1\">$key_val</font></td>
          <td nowrap height=\"22\"><font face=\"$font_face\" color=\"$font_color\" size=\"1\"><img src=\"$base_gif/$image.gif\" width=\"$img_width\" height=\"$img_height\"> $vote_val</font></td>
        </tr>\n";
  }
?>
       </table>
       <font face="<?php echo $font_face; ?>" color="<?php echo $font_color; ?>" size="1"><br>
       <?php echo $total_text; ?>: <font color="#CC0000"><?php echo $total; ?></font><br>
       <?php if($vote_stat==1) echo $voted; ?><br><br><div align="center">
       <?php if($comments==1) echo "<a class=\"links\" href=\"javascript:void(window.open('$comment_page?action=send&amp;id=$poll_id','$poll_id','width=230,height=320,toolbar=no,statusbar=no'))\">$send_com"; ?></a>&nbsp;</div></font>
       </td></tr>
      <tr><td height="32">&nbsp;</td></tr>
     </table>
    <font face="<?php echo $font_face; ?>" size="1"><a href="http://www.proxy2.de" target="_blank"><acronym title="Advanced Poll">Version <?php echo $poll_version; ?></acronym></a></font></td>
   </tr>
 </table>
</td>
</tr>
</table>
<?php }

if (isset($random_poll)) {
  if (!isset($poll_id)) {
    $poll_ids = get_poll_list();
    if (!$poll_ids) {
      echo "<b>No active polls available!</b>";
      exit();
    }
    $available = sizeof($poll_ids)-1;
    if ($available >0) {
      srand((double) microtime() * 1000000);
      $random_poll = rand(0,$available);
    } else {
      $random_poll=0;
    }
    $poll_id = $poll_ids[$random_poll];
  }
} elseif (isset($newest_poll)) {
  if (!isset($poll_id)) {
    $poll_ids = get_poll_list();
    if (!$poll_ids) {
      echo "<b>No active polls available!</b>";
      exit();
    }
    $poll_id = $poll_ids[0];
  }
} elseif (!isset($poll_id)) {
  echo "<b>Poll ID is not set!</b>";
  exit();
}

if (!isset($action)) {
  $action = '';
}

if (!file_exists("$include_path/$poll_id")) {
  echo "<b>Poll ID ".$poll_id." does not exist!</b>";
  exit();
} else {
  $stat_array = get_status($poll_id);
  if ($stat_array["status"]==2) {
    echo "<b>Poll ID ".$poll_id." does not exist!</b>";
    exit();
  }
}

if ($stat_array["status"] == 0) {
  $valid = 0;
} elseif ($stat_array["expire"] == 1) {
  if ($stat_array["exp_time"]<time()) {
    $valid = 0;
  }
}
$logging = $stat_array["logging"];
$pollcookie = "AdvancedPoll".$poll_id;

switch ($action) {
  case "results":
    view_results($poll_id,0);
    break;

  case "vote":
    if ($valid == 0) {
      view_results($poll_id,0);
      break;
    } elseif (isset($vote_for)) {
      if(isset($$pollcookie)) {
        $found=1;
      }
      if ($check_ip == 2) {
        $found_ip = check_poll_ip($poll_id);
        $found = ($found==0) ? $found_ip : 1;
      }
      if ($found==0) {
        do_vote($poll_id);
      }
    }
    view_results($poll_id,$found);
    break;

  default:
    if ($valid == 0) {
      view_results($poll_id,0);
      break;
    }
    if(isset($$pollcookie)) {
      $found=1;
    }
    if ($check_ip == 2) {
      $found_ip = check_poll_ip($poll_id);
      $found = ($found==0) ? $found_ip : 1;
    }
    if ($found==1) {
      view_results($poll_id,1);
      break;
    }
    display_poll($poll_id);
    break;
}

?>