<?php

/*======================================================================*\
|| GUESTBOOK SYSTEM v2.2 BY HASANN powered by www.vbulletin-turkey.com  ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
@ini_set('display_errors', true);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'guestbookadmin');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();
$actiontemplates = array();
$globaltemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_misc.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

if(empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'settings';
}

if($_REQUEST['do'] == 'settings')
{
	header("Location: options.php?do=options&dogroup=guestbook");
}

if($_REQUEST['do'] == 'permissions')
{
	header("Location: options.php?do=options&dogroup=guestbook_permissions");
}

if($_REQUEST['do'] == 'messages')
{

	$vbulletin->input->clean_array_gpc('r', array(
	'tutname' => TYPE_NOHTML,
	'lastsearch' => TYPE_NOHTML,
	'perpage' => TYPE_UINT,
	'pagenumber' => TYPE_UINT,
  'orderby' => TYPE_NOHTML,
  'sort' => TYPE_NOHTML
	));

	$showprev = false;
	$shownext = false;

	print_cp_header($vbphrase['guestbook_messages']);

	$count = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "guestbook AS guestbook
		" . iif($vbulletin->GPC['baslik'], "WHERE baslik LIKE '%" . addslashes($vbulletin->GPC['baslik']) . "%'") . "
	");

	if (($vbulletin->GPC['pagenumber'] < 1) || ($vbulletin->GPC['lastsearch'] != $vbulletin->GPC['baslik']))
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = $vbulletin->options['guestbook_per_page'];
	}

	$totalpages = ceil($count['total'] / $vbulletin->GPC['perpage']);
	if ($totalpages < 1)
	{
		$totalpages = 1;
	}

	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		// Perhaps some more ordering at a later date.
		case 'baslik':
		default:
		$order = 'DESC';
	}
     switch($vbulletin->GPC['sort'])
	{
		// Perhaps some more ordering at a later date.
		case 'baslik':
		default:
		$diz = 'tarih';
	}

	if ($vbulletin->GPC['pagenumber'] > 1)
	{
		$showprev = true;
	}
	if ($vbulletin->GPC['pagenumber'] < $totalpages)
	{
		$shownext = true;
	}

	$perpage = $vbulletin->options['guestbook_per_page'];
	$totaltut = $totaltuts['total'];

	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions["$i"] = "$vbphrase[page] $i / $totalpages";
	};

	?>

	<?php

	print_form_header('guestbookadmin', 'messages', false, true, 'navform', '100%', '', true, 'get');
	echo '<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>
		<td class="thead" nowrap>' . $vbphrase['search'] . ':<input type="hidden" name="lastsearch" value="' . $vbulletin->GPC['baslik'] . '" /></td>
		<td class="thead"><input type="text" name="baslik" class="bginput" tabindex="1" value="' . $vbulletin->GPC['baslik'] . '" /></td>
		<td class="thead">' .
	'<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="this.form.page.selectedIndex -= 1; this.form.submit()" />' .
	'<select name="page" tabindex="1" onchange="this.form.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>' .
	'<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="this.form.page.selectedIndex += 1; this.form.submit()" />
		</td>
		<td class="thead" nowrap>' . $vbphrase['per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';
	print_table_footer();


	print_form_header('guestbookadmin','messages');
	print_table_header($vbphrase['guestbook_messages'], 8);
	print_cells_row(array($vbphrase['guestbook_baslik'], $vbphrase['guestbook_yazan'], $vbphrase['guestbook_tarih'], $vbphrase['guestbook_sehir'], $vbphrase['guestbook_site'], $vbphrase['guestbook_rating'], $vbphrase['guestbook_status'], $vbphrase['guestbook_options']), 1, 'tcat');
	$mesajlar = $db->query_read_slave("SELECT guestbook.id, guestbook.userid, guestbook.yazan, guestbook.sehir, guestbook.site, guestbook.message, guestbook.not, 
              guestbook.tarih, guestbook.baslik, guestbook.status, user.avatarid, user.avatarrevision, avatarpath,
       NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline
       FROM " . TABLE_PREFIX . "guestbook AS guestbook
		   LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid=guestbook.userid)
       LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid=guestbook.userid)
       LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid=guestbook.userid)
       WHERE guestbook.tarih ORDER BY guestbook.$diz $order LIMIT $startat, " . $vbulletin->GPC['perpage']);


while($guestbook = $db->fetch_array($mesajlar))
	{
		if($guestbook['status'] == '0')
		{
			$guestbook['status'] = $vbphrase['guestbook_inactive'];
		}
		elseif($guestbook['status'] == '0')
		{
			$guestbook['status'] = $vbphrase['guestbook_inactive'];
		}
		elseif($guestbook['status'] == '1')
		{
			$guestbook['status'] = $vbphrase['guestbook_active'];
		}
		elseif($guestbook['status'] == '2')
		{
			$guestbook['status'] = $vbphrase['guestbook_awaiting'];
		}

     require_once(DIR . '/includes/class_bbcode.php');
	  $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
    $guestbook['baslik'] = stripslashes($guestbook['baslik']);
    $guestbook['yazan'] = stripslashes($guestbook['yazan']);
    $guestbook['sehir'] = stripslashes($guestbook['sehir']);
    $guestbook['tarih'] = vbdate($vbulletin->options['dateformat'], $guestbook['tarih']);
    $guestbook['not'] = intval($guestbook['not']);
    $guestbook['message'] = $bbcode_parser->do_parse($guestbook['message'], $vbulletin->options['guestbook_allowhtml'], $vbulletin->options['guestbook_allow_smilies'], $vbulletin->options['guestbook_allow_bbcode'], $vbulletin->options['guestbook_imgcode'], 1, 0);
		
		unset($cell);
		$cell[] = "<a href=\"guestbookadmin.php?do=view&amp;id=$guestbook[id]\" />$guestbook[baslik]</a>";
		$cell[] = "<a href=\"../member.php?u=$guestbook[userid]\" target='_blank' />$guestbook[yazan]</a>";
		$cell[] = $guestbook['tarih'];
		$cell[] = $guestbook['sehir'];
		$cell[] = $guestbook['site'];
		$cell[] = $guestbook['not'];
		$cell[] = $guestbook['status'];
		$cell[] = "<a href=\"guestbookadmin.php?do=edit&amp;id=$guestbook[id]\" /><img src=\"../images/buttons/edit_message.gif\" alt=\"Modify Message\" border=\"0\" /></a> <a href=\"guestbookadmin.php?do=delete&amp;id=$guestbook[id]&amp;userid=$guestbook[userid]\" onClick=\"return confirm('Are you sure you want to delete this message?!')\" /><img src=\"../images/buttons/delete_message.gif\" border=\"0\" /></a>";
		print_cells_row($cell,0,'alt1');
	print_hr_row(8,'alt1');
	print_description_row($guestbook['message'], 0, 8,'alt1');
	print_description_row('&nbsp;',0,8,'thead');
	}
	print_submit_row($vbphrase['guestbook_messages'], 0, 8);
	print_table_footer();
	print_cp_footer();

}


// view message
if($_REQUEST['do'] == 'view')
{
	$id = $vbulletin->input->clean_gpc('r', 'id', TYPE_INT);
	$mesaj = $db->query_first("SELECT guestbook.id, guestbook.userid, guestbook.yazan, guestbook.sehir, guestbook.site, guestbook.message, guestbook.not, 
              guestbook.tarih, guestbook.baslik, guestbook.ip, guestbook.status, user.avatarid, user.avatarrevision, avatarpath,
       NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline
       FROM " . TABLE_PREFIX . "guestbook AS guestbook
		   LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid=guestbook.userid)
       LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid=guestbook.userid)
       LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid=guestbook.userid) 
		WHERE id = '" . intval($id) . "'
	");
	
	    require_once(DIR . '/includes/class_bbcode.php');
      $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
      $mesaj['baslik'] = stripslashes($mesaj['baslik']);
      $mesaj['yazan'] = stripslashes($mesaj['yazan']);
      $mesaj['sehir'] = stripslashes($mesaj['sehir']);
      $mesaj['tarih'] = vbdate($vbulletin->options['dateformat'], $mesaj['tarih']);
      $mesaj['not'] = intval($mesaj['not']);
      $mesaj['message'] = $bbcode_parser->do_parse($mesaj['message'], $vbulletin->options['guestbook_allowhtml'], $vbulletin->options['guestbook_allow_smilies'], $vbulletin->options['guestbook_allow_bbcode'], $vbulletin->options['guestbook_imgcode'], 1, 0);
           
	if($mesaj['status'] == '0')
	{
		$mesaj['status'] = $vbphrase['guestbook_inactive'];
	}
	elseif($mesaj['status'] == '0')
	{
		$mesaj['status'] = $vbphrase['guestbook_inactive'];
	}
	elseif($mesaj['status'] == '1')
	{
		$mesaj['status'] = $vbphrase['guestbook_active'];
	}
	elseif($mesaj['status'] == '2')
	{
		$mesaj['status'] = $vbphrase['guestbook_awaiting'];
	}
	print_cp_header($vbphrase['guestbook_view_message']);
	print_form_header('guestbookadmin','edit');
	construct_hidden_code('id', $mesaj['id']);
	print_table_header("$vbphrase[guestbook_view_message]: $mesaj[baslik]");
	print_label_row($vbphrase['guestbook_baslik'], $mesaj['baslik']);
	print_label_row($vbphrase['guestbook_yazan'], $mesaj['yazan']);
	print_label_row($vbphrase['guestbook_mesaj'], $mesaj['message']);
	print_label_row($vbphrase['guestbook_tarih'], $mesaj['tarih']);
	print_label_row($vbphrase['guestbook_sehir'], $mesaj['sehir']);
	print_label_row($vbphrase['guestbook_site'], $mesaj['site']);
	print_label_row($vbphrase['guestbook_rating'], $mesaj['not']);
	print_label_row($vbphrase['guestbook_ip'], $mesaj['ip']);
	print_label_row($vbphrase['guestbook_status'], $mesaj['status']);
	print_submit_row($vbphrase['guestbook_edit'], 0);
	print_table_footer();
	print_cp_footer();
	exit;
}

// modify message
if($_REQUEST['do'] == 'edit')
{
	$id = $vbulletin->input->clean_gpc('r', 'id', TYPE_INT);
	$mesaj = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "guestbook WHERE id = '" . intval($id) . "'");
  
  require_once(DIR . '/includes/class_bbcode.php');
 $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
 $mesaj['tarih'] = vbdate($vbulletin->options['dateformat'], $mesaj['tarih']);
      
	print_cp_header($vbphrase['guestbook_edit']);
	print_form_header('guestbookadmin','update');
	construct_hidden_code('id', $mesaj['id']);
	print_table_header("$vbphrase[guestbook_edit]: $mesaj[baslik]");
	print_input_row($vbphrase['guestbook_baslik'], 'baslik', $mesaj['baslik']);
	print_input_row($vbphrase['guestbook_yazan'], 'yazan', $mesaj['yazan']);
	print_textarea_row($vbphrase['guestbook_mesaj'], 'message', $mesaj['message']);
	print_input_row($vbphrase['guestbook_tarih'], 'tarih', $mesaj['tarih']);
  print_input_row($vbphrase['guestbook_sehir'], 'sehir', $mesaj['sehir']);
  print_input_row($vbphrase['guestbook_site'], 'site', $mesaj['site']);
  print_input_row($vbphrase['guestbook_rating'], 'not', $mesaj['not']);
	print_yes_no_row($vbphrase['guestbook_is_it_active'], 'status', $mesaj['status']);
	print_submit_row($vbphrase['guestbook_update'], 0);
	print_table_footer();
	print_cp_footer();
	exit;
}

// update message
if($_POST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id' => TYPE_INT,
		'baslik' => TYPE_STR, 
		'yazan' => TYPE_STR, 
		'message' => TYPE_STR,
		'not' => TYPE_UINT,
		'tarih' => TYPE_STR, 
		'sehir' => TYPE_STR, 
		'site' => TYPE_STR,
		'status' => TYPE_STR,
	));


     $db->query_write("UPDATE " . TABLE_PREFIX . "guestbook
			SET baslik = '" . addslashes($vbulletin->GPC['baslik']) . "',
				  yazan = '" . addslashes($vbulletin->GPC['yazan']) . "',
				  message = '" . $db->escape_string($vbulletin->GPC['message']) . "',
				  tarih = '" . TIMENOW . "',
				  sehir = '" . addslashes($vbulletin->GPC['sehir']) . "',
				  site = '" . addslashes($vbulletin->GPC['site']) . "',
				  status = '" . intval($vbulletin->GPC['status']) . "'
			WHERE id = '" . intval($vbulletin->GPC['id']) . "'
		");
	
	define('CP_REDIRECT', 'guestbookadmin.php?do=messages');
	print_stop_message('guestbook_item_updated');
	exit;
}

// delete message
if($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_INT, 
	));
	
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "guestbook
		WHERE id = '" . intval($vbulletin->GPC['id']) . "'
	");

	define('CP_REDIRECT', 'guestbookadmin.php?do=messages');
	print_stop_message('guestbook_item_deleted');
	exit;
}

?>