<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// Ensure we can fetch bitfields
require_once(DIR . '/includes/adminfunctions_options.php');

$giftid = $vbulletin->input->clean_gpc('r', 'giftid', TYPE_UINT);
$gift = ($giftid ? $vbshop->cache['gift']["$giftid"] : false);

if (!is_array($gift))
{
	print_cp_message($vbphrase['dbtech_vbshop_invalid_gift']);
}

// grab current permissions
$gift['permissions'] = @unserialize($gift['permissions']);

// Table header
$headings = array();
$headings[] = $vbphrase['usergroup'];
$headings[] = $vbphrase['dbtech_vbshop_can_purchase'];

print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['permissions'], $gift['title'])));
print_form_header('vbshop', 'updategiftpermissions');
construct_hidden_code('giftid', $giftid);
print_table_header(construct_phrase($vbphrase['dbtech_vbshop_editing_x_y'], $vbphrase['permissions'], $gift['title']), count($headings));
print_cells_row($headings, 0, 'thead');

foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
{
	// Table data
	$cell = array();
	$cell[] = $usergroup['title'];	
	$cell[] = '<center>
		<input type="radio" name="usergroup[' . $usergroupid . ']" id="usergroup_' . $usergroupid . '_yes" value="1"' . ($gift['permissions']["$usergroupid"] == 1 ? ' checked="checked"' : '') . ' /> <label for="usergroup_' . $usergroupid . '_yes">' . $vbphrase['yes'] . '</label> 
		<input type="radio" name="usergroup[' . $usergroupid . ']" id="usergroup_' . $usergroupid . '_no" value="0"' . ($gift['permissions']["$usergroupid"] == 0 ? ' checked="checked"' : '') . '/> <label for="usergroup_' . $usergroupid . '_no">' . $vbphrase['no'] . '</label> 
		<input type="radio" name="usergroup[' . $usergroupid . ']" id="usergroup_' . $usergroupid . '_default" value="-1"' . (($gift['permissions']["$usergroupid"] == -1 OR !isset($gift['permissions']["$usergroupid"])) ? ' checked="checked"' : '') . '/> <label for="usergroup_' . $usergroupid . '_default">' . $vbphrase['default'] . '</label> 
	</center>';
	
	// Print the data
	print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
}
print_submit_row($vbphrase['save'], false, count($headings));

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: gift.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>