<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (defined('IN_CONTROL_PANEL'))
{
	define('ECHO_CRON_LOG', true);
}

// Deceptor sucks at the internet
require(DIR . '/includes/functions_misc.php');

// Any lottery items?
$lottery = array();

if (is_array($vbulletin->VBSHOP->cache['item']))
{
	foreach ($vbulletin->VBSHOP->cache['item'] as $item)
	{
		if ($item['itemtype'] == 'lotteryticket')
		{
			$lottery[$item['itemid']] = $item;
		}
	}
}

if (!empty($lottery))
{
	foreach ($lottery as $lotto)
	{
		$winners = array();
		$losers = array();
		$pm = array();
		$lotto = $vbulletin->VBSHOP->init_item($lotto);

		if (TIMENOW >= $lotto->nextdraw())
		{
			// Find available tickets
			$tickets = $lotto->fetchtickets();
			$ticketids = array();

			if (count($tickets) > 0)
			{
				$numbers = $lotto->getnumbers();
				$prizes = $lotto->prizes($lotto->config['code']['prize']);

				foreach ($tickets as $ticket)
				{
					$ticketids[] = $ticket['ticketid'];
					$matches = $lotto->matches($numbers, unserialize($ticket['numbers']));
					$prize = $lotto->findprize($matches, $prizes);

					if ($prize)
					{
						// We have a winner!
						$winners[] = array('ticket' => $ticket, 'prize' => ceil($lotto->calcprize($prize, $tickets)));
					}
					else
					{
						// Better luck next time!
						$losers[] = array('ticket' => $ticket);
					}
				}
				
				// Deceptor sucks at the internet
				$vbphrase['dbtech_vbshop_lottery_winner'] 			= fetch_phrase('dbtech_vbshop_lottery_winner', 			'global');
				$vbphrase['dbtech_vbshop_lottery_winner_message'] 	= fetch_phrase('dbtech_vbshop_lottery_winner_message', 	'global');
				$vbphrase['dbtech_vbshop_lottery_loser'] 			= fetch_phrase('dbtech_vbshop_lottery_loser', 			'global');
				$vbphrase['dbtech_vbshop_lottery_loser_message'] 	= fetch_phrase('dbtech_vbshop_lottery_loser_message', 	'global');

				// Any winners?
				foreach ($winners as $winner)
				{
					// Update funds
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "{$vbulletin->options[dbtech_vbshop_pointstable]}
						SET {$vbulletin->options[dbtech_vbshop_pointsfield]} = {$vbulletin->options[dbtech_vbshop_pointsfield]} + {$winner['prize']}
						WHERE userid = " . $winner['ticket']['userid'] . "
					");

					// Apply to PM array
					$pm[] = array(
						'userid'	=> $winner['ticket']['userid'],
						'username'	=> $winner['ticket']['username'],
						'title'		=> $vbphrase['dbtech_vbshop_lottery_winner'],
						'message'	=> sprintf($vbphrase['dbtech_vbshop_lottery_winner_message'], $matches, $prize, implode(', ', array_values($numbers)), $vbulletin->options['dbtech_vbshop_pointsname']),
					);
				}

				// Any losers?
				foreach ($losers as $loser)
				{
					$pm[] = array(
						'userid'	=> $loser['ticket']['userid'],
						'username'	=> $loser['ticket']['username'],
						'title'		=> $vbphrase['dbtech_vbshop_lottery_loser'],
						'message'	=> sprintf($vbphrase['dbtech_vbshop_lottery_loser_message'], implode(', ', array_values($numbers))),
					);
				}

				// Nullify tickets
				log_cron_action('Updating Tickets: ' . implode(',', $ticketids), $nextitem);
				$vbulletin->db->query_write("update " . TABLE_PREFIX . "dbtech_vbshop_ticket set active = '0' where ticketid in (" . implode(',', $ticketids) . ")");
			}
			else
			{
				log_cron_action('No tickets to check...', $nextitem);
			}

			// Update the lottery runtime
			$lotto->config['code']['start'] = $lotto->nextdraw();
			
			log_cron_action('Updating Item: ' . $lotto->config['itemid'], $nextitem);
			$vbulletin->db->query_write("update " . TABLE_PREFIX . "dbtech_vbshop_item set code = '" . $vbulletin->db->escape_string(serialize($lotto->config['code'])) . "' where itemid = " . intval($lotto->config['itemid']));
			$vbulletin->VBSHOP->build_cache('dbtech_vbshop_item');

			// Send the private messages
			if (count($pm) > 0)
			{
				$permissions = array(
					'pmsendmax' => 10,
				);

				foreach ($pm as $message)
				{
					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set_info('is_automated', true); // implies overridequota
					$pmdm->set('fromuserid', $message['userid']);
					$pmdm->set('fromusername', $message['username']);
					$pmdm->setr('title', $message['title']);
					$pmdm->set_recipients($message['username'], $permissions, 'cc');
					$pmdm->setr('message', $message['message']);
					$pmdm->set('dateline', TIMENOW);
					$pmdm->set('allowsmilie', 0);

					if ($pmdm->pre_save() AND empty($pmdm->errors))
					{
						log_cron_action("Sending PM to: $message[username]", $nextitem);
						$pmdm->save();
					}
					else
					{
						log_cron_action(implode(', ', $pmdm->errors), $nextitem);
					}
				}
			}
			else
			{
				log_cron_action('No users to PM...', $nextitem);
			}

			break; // 1 lottery per cron rotation max!
		}
		else
		{
			log_cron_action(TIMENOW . ' is less than ' . $lotto->nextdraw() . '...', $nextitem);
		}
	}
}
else
{
	log_cron_action('No lotteries found...', $nextitem);
}

//log_cron_action('Lottery Processed', $nextitem);

/*======================================================================*\
|| #################################################################### ||
|| # Created: 16:56, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$							 							  # ||
|| #################################################################### ||
\*======================================================================*/