<?php
class vBShop_Item_usernamestyle extends vBShop_Item_Core
{	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	vBShop		vBShop registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, $vbshop, &$item)
	{
		parent::__construct($registry, $vbshop, $item);
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_purchase_style';
	}
	
	/**
	* Load item info
	*/	
	public function load_item_info()
	{
		return array(
			'name' 					=> 'User Name Style Change',
			'description' 			=> 'Change the style of usernames.',
			'icon' 					=> '',
			'price' 				=> 10
		);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		// Finally print the select
		$this->vbshop->print_bitfield_row($vbphrase['dbtech_vbshop_usernamestyle'], 'code[value]', 'nocache|dbtech_vbshop_style', $code['value']);
	}
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	* @param	array		Recipient user info
	*/	
	protected function pre_purchase(&$buyer, &$recipient)
	{
		global $vbphrase;
		
		/*
		$noalter = explode(',', $this->registry->config['SpecialUsers']['undeletableusers']);
		if (!is_array($noalter))
		{
			$noalter = array();
		}

		if ($buyer['userid'] != $recipient['userid'] AND in_array($recipient['userid'], $noalter))
		{
			// Woups, immune
			eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
		}
		*/
				
		/*
		// Ensure we have the necessary files
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
		foreach ($bitfielddefs AS $key => $val)
		{
			if ($key == 'dbtech_vbshop_' . $this->config['itemtype'] AND $recipient['userid'] != $buyer['userid'] AND ($recipient['dbtech_vbshop_immunity'] & $val))
			{
				// Woups, immune
				eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
			}
		}
		*/
		
		// Get the form code
		$code = $this->registry->input->clean_gpc('p', 'code', TYPE_ARRAY);
		
		// Grab the current style
		$currentstyle = @unserialize($recipient['dbtech_vbshop_usernamestyle']);
		$currentstyle = (!is_array($currentstyle) ? array() : $currentstyle);
		
		foreach ($code as $style => $onoff)
		{
			if ($style == 'color')
			{
				// Special case
				$currentstyle["$style"] = htmlspecialchars_uni($code["$style"]);
				continue;
			}
			
			if ($currentstyle["$style"] AND !$onoff)
			{
				unset($currentstyle["$style"]);
				continue;
			}
			
			if (!$currentstyle["$style"] AND $onoff)
			{
				$currentstyle["$style"] = $code["$style"];
				continue;
			}
		}
		
		// Set username style
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET dbtech_vbshop_usernamestyle = " . $this->registry->db->sql_prepare(trim(serialize($currentstyle))) . "
			WHERE userid = " . intval($recipient['userid'])
		);
	}
	
	/**
	* Actions that override the musername / usertitle
	*
	* @param	array		User info
	* @param	integer		Display group id
	*/	
	public function fetch_musername(&$user, $displaygroupid)
	{
		if (!$this->action())
		{
			// We're not doin this
			return false;
		}
		
		if (!$user['dbtech_vbshop_usernamestyle'])
		{
			// We not doin dis
			return false;
		}
		
		if (!is_array($user['dbtech_vbshop_usernamestyle']))
		{
			// Ensure this is an array
			$user['dbtech_vbshop_usernamestyle'] = @unserialize($user['dbtech_vbshop_usernamestyle']);
		}
		
		// By default, no open tag
		$this->config['code']['opentag'] = '';
		
		if ($user['dbtech_vbshop_usernamestyle']['bold'] OR $user['dbtech_vbshop_usernamestyle']['italic'] OR $user['dbtech_vbshop_usernamestyle']['underline'] OR $user['dbtech_vbshop_usernamestyle']['color'])
		{
			// We have at least one thing, start the tag
			$this->config['code']['opentag'] = '<span style="';
			
			if ($user['dbtech_vbshop_usernamestyle']['bold'])
			{
				// Bolded username
				$this->config['code']['opentag'] .= 'font-weight:bold; ';
			}
			
			if ($user['dbtech_vbshop_usernamestyle']['italic'])
			{
				// Bolded username
				$this->config['code']['opentag'] .= 'font-style:italic; ';
			}
			
			if ($user['dbtech_vbshop_usernamestyle']['underline'])
			{
				// Bolded username
				$this->config['code']['opentag'] .= 'text-decoration:underline; ';
			}
			
			if ($user['dbtech_vbshop_usernamestyle']['color'])
			{
				// Bolded username
				$this->config['code']['opentag'] .= 'color:' . $user['dbtech_vbshop_usernamestyle']['color'] . '; ';
			}
			
			// Close the tag
			$this->config['code']['opentag'] .= '">';
			$this->config['code']['closetag'] = '</span>';
		}
		
		if (!empty($this->config['code']['opentag']))
		{
			// We've got musername 
			$user['musername'] = $this->registry->usergroupcache["$displaygroupid"]['opentag'] . $this->config['code']['opentag'] . $user['username'] . $this->config['code']['closetag'] . $this->registry->usergroupcache["$displaygroupid"]['closetag'];			
		}
	}	
}
?>