<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Init this
$columns = array(
	'title' 		=> TYPE_STR,
	'description' 	=> TYPE_STR,
	'displayorder'	=> TYPE_UINT,
	'shoptypes'		=> TYPE_ARRAY_UINT
);

// Grab stuff
$vbulletin->input->clean_array_gpc('p', $columns);
$categoryid = $vbulletin->input->clean_gpc('p', 'categoryid', TYPE_UINT);

$values = array();
foreach ($columns as $columnname => $type)
{
	// Store the values
	$values["$columnname"] = (is_array($vbulletin->GPC["$columnname"]) ? trim(serialize($vbulletin->GPC["$columnname"])) : $vbulletin->GPC["$columnname"]);
}

$bit = 0;
foreach ($vbulletin->GPC['shoptypes'] as $val)
{
	$bit += $val;
}
$values['shoptypes'] = $bit;

// Init this
$condition = '';

if ($categoryid)
{
	if (!$existing = $vbshop->cache['category']["$categoryid"])
	{
		// Editing ID doesn't exist
		print_stop_message('dbtech_vbshop_invalid_x', $vbphrase['dbtech_vbshop_category'], $categoryid);
	}
	
	if ($existing = $db->query_first("
		SELECT `title`
		FROM `" . TABLE_PREFIX . "dbtech_vbshop_category`
		WHERE `title` = " . $db->sql_prepare($vbulletin->GPC['title']) . "
			AND `categoryid` != " . $db->sql_prepare($categoryid) . "
		LIMIT 1
	"))
	{
		// Whoopsie, exists
		print_stop_message('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_category'], $existing['title']);
	}
	
	// Set condition
	$condition = "WHERE categoryid=" . $categoryid;
	
	// Set redirect phrase
	$phrase = $vbphrase['dbtech_vbshop_edited'];	
}
else
{
	if ($existing = $db->query_first("
		SELECT `title`
		FROM `" . TABLE_PREFIX . "dbtech_vbshop_category`
		WHERE `title` = " . $db->sql_prepare($vbulletin->GPC['title']) . "
		LIMIT 1
	"))
	{
		// Whoopsie, exists
		print_stop_message('dbtech_vbshop_x_already_exists_y', $vbphrase['dbtech_vbshop_category'], $existing['title']);
	}
	
	// Set redirect phrase
	$phrase = $vbphrase['dbtech_vbshop_added'];
}

// Update the database
$db->query_write(fetch_query_sql($values, 'dbtech_vbshop_category', $condition));	

// Rebuild the cache
$vbshop->build_cache('dbtech_vbshop_category', 'ORDER BY `displayorder` ASC');

define('CP_REDIRECT', 'vbshop.php?do=category');
print_stop_message('dbtech_vbshop_x_y', $vbphrase['dbtech_vbshop_category'], $phrase);


/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: category.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>