<?php
class vBShop_Item_permission extends vBShop_Item_Core
{	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	vBShop		vBShop registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, $vbshop, &$item)
	{
		parent::__construct($registry, $vbshop, $item);
	}
	
	/**
	* Load item info
	*/	
	public function load_item_info()
	{
		return array(
			'name' 					=> 'Usergroup Permissions (Yes / No)',
			'description' 			=> 'Yes / No Permission Flags',
			'icon' 					=> '',
			'price' 				=> 10
		);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	/**
	* Actions that override the permissions
	*
	* @param	array		User info
	*/	
	public function cache_permissions(&$user)
	{
		if (!$this->action())
		{
			// We're not doin this
			return false;
		}
		
		// Create a temp array
		$arr = explode('-=-', $this->config['code']['permissions']);
		
		if (!is_array($arr))
		{
			// We not doin this
			return false;
		}
		
		if (!is_array($this->registry->bf_ugp["$arr[0]"]))
		{
			// We not doin dis
			return false;
		}
		
		// Add the permissions
		$user['permissions']["$arr[0]"] |= $this->registry->bf_ugp["$arr[0]"]["$arr[1]"];
	}
	
	/**
	* Prints out an AdminCP form
	*/	
	public function print_admin_form($code)
	{
		global $vbphrase;
		
		// Ensure we can fetch bitfields
		require_once(DIR . '/includes/class_bitfield_builder.php');
		if (vB_Bitfield_Builder::build(false) !== false)
		{
			$myobj =& vB_Bitfield_Builder::init();
			if (sizeof($myobj->datastore_total['ugp']) != sizeof($this->registry->bf_ugp))
			{
				$myobj->save($db);
				build_forum_permissions();
				define('CP_REDIRECT', $this->registry->scriptpath);
				print_stop_message('rebuilt_bitfields_successfully');
			}
		}
		else
		{
			echo "<strong>error</strong>\n";
			print_r(vB_Bitfield_Builder::fetch_errors());
		}
		
		foreach ($myobj->data['ugp'] AS $grouptitle => $perms)
		{
			foreach ($perms AS $permtitle => $permvalue)
			{
				if (empty($permvalue['group']))
				{
					continue;
				}
				
				if ($permvalue['intperm'])
				{
					continue;
					//$groupinfo["$permvalue[group]"]["$permtitle"]['intperm'] = true;
				}
				
				$groupinfo["$permvalue[group]"]["$permtitle"] = array('phrase' => $permvalue['phrase'], 'value' => $permvalue['value'], 'parentgroup' => $grouptitle);
				
				if (!empty($myobj->data['layout']["$permvalue[group]"]['ignoregroups']))
				{
					$groupinfo["$permvalue[group]"]['ignoregroups'] = $myobj->data['layout']["$permvalue[group]"]['ignoregroups'];
				}
				if (!empty($permvalue['ignoregroups']))
				{
					$groupinfo["$permvalue[group]"]["$permtitle"]['ignoregroups'] = $permvalue['ignoregroups'];
				}
				if (!empty($permvalue['options']))
				{
					$groupinfo["$permvalue[group]"]["$permtitle"]['options'] = $permvalue['options'];
				}
			}
		}
		
		$permissions = array();		
		foreach ($groupinfo AS $grouptitle => $group)
		{
			foreach ($group AS $permtitle => $permvalue)
			{
				// Permission is shown only if a particular option is enabled.
				if (isset($permvalue['options']) AND !$vbulletin->options["$permvalue[options]"])
				{
					continue;
				}
		
				// Permission is hidden from specific groups
				if (isset($permvalue['ignoregroups']))
				{
					$ignoreids = explode(',', $permvalue['ignoregroups']);
					if (in_array($vbulletin->GPC['usergroupid'], $ignoreids))
					{
						continue;
					}
				}
				
				$group_title = ($vbphrase["$grouptitle"] ? $vbphrase["$grouptitle"] : $grouptitle);
				$permissions["$group_title"]["{$permvalue[parentgroup]}-=-{$permtitle}"] = preg_replace('/<dfn>.*$/isU', '', $vbphrase["$permvalue[phrase]"]);
			}
		}
		
		// Finally print the select
		print_select_row($vbphrase['dbtech_vbshop_usergroup_permissions_yesno'], 'code[permissions]', $permissions,	$code['permissions']);
	}	
}
?>