function getVersionArray(version){
var subVerCheck, mainVer, subVer, versionBits, i;
if (subVerCheck = version.match(/^([a-zA-Z]+ )?([0-9\.]+)\s*([a-zA-Z].*)$/))
{
mainVer = subVerCheck[2];
subVer = subVerCheck[3].toUpperCase();
}
else
{
mainVer = version;
subVer = "";
}
versionBits = mainVer.split(".");
if (versionBits.length < 4)
{
for (i = versionBits.length; i < 4; i++)
{
versionBits[i] = 0;
}
}
versionBits[4] = 0;
versionBits[5] = 0;
if (subVer != "")
{
if (matches = subVer.match(/^(A|ALPHA|B|BETA|G|GAMMA|RC|RELEASE CANDIDATE|GOLD|STABLE|FINAL|PL|PATCH LEVEL|PATCH)\s*(\d*)$/i))
{
switch(matches[1])
{
case "A":
case "ALPHA":
versionBits[4] = -4;
break;
case "B":
case "BETA":
versionBits[4] = -3;
break;
case "G":
case "GAMMA":
versionBits[4] = -2;
break;
case "RC":
case "RELEASE CANDIDATE":
versionBits[4] = -1;
break;
case "PL":
case "PATCH LEVEL":
case "PATCH":
versionBits[4] = 1;
break;
case "GOLD":
case "STABLE":
case "FINAL":
default:
versionBits[4] = 0;
}
versionBits[5] = matches[2];
}
}
for (i = 0; i < 6; i++)
{
if (!(versionBits[i] = parseInt(versionBits[i])))
{
versionBits[i] = 0;
}
}
return versionBits;
}
function isNewerVersion(thisVersion, latestVersion){
var curVersion, newVersion, i;
if (thisVersion != latestVersion)
{
curVersion = getVersionArray(thisVersion);
newVersion = getVersionArray(latestVersion);
for (i = 0; i < 6; i++)
{
if (newVersion[i] != curVersion[i])
{
return (newVersion[i] > curVersion[i]);
}
}
}
return false;}