<?php

(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['SUBJECT'] 	= 	true;
$CALL_SYSTEM['REPLY'] 		= 	true;
$CALL_SYSTEM['SECTION'] 		= 	true;
$CALL_SYSTEM['CACHE'] 			= 	true;

include('common.php');

define('CLASS_NAME','PowerBBTrashMOD');

class PowerBBTrashMOD extends _functions /** Yes it's Power Trash :D **/
{
	function run()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['member_permission'])
		{
			$PowerBB->template->display('header');

			if ($PowerBB->_GET['subject'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_SubjectTrashMain();
				}
				elseif ($PowerBB->_GET['untrash'])
				{
					$this->_SubjectUnTrash();
				}
				elseif ($PowerBB->_GET['del'])
				{
					if ($PowerBB->_GET['confirm'])
					{
						$this->_SubjectDelMain();
					}
					elseif ($PowerBB->_GET['start'])
					{
						$this->_SubjectDelete();
					}
				}
			}
			elseif ($PowerBB->_GET['reply'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ReplyTrashMain();
				}
				elseif ($PowerBB->_GET['untrash'])
				{
					$this->_ReplyUnTrash();
				}
				elseif ($PowerBB->_GET['del'])
				{
					if ($PowerBB->_GET['confirm'])
					{
						$this->_ReplyDelMain();
					}
					elseif ($PowerBB->_GET['start'])
					{
						$this->_ReplyDelete();
					}
				}
			}

			$PowerBB->template->display('footer');
		}
	}

	function _SubjectTrashMain()
	{
		global $PowerBB;

		$TrashArr 						= 	array();

		$TrashArr['proc'] 				= 	array();
		$TrashArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$TrashArr['where']				=	array();
		$TrashArr['where'][0]			=	array();
		$TrashArr['where'][0]['name']	=	'delete_topic';
		$TrashArr['where'][0]['oper']	=	'=';
		$TrashArr['where'][0]['value']	=	'1';

		$TrashArr['order']				=	array();
		$TrashArr['order']['field']		=	'id';
		$TrashArr['order']['type']		=	'DESC';

		$PowerBB->_CONF['template']['while']['TrashList'] = $PowerBB->subject->GetSubjectList($TrashArr);

		$PowerBB->template->display('trash_subjects');
	}

	function _SubjectUnTrash()
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$Trash['where']				=	array('id',$PowerBB->_GET['id']);

		$UnTrash = $PowerBB->subject->UnTrashSubject($Trash);

		if ($UnTrash)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['subject_has_been_trash_successfully']);
			$PowerBB->functions->redirect('admin.php?page=trash&amp;subject=1&amp;main=1');
		}
	}

	function _SubjectDelMain()
	{
		global $PowerBB;

		$this->check_subject_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('trash_subject_del');
	}

	function _SubjectDelete()
	{
		global $PowerBB;

		$this->check_subject_by_id($Inf);

		$DelArr				=	array();
		$DelArr['where'] 	= 	array('id',$Inf['id']);

		$del = $PowerBB->subject->DeleteSubject($DelArr);

		if ($del)
		{
             		$SecArr 			= 	array();
					$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

					$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

					// The number of section's subjects number
		     		$UpdateArr 					= 	array();
		     		$UpdateArr['field']			=	array();

		     		$UpdateArr['field']['subject_num'] 	= 	$this->SectionInfo['subject_num'] - 1;
		     		$UpdateArr['where']					= 	array('id',$this->SectionInfo['id']);

		     		$UpdateSubjectNumber = $PowerBB->section->UpdateSection($UpdateArr);


		     		// Free memory
		     		unset($UpdateArr);

		     		//////////

		     		// Update section's cache
		     		$UpdateArr 				= 	array();
		     		$UpdateArr['parent'] 	= 	$this->SectionInfo['parent'];

		     		$update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

		     		unset($UpdateArr);

		     		//////////

		     		//////////

		     		// The overall number of subjects
		     		$UpdateSubjectNumber = $PowerBB->cache->UpdateSubjectNumber(array('subject_num'	=>	$PowerBB->_CONF['info_row']['subject_number']));

		     		//////////

					$DelArr				=	array();
					$DelArr['where'] 	= 	array('subject_id',$Inf['id']);

					$del = $PowerBB->reply->DeleteReply($DelArr);


			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Topic_has_been_deleted_and_all_its_replies_successfully']);
			$PowerBB->functions->redirect('admin.php?page=trash&amp;subject=1&amp;main=1');
		}
	}

	function _ReplyTrashMain()
	{
		global $PowerBB;

		$TrashArr 						= 	array();
		$TrashArr['proc'] 				= 	array();
		$TrashArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$TrashArr['order']				=	array();
		$TrashArr['order']['field']		=	'id';
		$TrashArr['order']['type']		=	'DESC';

		$TrashArr['where']				=	array();
		$TrashArr['where'][0]			=	array();
		$TrashArr['where'][0]['name']	=	'delete_topic';
		$TrashArr['where'][0]['oper']	=	'=';
		$TrashArr['where'][0]['value']	=	'1';

		$PowerBB->_CONF['template']['while']['TrashList'] = $PowerBB->reply->GetReplyList($TrashArr);

		$PowerBB->template->display('trash_replies');
	}

	function _ReplyUnTrash()
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$Trash['where']				=	array('id',$PowerBB->_GET['id']);
		$UnTrash = $PowerBB->reply->UnTrashReply($Trash);

;
		if ($UnTrash)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Reply_has_been_trash_successfully']);
			$PowerBB->functions->redirect('admin.php?page=trash&amp;reply=1&amp;main=1');
		}
	}

	function _ReplyDelMain()
	{
		global $PowerBB;

		$this->check_reply_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('trash_reply_del');
	}

	function _ReplyDelete()
	{
		global $PowerBB;

		$this->check_reply_by_id($ReplyInf);
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$Tdel['where']	=	array('id',$PowerBB->_GET['id']);

		$del            = $PowerBB->reply->DeleteReply($Tdel);

		if ($del)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Reply_has_been_deleted_successfully']);
			$PowerBB->functions->redirect('admin.php?page=trash&amp;reply=1&amp;main=1');
		}
	}
}

class _functions
{
	function check_subject_by_id(&$Inf)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$InfArr 			= 	array();
		$InfArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$Inf = $PowerBB->subject->GetSubjectInfo($InfArr);

		if ($Inf == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['subject_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($Inf,'html');
	}

	function check_reply_by_id(&$ReplyInf)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$ReplyArr = array();
		$ReplyArr['where'] = array('id',$PowerBB->_GET['id']);

		$ReplyInf = $PowerBB->reply->GetReplyInfo($ReplyArr);

		if ($ReplyInf == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['subject_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($ReplyInf,'html');
	}
}

?>
