<?php
if ($block == 'latestreply' AND $vbulletin->options['dbtech_infopanel_latestreply_enabled'])
{
	// Add New Posts
	$xml->add_tag('header' . $blockid, $vbphrase['dbtech_infopanel_newest_replies']);
	
	if (!is_array($newposts))
	{
		$newposts = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_newposts');
		if ($newposts === false)
		{
			$newposts = array();
			$newposts_q = $db->query_read_slave("
				SELECT thread.threadid, thread.title, thread.lastpost, thread.lastpostid, thread.forumid, thread.replycount, thread.lastposter, thread.dateline, thread.views, thread.visible, thread.open, user.username, user.userid, user.usergroupid, user.displaygroupid, user.customtitle
				" . (($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid']) ? ", threadread.readtime AS threadread" : "") . "
				FROM " . TABLE_PREFIX . "thread AS thread
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
				" . (($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid']) ? " LEFT JOIN " . TABLE_PREFIX . "threadread AS threadread ON (threadread.threadid = thread.threadid AND threadread.userid = " . $vbulletin->userinfo['userid'] . ")" : "") . "
				WHERE NOT ISNULL(thread.threadid)
					AND thread.visible = '1'
					AND thread.open != '10'
					AND thread.forumid IN(0" . implode(', ', $forumids) . ")
					$excludegroups
				ORDER BY lastpost DESC
				LIMIT " . $vbulletin->options['dbtech_infopanel_limit']
			);
			while ($newposts_r = $db->fetch_array($newposts_q))
			{
				if ($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid'])
				{
					$forumread = $vbulletin->forumcache["$newposts_r[forumid]"]['forumread'];
					$lastread = max($forumread, TIMENOW - ($vbulletin->options['markinglimit'] * 86400));
				}
				else
				{
					$bbforumview = intval(fetch_bbarray_cookie('forum_view', $newposts_r['forumid']));
					$lastread = max($bbforumview, $vbulletin->userinfo['lastvisit']);
				}
				
				// Default to old post
				$word = 'old';			
				if ($newposts_r['lastpost'] > $lastread)
				{
					if ($vbulletin->options['threadmarking'] AND $newposts_r['threadread'])
					{
						$threadview = $newposts_r['threadread'];
					}
					else
					{
						$threadview = intval(fetch_bbarray_cookie('thread_lastview', $newposts_r['threadid']));
					}
					
					if (!$threadview)
					{
						$threadview = $vbulletin->userinfo['lastvisit'];
					}
		
					if ($newposts_r['lastpost'] > $threadview)
					{
						// Yep, this IS a new post
						$word = 'new';
					}
				}			
				
				// Strip tags from username
				$newposts_r['fullusername'] = $newposts_r['username'] = strip_tags($newposts_r['username']);
				
				if ($vbulletin->options['dbtech_infopanel_trimusername'])
				{
					// Trim the username
					$newposts_r['username'] = fetch_trimmed_title($newposts_r['username'], $vbulletin->options['dbtech_infopanel_trimusername']);
				}
				
				// Fetch coloured username
				$newposts_r['musername'] = fetch_musername($newposts_r);
				
				// Restore username for SEO Link purposes
				$newposts_r['username'] = $newposts_r['fullusername'];
				
				// Strip tags from thread title
				$newposts_r['fulltitle'] = $newposts_r['title'] = strip_tags($newposts_r['title']);
				
				if ($vbulletin->options['dbtech_infopanel_trimthread'])
				{
					// Trim the thread title
					$newposts_r['title'] = fetch_trimmed_title($newposts_r['title'], $vbulletin->options['dbtech_infopanel_trimthread']);
				}
				
				// Strip tags from forum name
				$newposts_r['fullforumname'] = $newposts_r['forumname'] = strip_tags($vbulletin->forumcache["$newposts_r[forumid]"]['title_clean']);
				
				if ($vbulletin->options['dbtech_infopanel_trimforum'])
				{
					// Trim the thread title
					$newposts_r['forumname'] = fetch_trimmed_title($newposts_r['forumname'], $vbulletin->options['dbtech_infopanel_trimforum']);
				}
				
				// Format reply count and views
				$newposts_r['replycount'] 	= vb_number_format($newposts_r['replycount']);
				$newposts_r['views'] 		= vb_number_format($newposts_r['views']);
				
				// Pre-title shiet
				$newposts_r['word'] 	= $word;
				$newposts_r['pretitle'] = $vbphrase["$word"];
				
				// New Post shiet
				$newposts_r['gotonewpost'] = array('goto' => 'newpost');
				
				// Store this now that we've tampered with the data enough
				$newposts[] = $newposts_r;
			}
			$db->free_result($newposts_q);
			unset($newposts_r);
			
			// Set the cache
			set_vbo_cache($vbulletin->userinfo['userid'] . '_newposts', $newposts, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
		}
	}
	
	$bit = '';
	foreach ($newposts as $post)
	{
		$templater = vB_Template::create('dbtech_infopanel_block_latestreply_bit');
			$templater->register('post', $post);
		$bit .= $templater->render();
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_block_latestreply');
		$templater->register('bit', $bit);
	
	// Add New Posts
	$xml->add_tag('block' . $blockid, $templater->render());
}
?>