<?php
if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/infopanels/includes/class_template.php');
}

require(DIR . '/dbtech/infopanels/includes/functions_infopanels.php');

// Some form of access permissions here in the future
$show['dbtech_infopanels_reloadstats'] = true;
$show['blogs'] 		= (bool)$vbulletin->products['vbblog'];
$show['vbactivity'] = (bool)$vbulletin->products['dbtech_vbactivity'];
$show['vbshout'] 	= (bool)$vbulletin->products['dbtech_vbshout'];

if ($vbulletin->options['dbtech_infopanel_separate_staff'])
{
	$activeusers = '';
	if (intval($vbulletin->versionnumber) > 3)
	{
		$activeusers = '<li>';
	}
	if (strlen($onlinegroups['staff']) > 0)
	{
		if (intval($vbulletin->versionnumber) == 3)
		{
			// Staff
			$activeusers .= '<b>' . $vbphrase['dbtech_infopanels_staff'] . ':</b> ' . $onlinegroups['staff'];
		}
		else
		{
			// Staff
			$activeusers .= '<b>' . $vbphrase['dbtech_infopanels_staff'] . ':</b> <ol class="commalist" style="display: inline">' . $onlinegroups['staff'] . '</ol>';
		}
	}
	
	if (strlen($onlinegroups['member']) > 0)
	{
		if (strlen($onlinegroups['staff']) > 0)
		{
			// Do sum lien break
			$activeusers .= '<br /><br />';
		}
		
		if (intval($vbulletin->versionnumber) == 3)
		{
			// Staff
			$activeusers .= '<b>' . $vbphrase['dbtech_infopanels_member'] . ':</b> ' . $onlinegroups['member'];
		}
		else
		{
			// Staff
			$activeusers .= '<b>' . $vbphrase['dbtech_infopanels_member'] . ':</b> <ol class="commalist" style="display: inline">' . $onlinegroups['member'] . '</ol>';
		}
	}
	if (intval($vbulletin->versionnumber) > 3)
	{
		$activeusers .= '</li>';
	}}

$infopanels = array(
	'welcomepanel' => '',
	'topxstats' => ''
);
if ($vbulletin->userinfo['userid'] AND $vbulletin->options['dbtech_infopanels_welcomepanel_enable'])
{
	($hook = vBulletinHook::fetch_hook('dbtech_infopanels_forumhome_complete')) ? eval($hook) : false;
	
	$totalthreads2 = 0;
	$totalposts2 = 0;
	if (is_array($vbulletin->forumcache))
	{
		foreach ($vbulletin->forumcache AS $forum)
		{
			$totalthreads2 += $forum['threadcount'];
			$totalposts2 += $forum['replycount'];
		}
	}
	
	// Do posts per day
	$jointime = (TIMENOW - $vbulletin->userinfo['joindate']) / 86400;
	$postsperday = ($jointime <= 1 ? $vbulletin->userinfo['posts'] : vb_number_format($vbulletin->userinfo['posts'] / $jointime, 2));
	
	if ($totalposts2 > 0)
	{
		// Fetch percent of total posts
		$postpercent = vb_number_format((($vbulletin->userinfo['posts'] / $totalposts2) * 100), 2);
	}
	else
	{
		// This cannot be!
		$postpercent = 'N/A';
	}
	
	// Fetch from vBO cache
	$counters = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_cnt', $vbulletin->userinfo['lastvisit']);
	if ($counters === false)
	{
		// Various counters
		$counters = $db->query_first_slave("
			SELECT (
				SELECT COUNT(postid)
				FROM " . TABLE_PREFIX . "post
				WHERE dateline >= " . $vbulletin->userinfo['lastvisit'] . "
			) AS newposts,
			(
				SELECT COUNT(threadid)
				FROM " . TABLE_PREFIX . "thread 
				WHERE dateline >= " . $vbulletin->userinfo['lastvisit'] . "
			) AS newthreads
			" . ($vbulletin->products['vbblog'] ? "
			,
			(
				SELECT COUNT(blogid)
				FROM " . TABLE_PREFIX . "blog_text
				WHERE dateline >= " . $vbulletin->userinfo['lastvisit'] . "
			) AS newblogs" : '') . "
		");
		
		// Set the cache
		set_vbo_cache($vbulletin->userinfo['userid'] . '_cnt', $counters, $vbulletin->userinfo['lastvisit']);
	}
	
	// Fetch from vBO cache
	$counters2 = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_cnt2');
	if ($counters2 === false)
	{
		$counters2 = $db->query_first_slave("
			SELECT 
			(
				SELECT COUNT(postid)
				FROM " . TABLE_PREFIX . "post 
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
					AND dateline >= " . (TIMENOW - (intval(vbdate('G', TIMENOW)) * 3600) - (intval(vbdate('i', TIMENOW)) * 60)) . "
			) AS todaysposts,
			(
				SELECT COUNT(threadid)
				FROM " . TABLE_PREFIX . "thread 
				WHERE postuserid = " . $vbulletin->userinfo['userid'] . "
			) AS threads		
		");
		
		// Set the cache
		set_vbo_cache($vbulletin->userinfo['userid'] . '_cnt2', $counters2, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
	}
	
	if ($vbulletin->products['dbtech_vbactivity'])
	{
	
		$counters3 = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_cnt3');
		if ($counters3 === false)
		{
			$counters3['achievement'] = 0;
			$counters3['medal'] = 0;
			$counters3['trophy'] = 0;			
			$counters3_q = $db->query_read_slave("
				SELECT COUNT(featureid) AS num, feature
				FROM " . TABLE_PREFIX . "dbtech_vbactivity_rewards
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
				GROUP BY feature
			");
			while ($counters3_r = $db->fetch_array($counters3_q))
			{
				$counters3["$counters3_r[feature]"] = $counters3_r['num'];
			}
			
			foreach ((array)$vbactivity->cache['type'] as $typeid => $type)
			{
				if (!$type['active'] OR $type['userid'] != $vbulletin->userinfo['userid'])
				{
					// Gtfo
					continue;
				}
				$counters3['trophy']++;
			}
			
			// Set the cache
			set_vbo_cache($vbulletin->userinfo['userid'] . '_cnt3', $counters3, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));			
		}
	}
	
	// Merge counters
	$counters = $counters + $counters2;
	
	$topposter = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_toppst');
	if ($topposter === false)
	{
		$topposter = $db->query_first_slave("
			SELECT 
				posts,
				userid,
				username,
				usergroupid,
				infractiongroupid,
				displaygroupid
			FROM " . TABLE_PREFIX . "user
			WHERE 1=1
				$excludegroups
			ORDER BY posts DESC
			LIMIT 1
		");
		$topposter['lastupdate'] = TIMENOW;
		
		// fetch the markup-enabled username
		fetch_musername($topposter);
			
		if (intval($vbulletin->versionnumber) == 4)
		{
			// vB4 have SEO URLs
			$link = fetch_seo_url('member', $topposter);
		}
		else
		{
			// vB3 don't
			$link = "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$topposter[userid]";
		}
						
		// Store the link to the most active forum
		$topposter['link'] = '<a href="' . $link . '" target="_blank">' . $topposter['musername'] . '</a>';
		
		// Set the cache
		set_vbo_cache($vbulletin->userinfo['userid'] . '_toppst', $topposter, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
	}
	
	// Set the number of shouts
	$shouts = ($vbulletin->products['dbtech_vbshout'] ? $vbulletin->userinfo['dbtech_vbshout_shouts'] : false);
	
	if ($vbulletin->products['dbtech_vbactivity'])
	{
		// Set activity user info
		$activity = array(
			'points' 			=> $vbulletin->userinfo['dbtech_vbactivity_points'],
			'pointscache'		=> $vbulletin->userinfo['dbtech_vbactivity_pointscache'],
			'pointscache_day' 	=> $vbulletin->userinfo['dbtech_vbactivity_pointscache_day'],
			'pointscache_week' 	=> $vbulletin->userinfo['dbtech_vbactivity_pointscache_week'],
			'pointscache_month' => $vbulletin->userinfo['dbtech_vbactivity_pointscache_month']
		);
		
		// Fetch the activity level
		$vbactivity->fetch_activity_level($activity);
		$vbactivity->fetch_activity_rating($activity);
		
		// Merge the counters
		$activity = $activity + $counters3;
	}
	
	if (!function_exists('fetch_avatar_url'))
	{
		// Fetch the user file
		require_once(DIR . '/includes/functions_user.php');
	}
	
	// Ensure this is set
	$vbulletin->options['dbtech_infopanels_enabledstats'] = (isset($vbulletin->options['dbtech_infopanels_enabledstats']) ? $vbulletin->options['dbtech_infopanels_enabledstats'] : 16383);
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_panel');
		
		// Left side info
		$templater->register('avatar', 			fetch_avatar_url($vbulletin->userinfo['userid']));
		$templater->register('newposts', 		(int)$counters['newposts']);
		$templater->register('newthreads', 		(int)$counters['newthreads']);
		$templater->register('newblogs', 		(int)$counters['newblogs']);
		$templater->register('lastvisit', 		vbdate($vbulletin->options['timeformat'], $vbulletin->userinfo['lastvisit']) . ' ' . vbdate($vbulletin->options['dateformat'], $vbulletin->userinfo['lastvisit']));
		$templater->register('time', 			vbdate($vbulletin->options['timeformat'], TIMENOW));
		$templater->register('date', 			vbdate($vbulletin->options['dateformat'], TIMENOW));
		$templater->register('unreadpms', 		'<a href="private.php' . $vbulletin->session->vars['sessionurl_q'] . '" rel="nofollow">' . $vbulletin->userinfo['pmunread'] . '</a>');
		$templater->register('totalpms', 		$vbulletin->userinfo['pmtotal']);
		
		// Right side info
		$templater->register('posts', 			$vbulletin->userinfo['posts']);
		$templater->register('threads', 		(int)$counters['threads']);
		$templater->register('postsperday', 	$postsperday);
		$templater->register('todaysposts',		(int)$counters['todaysposts']);
		$templater->register('postpercent',		$postpercent);
		if (is_array($activeforum))
		{
			$templater->register('activeforum',		array(
				'link' 	=> $activeforum['link'],
				'posts' => $activeforum['numposts'],
			));
		}
		$templater->register('forumstats',		array(
			'members' 	=> $numbermembers,
			'threads' 	=> $totalthreads,
			'posts' 	=> $totalposts,
		));
		$templater->register('topposter',		$topposter);
		$templater->register('shouts',			$shouts);
		$templater->register('activity',		$activity);
	$infopanels['welcomepanel'] = $templater->render();	
}

if ($vbulletin->options['dbtech_infopanels_topxstats_enable'])
{
	// Create the info headers and blocks
	$infoheaders = $blocks = array();
	
	for ($i = 1; $i <= 3; $i++)
	{
		$templater = vB_Template::create('dbtech_infopanel_panel_header');
			$templater->register('i', $i);
		$infoheader["$i"] = $templater->render();
		
		if (!$vbulletin->userinfo['userid'])
		{
			// Set the block data
			$blocks["$i"] = $vbulletin->options['dbtech_infopanel_defaultblock_' . ($i - 1) . ''];
		}
		else
		{
			if (!is_array($vbulletin->userinfo['dbtech_infopanels_blocks']) OR !$vbulletin->userinfo['dbtech_infopanels_blocks']["$i"])
			{
				$blocks["$i"] = $vbulletin->options['dbtech_infopanel_defaultblock_' . ($i - 1) . ''];
			}
			else
			{
				// Set the block data
				$blocks["$i"] = $vbulletin->userinfo['dbtech_infopanels_blocks']["$i"];
			}
		}
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_topxstats');
		$templater->register('infoheader',		$infoheader);
		$templater->register('blocks',			$blocks);
	$infopanels['topxstats'] = $templater->render();
}

if ($vbulletin->options['dbtech_infopanels_autodeploy'] OR !isset($vbulletin->options['dbtech_infopanels_autodeploy']))
{
	if (intval($vbulletin->versionnumber) == 3)
	{
		// Ensure we're always first in line
		$ad_location['ad_navbar_below'] = implode('', $infopanels) . $ad_location['ad_navbar_below'];
	}
	else
	{
		// Ensure we're always first in line
		$ad_location['global_below_navbar'] = implode('', $infopanels) . $ad_location['global_below_navbar'];
	}
}
else
{
	// Register the template
	vB_Template::preRegister('FORUMHOME', array('infopanels' => $infopanels));
}

if ($vbulletin->options['dbtech_infopanels_legend_enable'])
{
	$staffgroups = array();
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		if (!($usergroup['genericoptions'] & $vbulletin->bf_ugp_genericoptions['showgroup']))
		{
			// This isn't a staff group
			continue;
		}
		
		if (!$usergroup['opentag'])
		{
			// Didn't have a colour
			continue;
		}
		
		// This is a staff group
		$staffgroups[] = $usergroup['opentag'] . $usergroup['title'] . $usergroup['closetag'];
	}
	
	if (!empty($staffgroups))
	{
		// We had at least 1 staff group with some form of colour
		$templater = vB_Template::create('dbtech_infopanel_stafflegend');
			$templater->register('staffgroups',		implode(' | ', $staffgroups));
		$activeusers .= $templater->render();
	}
}

if ($vbulletin->options['dbtech_infopanels_stats_enable'])
{
	// Begin list of averages
	$averages = array();	
	if (empty($vbulletin->dbtech_infopanels_forumstats_first))
	{
		// We need to re-cache this
		$vbulletin->dbtech_infopanels_forumstats_first = $db->query_first_slave("
			SELECT
			(SELECT joindate FROM " . TABLE_PREFIX . "user ORDER BY userid ASC LIMIT 1) AS members,
			(SELECT dateline FROM " . TABLE_PREFIX . "post ORDER BY postid ASC LIMIT 1) AS posts,
			(SELECT dateline FROM " . TABLE_PREFIX . "thread ORDER BY threadid ASC LIMIT 1) AS threads
		");
		build_datastore('dbtech_infopanels_forumstats_first', serialize($vbulletin->dbtech_infopanels_forumstats_first), 1);
	}
	
	$vbulletin->userstats['totalthreads'] = 0;
	$vbulletin->userstats['totalposts'] = 0;
	if (is_array($vbulletin->forumcache))
	{
		foreach ($vbulletin->forumcache AS $forum)
		{
			$vbulletin->userstats['totalthreads'] += $forum['threadcount'];
			$vbulletin->userstats['totalposts'] += $forum['replycount'];
		}
	}
	$vbulletin->userstats['totalmembers'] = $vbulletin->userstats['numbermembers'];
	
	foreach ($vbulletin->dbtech_infopanels_forumstats_first as $key => $val)
	{
		// Get the number of days since the first member / post / thread
		$difference = ((TIMENOW - $val) / 86400);
		$difference = round($difference >= 1 ? $difference : 1);
		
		// Find out our averages
		$averages["$key"]['day'] 	= round(($vbulletin->userstats["total{$key}"] / $difference), 2);
		$averages["$key"]['week'] 	= round(($vbulletin->userstats["total{$key}"] / ($difference / 7)), 2);
		$averages["$key"]['month'] 	= round(($vbulletin->userstats["total{$key}"] / ($difference / 30)), 2);
	}
	
	if ($vbulletin->products['dbtech_vbactivity'] OR $vbulletin->products['dbtech_vbshout'])
	{
		if (empty($vbulletin->dbtech_infopanels_forumstats_avg))
		{
			// We need to re-cache this
			build_infopanels_averages();
		}
		
		if ($vbulletin->products['dbtech_vbactivity'])
		{
			// For activity level calculation
			$activity = array('points' => $vbulletin->dbtech_infopanels_forumstats_avg['avgpoints']);
			$vbactivity->fetch_activity_level($activity);
			$vbulletin->dbtech_infopanels_forumstats_avg['avglevel'] = $activity['activitylevel'];
		}
		
		if ($vbulletin->products['dbtech_vbshout'])
		{
			// Fetch avg shouts
			$avgshouts = $db->query_first_slave("SELECT AVG(dbtech_vbshout_shouts) AS avgshouts FROM " . TABLE_PREFIX . "user");
			
			// For activity level calculation
			$vbulletin->dbtech_infopanels_forumstats_avg['avgshouts'] = round($avgshouts['avgshouts']);
		}		
		
		// Now add these entries
		$averages = $averages + $vbulletin->dbtech_infopanels_forumstats_avg;
	}
	
	if ($vbulletin->options['dbtech_infopanels_enable_averages'])
	{
		$templater = vB_Template::create('dbtech_infopanel_averages');
			$templater->register('averages', $averages);
		$template_hook['forumhome_wgo_stats'] .= $templater->render();
	}	
}
?>