<?php
if ($block == 'newestmember' AND $vbulletin->options['dbtech_infopanel_newestmember_enabled'])
{
	// Add New Posts
	$xml->add_tag('header' . $blockid, $vbphrase['dbtech_infopanel_newest_members']);
	
	if (!is_array($newestmembers))
	{
		$newestmembers = fetch_vbo_cache('newestmember');
		if ($newestmembers === false)
		{
			$newestmembers = array();
			$newestmembers_q = $db->query_read_slave("
				SELECT 
					joindate,
					userid,
					username,
					usergroupid,
					infractiongroupid,
					displaygroupid
				FROM " . TABLE_PREFIX . "user
				WHERE 1=1
					$excludegroups
				ORDER BY joindate DESC		
				LIMIT " . $vbulletin->options['dbtech_infopanel_limit']
			);
			while ($newestmembers_r = $db->fetch_array($newestmembers_q))
			{
				// Strip tags from username
				$newestmembers_r['fullusername'] = $newestmembers_r['username'] = strip_tags($newestmembers_r['username']);
				
				if ($vbulletin->options['dbtech_infopanel_trimusername'])
				{
					// Trim the username
					$newestmembers_r['username'] = fetch_trimmed_title($newestmembers_r['username'], $vbulletin->options['dbtech_infopanel_trimusername']);
				}
				
				// Fetch coloured username
				$newestmembers_r['musername'] = fetch_musername($newestmembers_r);
				
				// Restore username for SEO Link purposes
				$newestmembers_r['username'] = $newestmembers_r['fullusername'];

				// Date formatting
				$newestmembers_r['joindate'] = vbdate($vbulletin->options['dbtech_infopanel_dateformat'], $newestmembers_r['joindate']);
				
				// Store this
				$newestmembers[] = $newestmembers_r;
			}
			$db->free_result($newestmembers_q);
			unset($newestmembers_r);
			
			// Set the cache
			set_vbo_cache('newestmember', $newestmembers, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
		}
	}
	
	$bit = '';
	foreach ($newestmembers as $post)
	{
		$templater = vB_Template::create('dbtech_infopanel_block_newestmember_bit');
			$templater->register('post', $post);
		$bit .= $templater->render();
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_block_newestmember');
		$templater->register('bit', $bit);
	
	// Add New Posts
	$xml->add_tag('block' . $blockid, $templater->render());
}
?>