<?php
if ($block == 'topposter' AND $vbulletin->options['dbtech_infopanel_topposter_enabled'])
{
	// Add New Posts
	$xml->add_tag('header' . $blockid, $vbphrase['dbtech_infopanel_top_posters']);
	
	if (!is_array($topposters))
	{
		$topposters = fetch_vbo_cache('topposters');
		if ($topposters === false)
		{
			$topposters = array();
			$topposters_q = $db->query_read_slave("
				SELECT 
					posts,
					userid,
					username,
					usergroupid,
					infractiongroupid,
					displaygroupid
				FROM " . TABLE_PREFIX . "user
				WHERE 1=1
					$excludegroups
				ORDER BY posts DESC		
				LIMIT " . $vbulletin->options['dbtech_infopanel_limit']
			);
			while ($topposters_r = $db->fetch_array($topposters_q))
			{
				// Strip tags from username
				$topposters_r['fullusername'] = $topposters_r['username'] = strip_tags($topposters_r['username']);
				
				if ($vbulletin->options['dbtech_infopanel_trimusername'])
				{
					// Trim the username
					$topposters_r['username'] = fetch_trimmed_title($topposters_r['username'], $vbulletin->options['dbtech_infopanel_trimusername']);
				}
				
				// Fetch coloured username
				$topposters_r['musername'] = fetch_musername($topposters_r);
				
				// Restore username for SEO Link purposes
				$topposters_r['username'] = $topposters_r['fullusername'];

				// Number formatting
				$topposters_r['posts'] = vb_number_format($topposters_r['posts']);
				
				// Store this
				$topposters[] = $topposters_r;
			}
			$db->free_result($topposters_q);
			unset($topposters_r);

			// Set the cache
			set_vbo_cache('topposters', $topposters, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
		}
	}
	
	$bit = '';
	foreach ($topposters as $post)
	{
		$templater = vB_Template::create('dbtech_infopanel_block_topposter_bit');
			$templater->register('post', $post);
		$bit .= $templater->render();
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_block_topposter');
		$templater->register('bit', $bit);
	
	// Add New Posts
	$xml->add_tag('block' . $blockid, $templater->render());
}
?>