<?PHP

##################
##  HTTP Class  ##
#############################################
##  http.php - class to perform HTTP GETs  ##
#############################################


class HTTP
{
    var $Host;
    var $Port;
    var $URI;
    var $URL;
    var $Status;
    var $Code;
    var $Sock;
    var $Errno;
    var $Errstr;
    var $Headers;
    var $Data;
    var $Location;
    var $Redirects;



    function HTTP( $url )
    {
        $this->URL       = $url;
        $this->Redirects = 0;
    }



    function GET()
    {
        if( !$this->parseURL() )
        {
            return 0;
        }

        if( !$this->connect() )
        {
            return 0;
        }

        fputs($this->Sock, "GET $this->URI HTTP/1.0\r\nHost: $this->Host\r\nUser-Agent: HTTPLib/1.0\r\nConnection: close\r\n\r\n");

        while( $line = fgets($this->Sock, 1024) )
        {
            if( preg_match('|^\s+$|', $line) )
            {
                break;
            }
            else
            {
                $this->Headers .= $line;
            }
        }


        while( $line = fread($this->Sock, 1024) )
        {
            $this->Data .= $line;
        }


        $this->disconnect();
        $this->parseHeaders();


        // Bad response code
        if( $this->Code >= 400 )
        {
            $this->Errstr = $this->Status;
            return 0;
        }


        // Redirected
        else if( $this->Code >= 300 )
        {
            $this->Redirects++;

            if( $this->Redirects > 3 )
            {
                $this->Errstr = 'Excessive URL redirection';
                return 0;
            }
            else
            {
                if( $this->Location )
                {
                    $this->SetRedir();
                    return $this->GET();
                }
                else
                {
                    $this->Errstr = $this->Status;
                    return 0;
                }
            }
        }

        // Good response code
        else
        {
            return 1;
        }
    }



    function OutputData( $file = 0 )
    {
        if( $file )
        {
            fileWrite($file, $this->Data);
        }
        else
        {
            print $this->Data;
        }

    }



    function GetHeaders()
    {
        return $this->Headers;
    }



    function GetLastError()
    {
        return $this->Errstr;
    }



    function SetRedir()
    {
        if( !preg_match('|^http://|', $this->Location) )
        {
            $this->URL .= '/' . $this->Location;
        }
        else
        {
            $this->URL = $this->Location;
        }

        unset($this->Headers, $this->Data, $this->Errstr);
    }



    function NewURL($url)
    {
        $this->URL       = $url;
        $this->Redirects = 0;

        unset($this->Headers, $this->Data, $this->Errstr);
    }



    function parseHeaders()
    {
        $this->Code = substr($this->Headers, 9, 3);

        preg_match('|^HTTP/\d\.\d (.*)$|m', $this->Headers, $matches);
        
        $this->Status = chop($matches[1]);

        preg_match('|^Location:\s+(.*)$|m', $this->Headers, $matches);

        $this->Location = chop($matches[1]);
    }



    function parseURL()
    {
        preg_match('|http://([^:/]+):?(\d+)*(/?.*)|i', $this->URL, $matches);

        if( $matches[1] )
        {
            $this->Host = $matches[1];
            $this->Port = $matches[2] ? $matches[2] : 80;
            $this->URI  = $matches[3] ? $matches[3] : '/';

            return 1;
        }
        else
        {
            $this->Errstr = 'The supplied value is not a valid URL.';
            return 0;
        }
    }



    function connect()
    {
        $ipaddr = gethostbyname($this->Host);

        if( $ipaddr == $this->Host )
        {
            $this->Errstr = "Could not resolve $this->Host";
            return 0;
        }

        $this->Sock = fsockopen($ipaddr, $this->Port, $this->Errno, $this->Errstr, 30);

        if( !$this->Sock )
        {
            return 0;
        }
        else
        {
            return 1;
        }
    }



    function disconnect()
    {
        if( $this->Sock )
        {
            fclose($this->Sock);
            unset($this->Sock);
        }
    }
}

?>