<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  sort.php - SQL queries for sorting members               ##
###############################################################


$time = time();

$sort_name   = array (
                  'currentIn'     => 'Hits In Since Last Reset',
                  'currentOut'    => 'Hits Out Since Last Reset',
                  'totalIn'       => 'Total Hits In',
                  'totalOut'      => 'Total Hits Out',
                  'inPerDay'      => 'Average Hits In/Day',
                  'inPerWeek'     => 'Average Hits In/Week',
                  'inPerMonth'    => 'Average Hits In/Month',
                  'outPerDay'     => 'Average Hits Out/Day',
                  'outPerWeek'    => 'Average Hits Out/Week',
                  'outPerMonth'   => 'Average Hits Out/Month',
                  'totalRatings'  => 'Number of Ratings',
                  'averageRating' => 'Average Rating',
                  'signupDate'    => 'Signup Date',
                  'username'      => 'Username',
                  'inactivity'    => 'Inactivity'
               );


$sort_string = array (
                  'currentIn'     => "ROUND(Current_In * Ratio)",
                  'currentOut'    => "Current_Out",
                  'totalIn'       => "ROUND(Total_In * Ratio)",
                  'totalOut'      => "Total_Out",
                  'inPerDay'      => "IF(($time - Reset) > 86400, ((Total_In * Ratio) / (($time - Reset) / 86400)), (Total_In * Ratio))",
                  'inPerWeek'     => "IF(($time - Reset) > 604800, ((Total_In * Ratio) / (($time - Reset) / 604800)), (Total_In * Ratio))",
                  'inPerMonth'    => "IF(($time - Reset) > 2592000, ((Total_In * Ratio) / (($time - Reset) / 2592000)), (Total_In * Ratio))",
                  'outPerDay'     => "IF(($time - Reset) > 86400, (Total_Out / (($time - Reset) / 86400)), Total_Out)",
                  'outPerWeek'    => "IF(($time - Reset) > 604800, (Total_Out / (($time - Reset) / 604800)), Total_Out)",
                  'outPerMonth'   => "IF(($time - Reset) > 2592000, (Total_Out / (($time - Reset) / 2592000)), Total_Out)",
                  'totalRatings'  => "Num_Ratings",
                  'averageRating' => "IF(Num_Ratings > 0, (Rating_Total/Num_Ratings), 0)",
                  'signupDate'    => "Signup_Time",
                  'username'      => "a_Accounts.Username",
                  'inactivity'    => "Inactive",
               );


$sorter = $sort_string[$GLOBALS['SORT_METHOD']];


if( !emptyString($GLOBALS['SORT_STRING']) )
{
    $custom = ", {$GLOBALS['SORT_STRING']}";
}


$adminRanks = 'SELECT ' .
                  'a_Accounts.*, ' .
                  'a_Hits.*, ' .
                  'a_Ratings.*, ' .
                  '#%SORTER%# AS Sort_Value ' .
              'FROM ' .
                  'a_Accounts, ' .
                  'a_Hits, ' .
                  'a_Ratings ' .
              'WHERE ' .
                  'a_Accounts.Username = a_Hits.Username AND ' .
                  'a_Ratings.Username  = a_Hits.Username AND ' .
                  'Approved  =  1 AND ' .
                  'Confirmed =  1 ' .
                  '#%CATEGORY%#' .
              'ORDER BY ' .
                  'Sort_Value #%DESC%# ' .
              '#%LIMIT%#';


$fullRanks =  "INSERT INTO " .
                  "a_Ranks " .
              "SELECT " .
                  "a_Accounts.Username, " .
                  "@rank:=@rank+1, " .
                  "NULL, " .
                  "$sorter AS Sort_Value, " .
                  "Current_In, " .
                  "Current_Out, " .
                  "Total_In, " .
                  "Total_Out, " .
                  "Prev_In, " .
                  "Prev_Out, " .
                  "Prev_Sort, " .
                  "Prev_ORank, " .
                  "Prev_CRank, " .
                  "Inactive, " .
                  "Num_Ratings, " .
                  "Rating_Total, " .
                  "Site_URL, " .
                  "Banner_URL, " .
                  "Banner_Height, " .
                  "Banner_Width, " .
                  "Site_Title, " .
                  "Description, " .
                  "Category, " .
                  "Icons, " .
                  "Signup_Time, " .
                  "Ratio, " .
                  "Reset, " .
                  "Field_1, " .
                  "Field_2, " .
                  "Field_3 " .
              "FROM " .
                  "a_Accounts, " .
                  "a_Hits, " .
                  "a_Ratings " .
              "WHERE " .
                  "a_Accounts.Username = a_Hits.Username AND " .
                  "a_Ratings.Username  = a_Hits.Username AND " .
                  "Suspended =  0                        AND " .
                  "Approved  =  1                        AND " .
                  "Confirmed =  1 " .
              "ORDER BY " .
                  "Sort_Value DESC $custom";



$quickRanks = 'INSERT INTO ' .
                  'a_QuickRanks ' .
              'SELECT ' .
                  'Username,' .
                  'Overall_Rank,' .
                  'Category_Rank ' .
              'FROM ' .
                  'a_Ranks';


$memStats   = 'INSERT INTO ' .
                   'a_MemStats ' .
              'SELECT ' .
                   'Username, ' .
                   'UNIX_TIMESTAMP(), ' .
                   'Current_In, ' .
                   'Current_Out, ' .
                   'Total_In, ' .
                   'Total_Out, ' .
                   'Overall_Rank, ' .
                   'Category_Rank, ' .
                   'Ratio ' .
              'FROM ' .
                   'a_Ranks';


$memHits =    'REPLACE INTO ' .
                   'a_Hits ' .
              'SELECT ' .
                   'Username, ' .
                   '0, ' .
                   '0, ' .
                   'Total_In, ' .
                   'Total_Out, ' .
                   'Current_In, ' .
                   'Current_Out, ' .
                   'Sort_Value, ' .
                   'Overall_Rank, ' .
                   'Category_Rank, ' .
                   'IF( Current_In=0, Inactive+1, 0 ) ' .
              'FROM ' .
                   'a_Ranks';


$adminStats = 'INSERT INTO ' .
                   'a_AdminStats ' .
              'SELECT ' .
                  'UNIX_TIMESTAMP(), ' .
                  '#%PERIOD%#, ' .
                  'SUM(Prev_In), ' .
                  'SUM(Prev_Out), ' .
                  'SUM(IF(Inactive=0, 1, 0)), ' .
                  '"#%TOP%#" ' .
               'FROM ' .
                   'a_Hits';



function getSortValue(&$member, &$sorter)
{
    getAverages($average, $member);

    switch($sorter)
    {
        case 'currentIn':
            $value = numFormat(round($member['Current_In'] * $member['Ratio']));
            break;

        case 'currentOut':
            $value = numFormat($member['Current_Out']);
            break;

        case 'totalIn':
            $value = numFormat(round($member['Total_In'] * $member['Ratio']));
            break;

        case 'totalOut':
            $value = numFormat($member['Total_Out']);
            break;

        case 'inPerDay':
            $value = $average['IN_PER_DAY'];
            break;

        case 'inPerWeek':
            $value = $average['IN_PER_WEEK'];
            break;

        case 'inPerMonth':
            $value = $average['IN_PER_MONTH'];
            break;

        case 'outPerDay':
            $value = $average['OUT_PER_DAY'];
            break;

        case 'outPerWeek':
            $value = $average['OUT_PER_WEEK'];
            break;

        case 'outPerMonth':
            $value = $average['OUT_PER_MONTH'];
            break;

        case 'averageRating':
            $value = $average['RATING'];
            break;

        case 'totalRatings':
            $value = numFormat($member['Num_Ratings']);
            break;

        case 'username':
            $value = $member['Username'];
            break;

        case 'signupDate':
            $value = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $member['Signup_Time']);
            break;

        case 'inactivity':
            $value = numFormat($member['Inactive']);
            break;
    }

    return $value;
}


?>