<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.0 Build 9                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2004 Belchior Foundry                   //
//***************************************************************************//
/********************************************************************
Template: inspirated in (phplib)
********************************************************************/
define('CARDLAYOUT_INC',true);
class Template
{
	var $debug = false;
	var $root = '.';
	var $_file = array();
	var $_var_keys = array();
	var $_var_values = array();
	
	function Template($root='.') {
		$this->root = !empty($root)? (substr($root,-1)=='/')? $root : $root.'/' : './';;
	}
	
	function set_file($handle,$file_name='') {
		if (!is_array($handle))
		{
			if (empty($file_name))
			{
				$this->_stop("set_file(): $handle is empty.");
				return false;
			}
			$this->_file[$handle] = $this->_make_filename($file_name);
		} else {
			foreach ($handle as $ar_handle => $ar_file)
			{
				$this->_file[$ar_handle] = $this->_make_filename($ar_file);
			}
			
		}
	}
	
	function set_var($var_name, $value='') {
		if (is_array($var_name))
		{
			reset($var_name);
			foreach ($var_name as $key=>$val)
			{
				if (!empty($key))
				{
					if ($this->debug) print "array: set *$key* to *$val*<br>\n";
					$this->_var_keys[$key] = "/".$this->_quote_var($key)."/";
					$this->_var_values[$key] = $val;
				}
			}
		} else {
			if ($this->debug) print "set *$var_name* to *$value* <br>\n";
			$this->_var_keys[$var_name]= '/'.$this->_quote_var($var_name).'/';
			$this->_var_values[$var_name]= $value;
		}
	}
	
	function parse($target, $handle, $append = false) {
		if (!is_array($handle))
		{
			$str = $this->_get_replaced_vars($handle);
			($append)? $this->set_var($target, $this->_get_var($target) . $str) : $this->set_var($target, $str);
		} else {
			foreach ($handle as $ar_i => $ar_h)
			{
				$str = $this->_get_replaced_vars($ar_h);
				$this->set_var($target, $str);
			}
		}
		return $str;
	}
	
	function pparse($target, $handle, $append = false) {
		print $this->parse($target, $handle, $append);
		return false;
	}
	
	function p($var_name) {
		print $this->_remove_undefined_vars($this->_get_var($var_name));
	}
	
	function getcard($var_name) {
		return $this->_remove_undefined_vars($this->_get_var($var_name));
	}
	/* private functions */
	function _get_var($var_name) {
		if (!is_array($var_name))
		{
			return $this->_var_values[$var_name];
		} else {
			foreach ($var_name as $ar_key => $ar_value)
			{
				$result[$ar_key] = $this->_var_values[$ar_key];
			}
			return $result;
		}
	}
	
	function _remove_undefined_vars($str) {
		$str = preg_replace('/{[^ \t\r\n}]+}/','', $str);
		return $str;
	}
	
	function _get_replaced_vars($handle) {
		if (!$this->_get_template($handle))
		{
			$this->_stop("_get_replaced_vars(): unable to load $handle.");
			return false;
		}
		$str = $this->_get_var($handle);
		if ($this->debug){ print "_get_replaced_vars($handle) => $str<br>\n".print_r($this->_var_keys); }
		$str = @preg_replace($this->_var_keys, $this->_var_values, $str);
		return $str;
	}
	
	function _get($var_name) {
		return $this->_remove_undefined_vars($this->_get_var($var_name));
	}
	
	function _make_filename($file_name) {
		if (substr($file_name,0,1) !='/') // first word != '/'
		{
			$file_name = $this->root . $file_name;
		}
		if (!file_exists($file_name))
		{
			$this->_stop("_make_filename(): file $file_name does not exist.");
		}
		return $file_name;
	}
	
	function _quote_var($var_name) {
		return preg_quote('{'.$var_name.'}');
	}
	
	function _get_template($handle) {
		if (isset($this->_var_keys[$handle]) and !empty($this->_var_values[$handle]))
			return true;
			if (!isset($this->_file[$handle]))
			{
				$this->_stop("_get_template(): $handle is not a valid handle.");
				return false;
			}
			$file_name = $this->_file[$handle];
			//$str = implode("", @file($file_name));
			$str = fread($fp = fopen($file_name, 'r'), filesize($file_name));
			if (empty($str))
			{
				$this->_stop("_get_template)_: While loading $handle, $file_name does not exist or is empty.");
				return false;
			}
			$this->set_var($handle, $str);
			return true;
	}
	
	function _stop($msg) {
		$this->last_error = $msg;
		printf("<b>Card Layout Template Error:</b> %s<br>\n", $msg);
		die();
		return false;
	}
}
?>