#
# Table structure for table `vcard_abook`
#

CREATE TABLE vcard_abook (
  ab_id int(10) unsigned NOT NULL auto_increment,
  ab_username varchar(60) NOT NULL default '',
  ab_realname varchar(50) NOT NULL default '0',
  ab_email varchar(60) NOT NULL default '',
  ab_date date NOT NULL default '0000-00-00',
  ab_password varchar(32) NOT NULL default '',
  PRIMARY KEY  (ab_id),
  KEY ab_email (ab_email),
  KEY ab_username (ab_username)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_account`
#

CREATE TABLE vcard_account (
  account_id smallint(6) unsigned NOT NULL auto_increment,
  account_username varchar(50) NOT NULL default '',
  account_password varchar(50) NOT NULL default '',
  superuser tinyint(2) unsigned NOT NULL default '0',
  canworkcategory smallint(6) unsigned NOT NULL default '0',
  canaddcard tinyint(3) unsigned NOT NULL default '0',
  caneditcard tinyint(3) unsigned NOT NULL default '0',
  candeletecard tinyint(3) unsigned NOT NULL default '0',
  canaddmusic tinyint(3) unsigned NOT NULL default '0',
  caneditmusic tinyint(3) unsigned NOT NULL default '0',
  candeletemusic tinyint(3) unsigned NOT NULL default '0',
  canaddpattern tinyint(3) unsigned NOT NULL default '0',
  caneditpattern tinyint(3) unsigned NOT NULL default '0',
  candeletepattern tinyint(3) unsigned NOT NULL default '0',
  canaddpoem tinyint(3) unsigned NOT NULL default '0',
  caneditpoem tinyint(3) unsigned NOT NULL default '0',
  candeletepoem tinyint(3) unsigned NOT NULL default '0',
  canaddeffect tinyint(3) unsigned NOT NULL default '0',
  canediteffect tinyint(3) unsigned NOT NULL default '0',
  candeleteeffect tinyint(3) unsigned NOT NULL default '0',
  canaddevent tinyint(3) unsigned NOT NULL default '0',
  caneditevent tinyint(3) unsigned NOT NULL default '0',
  candeleteevent tinyint(3) unsigned NOT NULL default '0',
  canaddstamp tinyint(3) unsigned NOT NULL default '0',
  caneditstamp tinyint(3) unsigned NOT NULL default '0',
  candeletestamp tinyint(3) unsigned NOT NULL default '0',
  canaddreplace tinyint(3) unsigned NOT NULL default '0',
  caneditreplace tinyint(3) unsigned NOT NULL default '0',
  canviewcontrol tinyint(3) unsigned NOT NULL default '0',
  canviewoptions tinyint(3) unsigned NOT NULL default '0',
  canedittemplate tinyint(3) unsigned NOT NULL default '0',
  canviewsearch tinyint(3) unsigned NOT NULL default '0',
  canviewstyle tinyint(3) unsigned NOT NULL default '0',
  canviewstats tinyint(3) unsigned NOT NULL default '0',
  canviewemailog tinyint(3) unsigned NOT NULL default '0',
  canviewphpinfo tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (account_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_address`
#

CREATE TABLE vcard_address (
  addr_id int(10) unsigned NOT NULL auto_increment,
  ab_id int(10) unsigned NOT NULL default '0',
  addr_name varchar(50) NOT NULL default '',
  addr_email varchar(60) NOT NULL default '',
  KEY addr_id (addr_id),
  KEY ab_id (ab_id),
  KEY addr_name (addr_name),
  KEY addr_email (addr_email)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_assoc_evcatcard`
#

CREATE TABLE vcard_assoc_evcatcard (
  event_id int(11) unsigned NOT NULL default '0',
  card_id int(11) unsigned NOT NULL default '0',
  cat_id int(11) unsigned NOT NULL default '0',
  KEY event_id (event_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_attach`
#

CREATE TABLE vcard_attach (
  attach_id int(10) unsigned NOT NULL auto_increment,
  messageid varchar(25) NOT NULL default '',
  time datetime NOT NULL default '0000-00-00 00:00:00',
  filedata mediumtext NOT NULL,
  filename varchar(100) NOT NULL default '',
  filesize varchar(50) NOT NULL default '',
  ip varchar(25) NOT NULL default '',
  status varchar(10) NOT NULL default 'incomplete',
  PRIMARY KEY  (attach_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_cache`
#

CREATE TABLE vcard_cache (
  title varchar(100) NOT NULL default '',
  content mediumtext NOT NULL,
  date int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (title),
  KEY date (date)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_cards`
#

CREATE TABLE vcard_cards (
  card_id int(10) unsigned NOT NULL auto_increment,
  cat_id int(10) unsigned NOT NULL default '0',
  card_group smallint(4) NOT NULL default '0',
  card_rating varchar(5) NOT NULL default '0',
  card_votes int(11) NOT NULL default '0',
  card_nvotes int(11) NOT NULL default '0',
  card_imgfile varchar(200) NOT NULL default '',
  card_thmfile varchar(200) NOT NULL default '',
  card_width int(4) NOT NULL default '0',
  card_height int(4) NOT NULL default '0',
  card_template varchar(30) NOT NULL default '',
  card_date date NOT NULL default '0000-00-00',
  card_caption varchar(200) NOT NULL default '',
  card_keywords varchar(200) NOT NULL default '',
  card_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (card_id),
  KEY card_date (card_date),
  KEY cat_id (cat_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_cardsgroup`
#

CREATE TABLE vcard_cardsgroup (
  cardsgroup_id int(4) unsigned NOT NULL auto_increment,
  cardsgroup_name varchar(100) NOT NULL default '',
  cardsgroup_fontface smallint(6) NOT NULL default '0',
  cardsgroup_fontcolor smallint(6) NOT NULL default '0',
  cardsgroup_fontsize smallint(6) NOT NULL default '0',
  cardsgroup_cardcolor smallint(6) NOT NULL default '0',
  cardsgroup_background smallint(6) NOT NULL default '0',
  cardsgroup_poem smallint(6) NOT NULL default '0',
  cardsgroup_effect smallint(6) NOT NULL default '0',
  cardsgroup_advancedate smallint(6) NOT NULL default '0',
  cardsgroup_stamp smallint(6) NOT NULL default '0',
  cardsgroup_music smallint(6) NOT NULL default '0',
  cardsgroup_notify smallint(6) NOT NULL default '0',
  cardsgroup_copy smallint(6) NOT NULL default '0',
  cardsgroup_layout smallint(6) NOT NULL default '0',
  cardsgroup_heading smallint(6) NOT NULL default '0',
  cardsgroup_signature smallint(6) NOT NULL default '0',
  PRIMARY KEY  (cardsgroup_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_category`
#

CREATE TABLE vcard_category (
  cat_id int(10) NOT NULL auto_increment,
  cat_subid int(10) default NULL,
  cat_order varchar(10) NOT NULL default '0',
  cat_name varchar(110) NOT NULL default '',
  cat_img varchar(150) NOT NULL default '',
  cat_link tinyint(1) NOT NULL default '0',
  cat_header mediumtext NOT NULL,
  cat_footer mediumtext NOT NULL,
  cat_sort tinyint(4) NOT NULL default '0',
  cat_ncards int(10) unsigned NOT NULL default '0',
  cat_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (cat_id),
  KEY cat_order (cat_order),
  KEY cat_active (cat_active)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_effect`
#

CREATE TABLE vcard_effect (
  effect_id int(10) unsigned NOT NULL auto_increment,
  effect_title varchar(100) NOT NULL default '',
  effect_text mediumtext NOT NULL,
  effect_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (effect_id),
  KEY effect_title (effect_title)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_emaillog`
#

CREATE TABLE vcard_emaillog (
  emaillogid int(20) NOT NULL auto_increment,
  date datetime NOT NULL default '0000-00-00 00:00:00',
  email varchar(60) NOT NULL default '',
  name varchar(60) NOT NULL default '',
  PRIMARY KEY  (emaillogid),
  KEY email (email)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_event`
#

CREATE TABLE vcard_event (
  event_id int(10) unsigned NOT NULL auto_increment,
  event_day varchar(10) NOT NULL default '',
  event_dayend varchar(10) NOT NULL default '',
  event_month varchar(10) NOT NULL default '',
  event_name varchar(110) NOT NULL default '',
  event_active tinyint(2) NOT NULL default '1',
  PRIMARY KEY  (event_id),
  KEY event_month (event_month)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_pattern`
#

CREATE TABLE vcard_pattern (
  pattern_id int(10) unsigned NOT NULL auto_increment,
  pattern_file varchar(120) NOT NULL default '',
  pattern_name varchar(50) NOT NULL default '',
  pattern_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (pattern_id),
  KEY pattern_name (pattern_name)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_poem`
#

CREATE TABLE vcard_poem (
  poem_id int(10) unsigned NOT NULL auto_increment,
  cat_id int(10) unsigned NOT NULL default '0',
  poem_title varchar(100) NOT NULL default '',
  poem_text mediumtext NOT NULL,
  poem_active tinyint(2) NOT NULL default '1',
  poem_style tinyint(2) NOT NULL default '0',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (poem_id),
  KEY poem_title (poem_title),
  KEY cat_id (cat_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_rating`
#

CREATE TABLE vcard_rating (
  rating_card int(10) unsigned NOT NULL default '0',
  rating_value tinyint(4) NOT NULL default '0',
  rating_ip varchar(50) NOT NULL default '',
  rating_date date NOT NULL default '0000-00-00'
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_replace`
#

CREATE TABLE vcard_replace (
  replace_id smallint(5) unsigned NOT NULL auto_increment,
  findword text NOT NULL,
  replaceword text NOT NULL,
  KEY replace_id (replace_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_search`
#

CREATE TABLE vcard_search (
  word_id int(10) unsigned NOT NULL default '0',
  card_id int(10) unsigned NOT NULL default '0',
  cat_id int(10) unsigned NOT NULL default '0',
  KEY word_id (word_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_searchlog`
#

CREATE TABLE vcard_searchlog (
  search_date datetime NOT NULL default '0000-00-00 00:00:00',
  search_word varchar(50) NOT NULL default '',
  KEY search_date (search_date),
  KEY search_word (search_word)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_session`
#

CREATE TABLE vcard_session (
  session_id varchar(60) NOT NULL default '',
  session_user tinyint(3) unsigned NOT NULL default '0',
  session_ip varchar(60) NOT NULL default '',
  session_agent varchar(60) NOT NULL default '',
  session_date int(12) NOT NULL default '0',
  PRIMARY KEY  (session_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_setting`
#

CREATE TABLE vcard_setting (
  setting_id smallint(5) unsigned NOT NULL auto_increment,
  settinggroup_id smallint(5) unsigned NOT NULL default '0',
  varname varchar(100) NOT NULL default '',
  value mediumtext NOT NULL,
  optioncode mediumtext NOT NULL,
  displayorder smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (setting_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_settinggroup`
#

CREATE TABLE vcard_settinggroup (
  settinggroup_id smallint(5) unsigned NOT NULL auto_increment,
  varname char(100) NOT NULL default '',
  displayorder smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (settinggroup_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_sound`
#

CREATE TABLE vcard_sound (
  sound_id int(10) unsigned NOT NULL auto_increment,
  cat_id int(10) unsigned NOT NULL default '0',
  sound_file varchar(250) NOT NULL default '',
  sound_name varchar(150) NOT NULL default '',
  sound_author varchar(150) NOT NULL default '',
  sound_genre varchar(150) NOT NULL default '',
  sound_order tinyint(4) NOT NULL default '0',
  sound_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (sound_id),
  KEY sound_name (sound_name),
  KEY cat_id (cat_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_spam`
#

CREATE TABLE vcard_spam (
  id bigint(20) NOT NULL auto_increment,
  ip varchar(50) NOT NULL default '',
  date int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY ip (ip),
  KEY date (date)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_stamp`
#

CREATE TABLE vcard_stamp (
  stamp_id int(10) unsigned NOT NULL auto_increment,
  stamp_file varchar(120) NOT NULL default '',
  stamp_name varchar(50) NOT NULL default '',
  stamp_active tinyint(2) NOT NULL default '1',
  hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stamp_id),
  KEY stamp_name (stamp_name)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_stats`
#

CREATE TABLE vcard_stats (
  date datetime NOT NULL default '0000-00-00 00:00:00',
  card_id int(10) NOT NULL default '0',
  card_template varchar(30) NOT NULL default '',
  KEY date (date),
  KEY card_id (card_id),
  KEY card_template (card_template)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_statsextfile`
#

CREATE TABLE vcard_statsextfile (
  extfile_id int(11) unsigned NOT NULL auto_increment,
  extfile_file varchar(150) NOT NULL default '',
  extfile_date date NOT NULL default '0000-00-00',
  PRIMARY KEY  (extfile_id),
  KEY extfile_file (extfile_file)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_template`
#

CREATE TABLE vcard_template (
  title varchar(100) NOT NULL default '',
  parent varchar(50) NOT NULL default '',
  template mediumtext NOT NULL,
  UNIQUE KEY title (title)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_template_o`
#

CREATE TABLE vcard_template_o (
  title varchar(100) NOT NULL default '',
  parent varchar(50) NOT NULL default '',
  template mediumtext NOT NULL,
  UNIQUE KEY title (title)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_user`
#

CREATE TABLE vcard_user (
  card_date datetime NOT NULL default '0000-00-00 00:00:00',
  sender_name varchar(60) NOT NULL default '',
  sender_email varchar(60) NOT NULL default '',
  sender_ip varchar(25) NOT NULL default '',
  recip_name varchar(60) NOT NULL default '',
  recip_email varchar(60) NOT NULL default '',
  card_file varchar(150) NOT NULL default '',
  card_stamp varchar(150) NOT NULL default '',
  card_sound varchar(150) NOT NULL default '',
  card_poem int(10) NOT NULL default '0',
  card_effect int(10) NOT NULL default '0',
  card_heading varchar(110) NOT NULL default '',
  card_id varchar(20) NOT NULL default '',
  card_message blob NOT NULL,
  card_sig varchar(60) NOT NULL default '',
  card_background varchar(150) NOT NULL default '',
  card_color varchar(30) NOT NULL default '',
  card_template varchar(30) NOT NULL default '',
  card_fontface varchar(30) NOT NULL default '',
  card_fontcolor varchar(30) NOT NULL default '',
  card_fontsize varchar(10) NOT NULL default '',
  message_id varchar(25) NOT NULL default '',
  card_read tinyint(2) NOT NULL default '0',
  card_notify varchar(10) NOT NULL default '',
  card_tosend varchar(12) NOT NULL default '',
  card_sent varchar(10) NOT NULL default '',
  PRIMARY KEY  (message_id),
  KEY card_tosend (card_tosend),
  KEY card_sent (card_sent)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_useronline`
#

CREATE TABLE vcard_useronline (
  timestamp int(15) NOT NULL default '0',
  ip varchar(40) NOT NULL default '',
  file varchar(100) NOT NULL default '',
  KEY timestamp (timestamp),
  KEY ip (ip),
  KEY file (file)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `vcard_word`
#

CREATE TABLE vcard_word (
  word_id int(10) unsigned NOT NULL auto_increment,
  word_str char(60) NOT NULL default '',
  PRIMARY KEY  (word_id),
  UNIQUE KEY word_str (word_str)
) TYPE=MyISAM;

