<?php

/*
+--------------------------------------------------------------------------
|   Invision Gallery v<{%dyn.down.var.human.version%}>
|   =============================================
|   by Adam Kinder
|   (c) 2001 - 2005 Invision Power Services, Inc.
|   Nullified by DGT
|   =============================================
|   
|   
|   
+--------------------------------------------------------------------------
|
|   > Setup script
|   > Script written by Remco Wilting
|   > Gallery additions by Adam Kinder
|   > Date started: 6st September 2004
|   > Module version: 1.0.001
|
+--------------------------------------------------------------------------
*/

//-----------------------------------------------
// USER CONFIGURABLE ELEMENTS
//-----------------------------------------------

define( 'THIS_PATH'  , './'  );
define( 'ROOT_PATH'  , "../" );
define( 'KERNEL_PATH', ROOT_PATH.'ips_kernel/' );
define( 'CACHE_PATH' , ROOT_PATH );

//-----------------------------------------------
// NO USER EDITABLE SECTIONS BELOW
//-----------------------------------------------

define ( 'IN_ACP', 0 );
define ( 'IN_IPB', 0 );
define ( 'IN_DEV', 0 );
define ( 'SAFE_MODE_ON', 0 );
define ( 'USE_SHUTDOWN', 0 );
define ( 'IPB_THIS_SCRIPT', 'admin' );

error_reporting  (E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);

//===========================================================================
// MAIN PROGRAM
//===========================================================================

//--------------------------------
// Import $INFO, now!
//--------------------------------

$INFO = array();

//--------------------------------
// Load our classes
//--------------------------------

require ROOT_PATH   . "sources/ipsclass.php";
require KERNEL_PATH . "class_converge.php";
require ROOT_PATH   . "conf_global.php";

# Initiate super-class
$ipsclass       = new ipsclass();
$ipsclass->vars = $INFO;

//--------------------------------
// Load the DB driver and such
//--------------------------------

$ipsclass->init_db_connection();

require THIS_PATH	. "core/template.php";
$ipsclass->template = new template( $ipsclass->DB );

//--------------------------------
//  Set up our vars
//--------------------------------

$ipsclass->parse_incoming();

$ipsclass->initiate_ipsclass();

//--------------------------------
//  Set converge
//--------------------------------

$ipsclass->converge = new class_converge( $ipsclass->DB );

//--------------------------------
// Require our global functions
//--------------------------------

require THIS_PATH."core/functions.php";
$core     = new core_functions();
$core->ipsclass = & $ipsclass;

//--------------------------------
// Get dir contents
//--------------------------------

$core->dir_contents = $core->get_dir_structure();

//--------------------------------
// Get DB contents
//--------------------------------

$core->db_contents  = $core->get_db_structure();

//--------------------------------
// Get latest ID...
//--------------------------------

$dir_versions = array_reverse( $core->dir_contents );
$core->last_poss_id = array_shift( $dir_versions );

//--------------------------------
// Get datafile
//--------------------------------

if ( ! $core->last_poss_id )
{
	$core->login_screen( "An error has occured, we are unable to determine the current version or if there are any required upgrade files left to run" );
}

if ( file_exists( THIS_PATH.'upg_'.$core->last_poss_id.'/version_history.php' ) )
{
	require_once( THIS_PATH.'upg_'.$core->last_poss_id.'/version_history.php' );

	$core->versions = $import_versions;
}
else
{
	$core->login_screen( "Could not locate the required upgrade script: 'upg_{$ipsclass->last_poss_id}/version_history.php'");
}

//--------------------------------
// Version logic check
//--------------------------------

$core->get_version_latest();

if ( ! $core->current_version )
{
	$core->login_screen( "An error has occured, we are unable to determine the current version or if there are any required upgrade files left to run" );
}

if ( ! $ipsclass->input['act'] )
{
	if ( $core->current_version >= $core->current_upgrade )
	{
		$core->login_screen( "This Gallery installation is up-to-date and there are no more upgrades required" );
	}
}

//--------------------------------
//  Get our loverly member
//--------------------------------

$ipsclass->member = $core->get_member();

//--------------------------------
// Log in?
//--------------------------------

if ( $ipsclass->input['act'] != 'login' )
{
	if ( ! $ipsclass->member['id'] )
	{
		$core->login_screen("You do not have access to this upgrade system.");
	}

	if ( $ipsclass->return_md5_check() != $core->securekey )
	{
		$core->login_screen("You do not have access to this upgrade system!");
	}

	if ( ! $ipsclass->member['g_access_cp'] )
	{
		$core->login_screen('You must be an admin to access this upgrade script');
	}
}
else
{
	//----------------------------------
	// We must have submitted the form
	// time to check some details.
	//----------------------------------

	if ( empty($ipsclass->input['username']) )
	{
		$core->login_screen("You must enter a username before proceeding");
	}

	if ( empty($ipsclass->input['password']) )
	{
		$core->login_screen("You must enter a password before proceeding");
	}

	//----------------------------------
	// Attempt to get the details from the
	// DB
	//----------------------------------

	$ipsclass->DB->query("SELECT m.*, g.* FROM ibf_members m, ibf_groups g WHERE LOWER(name)='".strtolower($ipsclass->input['username'])."' and m.mgroup=g.g_id");

	$mem = $ipsclass->DB->fetch_row();

	//----------------------------------
	// Get perms
	//----------------------------------

	if ( empty($mem['id']) )
	{
		$core->login_screen("Could not find a record matching that username, please check the spelling");
	}

	//----------------------------------
	// Load converge member
	//----------------------------------

	$ipsclass->converge->converge_load_member($mem['email']);

	if ( ! $ipsclass->converge->member['converge_id'] )
	{
		$core->login_screen("Could not find a record matching that username, please check the spelling");
	}

	//----------------------------------
	// Check converge pass
	//----------------------------------

	$pass = md5( $ipsclass->input['password'] );

	//------------------------------
	// Check password...
	//------------------------------

	if ( $ipsclass->converge->converge_authenticate_member( $pass ) != TRUE )
	{
		$core->login_screen("The password you entered is not correct");
	}
	else
	{
		if ($mem['g_access_cp'] != 1)
		{
			$core->login_screen("You do not have access to the administrative CP");
		}
		else
		{

			//----------------------------------
			// All is good, bounce onwards...
			//----------------------------------

			$ipsclass->member = $mem;

			$core->redirect( "index.php?act=work&loginkey={$mem['member_login_key']}&securekey=".$ipsclass->return_md5_check()."&mid={$mem['id']}", "Thanks for logging in...." );
		}
	}
}

//===========================================================================
// MAIN LOGIC...
//===========================================================================

//--------------------------------
// Get and run upgrade script
//--------------------------------

if ( ! in_array( $ipsclass->input['act'], $core->safe_act ) )
{
	if ( $core->current_version == '00000' )
	{
		if ( file_exists( THIS_PATH.'install/version_install.php' ) )
		{
			require_once( THIS_PATH.'install/version_install.php' );
			$runme = new version_install( $ipsclass, $core );
		}
		else
		{
			$core->login_screen( "Could not locate the required installation script: 'install/version_install.php'");
		}
	}
	elseif ( file_exists( THIS_PATH.'upg_'.$core->current_upgrade.'/version_upgrade.php' ) )
	{
		require_once( THIS_PATH.'upg_'.$core->current_upgrade.'/version_upgrade.php' );
		$runme = new version_upgrade( $ipsclass, $core );
	}
	else
	{
		$core->login_screen( "Could not locate the required upgrade script: 'upg_{$ipsclass->current_upgrade}/version_upgrade.php'");
	}
}

// Module(work) -> done -> settings -> recache -> templates -> templatesrecache -> updatecomp -> finish
switch ($ipsclass->input['act'])
{
	case 'recache':
		$core->rebuild_caches();
		break;
	case 'templates':
		$core->rebuild_templates();
		break;
	case 'templatescache':
		$core->rebuild_templates_cache();
		break;
	case 'settings':
		$core->rebuild_settings();
		break;
    case 'updatecomp':
        $core->update_component();
        break;
	case 'finish':
		$core->upgrade_complete();
		break;
	case 'done':
		$core->module_complete();
		break;
	case 'work':
		$runme->auto_run();
		break;
	default:
		$core->login_screen();
		break;
}

/*-------------------------------------------------------------------------*/
// INFO CLASS
/*-------------------------------------------------------------------------*/

class info {

	var $member          = array();
	var $input           = array();
	var $base_url        = "";
	var $vars            = "";
	var $upgrade_history = array();
	var $current_version = '';
    var $loginkey        = '';
    var $securekey       = '';
    var $current_action  = '';
    var $safe_act        = array( 'recache', 'templates', 'templatescache', 'settings', 'updatecomp', 'finish' );

}


?>