<?php

$SQL[] = "CREATE TABLE ibf_gallery_albums (
  id bigint NOT NULL identity,
  member_id int NOT NULL default 0,
  public_album tinyint NOT NULL default 0,
  name varchar(60) NOT NULL default '',
  description varchar(120) NOT NULL default '',
  images bigint NOT NULL default 0,
  comments bigint NOT NULL default 0,
  last_pic bigint NOT NULL default 0,
  category_id INT DEFAULT 0,
  last_name VARCHAR( 255 ) NULL,
  PRIMARY KEY  (id)
);";
$SQL[] = "CREATE INDEX member_id ON ibf_gallery_albums (member_id)";
$SQL[] = "CREATE INDEX public_album ON ibf_gallery_albums (public_album)";


$SQL[] = "CREATE TABLE ibf_gallery_bandwidth (
  bid bigint NOT NULL identity,
  member_id int NOT NULL default 0,
  file_name varchar(60) NOT NULL default '',
  date int NOT NULL default 0,
  size int NOT NULL default 0,
  PRIMARY KEY  (bid)
);";
$SQL[] = "CREATE INDEX file_name ON ibf_gallery_bandwidth (file_name)";
$SQL[] = "CREATE INDEX member_id ON ibf_gallery_bandwidth (member_id)";
$SQL[] = "CREATE INDEX date ON ibf_gallery_bandwidth (date)";

$SQL[] = "CREATE TABLE ibf_gallery_categories (
  id int NOT NULL identity,
  parent int NOT NULL default 0,
  name varchar(60) NOT NULL default '',
  description text NOT NULL,
  c_order int NOT NULL default 0,
  images bigint NOT NULL default 0,
  comments bigint NOT NULL default 0,
  perms_thumbs varchar(120) NOT NULL default '',
  perms_view varchar(120) NOT NULL default '',
  perms_images varchar(120) NOT NULL default '',
  perms_comments varchar(120) NOT NULL default '',
  perms_moderate varchar(120) NOT NULL default '',
  allow_ibfcode tinyint NOT NULL default 1,
  allow_html tinyint NOT NULL default 0,
  password varchar(60) NOT NULL default '',
  approve_images tinyint NOT NULL default 0,
  imgs_per_col smallint NOT NULL default 4,
  imgs_per_row smallint NOT NULL default 5,
  watermark_images tinyint NOT NULL default 0,
  thumbnail tinyint NOT NULL default 1,
  allow_comments tinyint NOT NULL default 1,
  approve_comments tinyint NOT NULL default 0,
  inc_post_count tinyint NOT NULL default 1,
  status tinyint NOT NULL default 1,
  last_pic bigint NOT NULL default 0,
  def_view varchar(30) NULL default 'date:DESC:30',
  rate TINYINT NOT NULL DEFAULT 1,
  allow_movies TINYINT NOT NULL DEFAULT 0,
  allow_images TINYINT NOT NULL DEFAULT 1,
  category_only TINYINT NOT NULL DEFAULT 0,
  last_name VARCHAR( 255 ) NULL,
  last_member_id INT NULL,
  album_mode TINYINT NOT NULL DEFAULT 0,
  mod_images int NOT NULL DEFAULT 0,
  cat_rule_method tinyint NOT NULL default 0,
  cat_rule_title varchar( 120 ) NOT NULL default '',
  cat_rule_text text NOT NULL default '',
  PRIMARY KEY  (id)
)";
$SQL[] = "CREATE INDEX parent ON ibf_gallery_categories (parent)";

$SQL[] = "CREATE TABLE ibf_gallery_comments (
  pid int NOT NULL identity CONSTRAINT PK_gpid PRIMARY KEY,
  append_edit tinyint default 0,
  edit_time int NULL default NULL,
  author_id int NOT NULL default 0,
  author_name varchar(32) NULL,
  use_sig tinyint NOT NULL default 0,
  use_emo tinyint NOT NULL default 0,
  ip_address varchar(16) NOT NULL default '',
  post_date int NULL,
  comment text NULL,
  approved tinyint NULL,
  img_id int NOT NULL default 0,
  edit_name varchar(255) NULL
);";
$SQL[] = "CREATE INDEX img_id ON ibf_gallery_comments (img_id,author_id)";
$SQL[] = "CREATE INDEX author_id ON ibf_gallery_comments (author_id)";

$SQL[] = "CREATE TABLE ibf_gallery_ecardlog (
  id bigint NOT NULL identity,
  img_id bigint NOT NULL default 0,
  date int NOT NULL default 0,
  member_id int NOT NULL default 0,
  receiver_name varchar(60) NOT NULL default '',
  receiver_email varchar(60) NOT NULL default '',
  title varchar(60) NOT NULL default '',
  msg text NOT NULL,
  bg varchar(7) NOT NULL default '',
  font varchar(7) NOT NULL default '',
  border varchar(7) NOT NULL default '',
  PRIMARY KEY  (id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_favorites (
  id bigint NOT NULL identity,
  img_id bigint NOT NULL default 0,
  member_id int NOT NULL default 0,
  PRIMARY KEY  (id)
) ;";
$SQL[] = "CREATE INDEX member_id ON ibf_gallery_favorites (member_id)";

$SQL[] = "CREATE TABLE ibf_gallery_form_fields (
  id int NOT NULL identity,
  name varchar(60) NOT NULL default '',
  description varchar(120) NOT NULL default '',
  type varchar(10) NOT NULL default '',
  content text NOT NULL,
  required tinyint NOT NULL default 0,
  position int NOT NULL default 0,
  deleteable tinyint NOT NULL default 0,
  PRIMARY KEY  (id)
);";

$SQL[] = "CREATE TABLE ibf_gallery_images (
  id bigint NOT NULL identity,
  member_id int NOT NULL default 0,
  category_id smallint NOT NULL default 0,
  album_id bigint NOT NULL default 0,
  caption varchar(60) NOT NULL default '',
  description text NOT NULL,
  directory int NOT NULL default 0, 
  masked_file_name varchar(60) NOT NULL default '',
  medium_file_name varchar(75) NOT NULL default '',
  file_name varchar(60) NOT NULL default '',
  file_size int NOT NULL default 0,
  file_type varchar(20) NOT NULL default '',
  approved tinyint NOT NULL default 0,
  thumbnail tinyint NOT NULL default 0,
  views bigint NOT NULL default 0,
  comments int NOT NULL default 0,
  date int NOT NULL default 0,
  ratings_total int NOT NULL default 0,
  ratings_count int NOT NULL default 0,
  rating tinyint NOT NULL default 0,
  pinned tinyint NOT NULL default 0,
  lastcomment INT NOT NULL DEFAULT 0,
  media TINYINT NULL,
  credit_info text NOT NULL DEFAULT '',
  copyright varchar( 120 ) NOT NULL default '',
  PRIMARY KEY  (id),
) ;";
$SQL[] = "CREATE INDEX category_id ON ibf_gallery_images (category_id)";
$SQL[] = "CREATE INDEX album_id ON ibf_gallery_images (album_id)";
$SQL[] = "CREATE INDEX member_id ON ibf_gallery_images (member_id)";
$SQL[] = "CREATE INDEX approved ON ibf_gallery_images (approved)";

$SQL[] = "CREATE TABLE ibf_gallery_ratings (
  id bigint NOT NULL identity,
  member_id int NOT NULL default 0,
  img_id bigint NOT NULL default 0,
  date int NOT NULL default 0,
  rate smallint NOT NULL default 0,
  PRIMARY KEY  (id)
) ;";
$SQL[] = "CREATE INDEX member_id ON ibf_gallery_ratings (member_id)";
$SQL[] = "CREATE INDEX img_id ON ibf_gallery_ratings (img_id)";

$SQL[] = "CREATE TABLE ibf_gallery_media_types (
  id int NOT NULL identity,
  icon varchar(60) NOT NULL default '',
  title varchar(80) NOT NULL default '',
  mime_type varchar(20) NOT NULL default '',
  extension varchar(32) NOT NULL default '',
  allowed tinyint NOT NULL default 0,
  allow_user_thumb tinyint NOT NULL default 0,
  thumb_width int NOT NULL default 0,
  thumb_height int NOT NULL default 0,
  thumb_prop tinyint NOT NULL default 0,
  display_code text NOT NULL,
  default_type TINYINT DEFAULT 0 NOT NULL,
  PRIMARY KEY  (id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_upgrade_history (
  gallery_upgrade_id int NOT NULL identity,
  gallery_version_id int NOT NULL default 0,
  gallery_version_human varchar(200) NOT NULL default '',
  gallery_upgrade_date int NOT NULL default 0,
  gallery_upgrade_mid int NOT NULL default 0,
  gallery_upgrade_notes text NULL,
  PRIMARY KEY  (gallery_upgrade_id)
)";

$SQL[] = "ALTER TABLE ibf_members ADD gallery_perms VARCHAR( 10 ) NOT NULL DEFAULT '1:1:1'";
$SQL[] = "ALTER TABLE ibf_members ADD has_gallery TINYINT NOT NULL DEFAULT 0";

$SQL[] = "ALTER TABLE ibf_groups ADD g_max_diskspace INT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_upload INT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_transfer INT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_views INT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_create_albums TINYINT NOT NULL DEFAULT 1";
$SQL[] = "ALTER TABLE ibf_groups ADD g_album_limit TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_img_album_limit TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_slideshows TINYINT NOT NULL DEFAULT 1";
$SQL[] = "ALTER TABLE ibf_groups ADD g_favorites TINYINT NOT NULL DEFAULT 1";
$SQL[] = "ALTER TABLE ibf_groups ADD g_comment TINYINT NOT NULL DEFAULT 1";
$SQL[] = "ALTER TABLE ibf_groups ADD g_rate TINYINT NOT NULL DEFAULT 1";
$SQL[] = "ALTER TABLE ibf_groups ADD g_ecard TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_edit_own TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_del_own TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_move_own TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_mod_albums TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_img_local TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_movies TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_movie_size INT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_multi_file_limit SMALLINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_zip_upload TINYINT NOT NULL DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_can_search_gallery TINYINT NOT NULL DEFAULT 1";

$SQL[] = "ALTER TABLE ibf_contacts ADD gallery_album_perms TEXT NOT NULL DEFAULT ''";

?>