<?php

$SQL[] = "CREATE TABLE ibf_gallery_albums (
  id bigint(10) unsigned NOT NULL auto_increment,
  member_id mediumint(8) unsigned NOT NULL default '0',
  public_album tinyint(1) unsigned NOT NULL default '0',
  name varchar(60) NOT NULL default '',
  description varchar(120) NOT NULL default '',
  images bigint(10) unsigned NOT NULL default '0',
  comments bigint(10) unsigned NOT NULL default '0',
  last_pic bigint(10) unsigned NOT NULL default '0',
  category_id INT(10) UNSIGNED DEFAULT '0',
  last_name VARCHAR( 255 ) NOT NULL,
  PRIMARY KEY  (id),
  KEY member_id (member_id)
      );";

$SQL[] = "CREATE TABLE ibf_gallery_bandwidth (
  bid bigint(10) unsigned NOT NULL auto_increment,
  member_id mediumint(8) unsigned NOT NULL default '0',
  file_name varchar(60) NOT NULL default '',
  date int(10) unsigned NOT NULL default '0',
  size int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (bid),
  KEY file_name (file_name),
  KEY member_id (member_id),
  KEY date (date)
);";

$SQL[] = "CREATE TABLE ibf_gallery_categories (
  id int(10) unsigned NOT NULL auto_increment,
  parent int(10) unsigned NOT NULL default '0',
  name varchar(60) NOT NULL default '',
  description text NOT NULL,
  c_order int(10) unsigned NOT NULL default '0',
  images bigint(10) unsigned NOT NULL default '0',
  comments bigint(10) unsigned NOT NULL default '0',
  perms_thumbs varchar(120) NOT NULL default '',
  perms_view varchar(120) NOT NULL default '',
  perms_images varchar(120) NOT NULL default '',
  perms_comments varchar(120) NOT NULL default '',
  perms_moderate varchar(120) NOT NULL default '',
  allow_ibfcode tinyint(1) unsigned NOT NULL default '1',
  allow_html TINYINT( 1 ) UNSIGNED DEFAULT 0 NOT NULL,
  password varchar(60) NOT NULL default '',
  approve_images tinyint(1) unsigned NOT NULL default '0',
  imgs_per_col int(5) unsigned NOT NULL default '4',
  imgs_per_row int(5) unsigned NOT NULL default '5',
  watermark_images tinyint(1) unsigned NOT NULL default '0',
  thumbnail tinyint(1) unsigned NOT NULL default '1',
  allow_comments tinyint(1) unsigned NOT NULL default '1',
  approve_comments tinyint(1) unsigned NOT NULL default '0',
  inc_post_count tinyint(1) unsigned NOT NULL default '1',
  status tinyint(1) unsigned NOT NULL default '1',
  last_pic bigint(10) unsigned NOT NULL default '0',
  def_view varchar(30) default 'date:DESC:30',
  rate TINYINT( 1 ) UNSIGNED DEFAULT '1' NOT NULL,
  allow_movies TINYINT( 1 ) UNSIGNED DEFAULT '0' NOT NULL,
  allow_images TINYINT( 1 ) UNSIGNED DEFAULT '1' NOT NULL,
  category_only TINYINT(1) UNSIGNED DEFAULT '0',
  album_mode TINYINT( 1 ) UNSIGNED DEFAULT '0' NOT NULL,
  last_name VARCHAR( 255 ) NOT NULL,
  last_member_id MEDIUMINT( 8 ) UNSIGNED NOT NULL,
  mod_images int( 10 ) UNSIGNED NOT NULL default '0',
  cat_rule_method tinyint( 1 ) UNSIGNED NOT NULL default '0',
  cat_rule_title varchar( 120 ) NOT NULL default '',
  cat_rule_text text,
  PRIMARY KEY  (id),
  KEY parent (parent)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_comments (
  pid int(10) NOT NULL auto_increment,
  append_edit tinyint(1) default '0',
  edit_time int(10) default NULL,
  author_id mediumint(8) NOT NULL default '0',
  author_name varchar(32) default NULL,
  use_sig tinyint(1) NOT NULL default '0',
  use_emo tinyint(1) NOT NULL default '0',
  ip_address varchar(16) NOT NULL default '',
  post_date int(10) default NULL,
  comment text,
  approved tinyint(1) default NULL,
  img_id int(10) NOT NULL default '0',
  edit_name varchar(255) default NULL,
  PRIMARY KEY  (pid),
  KEY img_id (img_id,author_id),
  KEY author_id (author_id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_ecardlog (
  id bigint(10) unsigned NOT NULL auto_increment,
  img_id bigint(10) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  member_id mediumint(8) unsigned NOT NULL default '0',
  receiver_name varchar(60) NOT NULL default '',
  receiver_email varchar(60) NOT NULL default '',
  title varchar(60) NOT NULL default '',
  msg text NOT NULL,
  bg varchar(7) NOT NULL default '',
  font varchar(7) NOT NULL default '',
  border varchar(7) NOT NULL default '',
  PRIMARY KEY  (id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_favorites (
  id bigint(10) unsigned NOT NULL auto_increment,
  img_id bigint(10) unsigned NOT NULL default '0',
  member_id mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY member_id (member_id)
);";

$SQL[] = "CREATE TABLE ibf_gallery_form_fields (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  description varchar(120) NOT NULL default '',
  type varchar(10) NOT NULL default '',
  content text NOT NULL,
  required tinyint(1) unsigned NOT NULL default '0',
  position int(10) unsigned NOT NULL default '0',
  deleteable tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
);";

$SQL[] = "CREATE TABLE ibf_gallery_images (
  id bigint(10) unsigned NOT NULL auto_increment,
  member_id mediumint(8) unsigned NOT NULL default '0',
  category_id smallint(5) unsigned NOT NULL default '0',
  album_id bigint(10) unsigned NOT NULL default '0',
  caption varchar(60) NOT NULL default '',
  description text NOT NULL,
  directory VARCHAR( 60 ) NOT NULL default '', 
  masked_file_name varchar(60) NOT NULL default '',
  medium_file_name varchar(75) NOT NULL default '',
  file_name varchar(60) NOT NULL default '',
  file_size int(10) unsigned NOT NULL default '0',
  file_type varchar(20) NOT NULL default '',
  approved tinyint(1) unsigned NOT NULL default '0',
  thumbnail tinyint(1) unsigned NOT NULL default '0',
  views bigint(10) unsigned NOT NULL default '0',
  comments int(10) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  ratings_total int(10) unsigned NOT NULL default '0',
  ratings_count int(10) unsigned NOT NULL default '0',
  rating tinyint( 2 ) unsigned NOT NULL default '0',
  pinned tinyint(1) unsigned NOT NULL default '0',
  lastcomment INT( 10 ) UNSIGNED DEFAULT 0 NOT NULL,
  media TINYINT( 1 ) UNSIGNED NOT NULL,
  credit_info text NOT NULL,
  copyright varchar( 120 ) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY category_id (category_id),
  KEY approved (approved)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_ratings (
  id bigint(10) unsigned NOT NULL auto_increment,
  member_id mediumint(8) unsigned NOT NULL default '0',
  img_id bigint(10) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  rate smallint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY member_id (member_id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_media_types (
  id int(10) unsigned NOT NULL auto_increment,
  icon varchar(60) NOT NULL default '',
  title varchar(80) NOT NULL default '',
  mime_type varchar(20) NOT NULL default '',
  extension varchar(32) NOT NULL default '',
  allowed tinyint(1) unsigned NOT NULL default '0',
  allow_user_thumb tinyint(1) unsigned NOT NULL default '0',
  thumb_width int(10) unsigned NOT NULL default '0',
  thumb_height int(10) unsigned NOT NULL default '0',
  thumb_prop tinyint(1) unsigned NOT NULL default '0',
  display_code text NOT NULL,
  default_type TINYINT( 1 ) UNSIGNED DEFAULT '0' NOT NULL,
  PRIMARY KEY  (id)
) ;";

$SQL[] = "CREATE TABLE ibf_gallery_upgrade_history (
  gallery_upgrade_id int(10) NOT NULL auto_increment,
  gallery_version_id int(10) NOT NULL default '0',
  gallery_version_human varchar(200) NOT NULL default '',
  gallery_upgrade_date int(10) NOT NULL default '0',
  gallery_upgrade_mid int(10) NOT NULL default '0',
  gallery_upgrade_notes text NOT NULL,
  PRIMARY KEY  (gallery_upgrade_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;";

$SQL[] = "ALTER TABLE ibf_gallery_albums ADD INDEX ( public_album )";
$SQL[] = "ALTER TABLE ibf_gallery_images ADD INDEX ( album_id )";
$SQL[] = "ALTER TABLE ibf_gallery_images ADD INDEX ( member_id )";
$SQL[] = "ALTER TABLE ibf_gallery_images ADD INDEX ( approved )";
$SQL[] = "ALTER TABLE ibf_gallery_ratings ADD INDEX (img_id)";
$SQL[] = "ALTER TABLE ibf_gallery_bandwidth ADD INDEX ( date )";

$SQL[] = "ALTER TABLE ibf_members ADD gallery_perms VARCHAR( 10 ) DEFAULT '1:1:1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_members ADD has_gallery TINYINT( 1 ) DEFAULT '0' NOT NULL";

$SQL[] = "ALTER TABLE ibf_groups ADD g_max_diskspace INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_upload INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_transfer INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_max_views INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_create_albums TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_album_limit INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_img_album_limit INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_slideshows TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_favorites TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_comment TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_rate TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_ecard TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_edit_own TINYINT( 1 ) UNSIGNED default '1' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_del_own TINYINT( 1 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_move_own TINYINT( 1 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_mod_albums TINYINT( 1 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_img_local TINYINT( 1 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_movies TINYINT( 1 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_movie_size INT( 10 ) UNSIGNED default '0' NOT NULL";
$SQL[] = "ALTER TABLE ibf_groups ADD g_multi_file_limit SMALLINT(2) UNSIGNED DEFAULT 0";
$SQL[] = "ALTER TABLE ibf_groups ADD g_zip_upload TINYINT(1) UNSIGNED DEFAULT 0";
$sql[] = "ALTER TABLE ibf_groups ADD g_can_search_gallery TINYINT( 1 ) UNSIGNED DEFAULT '1' NOT NULL";

?>