<?php

/*
+--------------------------------------------------------------------------
|   Invision Gallery
|   =============================================
|   (c) 2001 - 2004 Invision Power Services, Inc.
|   Nullified by DGT
|   =============================================
+--------------------------------------------------------------------------
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class version_upgrade
{
	var $this_version = '10003';
	var $upgrade_from = '10002';
	var $ipsclass;
	var $core;
	var $first_step   = 'create the necessary tables, indexes and updates your database to include the new schematic modifications.';
	var $md5_check    = '';
	var $base_url     = '';
	var $mod_to_run   = '';
	
	/*-------------------------------------------------------------------------*/
	// CONSTRUCTOR
	/*-------------------------------------------------------------------------*/
	
	function version_upgrade( &$ipsclass, &$core )
	{
		$this->ipsclass = &$ipsclass;
		$this->ipsclass->core = &$core;
		$this->md5_check = $this->ipsclass->return_md5_check();
		
		$this->base_url  = "index.php?act=work&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}";
		
		if ( is_array( $this->ipsclass->core->modules_to_run ) and count( $this->ipsclass->core->modules_to_run ) )
		{
			$tmp = array_shift( $this->ipsclass->core->modules_to_run );
			
			$this->mod_to_run = implode( ', ', $this->ipsclass->core->modules_to_run );
		}
		
		if ( ! $this->mod_to_run )
		{
			$this->mod_to_run = 'None';
		}
	}
	
	/*-------------------------------------------------------------------------*/
	// Auto run..
	/*-------------------------------------------------------------------------*/
	
	function auto_run()
	{
		//--------------------------------
		// What are we doing?
		//--------------------------------
		
		switch( $this->ipsclass->input['workact'] )
		{
			case 'sql':
				$this->upgrade_sql();
				break;
			default:
				$this->upgrade_intro();
				break;
		}
	}
	
	
	/*-------------------------------------------------------------------------*/
	// SQL
	/*-------------------------------------------------------------------------*/
	
	function upgrade_sql()
	{
		$cnt = 0;

		// Create/Alter tables		
		$SQL = array();
		if ( file_exists( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' ) )
		{
			require_once( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' );
		
			foreach( $SQL as $q )
			{
				$this->ipsclass->DB->query( $q );
				
				$cnt++;
			}
		}

		$this->update_cats();
		$this->update_albums();

		//--------------------------------
		// Next page...
		//--------------------------------
		
		$this->ipsclass->core->redirect( "index.php?act=done&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}", "$cnt queries run...." );
		
	}

	function update_cats()
	{
		$this->ipsclass->DB->simple_construct( array( 'select' => 'id, album_mode', 'from' => 'gallery_categories' ) );
		$this->ipsclass->DB->simple_exec();

		while( $i = $this->ipsclass->DB->fetch_row() )
		{
			$cats[] = array( $i['id'], $i['album_mode'] );
		}

		if( is_array( $cats ) )
		{
			foreach( $cats as $a )
			{
				$cat        = $a[0];
				$album_mode = $a[1];			
				unset( $ids );
		
				// Get last poster info
				if( ! $album_mode )
				{
					$this->ipsclass->DB->simple_construct( array( 'select' => 'member_id', 
												  'from'   => 'gallery_images', 
								  				  'where'  => "category_id={$cat}", 
												  'order'  => 'id desc', 
												  'limit'  => array( 0,1 ) ) );
					$this->ipsclass->DB->simple_exec();
				}
				else
				{
					$this->ipsclass->DB->simple_construct( array( 'select' => 'member_id',
						                          'from'   => 'gallery_albums',
						                          'where'  => "category_id={$cat}",
												  'order'  => 'last_pic desc',
												  'limit'  => array( 0,1 ) ) );
					$this->ipsclass->DB->simple_exec();
				}

				$mid = $this->ipsclass->DB->fetch_row();

				if( $mid['member_id'] )
				{
					$this->ipsclass->DB->simple_construct( array( 'select' => 'name', 'from' => 'members', 'where' => "id={$mid['member_id']}" ) );
					$this->ipsclass->DB->simple_exec();
					$member = $this->ipsclass->DB->fetch_row();
				}
				else
				{
					$mid['member_id'] = 0;
					$member['name'] = '';
				}	

			    $this->ipsclass->DB->simple_update( 'gallery_categories', "last_name='{$member['name']}', last_member_id={$mid['member_id']}", "id={$cat}", 1 );
		        $this->ipsclass->DB->simple_exec();
			}
		}
	}

	function update_albums()
	{
        $this->ipsclass->DB->simple_construct( array( 'select' => 'id, member_id',
                                     'from'   => 'gallery_albums' ) );
                                     
		$this->ipsclass->DB->simple_exec();
		
		while( $i = $this->ipsclass->DB->fetch_row() )
		{
			$albums[] = array( $i['id'], $i['member_id'] );
		}
		
		if( is_array( $albums ) )
		{
			foreach( $albums as $a )
			{
				$album = $a[0];
				$mid   = $a[1];			
				unset( $ids );
	      		$this->ipsclass->DB->simple_construct( array( 'select' => 'id', 
											  'from'   => 'gallery_images', 
			    	                          'where'  => "album_id={$album}" ) );
				$this->ipsclass->DB->simple_exec();

			    while( $i = $this->ipsclass->DB->fetch_row() )
		  		{
			  		$ids[] = $i['id'];
      			}
      
			    if( is_array( $ids ) )
			    {
					$this->ipsclass->DB->simple_construct( array( 'select' => 'COUNT(*) AS comments', 
        			                                'from'   => 'gallery_comments', 
        			                                'where'  => "img_id IN ( ".implode( ",", $ids )." ) AND approved=1" ) );
			        $this->ipsclass->DB->simple_exec();
		    		$info = $this->ipsclass->DB->fetch_row();

					$this->ipsclass->DB->simple_update( 'gallery_albums', "comments={$info['comments']}", "id={$album}", 1 );
        			$this->ipsclass->DB->simple_exec();
	      		}
		  		else
      			{
        			$this->ipsclass->DB->simple_update( 'gallery_albums', "comments=0", "id={$album}", 1 );
        			$this->ipsclass->DB->simple_exec();      		
	      		}

			    $this->ipsclass->DB->simple_construct( array( 'select' => 'COUNT(*) AS images', 
				                              'from'   => 'gallery_images', 
        		                              'where'  => "album_id={$album} AND approved=1" ) );
			    $this->ipsclass->DB->simple_exec();
		  		$info = $this->ipsclass->DB->fetch_row();

				$this->ipsclass->DB->simple_construct( array( 'select' => 'name', 'from' => 'members', 'where' => "id={$mid}" ) );
				$this->ipsclass->DB->simple_exec();
				$mem = $this->ipsclass->DB->fetch_row();      		

			    $this->ipsclass->DB->simple_update( 'gallery_albums', "images={$info['images']}, last_name='{$mem['name']}'", "id={$album}", 1 );
			    $this->ipsclass->DB->simple_exec();
			}
		}
	}
	
	/*-------------------------------------------------------------------------*/
	// INTRO
	/*-------------------------------------------------------------------------*/
	
	function upgrade_intro()
	{
		$this->ipsclass->template->content .= "
			<div class='tableborder'>
			 <div class='maintitle'>Welcome to the Invision Gallery Setup System</div>
			 <div class='tdrow1' style='padding:6px'>This module will upgrade you from <b>{$this->ipsclass->core->versions[$this->upgrade_from]}</b> to <b>{$this->ipsclass->core->versions[$this->this_version]}</b>
			 <br /><br />This first step will {$this->first_step}
			 <br /><br />
			 <div align='center'><span style='font-weight:bold;font-size:14px'>&raquo; <a href='{$this->base_url}&workact=sql'>Proceed...</a></span></div>
			 </div>
			</div>
			<br />
			<div align='center'>Modules to run after this module: {$this->ipsclass->mod_to_run}</div>
			";
		
		$this->ipsclass->template->output();
		
	}
	
}
	
	
?>