<?php

/*
+--------------------------------------------------------------------------
|   Invision Gallery
|   =============================================
|   (c) 2001 - 2004 Invision Power Services, Inc.
|   Nullified by DGT
|   =============================================
+--------------------------------------------------------------------------
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class version_upgrade
{
	var $this_version = '10008';
	var $upgrade_from = '10007';
	var $ipsclass;
	var $core;
	var $first_step   = 'create the necessary tables, indexes and updates your database to include the new schematic modifications.';
	var $md5_check    = '';
	var $base_url     = '';
	var $mod_to_run   = '';
	
	/*-------------------------------------------------------------------------*/
	// CONSTRUCTOR
	/*-------------------------------------------------------------------------*/
	
	function version_upgrade( &$ipsclass, &$core )
	{
		$this->ipsclass = &$ipsclass;
		$this->ipsclass->core = &$core;
		$this->core = &$core;
		$this->md5_check = $this->ipsclass->return_md5_check();
		
		$this->base_url  = "index.php?act=work&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}";
		
		if ( is_array( $this->ipsclass->core->modules_to_run ) and count( $this->ipsclass->core->modules_to_run ) )
		{
			$tmp = array_shift( $this->ipsclass->core->modules_to_run );
			
			$this->mod_to_run = implode( ', ', $this->ipsclass->core->modules_to_run );
		}
		
		if ( ! $this->mod_to_run )
		{
			$this->mod_to_run = 'None';
		}
	}
	
	/*-------------------------------------------------------------------------*/
	// Auto run..
	/*-------------------------------------------------------------------------*/
	
	function auto_run()
	{
		//--------------------------------
		// What are we doing?
		//--------------------------------
		
		switch( $this->ipsclass->input['workact'] )
		{
			case 'sql':
				$this->upgrade_sql();
				break;
			default:
				$this->upgrade_intro();
				break;
		}
	}
	
	
	/*-------------------------------------------------------------------------*/
	// SQL
	/*-------------------------------------------------------------------------*/
	
	function upgrade_sql()
	{
		$cnt = 0;

		// Create/Alter tables		
		$SQL = array();
		if ( file_exists( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' ) )
		{
			require_once( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' );
		
			foreach( $SQL as $q )
			{
				$this->ipsclass->DB->query( $q );
				
				$cnt++;
			}
		}
		//--------------------------------
		// Next page...
		//--------------------------------
		
		$this->ipsclass->core->redirect( "index.php?act=done&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}", "$cnt queries run...." );
		
	}

	/*-------------------------------------------------------------------------*/
	// INTRO
	/*-------------------------------------------------------------------------*/
	
	function upgrade_intro()
	{
		$this->ipsclass->template->content .= "
			<div class='tableborder'>
			 <div class='maintitle'>Welcome to the Invision Gallery Setup System</div>
			 <div class='tdrow1' style='padding:6px'>This module will upgrade you from <b>{$this->ipsclass->core->versions[$this->upgrade_from]}</b> to <b>{$this->ipsclass->core->versions[$this->this_version]}</b>
			 <br /><br />This first step will {$this->first_step}
			 <br /><br />
			 <div align='center'><span style='font-weight:bold;font-size:14px'>&raquo; <a href='{$this->base_url}&workact=sql'>Proceed...</a></span></div>
			 </div>
			</div>
			<br />
			<div align='center'>Modules to run after this module: {$this->ipsclass->mod_to_run}</div>
			";
		
		$this->ipsclass->template->output();
		
	}
	
}
	
	
?>