<?php

/*
+--------------------------------------------------------------------------
|   Invision Gallery
|   =============================================
|   (c) 2001 - 2004 Invision Power Services, Inc.
|   Nullified by DGT
|   =============================================
+--------------------------------------------------------------------------
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class version_upgrade
{
	var $this_version = '20004';
	var $upgrade_from = '20003';
	var $ipsclass;
	var $core;
	var $first_step   = 'create the necessary tables, indexes and updates your database to include the new schematic modifications.';
	var $md5_check    = '';
	var $base_url     = '';
	var $mod_to_run   = '';
	
	/*-------------------------------------------------------------------------*/
	// CONSTRUCTOR
	/*-------------------------------------------------------------------------*/
	
	function version_upgrade( &$ipsclass, &$core )
	{
		$this->ipsclass = &$ipsclass;
		$this->ipsclass->core = &$core;
		$this->md5_check = $this->ipsclass->return_md5_check();
		
		$this->base_url  = "index.php?act=work&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}";
		
		if ( is_array( $this->ipsclass->core->modules_to_run ) and count( $this->ipsclass->core->modules_to_run ) )
		{
			$tmp = array_shift( $this->ipsclass->core->modules_to_run );
			
			$this->mod_to_run = implode( ', ', $this->ipsclass->core->modules_to_run );
		}
		
		if ( ! $this->mod_to_run )
		{
			$this->mod_to_run = 'None';
		}
	}
	
	/*-------------------------------------------------------------------------*/
	// Auto run..
	/*-------------------------------------------------------------------------*/
	
	function auto_run()
	{
		//--------------------------------
		// What are we doing?
		//--------------------------------
		
		switch( $this->ipsclass->input['workact'] )
		{
			case 'sql':
				$this->upgrade_sql();
				break;
			default:
				$this->upgrade_intro();
				break;
		}
	}
	
	
	/*-------------------------------------------------------------------------*/
	// SQL
	/*-------------------------------------------------------------------------*/
	
	function upgrade_sql()
	{		
		$cnt = 0;

		// Create/Alter tables		
		$SQL = array();
		if ( file_exists( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' ) )
		{
			require_once( THIS_PATH.'upg_'.$this->ipsclass->core->current_upgrade.'/'.strtolower($this->ipsclass->vars['sql_driver']).'_updates.php' );
		
			foreach( $SQL as $q )
			{
				$this->ipsclass->DB->query( $q );
				
				$cnt++;
			}
		}
		
		/*
		* Check for missing columns from the beta upgrader ( Beta 4 to RC 1 ) */
		$cnt = $this->check_columns( $cnt );
		
		//--------------------------------
		// Next page...
		//--------------------------------
		
		$this->ipsclass->core->redirect( "index.php?act=done&loginkey={$this->ipsclass->input['loginkey']}&securekey={$this->ipsclass->input['securekey']}&mid={$this->ipsclass->input['mid']}", "Checking for missing columns...<br />$cnt queries run...." );
		
	}

	/*
	* Check for missing keys ( beta cleanup ) */
	function check_columns( $cnt )  {
		if( !$this->ipsclass->DB->field_exists( 'medium_file_name', 'gallery_images' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_images', 'medium_file_name', 'VARCHAR( 75 )', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'credit_info', 'gallery_images' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_images', 'credit_info', 'TEXT', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'copyright', 'gallery_images' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_images', 'copyright', 'VARCHAR( 120 )', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'cat_rule_method', 'gallery_categories' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_categories', 'cat_rule_method', 'TINYINT UNSIGNED', "'0' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'cat_rule_title', 'gallery_categories' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_categories', 'cat_rule_title', 'VARCHAR( 120 )', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'cat_rule_text', 'gallery_categories' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_categories', 'cat_rule_text', 'TEXT', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'g_can_search_gallery', 'groups' ) )  {
			$this->ipsclass->DB->sql_add_field( 'groups', 'g_can_search_gallery', 'TINYINT UNSIGNED', "'1' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'gallery_album_perms', 'contacts' ) )  {
			$this->ipsclass->DB->sql_add_field( 'contacts', 'gallery_album_perms', 'TEXT', "'' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'has_gallery', 'members' ) )  {
			$this->ipsclass->DB->sql_add_field( 'members', 'has_gallery', 'TINYINT UNSIGNED', "'0' NOT NULL" );
			$cnt++;
		}
		if( !$this->ipsclass->DB->field_exists( 'mod_images', 'gallery_categories' ) )  {
			$this->ipsclass->DB->sql_add_field( 'gallery_categories', 'mod_images', 'INT( 10 ) UNSIGNED', "'0' NOT NULL" );
			$cnt++;
		}
		
		return $cnt;
	}
	
	/*-------------------------------------------------------------------------*/
	// INTRO
	/*-------------------------------------------------------------------------*/
	
	function upgrade_intro()
	{
		$this->ipsclass->template->content .= "
			<div class='tableborder'>
			 <div class='maintitle'>Welcome to the Invision Gallery Setup System</div>
			 <div class='tdrow1' style='padding:6px'>This module will upgrade you from <b>{$this->ipsclass->core->versions[$this->upgrade_from]}</b> to <b>{$this->ipsclass->core->versions[$this->this_version]}</b>
			 <br /><br />This first step will {$this->first_step}
			 <br /><br />
			 <div align='center'><span style='font-weight:bold;font-size:14px'>&raquo; <a href='{$this->base_url}&workact=sql'>Proceed...</a></span></div>
			 </div>
			</div>
			<br />
			<div align='center'>Modules to run after this module: {$this->mod_to_run}</div>
			";
		
		$this->ipsclass->template->output();
		
	}
	
}
	
	
?>