<?php
/*-----------------------------------------*\
|	The majority of this code is based	  |
|	on code by  Dean (D-Scripting) and    |
|               ( FuSoYa )                  |
|              Thxs To Them                 |
\*-----------------------------------------*/

error_reporting  (E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);
$INFO = array();
define( 'ROOT_PATH', dirname(__FILE__).'/');
define( 'KERNEL_PATH', ROOT_PATH.'ips_kernel/');
require ROOT_PATH."conf_global.php";
require_once ROOT_PATH.'sources/ipsclass.php';
require_once ROOT_PATH.'sources/classes/class_display.php';
require_once ROOT_PATH.'sources/classes/class_session.php';
require_once ROOT_PATH.'conf_global.php';
define( 'USE_SHUTDOWN', 0);
define( 'SAFE_MODE_ON', 0);
define( 'IN_DEV', 0);
define( 'IN_IPB', 1 );
$ipsclass       = new ipsclass();
$ipsclass->vars = $INFO;
$ipsclass->init_db_connection();
$ipsclass->print            =  new display();
$ipsclass->print->ipsclass  =& $ipsclass;
$ipsclass->sess             =  new session();
$ipsclass->sess->ipsclass   =& $ipsclass;
$ipsclass->parse_incoming();
$ipsclass->initiate_ipsclass();
$thisfile = preg_replace("#.+/(.+?)#","\\1", $_SERVER['PHP_SELF']);
$ipsclass->base_url = $ipsclass->vars['board_url'].'/'.$thisfile.'?';
$core = new core;
$core->ipsclass =& $ipsclass;
$core->startTimer();
$install = new install;
$install->ipsclass =& $ipsclass;
$install->core     =& $core;
$install->begin();
class core
{
	var $ipsclass;
	var $xml_file	= "mohamed_data.xml";
	
	function startTimer()
    {
        global $starttime;
        
        $mtime = microtime();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $starttime = $mtime;
    }
	
    function endTimer()
    {
        global $starttime;
        
        $mtime = microtime();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $endtime = $mtime;
        $totaltime = round (($endtime - $starttime), 5);
        return $totaltime;
    }
        
    function load_xml()
	{
		require_once(KERNEL_PATH.'class_xml.php');
		$xml = new class_xml();
		$xmlfile = ROOT_PATH.$this->xml_file;
		$xmldata = implode('', file($xmlfile));
		$xml->xml_parse_document($xmldata);

		if (!is_array($xml->xml_array['mohamedmod_data']))
		{
			$this->error("Install error: Unknown error in ".$this->xml_file.".<br />Installer couldn't process the XML properly.");
		}
		$this->xml_array = $xml->xml_array['mohamedmod_data'];
	}
	
	function delete_cache($name="")
	{
		if (!$name || $name == '')
		{
			return false;
		}

		$this->ipsclass->DB->simple_exec_query(array('select' => '*', 'from' => 'skin_templates_cache', 'where' => "template_group_name='".$name."'"));
		
		if ($this->ipsclass->DB->get_num_rows())
		{
			$this->ipsclass->DB->simple_exec_query(array('delete' => 'skin_templates_cache', 'where' => "template_group_name='".$name."'"));
		}
		return true;
	}
	
	function print_it($output="", $step="")
	{
		$execution  = sprintf( "%.4f", $this->endTimer() );
		$queries	= number_format($this->ipsclass->DB->get_query_cnt(),0,".",",");
		
		if ($step == "")
		{
			$step = $this->this_mod." Installer";
		}
		$this->headers();
		print $this->layout($output, $step, $queries, $execution);
	}
	
	function redirect($message="", $url="")
	{
		$url = $this->ipsclass->base_url.$url;
		
		$this->output .= "<meta http-equiv='refresh' content='2; url={$url}' />{$message}<br /><br />You are now being redirected...<br /><a href='{$url}'>(Click here if you are not redirected)</a>";
		$this->print_it($this->output, $this->step);
	}

	function error($output="")
	{
		$this->headers();
		print $this->layout($output, "Error!", 0, "0.0000");
		exit;
	}
	
	function headers()
	{
		@header("HTTP/1.0 200 OK");
		@header("HTTP/1.1 200 OK");
		@header("Content-type: text/html");
		@header("Cache-Control: no-cache, must-revalidate, max-age=0");
		@header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		@header("Pragma: no-cache");
	}
	
	function layout($output="", $step="", $queries="", $execution="")
	{
		return <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xml:lang="en" lang="en" xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>M&M Announce System v2.1</title>
		<meta http-equiv="Page-Enter" content="blendTrans(Duration=0.3)" />
		<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
		<style type="text/css">
			<!--
			body
			{
				background-color: #465584;
				color: #000;
				font-family: Verdana, Arial, Helvetica, sans-serif;
				font-size: 12px;
			}
			a
			{
				color: #000055;
			}
			a:hover
			{
				color:#333377;
                         text-decoration:underline;
			}
			.table
			{
				border: 1px solid #345487;
				margin: 2px;
				padding: 1px;
				background-color: #F5F9FD;
				text-align: center;
			}
			.trows
			{
				border: 1px solid #FFFFFF;
			}

			.textarea
			{
				font-size: 11px;
				color: #FFFFFF;
				background-color: #05536D;
				border: 1px solid #FFFFFF;
				overflow: hidden;
			}
			-->
		</style>
	</head>
	 <body>
		<div align="center">
		<h3>M&M Announce System</h3>
		<table width="80%" cellpadding="3" cellspacing="3" class="table">
			<tr>
				<td><b>{$step}</b></td>
			</tr>
		</table>
		<br />
		<table width="80%" cellpadding="3" cellspacing="3" class="table">
			<tr>
				<td>{$output}</td>
			</tr>
		</table>
		<br /><br />
		<table width="80%" cellpadding="3" cellspacing="3" class="table">
		<tr>
			<td valign="middle">M&M Announce System &copy; 2005 <a href="http://www.ipbhacker.com" target="_blank">mohamed</a></td>
		</tr>
		</table>
		</div>
	</body>
</html>
EOF;
	}
}

class install
{
	var $ipsclass;
	var $core;	
	var $output	= "";
	var $step	= "";

	function begin()
	{
		$this->core->load_xml();
		
		switch ($this->ipsclass->input['act'])
		{
			case 'settings':
				$this->step = "Installing ACP Settings";
				$this->general_settings();
				break;
			case 'finish':
				$this->step = "Finishing installation";
				$this->finish_install();
				break;
			default:
				$this->step = "Introduction";
				$this->intro();
				break;
		}
	}

	function intro()
	{
		$this->output .= "Please click the button below to start the installation.<form method='post' action='?act=settings'><input type='submit' name='startinstall' value='Start Installation'></form>";
	$this->core->print_it($this->output, $this->step);
	}
	function general_settings()
	{
		$set_keys = array();
		foreach($this->core->xml_array['setting_group']['setting'] as $k => $s)
		{
			$setkeys[] = "'".$s['conf_key']['VALUE']."'";
			$set_keys[] = $s['conf_key']['VALUE'];
		}

		$this->ipsclass->DB->simple_construct(array('select' => '*', 'from' => 'conf_settings', 'where' => "conf_key IN (".implode(",", $setkeys).")"));
		$this->ipsclass->DB->simple_exec();
		if ($this->ipsclass->DB->get_num_rows())
		{
			$had_old_sets = 1;
			while ($r = $this->ipsclass->DB->fetch_row())
			{
				$val = ($r['conf_value'] != '' && $r['conf_value'] != $r['conf_default']) ? $r['conf_value'] : '';
				$old_settings[$r['conf_key']] = $val;
			}
		}
		else
		{
			$old_settings = array();
			$had_old_sets = 0;
		}

		$this->ipsclass->DB->simple_exec_query(array('select' => '*', 'from' => 'conf_settings_titles', 'where' => "conf_title_title='Announce System' || conf_title_title='Announce System'"));
		if ($this->ipsclass->DB->get_num_rows())
		{
			$this->ipsclass->DB->simple_exec_query(array('delete' => 'conf_settings_titles', 'where' => "conf_title_title='Announce System' || conf_title_title='Announce System'"));
		}

		$this->ipsclass->DB->simple_construct(array('select' => '*', 'from' => 'conf_settings', 'where' => "conf_key IN (".implode(",", $setkeys).")"));
		$q = $this->ipsclass->DB->simple_exec();
		if ($this->ipsclass->DB->get_num_rows())
		{
			while ($r = $this->ipsclass->DB->fetch_row($q))
			{
				$this->ipsclass->DB->simple_exec_query(array('delete' => 'conf_settings', 'where' => "conf_key='".$r['conf_key']."'"));
			}
		}

		$this->ipsclass->DB->do_insert('conf_settings_titles', array('conf_title_title' => 'Announce System', 'conf_title_desc' => 'All Copyrights Belong to mohamed', 'conf_title_count' => 0, 'conf_title_noshow' => 0, 'conf_title_keyword' => 'announce'));
		$set_group = $this->ipsclass->DB->get_insert_id();

		foreach ($this->core->xml_array['setting_group']['setting'] as $k => $s)
		{
			$set = array();
			$set['conf_title']       = $s['conf_title']['VALUE'];
			$set['conf_description'] = $s['conf_description']['VALUE'];
			$set['conf_group']       = $set_group;
			$set['conf_type']        = $s['conf_type']['VALUE'];
			$set['conf_key']         = $s['conf_key']['VALUE'];
			$set['conf_value']       = '';
			$set['conf_default']     = $s['conf_default']['VALUE'];
			$set['conf_extra']       = $s['conf_extra']['VALUE'];
			$set['conf_evalphp']     = '';
			$set['conf_protected']   = 1;
			$set['conf_position']    = $s['conf_position']['VALUE'];
			$set['conf_start_group'] = $s['conf_start_group']['VALUE'];
			$set['conf_end_group']   = $s['conf_end_group']['VALUE'];
			$set['conf_help_key']    = '';
			$set['conf_add_cache']   = 1;

			$dbs = $this->ipsclass->DB->compile_db_insert_string($set);
			$query = "INSERT INTO ".SQL_PREFIX."conf_settings (".$dbs['FIELD_NAMES'].") VALUES (".$dbs['FIELD_VALUES'].")";
			if (!$this->ipsclass->DB->query($query))
			{
				$this->error("Install Error:<p>".$query."<br><br>".$this->ipsclass->DB->error);
			}
		}

		$conf = $this->ipsclass->DB->simple_exec_query(array('select' => 'count(*) as count', 'from' => 'conf_settings', 'where' => 'conf_group='.$set_group));
		$count = intval($conf['count']);
		$this->ipsclass->DB->do_update('conf_settings_titles', array('conf_title_count' => $count), 'conf_title_id='.$set_group);

		if ($had_old_sets == 1 && is_array($old_settings))
		{
			foreach ($old_settings as $k => $v)
			{
				if ($v != '')
				{
					$this->ipsclass->DB->do_update('conf_settings', array('conf_value' => $v), "conf_key='".$k."'");
				}
			}
		}

		$settings = array();
		$this->ipsclass->DB->simple_construct(array('select' => '*', 'from' => 'conf_settings', 'where' => 'conf_add_cache=1'));
		$this->ipsclass->DB->simple_exec();
		while ($r = $this->ipsclass->DB->fetch_row())
		{	
			$value = ($r['conf_value'] != '') ?  $r['conf_value'] : $r['conf_default'];
			if ($value == '{blank}')
			{
				$value = '';
			}
			$settings[$r['conf_key']] = $value;
		}
		$svalue = $this->ipsclass->DB->add_slashes(serialize($settings));
		$this->ipsclass->DB->manual_addslashes = 1;
		$this->ipsclass->DB->simple_construct(array('delete' => 'cache_store', 'where' => "cs_key='settings'"));
		$this->ipsclass->DB->simple_shutdown_exec();
		$this->ipsclass->DB->do_shutdown_insert('cache_store', array('cs_array' => 1, 'cs_key' => 'settings', 'cs_value' => $svalue));
		
		$this->core->redirect("New ACP settings added.", "act=finish");
	}	
			
	function finish_install()
	{
		$this->output .= "The installation is complete!<br />";	
		      $this->output .= "Please click the button below to return to your forums.<form action='index.php' method='post'><input type='submit' value='Return to your forums'></form>";
		$this->core->print_it($this->output, $this->step);
	}
}
?>