<html dir=rtl>
<title>  </title>
<?

##=================================================================
##                                 
##                  
##          By:  Tknlujia
##       Email:  m@tknlujia.com
##
##
##====================================================================================##
class prayer_time
{

    //   
    function julian_day($y, $m, $d)
    {

        $day =((367*$y)-((INT)((7/4)*($y+(INT)(($m+9)/12))))+(INT)(275*($m/9))+$d-730531.5);
        return $day;
    }
    
    
    //   
    function sun_long($julian_day)
    {
        $l=  (280.461+0.9856474*$julian_day);
        if($l>360)
        {
            $l= (($l/360)-(INT)($l/360))*360;
        }

        return $l;
    }
    
    
    //    
    function sun_period($julian_day)
    {
        $m = (357.528+0.9856003*$julian_day);
        if($m>360)
        {
            $m= (($m/360)-(INT)($m/360))*360;
        }

        return $m;
    }
    
    //     
    // lambda
    
    function sun_wave_long($sun_long, $sun_period, $pi)
    {
        $Lambda = $sun_long +1.915*SIN($sun_period*$pi/180)+0.02*SIN(2* $sun_period*$pi/180);
        return $Lambda;
    }
    
    //     
    // obliquity
    
    function obliquity($julian_day)
    {
        $Obliquity = (23.439-0.0000004*$julian_day);
        return $Obliquity;
    }
    
    //    
    // alpha
    
    function alpha($Obliquity, $Lambda, $pi)
    {

        $Alpha =ATAN (COS($Obliquity*$pi/180)*TAN($Lambda*$pi/180))*180/$pi;
        if($Alpha>90 AND $Alpha<180)
        {
            $Alpha= $Alpha + 180;
        }
        else
        {
            $Alpha= $Alpha + 360;
        }

        $Alpha=  $Alpha + 90 * (((INT)($Lambda/90))-((INT)($Alpha/90)));



        return $Alpha;
    }
    
    
    //     
    //  ST
    
    function starry_time($julian_day)
    {
        $ST = (100.46+0.985647352*$julian_day);
        if ($ST>360)
        {
            $ST=  (($ST/360)-((INT)($ST/360)))*360;
        }
        return $ST;
    }
    
    
    //     
    // Dec
    
    function sun_obliquity($Obliquity, $Lambda, $pi)
    {
        $Dec = ASIN(SIN($Obliquity*$pi/180)*SIN($Lambda*$pi/180))*180/$pi;
        return $Dec;
    }
    
    //     
    // noon
    
    function sun_miday($Alpha, $ST)
    {
        $noon = ($Alpha - $ST);
        if($noon<0)
        {
            $noon = $noon+360;
        }
        return $noon;
    }
    
    //    
    // UT NOON
    
    function international_midday($noon, $long)
    {
        $UT_noon = $noon - $long;
        return $UT_noon;
    }
    
    //        
    // local_noon
    
    function local_noon($UT_noon, $zone)
    {
        $local_noon = $UT_noon/15+$zone;
        return $local_noon;
    }
    
     //     
     
    function zuhr_time($local_noon)
    {
        $timeh = floor ($local_noon);
        $timem = floor (($local_noon - (INT)($local_noon))*60);
        $zuhr_prayer = "$timeh:$timem";
        
        return $zuhr_prayer;

    }
    
    //    -  
    //       
    //       
    //      
    // Asr_Alt
    
    function asr_alt($lat, $Dec, $pi)
    {

        $Asr_Alt= ATAN(1+TAN(($lat-$Dec)*$pi/180))*180/$pi;

        return $Asr_Alt;
    }
    
    
    
    
    //    -  
    //       
    //      
    // Asr_Alt
    
    
    //      
    //          
    //    
    // AsrArc

    function asr_arc($AsrAlt, $lat, $Dec, $pi)
    {


        $AsrArc= ACOS((SIN((90-$AsrAlt)*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi/15;

        return $AsrArc;
    }
    
    
    //         
    function asr_time($local_noon, $AsrArc)
    {
        $AsrTime = $local_noon + $AsrArc;
        
        return $AsrTime;
    }
    
    
    
         //     

    function asr_prayer_time($AsrTime)
    {
        $timeh = floor ($AsrTime);
        $timeh= $timeh-12;
        $timem = floor (($AsrTime - (INT)($AsrTime))*60);
        $asr_prayer = "$timeh:$timem";

        return $asr_prayer;

    }
    
    
    //        
    //       
    // Durinal_Arc
    
    function Durinal_Arc ($lat, $Dec, $pi)
    {

        $Durinal_Arc= Acos((SIN(-0.8333*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        return $Durinal_Arc;
    }
    
    //        
    // sun_rise
    //     
    
    function sun_rise($local_noon, $Durinal_Arc)
    {
        $sun_rise= $local_noon - ($Durinal_Arc/15);
        
        return $sun_rise;
    }
    
    
    
    //    
    function shrouk_prayer($sun_rise)
    {
        $timeh= floor($sun_rise);
        $timem = floor (($sun_rise - (INT)($sun_rise))*60);
        $sun_rise_prayer = "$timeh:$timem";
        
        return $sun_rise_prayer;
    }
    
    
    //        
    // sun_set
    //          
    
    function sun_set($local_noon, $Durinal_Arc)
    {
        $sun_set= $local_noon + ($Durinal_Arc/15);

        return $sun_set;
    }
    
    //     

    function maghrib_prayer($sun_set)
    {
        $timeh= floor($sun_set);
        $timeh= $timeh-12;
        $timem = floor (($sun_set - (INT)($sun_set))*60);
        $maghrib_prayer = "$timeh:$timem";

        return $maghrib_prayer;
    }
    
    
    //       
    //          
    // Esha_Arc
    function esha_arc($lat, $Dec, $pi)
    {
        $Esha_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        
        return $Esha_Arc;
    }
    
    //    
    //     
    
    function esha_time($local_noon, $Esha_Arc)
    {
        $esha_time= $local_noon + ($Esha_Arc/15);

        return $esha_time;
    }
    
    //     
    
    function esha_prayer($esha_time)
    {
        $timeh= floor($esha_time);
        $timeh= $timeh-12;
        $timem = floor (($esha_time - (INT)($esha_time))*60);
        $esha_prayer = "$timeh:$timem";

        return $esha_prayer;
    }
    
    
    //             
    //   
    // Fajr_Arc
    
    function fajr_arc($lat, $Dec, $pi)
    {
        $Fajr_Arc= Acos((SIN(-18*$pi/180)-SIN($Dec*$pi/180)*SIN($lat*$pi/180))/(COS($Dec*$pi/180)*COS($lat*$pi/180)))*180/$pi;
        
        return $Fajr_Arc;
    }
    
    //    
    function fajr_time($local_noon, $Fajr_Arc)
    {
        $fajr_time= $local_noon - ($Fajr_Arc/15);
        
        return $fajr_time;
    }
    
    //     
    function fajr_prayer($fajr_time)
    {
        $timeh= floor($fajr_time);
        $timem = floor (($fajr_time - (INT)($fajr_time))*60);
        $fajr_time = "$timeh:$timem";

        return $fajr_time;
    }

    

}



$newclass = new prayer_time;
$y= date("Y");
$m= date("n");
$d= date("j");



//   3.14159265358
$pi = 3.14159265358;


//        
//    
$long = 46.69;

//        
//    
$lat = 24.67;

//        
$zone = 3;

$julian_day = $newclass->julian_day($y, $m, $d);
$sun_long = $newclass->sun_long($julian_day);
$sun_period = $newclass->sun_period($julian_day);
$Lambda = $newclass->sun_wave_long($sun_long, $sun_period, $pi);
$Obliquity = $newclass->obliquity($julian_day);
$Alpha = $newclass->alpha($Obliquity, $Lambda, $pi);
$ST = $newclass->starry_time($julian_day);
$Dec = $newclass->sun_obliquity($Obliquity, $Lambda, $pi);
$noon = $newclass->sun_miday($Alpha, $ST);
$UT_noon = $newclass->international_midday($noon, $long);
$local_noon = $newclass->local_noon($UT_noon, $zone);
$zuhr_prayer = $newclass->zuhr_time($local_noon);
$AsrAlt = $newclass->asr_alt($lat, $Dec, $pi);
$AsrArc = $newclass->asr_arc($AsrAlt, $lat, $Dec, $pi);
$AsrTime = $newclass->asr_time($local_noon, $AsrArc);
$asr_prayer = $newclass->asr_prayer_time($AsrTime);
$Durinal_Arc= $newclass->Durinal_Arc ($lat, $Dec, $pi);
$sun_rise =  $newclass->sun_rise($local_noon, $Durinal_Arc);
$Shrouk_prayer= $newclass->shrouk_prayer($sun_rise);
$sun_set =  $newclass->sun_set($local_noon, $Durinal_Arc);
$maghrib_prayer =  $newclass->maghrib_prayer($sun_set);
$Esha_Arc =  $newclass->esha_arc($lat, $Dec, $pi);
$esha_time=  $newclass->esha_time($local_noon, $Esha_Arc);
$esha_prayer=  $newclass->esha_prayer($esha_time);
$Fajr_Arc=  $newclass->fajr_arc($lat, $Dec, $pi);
$fajr_time=  $newclass->fajr_time($local_noon, $Fajr_Arc);
$fajr_prayer=  $newclass->fajr_prayer($fajr_time);


echo "<table border=1 width=50% cellspacing=1 cellpadding=3 align=center>";
echo "<tr><td></td> <td>$fajr_prayer</td></tr>";
echo "<tr><td></td> <td> $Shrouk_prayer</td></tr>";
echo "<tr><td></td> <td> $zuhr_prayer</td></tr>";
echo "<tr><td></td> <td>$asr_prayer</td></tr>";
echo "<tr><td></td> <td> $maghrib_prayer</td></tr>";
echo "<tr><td></td> <td> $esha_prayer</td></tr>";
echo "</table>";
?>
<p align="center">Powered by <a href="http://www.Tknlujia.com/">Tknlujia.com</a></p>







