<?php
/*
$Date: 2002/05/17 22:12:03 $
$Revision: 1.8 $
-------------------------------------------------
EMAIL -> SMS 0.7 (17-MAY-2002)
Keyvan Minoukadeh - keyvan@k1m.com
http://www.k1m.com/
-------------------------------------------------

* Read readme.txt for information *

-----------
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
-----------
*/

require_once('includes.php');

// read config file
$c = new config_reader('config.conf');
$c = $c->load();

$output = $c['output'];

set_time_limit($c['time_limit']);

// retreive config stats
// vars from config:
//   $process_email
//   $admin_mail_sent
//   $count
//   $prev_uidl_array
retrieve_stats($c['stats_file']);

if (!$process_email) {
	$output('Email processing disabled');
	exit;
}

$count++;

update_stats($c['stats_file'], array(
					'count'=>$count,
					'process_email'=>$process_email,
					'admin_mail_sent'=>$admin_mail_sent,
					'prev_uidl_array'=>$prev_uidl_array));

// terminate script if error count has exceeded the retries number
if ($count > $c['error_retries']) {
	if (!$admin_mail_sent) {
		mail($c['admin_email'], 'SMS Errors', "$count errors occured, maximum allowed was: {$c['error_retries']}");
		$admin_mail_sent = 1;
	}
	update_stats($c['stats_file'], array(
						'count'=>$count,
						'process_email'=>$process_email,
						'admin_mail_sent'=>$admin_mail_sent,
						'prev_uidl_array'=>$prev_uidl_array));
	$output('Maximum errors reached');
	exit;
}

$pop3 = new kPOP3();

if(!$pop3->connect($c['pop_server'], $c['pop_port']))
{
	$output("Ooops {$pop3->ERROR} <BR>\n");
	exit;
}

$inbox_count = $pop3->login($c['pop_login'], $c['pop_pass']);
if( ($inbox_count == -1) )
{
	$output("<H1>Login Failed: {$pop3->ERROR}</H1>\n");
	exit;
}

if ($inbox_count < 1)
{
	$output("Login OK: Inbox EMPTY<BR>\n");
	$pop3->quit();
	update_stats($c['stats_file'], array(
						'count'=>0,
						'process_email'=>$process_email,
						'admin_mail_sent'=>$admin_mail_sent,
						'prev_uidl_array'=>array()));
	exit;
} else {
	$output("Login OK: Inbox contains [$inbox_count] messages<BR>\n");
}

//--------------------------------------------------
//-- INITIALISE THE MIME PARSE CLASS
//--------------------------------------------------
$mime = new mime_email();

//--------------------------------------------------
//-- INITIALISE THE SMS CLASS
//--------------------------------------------------
$sms = new sms_web_sender($c['sms_debug']);

// Add sms site accounts
if (isset($c['sms_login'])) {
	if (is_string($c['sms_login'])) {
		$c['sms_login'] = (array)$c['sms_login'];
	}
	if (is_array($c['sms_login']) && (count($c['sms_login']) > 0)) {
		for ($x = 0; $x < count($c['sms_login']); $x++) {
			$tmp = explode(',', $c['sms_login'][$x]);
			$sms->add_site(array('user'=>trim($tmp[0]), 'pass'=>trim($tmp[1]), 'class'=>trim($tmp[2]), 'weight'=>(int)trim($tmp[3])));
		}
	}
}

if (count($sms->sites) > 1) {
	$sms->shuffle_logins();
}

// grab unique ids of email messages
// $uidl_array[msg_number] = unique_id
// $uidl_array[0] = total_messages (we unset this)
$uidl_array = $pop3->uidl();
unset($uidl_array[0]);

// count number of email messages
$messages = $pop3->last();

// checks to see if number of messages waiting to be processed is greater than $c['sends_per_exec']
// if it is it sets $sends_this_exec to $c['sends_per_exec']
$sends_this_exec = (!empty($c['sends_per_exec']) && $c['sends_per_exec'] < $messages) ? $c['sends_per_exec'] : $messages;

// message counter
$x = 1;

// send counter
// keeps track of how many messages
// have been sent by sms
$sent_msgs = 0;

flush();

// loop through email messages
while (($sent_msgs < $sends_this_exec) && ($x <= $messages)) {
	
	// if uidl for this message ($x) has already been
	// stored in array, if it has increment $x and continue
	// while loop (basically move on to next message)
	if (in_array($uidl_array[$x], $prev_uidl_array)) {
		$output("<br> - UIDL found in previous array (message $x has already been processed)\n");
		
		// if $leave_mail_on_server (found in config) is false then
		// mark email deleted (will not actually be deleted until pop3->quit()
		// has been executed
		if (!$c['leave_mail_on_server']) {
			if(!$pop3->delete($x))
			{
				$output("oops {$pop3->ERROR} <BR>\n");
				$pop3->reset();
				exit;
			} else {
				$output("<br> - Message $x Deleted\n");
			}
		}
		
		flush();
		$x++;
		continue;
	}

	// grab message
	if ($pop3->pop_list($x) > $c['msg_bytes']) {
		$email_msg = $pop3->top($x);
	} else {
		$email_msg = $pop3->get($x);
	}

	// feed to mime class
	$mime->set_emaildata($email_msg);
	$mime->go_decode();

	// grab email body
	if (empty($mime->emailtextplain)) {
		$sms_body = 'MSG BODY NOT PLAIN TEXT';
	} else {
		$sms_body = $mime->emailtextplain;
	}

	// cut and trim body
	$sms_body = substr(trim($sms_body), 0, 160); 

	// if $leave_mail_on_server (found in config) is false then
	// mark email deleted (will not actually be deleted until pop3->quit()
	// has been executed
	if (!$c['leave_mail_on_server']) {
		if(!$pop3->delete($x))
		{
			$output("oops $pop3->ERROR <BR>\n");
			$pop3->reset();
			exit;
		} else {
			$output("<br> - Message $x Deleted\n");
		}
	}

	// tries to match a phone number in the subject line
	if ($c['allow_forwarded_sms'] && preg_match('/^(\+[0-9]+) ([0-9]+)/', $mime->subject, $matches)) {
		$sms_success = $sms->send_sms(array('ccode'=>$matches[1], 'num'=>$matches[2], 'msg'=>$sms_body));
		unset($matches);

		if ($sms_success) {
			$output("<br> - Message $x Sent");
		} else {
			$output("<br> - <b>Message $x NOT Sent</b>");
		}

	} elseif (!empty($c['mobile_number'])) {
		// check To: header
		if (isset($c['filter_to'])) {
			if (is_string($c['filter_to'])) {
				$c['filter_to'] = (array)$c['filter_to'];
			}
			if (is_array($c['filter_to']) && count($c['filter_to']) > 0) {
				$blocked = true;
				foreach ($c['filter_to'] as $filter) {
					if (stristr($mime->to, $filter) !== false) {
						$blocked = false;
						break;
					}
				}
			}
		}

		if (isset($blocked) && $blocked === true) {
			$output("<br> - Message $x filtered out");
			unset($blocked);
		} else {
			$new_sms_body = $c['message_format'];
			$new_sms_body = parse_message_format('subject', $mime->subject, $new_sms_body);
			$new_sms_body = parse_message_format('from', $mime->from, $new_sms_body);
			$new_sms_body = parse_message_format('body', $sms_body, $new_sms_body);
			$sms_success = $sms->send_sms(array('num'=>$c['mobile_number'], 'ccode'=>$c['mobile_ccode'], 'msg'=>$new_sms_body));
			
			if ($sms_success) {
				$output("<br> - Message $x Sent");
			} else {
				$output("<br> - <b>Message $x NOT Sent</b>");
			}
		}
	} else {
		$output("<br> - {$mime->subject} didn't match");
	}

	// message process, so add current uidl
	// to $prev_uidl_array which will get
	// serialized and used on next run
	$prev_uidl_array[] = $uidl_array[$x];
	
	$x++;
	$sent_msgs++;

	flush();

} // loop

$pop3->quit();

// update $prev_uidl_array with only uidls which are present in
// the current uidl list AND the previous list (so basically
// removes the older uidls which have probably been downloaded)
// also it will not use all the existing ones because some of them
// might not have been processed yet..
$prev_uidl_array = array_intersect($prev_uidl_array, $uidl_array); 

// update config again
update_stats($c['stats_file'], array(
					'count'=>0,
					'process_email'=>$process_email,
					'admin_mail_sent'=>$admin_mail_sent,
					'prev_uidl_array'=>$prev_uidl_array));

$output("<br><br>Done...\n");

?>
